/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.eventSend.core;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.eventSend.core.SscEventContext;
import kd.ssc.eventSend.core.SscSendEventFactory;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.eventSend.entity.EventTypeEnum;
import kd.ssc.eventSend.entity.PersonChangeTypeEnum;
import kd.ssc.eventSend.event.SscSendEvent;

public class SscEventDistributor {
    private static final Log logger = LogFactory.getLog(SscEventDistributor.class);

    public static void taskSyncData(String taskEntityNumber, DataChangeTypeEnum dataChangeType, Long sscId, Long taskId) {
        ArrayList<Long> taskIdList = new ArrayList<Long>();
        taskIdList.add(taskId);
        SscEventDistributor.taskSyncData(taskEntityNumber, dataChangeType, sscId, taskIdList);
    }

    public static void taskSyncData(String taskEntityNumber, DataChangeTypeEnum dataChangeType, Long sscId, List<Long> taskIdList) {
        if (StringUtils.isEmpty((String)taskEntityNumber) || sscId == null || CollectionUtils.isEmpty(taskIdList)) {
            logger.error("taskEntityNumber = {}, sscId = {}, taskIdList = {}", new Object[]{taskEntityNumber, sscId, JSONObject.toJSONString(taskIdList)});
            return;
        }
        EventTypeEnum eventType = EventTypeEnum.TASK_SYN;
        SscSendEventFactory.init();
        SscSendEvent sscSendEvent = SscSendEventFactory.getSscSendEvent(eventType);
        SscEventContext sscEventContext = new SscEventContext(eventType, sscSendEvent);
        sscEventContext.setTaskEntityNumber(taskEntityNumber);
        sscEventContext.setFullSync(false);
        sscEventContext.setDataChangeType(dataChangeType);
        sscEventContext.setTaskIdList(taskIdList);
        sscEventContext.setSscId(sscId);
        sscEventContext.sendEvent();
    }

    public static Map<String, Object> cancelPendVerify(Long taskId, Map<String, Object> paramMap) {
        EventTypeEnum eventType = EventTypeEnum.CANCEL_PEND_VERIFY;
        SscSendEventFactory.init();
        SscSendEvent sscSendEvent = SscSendEventFactory.getSscSendEvent(eventType);
        SscEventContext sscEventContext = new SscEventContext(eventType, sscSendEvent, taskId);
        sscEventContext.setParamMap(paramMap);
        return sscEventContext.sendEvent();
    }

    public static void personChangeNotify(Long taskId, PersonChangeTypeEnum personChangeType) {
        EventTypeEnum eventType = EventTypeEnum.PERSON_CHANGE;
        SscSendEventFactory.init();
        SscSendEvent sscSendEvent = SscSendEventFactory.getSscSendEvent(eventType);
        SscEventContext sscEventContext = new SscEventContext(eventType, sscSendEvent, taskId);
        sscEventContext.setPersonChangeType(personChangeType);
        sscEventContext.sendEvent();
    }

    public static void personChangeNotify(DynamicObject taskInfoDo, PersonChangeTypeEnum personChangeType) {
        EventTypeEnum eventType = EventTypeEnum.PERSON_CHANGE;
        SscSendEventFactory.init();
        SscSendEvent sscSendEvent = SscSendEventFactory.getSscSendEvent(eventType);
        if (taskInfoDo != null) {
            Long taskId = taskInfoDo.getLong("id");
            SscEventContext sscEventContext = new SscEventContext(eventType, sscSendEvent, taskId);
            sscEventContext.setTaskInfoDo(taskInfoDo);
            sscEventContext.setPersonChangeType(personChangeType);
            sscEventContext.sendEvent();
        }
    }
}

