/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.compensate;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.exception.compensate.CompensateHandler;
import kd.ssc.exception.dto.ExceptionDTO;
import kd.ssc.exception.enums.CompensateStatusEnum;
import kd.ssc.exception.util.ExceptionHelperUtil;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class WfSynCompensateHandler
extends CompensateHandler {
    public WfSynCompensateHandler(ExceptionDTO dto) {
        super(dto);
    }

    @Override
    public boolean exceptionCompensate() {
        try {
            this.synStatus2Workflow();
            ExceptionHelperUtil.updateTableAfterCompensate(CompensateStatusEnum.SUCCESS, this.dto);
            return true;
        }
        catch (Exception e) {
            ExceptionHelperUtil.updateTableAfterCompensateException(e, this.dto);
            return false;
        }
    }

    private void synStatus2Workflow() {
        Map queryParam = (Map)SerializationUtils.fromJsonString((String)this.dto.getRequestParam(), Map.class);
        long taskId = Long.parseLong((String)queryParam.get("taskId"));
        DynamicObject task = this.getTaskById(taskId);
        String auditMsg = (String)queryParam.get("msg");
        boolean isCheckPerson = Boolean.parseBoolean((String)queryParam.get("checkPerson"));
        if (isCheckPerson) {
            TaskWorkFlowUtil.updatePersonAndMsgDisTask(new DynamicObject[]{task}, auditMsg);
        } else {
            TaskWorkFlowUtil.updateMsgCreateTask(new DynamicObject[]{task}, auditMsg);
        }
    }

    private DynamicObject getTaskById(Long taskId) {
        if (QueryServiceHelper.exists((String)"task_task", (Object)taskId)) {
            return BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
        }
        return BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_taskhistory");
    }
}

