/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.message;

import com.alibaba.fastjson.JSONObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.util.StringUtils;
import kd.ssc.task.dto.TaskLogRecordDTO;
import kd.ssc.task.ierp.TaskLogFacadeImpl;

public class RecordingExceptionConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(RecordingExceptionConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        log.error("\u5f02\u5e38\u4fe1\u606f\u8bb0\u5f55 " + message + ", " + messageId + ", " + resend);
        if (message == null || StringUtils.isEmpty((String)message.toString())) {
            log.error("message \u4e3anull,\u4e0d\u7528\u8bb0\u5f55");
            messageAcker.ack(messageId);
            return;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)message.toString());
        TaskLogRecordDTO taskLogRecordDTO = new TaskLogRecordDTO();
        TaskLogFacadeImpl taskLogFacade = new TaskLogFacadeImpl();
        taskLogRecordDTO.setErrorMsg(jsonObject.getString("errorMsg"));
        taskLogRecordDTO.setErrorStack(jsonObject.getString("errorStack"));
        taskLogRecordDTO.setType(jsonObject.getString("type"));
        taskLogRecordDTO.setMethod(jsonObject.getString("method"));
        taskLogFacade.saveTaskLogRecord(taskLogRecordDTO);
        messageAcker.ack(messageId);
    }
}

