/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartApproval.enums;

import kd.bos.url.UrlService;
import kd.ssc.enums.MultiLangEnumBridge;
import kd.ssc.smartApproval.enums.IsPassEnum;

public enum AIRiskLevel {
    LOW_RISK("dfx", new MultiLangEnumBridge("\u4f4e\u98ce\u9669", "AIRiskLevel_0", "ssc-task-common"), "#276FF5"),
    MEDIUM_RISK("zfx", new MultiLangEnumBridge("\u4e2d\u98ce\u9669", "AIRiskLevel_1", "ssc-task-common"), "#FF991C"),
    HIGH_RISK("gfx", new MultiLangEnumBridge("\u9ad8\u98ce\u9669", "AIRiskLevel_2", "ssc-task-common"), "#FB2323");

    private static final String BACKGROUND_IMG_KEY_PREFIX = "/icons/pc/other/cwy_";
    private static final String BACKGROUND_IMG_KEY_SUFFIX = ".png";
    private final String key;
    private final MultiLangEnumBridge bridge;
    private final String color;

    private AIRiskLevel(String key, MultiLangEnumBridge bridge, String color) {
        this.key = key;
        this.bridge = bridge;
        this.color = color;
    }

    public String getBackgroundImgKey() {
        return BACKGROUND_IMG_KEY_PREFIX + this.key + BACKGROUND_IMG_KEY_SUFFIX;
    }

    public String getBackgroundImgUrl() {
        String key = this.getBackgroundImgKey();
        return UrlService.getImageFullUrl((String)key);
    }

    public String getText() {
        return this.bridge.loadKDString();
    }

    public String getColor() {
        return this.color;
    }

    public static AIRiskLevel getAIRiskLevel(IsPassEnum predictPass, Boolean schemaPass) {
        if (predictPass == null) {
            return null;
        }
        if (schemaPass == null) {
            return predictPass == IsPassEnum.pass ? LOW_RISK : HIGH_RISK;
        }
        if (predictPass == IsPassEnum.pass && schemaPass.booleanValue()) {
            return LOW_RISK;
        }
        if (!schemaPass.booleanValue()) {
            return HIGH_RISK;
        }
        return MEDIUM_RISK;
    }
}

