/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartcs.product;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.ssc.smartcs.enums.ExcpStateEnum;
import kd.ssc.smartcs.enums.OperationEnum;
import kd.ssc.smartcs.factory.AbstractAIMetaFactory;
import kd.ssc.smartcs.factory.KeywordsFactory;
import kd.ssc.smartcs.parameter.AbstractAIMetaParameter;
import kd.ssc.smartcs.parameter.KeywordsParameter;
import kd.ssc.smartcs.parameter.QuestionParameter;
import kd.ssc.smartcs.product.AbstractAIMetaProduct;
import kd.ssc.smartcs.product.KeywordsProduct;
import kd.ssc.smartcs.result.KeywordResult;
import kd.ssc.smartcs.result.QuestionResult;

public class QuestionProduct
extends AbstractAIMetaProduct {
    public QuestionProduct() {
    }

    public QuestionProduct(AbstractAIMetaParameter inputParameter) {
        super(inputParameter);
    }

    @Override
    public void add() {
        String input = this.getAddInput();
        String output = this.invoke(OperationEnum.ADD_QUESTIONGROUP, input);
        boolean callSuccess = this.parseAddResult(output);
        this.saveCallInfo2DB(this.getMethodName(), input, output, callSuccess, this.getResult().getTraceId(), OperationEnum.ADD_QUESTIONGROUP.getOperate(), this.getInputParameterJson());
    }

    @Override
    public void bdelete() {
        String input = this.getDeleteInput();
        String output = this.invoke(OperationEnum.DEL_QUESTIONGROUP, input);
        boolean callSuccess = this.parseDeleteResult(output);
        this.saveCallInfo2DB(this.getMethodName(), input, output, callSuccess, this.getResult().getTraceId(), OperationEnum.DEL_QUESTIONGROUP.getOperate(), this.getInputParameterJson());
    }

    @Override
    protected boolean parseResult(String outputJson) {
        this.setResult(new QuestionResult());
        return super.parseResult(outputJson);
    }

    private Long queryAndAddKeyword(Long qaId, String keyword) {
        Long keywordId = this.queryKeyword(qaId, keyword);
        if (keywordId <= 0L) {
            keywordId = this.addKeyword(qaId, keyword);
        }
        return keywordId;
    }

    private Long queryKeyword(Long qaId, String keyword) {
        KeywordsFactory factory = new KeywordsFactory();
        KeywordsParameter input = this.constructKeywordInput(qaId, keyword);
        KeywordsProduct product = (KeywordsProduct)((AbstractAIMetaFactory)factory).makeMeta(input);
        return product.queryKeyword();
    }

    private Long addKeyword(Long qaId, String keyword) throws KDException {
        KeywordsFactory factory = new KeywordsFactory();
        KeywordsParameter input = this.constructKeywordInput(qaId, keyword);
        KeywordsProduct product = (KeywordsProduct)((AbstractAIMetaFactory)factory).makeMeta(input);
        product.add();
        KeywordResult result = (KeywordResult)product.getResult();
        if (result.isCallSuccess()) {
            return result.getId();
        }
        ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), String.format(ResManager.loadKDString((String)"\u65b0\u589e\u5173\u952e\u8bcd\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s\u3002", (String)"QuestionProduct_0", (String)"ssc-task-common", (Object[])new Object[0]), result.getMessage()));
        throw new KDException(code, new Object[0]);
    }

    private KeywordsParameter constructKeywordInput(Long qaId, String keyword) {
        KeywordsParameter input = new KeywordsParameter();
        input.setQaId(qaId);
        input.setKeyword(keyword);
        return input;
    }

    private String getAddInput() {
        Map<String, Object> inputParamterMap = this.getAddInputParamMap();
        String keyword = inputParamterMap.get("keywordString") + "";
        Long qaId = (Long)inputParamterMap.get("qaId");
        if (StringUtils.isNotBlank((CharSequence)keyword) && !"null".equals(keyword)) {
            Long keywordId = this.queryAndAddKeyword(qaId, keyword);
            inputParamterMap.put("keywordId", keywordId);
        }
        inputParamterMap.remove("keywordString");
        inputParamterMap.remove("qaId");
        HashMap<String, Map<String, Object>> input = new HashMap<String, Map<String, Object>>(1);
        input.put("obj", inputParamterMap);
        return SerializationUtils.toJsonString(input);
    }

    private Map<String, Object> getAddInputParamMap() {
        HashMap<String, Object> input = new HashMap<String, Object>(8);
        QuestionParameter parameter = (QuestionParameter)this.getInputParameter();
        input.put("id", parameter.getId());
        input.put("domainId", parameter.getAreaId());
        input.put("cateId", parameter.getSubjectId());
        input.put("questions", this.constructQuestionList(parameter));
        input.put("answer", this.getAnswerMap(parameter));
        input.put("keywordString", parameter.getKeyword());
        input.put("qaId", parameter.getQaId());
        if (StringUtils.isNotBlank((CharSequence)parameter.getLinkAddress())) {
            input.put("enableLinkCard", Boolean.TRUE);
            input.put("linkCardTitle", parameter.getLinkName());
            input.put("linkCardLink", parameter.getLinkAddress());
        } else {
            input.put("enableLinkCard", Boolean.FALSE);
            input.put("linkCardTitle", "");
            input.put("linkCardLink", "");
        }
        input.put("attachments", this.getAttachmentList(parameter));
        return input;
    }

    private boolean parseAddResult(String output) {
        boolean callSuccess = this.parseResult(output);
        if (callSuccess) {
            QuestionResult result = (QuestionResult)this.getResult();
            JSONObject obj = JSON.parseObject((String)output);
            JSONObject data = obj.getJSONObject("data");
            Long questionId = data.getLong("id");
            result.setId(questionId);
        }
        return callSuccess;
    }

    private String getDeleteInput() {
        return SerializationUtils.toJsonString(this.getDeleteInputParamMap());
    }

    private Map<String, Object> getDeleteInputParamMap() {
        HashMap<String, Object> input = new HashMap<String, Object>(3);
        QuestionParameter inputParameter = (QuestionParameter)this.getInputParameter();
        input.put("faqDomainId", inputParameter.getAreaId());
        input.put("faqCategoryId", inputParameter.getSubjectId());
        input.put("ids", inputParameter.getDeleteIds());
        return input;
    }

    private boolean parseDeleteResult(String output) {
        return this.parseResult(output);
    }

    private Map<String, String> getAnswerMap(QuestionParameter parameter) {
        HashMap<String, String> answerMap = new HashMap<String, String>(1);
        answerMap.put("content", parameter.getAnswer());
        return answerMap;
    }

    private List<Map<String, String>> constructQuestionList(QuestionParameter parameter) {
        ArrayList<Map<String, String>> questionList = new ArrayList<Map<String, String>>(5);
        List<String> questions = parameter.getQuestions();
        for (String eachQus : questions) {
            HashMap<String, String> qusMap = new HashMap<String, String>(1);
            qusMap.put("title", eachQus);
            questionList.add(qusMap);
        }
        return questionList;
    }

    private List<Map<String, Object>> getAttachmentList(QuestionParameter parameter) {
        Map<Long, List<String>> attachments = parameter.getAttachments();
        ArrayList<Map<String, Object>> rtn = new ArrayList<Map<String, Object>>(attachments.size());
        for (Map.Entry<Long, List<String>> entry : attachments.entrySet()) {
            Long id = entry.getKey();
            List<String> value = entry.getValue();
            if (value == null || value.size() != 3) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("id", id);
            map.put("title", value.get(0));
            map.put("fileId", value.get(1));
            map.put("fileId_mobile", value.get(2));
            rtn.add(map);
        }
        return rtn;
    }
}

