/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartcs.product;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.ssc.smartcs.enums.OperationEnum;
import kd.ssc.smartcs.parameter.AbstractAIMetaParameter;
import kd.ssc.smartcs.parameter.SubjectParameter;
import kd.ssc.smartcs.product.AbstractAIMetaProduct;
import kd.ssc.smartcs.result.SubjectResult;

public class SubjectProduct
extends AbstractAIMetaProduct {
    public SubjectProduct() {
    }

    public SubjectProduct(AbstractAIMetaParameter inputParameter) {
        super(inputParameter);
    }

    @Override
    public void add() {
        String input = this.getAddInput();
        String output = this.invoke(OperationEnum.ADD_CATEGORY, input);
        boolean callSuccess = this.parseAddResult(output);
        this.saveCallInfo2DB(this.getMethodName(), input, output, callSuccess, this.getResult().getTraceId(), OperationEnum.ADD_CATEGORY.getOperate(), this.getInputParameterJson());
    }

    @Override
    public void update() {
        String input = this.getUpdateInput();
        String output = this.invoke(OperationEnum.EDIT_CATEGORY, input);
        boolean callSuccess = this.parseUpdateResult(output);
        this.saveCallInfo2DB(this.getMethodName(), input, output, callSuccess, this.getResult().getTraceId(), OperationEnum.EDIT_CATEGORY.getOperate(), this.getInputParameterJson());
    }

    @Override
    public void bdelete() {
        String input = this.getDeleteInput();
        String output = this.invoke(OperationEnum.DEL_CATEGORY, input);
        boolean callSuccess = this.parseDeleteResult(output);
        this.saveCallInfo2DB(this.getMethodName(), input, output, callSuccess, this.getResult().getTraceId(), OperationEnum.DEL_CATEGORY.getOperate(), this.getInputParameterJson());
    }

    @Override
    protected boolean parseResult(String outputJson) {
        this.setResult(new SubjectResult());
        return super.parseResult(outputJson);
    }

    private String getAddInput() {
        HashMap<String, Map<String, Object>> input = new HashMap<String, Map<String, Object>>(1);
        input.put("obj", this.getAddInputParamMap());
        return SerializationUtils.toJsonString(input);
    }

    private Map<String, Object> getAddInputParamMap() {
        HashMap<String, Object> input = new HashMap<String, Object>(3);
        SubjectParameter parameter = (SubjectParameter)this.getInputParameter();
        input.put("name", parameter.getName());
        input.put("number", parameter.getNumber());
        input.put("domainId", parameter.getAreaId());
        return input;
    }

    private boolean parseAddResult(String output) {
        boolean callSuccess = this.parseResult(output);
        if (callSuccess) {
            SubjectResult result = (SubjectResult)this.getResult();
            JSONObject obj = JSON.parseObject((String)output);
            JSONObject data = obj.getJSONObject("data");
            Long subjectId = data.getLong("id");
            String name = data.getString("name");
            String number = data.getString("number");
            result.setId(subjectId);
            result.setName(name);
            result.setNumber(number);
        }
        return callSuccess;
    }

    private String getUpdateInput() {
        HashMap<String, Map<String, Object>> input = new HashMap<String, Map<String, Object>>(1);
        input.put("obj", this.getUpdateInputParamMap());
        return SerializationUtils.toJsonString(input);
    }

    private Map<String, Object> getUpdateInputParamMap() {
        HashMap<String, Object> input = new HashMap<String, Object>(4);
        SubjectParameter inputParamter = (SubjectParameter)this.getInputParameter();
        input.put("id", inputParamter.getId());
        input.put("name", inputParamter.getName());
        input.put("number", inputParamter.getNumber());
        input.put("domainId", inputParamter.getAreaId());
        return input;
    }

    private boolean parseUpdateResult(String output) {
        return this.parseResult(output);
    }

    private String getDeleteInput() {
        return SerializationUtils.toJsonString(this.getDeleteInputParamMap());
    }

    private Map<String, Object> getDeleteInputParamMap() {
        HashMap<String, Object> input = new HashMap<String, Object>(2);
        SubjectParameter parameter = (SubjectParameter)this.getInputParameter();
        input.put("domainId", parameter.getAreaId());
        input.put("ids", parameter.getDeleteIds());
        return input;
    }

    private boolean parseDeleteResult(String output) {
        return this.parseResult(output);
    }
}

