/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.partask.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.partask.ParTaskConsumer;
import kd.ssc.task.partask.ParTaskMessage;
import kd.ssc.task.partask.enums.FlowInstEnum;
import kd.ssc.task.partask.service.impl.ParTaskFlowInstServiceImpl;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;

public class CreateNewPartask {
    private static final Log log = LogFactory.getLog(ParTaskConsumer.class);

    public static Long createNewTask(ParTaskMessage message) throws KDException {
        ParTaskFlowInstServiceImpl insService = new ParTaskFlowInstServiceImpl();
        Long defId = message.getDefId();
        if (!QueryServiceHelper.exists((String)"task_partaskflowdef", (Object)defId)) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u591a\u7ea7\u4efb\u52a1\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"ParTaskConsumer_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        Long insId = message.getInstanceId();
        if (QueryServiceHelper.exists((String)"task_partaskinst", (Object)insId)) {
            DynamicObject insDyo = BusinessDataServiceHelper.loadSingle((Object)insId, (String)"task_partaskinst", (String)"ptstatus");
            ErrorCode errorCode = CreateNewPartask.validateInsStatus(insDyo, message.getNextNodeTypeId());
            if (errorCode != null) {
                throw new KDException(errorCode, new Object[0]);
            }
        } else {
            log.info("\u591a\u7ea7\u4efb\u52a1\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff0cdefId = {}, instanceId = {}", (Object)defId, (Object)insId);
            insId = insService.CreateParTaskIns(message.getSscid(), message.getBillTypeId(), message.getBillId(), message.getDefId(), message.getWorkflowId());
        }
        long taskId = 0L;
        try {
            taskId = new ParTaskNodeServiceImpl().createNewNode(message.getSscid(), message.getBillTypeId(), message.getBillId(), String.valueOf(message.getWorkflowId()), message.getDefId(), insId, message.getNextNodeTypeId(), message.getNextNodeDefId());
        }
        catch (Exception e) {
            ErrorCode code = new ErrorCode("-4", e.getMessage());
            throw new KDException((Throwable)e, code, new Object[0]);
        }
        return taskId;
    }

    private static ErrorCode validateInsStatus(DynamicObject insDyo, long taskTypeId) {
        int status = insDyo.getInt("ptstatus");
        ErrorCode errCode = null;
        if (FlowInstEnum.PROCESSING.getValue() == status) {
            QFilter[] qFilters = new QFilter[]{new QFilter("instantid", "=", insDyo.getPkValue()), new QFilter("type", "=", (Object)taskTypeId)};
            if (QueryServiceHelper.exists((String)"task_partaskinstnode", (QFilter[])qFilters)) {
                log.info("\u91cd\u590d\u8c03\u7528\u5e42\u7b49\u6027\u5904\u7406,\u6e90\u81ea\uff1a\u672aack\u91cd\u53d1\u7684mq\u6d88\u606f");
                errCode = new ErrorCode("-2", ResManager.loadKDString((String)"\u91cd\u590d\u8c03\u7528\u5e42\u7b49\u6027\u5904\u7406", (String)"ParTaskConsumer_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if (FlowInstEnum.FAILED.getValue() == status || FlowInstEnum.REPULSE.getValue() == status) {
            errCode = new ErrorCode("-3", ResManager.loadKDString((String)"\u591a\u7ea7\u4efb\u52a1\u5b9e\u4f8b\u521b\u5efa\u5931\u8d25\uff0c\u53d6\u6d88\u521b\u5efa\u8282\u70b9\u4efb\u52a1\u3002", (String)"ParTaskConsumer_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return errCode;
    }
}

