/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BizBillValidateUtil {
    public static Map.Entry<Boolean, String> validateOrgUsed(List<Long> bailedOrg, long bizBillId, String bindBill, long applyCondId) {
        return BizBillValidateUtil.validateOrgUsedByBizBillStatus(bailedOrg, bizBillId, bindBill, "1", applyCondId);
    }

    public static Map.Entry<Boolean, String> validateOnWayBizBillOrgUsed(List<Long> bailedOrg, long bizBillId, String bindBill, long applyCondId) {
        return BizBillValidateUtil.validateOrgUsedByBizBillStatus(bailedOrg, bizBillId, bindBill, "2", applyCondId);
    }

    public static boolean existMultiEffectiveBizBill(long sscid, String bindBill) {
        return BizBillValidateUtil.existMultiBizBill(sscid, bindBill, "1");
    }

    public static boolean existMultiEffectiveBizBillIncludeIdFilter(long sscid, long bizBillId, String bindBill) {
        if (sscid <= 0L) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5165\u53c2\uff1asscid\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"BizBillValidateUtil_2", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        if (bizBillId <= 0L) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5165\u53c2\uff1abizBillId\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"BizBillValidateUtil_3", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)bindBill)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5165\u53c2\uff1abindBill\u4e0d\u80fd\u4e3a\u7a7a\u503c\u6216\u7a7a\u4e32\u3002", (String)"BizBillValidateUtil_4", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        qFilterList.add(new QFilter("bindbill", "=", (Object)bindBill));
        qFilterList.add(new QFilter("ssccenter", "=", (Object)sscid));
        qFilterList.add(new QFilter("effective", "=", (Object)"1"));
        qFilterList.add(new QFilter("id", "!=", (Object)bizBillId));
        return QueryServiceHelper.exists((String)"task_taskbill", (QFilter[])qFilterList.toArray(new QFilter[0]));
    }

    public static Map.Entry<Boolean, String> checkUseOrgOfOnWayBizBIll(String bindBill, List<Long> useOrgIds) {
        Map<Long, String> failOrgMap = BizBillValidateUtil.getOrgMapOfFailBizBillCon(bindBill, useOrgIds, "1", "1");
        if (failOrgMap != null && failOrgMap.size() > 0) {
            CharSequence[] orgNameCol = failOrgMap.values().toArray(new String[0]);
            StringBuilder jointOrgName = new StringBuilder();
            if (failOrgMap.size() > 5) {
                for (int i = 0; i < 5; ++i) {
                    jointOrgName.append((String)orgNameCol[i]);
                    if (i == 4) continue;
                    jointOrgName.append(",");
                }
                jointOrgName.append(String.format(ResManager.loadKDString((String)"\u7b49%s\u4e2a\u7ec4\u7ec7", (String)"BizBillValidateUtil_6", (String)"ssc-task-common", (Object[])new Object[0]), failOrgMap.size()));
            } else {
                jointOrgName = new StringBuilder(String.join((CharSequence)",", orgNameCol));
            }
            String orgBizBillCheckMsg = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e00\u4e2a\u751f\u6548\u72b6\u6001\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u4e14\u4efb\u52a1\u521b\u5efa\u6a21\u5f0f\u4e3a\u5de5\u4f5c\u6d41\u521b\u5efa\u4efb\u52a1\uff0c\u9002\u7528\u4e8e\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\uff0c\u65e0\u6cd5\u5728\u9014\u751f\u6548\u3002\u8bf7\u5c06\u6838\u7b97\u7ec4\u7ec7\u914d\u7f6e\u4e8e\u5bf9\u5e94\u7684\u5171\u4eab\u4e2d\u5fc3\u4e1a\u52a1\u5355\u636e\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e2d\u3002", (String)"BizBillValidateUtil_5", (String)"ssc-task-common", (Object[])new Object[0]), jointOrgName);
            return new AbstractMap.SimpleEntry<Boolean, String>(Boolean.FALSE, orgBizBillCheckMsg);
        }
        return new AbstractMap.SimpleEntry<Boolean, String>(Boolean.TRUE, "");
    }

    public static Map<Long, String> getOrgMapOfFailBizBillCon(String bindBill, List<Long> accountOrgIds, String createTaskModel, String effectiveStatus) {
        if (StringUtils.isEmpty((CharSequence)bindBill) || accountOrgIds == null || accountOrgIds.isEmpty()) {
            return null;
        }
        QFilter bindBillFilter = new QFilter("bindbill", "=", (Object)bindBill);
        QFilter effectiveFilter = new QFilter("effective", "=", (Object)effectiveStatus);
        QFilter createModelFilter = new QFilter("createtaskmodel", "=", (Object)createTaskModel);
        QFilter sscOrgParFilter = new QFilter("sscbillorgpar.FBasedataId", "in", accountOrgIds);
        DynamicObjectCollection connectedOrgCol = QueryServiceHelper.query((String)"task_taskbill", (String)"sscbillorgpar.FBasedataId accountOrgId", (QFilter[])new QFilter[]{bindBillFilter, createModelFilter, effectiveFilter, sscOrgParFilter});
        List connectedOrgIds = connectedOrgCol.stream().map(dyn -> dyn.getLong("accountOrgId")).collect(Collectors.toList());
        accountOrgIds.removeAll(connectedOrgIds);
        if (accountOrgIds.size() < 1) {
            return null;
        }
        DynamicObjectCollection orgDynCol = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "in", accountOrgIds).toArray());
        return orgDynCol.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("name")));
    }

    private static String constructValidateMsg(DynamicObject tkbillDyObj, long applyCondId) {
        StringBuilder orgReaptErrMsg = new StringBuilder();
        String msgFormat = applyCondId > 0L ? ResManager.loadKDString((String)"\u591a\u4e2a\u4e1a\u52a1\u5355\u636e\u7684\u6765\u6e90\u5355\u636e\uff08%1$s\uff09\u76f8\u540c\u4e14\u9002\u7528\u6761\u4ef6\u76f8\u540c\u65f6\uff0c\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e0d\u80fd\u6709\u4ea4\u96c6\uff1a\u5171\u4eab\u4e2d\u5fc3\uff08%2$s\uff09\u4e0b\u4e1a\u52a1\u5355\u636e\uff08%3$s %4$s\uff09\u7684\u9002\u7528\u7ec4\u7ec7\u5df2\u5f15\u7528\u7ec4\u7ec7\uff08%5$s\uff09", (String)"OrganizationSynchronizeUtil_15", (String)"ssc-task-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u591a\u4e2a\u4e1a\u52a1\u5355\u636e\u7684\u6765\u6e90\u5355\u636e\uff08%1$s\uff09\u76f8\u540c\u65f6\uff0c\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e0d\u80fd\u6709\u4ea4\u96c6\uff1a\u5171\u4eab\u4e2d\u5fc3\uff08%2$s\uff09\u4e0b\u4e1a\u52a1\u5355\u636e\uff08\u7f16\u53f7\uff1a%3$s\uff1b\u540d\u79f0\uff1a%4$s\uff09\u7684\u9002\u7528\u7ec4\u7ec7\u5df2\u5f15\u7528\u7ec4\u7ec7\uff08%5$s\uff09", (String)"OrganizationSynchronizeUtil_9", (String)"ssc-task-common", (Object[])new Object[0]);
        orgReaptErrMsg.append(String.format(msgFormat, tkbillDyObj.get("bindbill.name"), tkbillDyObj.get("ssccenter.name"), tkbillDyObj.get("number"), tkbillDyObj.get("name"), tkbillDyObj.get("sscbillorgpar.FBasedataId.name")));
        orgReaptErrMsg.append('\n');
        return orgReaptErrMsg.toString();
    }

    private static boolean existMultiBizBill(long sscId, String bindBill, String bizBillStatus) {
        if (sscId <= 0L) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5165\u53c2\uff1asscid\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"BizBillValidateUtil_2", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)bindBill)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5165\u53c2\uff1abindBill\u4e0d\u80fd\u4e3a\u7a7a\u503c\u6216\u7a7a\u4e32\u3002", (String)"BizBillValidateUtil_4", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        qFilterList.add(new QFilter("bindbill", "=", (Object)bindBill));
        qFilterList.add(new QFilter("ssccenter", "=", (Object)sscId));
        qFilterList.add(new QFilter("effective", "=", (Object)bizBillStatus));
        return QueryServiceHelper.exists((String)"task_taskbill", (QFilter[])qFilterList.toArray(new QFilter[0]));
    }

    private static Map.Entry<Boolean, String> validateOrgUsedByBizBillStatus(List<Long> bailedOrg, long bizBillId, String bindBill, String bizBIllStatus, long applyCondId) {
        if (StringUtils.isBlank((CharSequence)bindBill)) {
            return new AbstractMap.SimpleEntry<Boolean, String>(Boolean.FALSE, ResManager.loadKDString((String)"\u5165\u53c2\uff1abindBill\u4e0d\u80fd\u4e3a\u7a7a\u503c\u6216\u7a7a\u4e32\u3002", (String)"BizBillValidateUtil_0", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        if (bailedOrg == null) {
            return new AbstractMap.SimpleEntry<Boolean, String>(Boolean.FALSE, ResManager.loadKDString((String)"\u5165\u53c2\uff1abailedOrg\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"BizBillValidateUtil_1", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        if (bailedOrg.isEmpty()) {
            return new AbstractMap.SimpleEntry<Boolean, String>(Boolean.TRUE, "");
        }
        StringBuilder errorMsg = new StringBuilder();
        QFilter bindBillFilter = new QFilter("bindbill", "=", (Object)bindBill);
        QFilter idFilter = new QFilter("id", "!=", (Object)bizBillId);
        QFilter effectiveFilter = new QFilter("effective", "=", (Object)bizBIllStatus);
        QFilter sscOrgParFilter = new QFilter("sscbillorgpar.FBasedataId", "in", bailedOrg);
        QFilter applyCondFilter = new QFilter("applycond", "=", (Object)applyCondId);
        DynamicObjectCollection tkbillDyObjCol = QueryServiceHelper.query((String)"task_taskbill", (String)"number,name,ssccenter.name,sscbillorgpar.FBasedataId.name,bindbill.name", (QFilter[])new QFilter[]{bindBillFilter, idFilter, effectiveFilter, sscOrgParFilter, applyCondFilter});
        if (tkbillDyObjCol.size() == 0) {
            return new AbstractMap.SimpleEntry<Boolean, String>(Boolean.TRUE, "");
        }
        for (DynamicObject tkbillDyObj : tkbillDyObjCol) {
            errorMsg.append(BizBillValidateUtil.constructValidateMsg(tkbillDyObj, applyCondId));
        }
        return new AbstractMap.SimpleEntry<Boolean, String>(Boolean.FALSE, errorMsg.toString());
    }
}

