/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.workbill.field;

import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;

public abstract class AbstractFieldPropService {
    protected String formId;
    protected String closeCallBackKey;

    public AbstractFieldPropService() {
    }

    public AbstractFieldPropService(String formId, String closeCallBackKey) {
        this.formId = formId;
        this.closeCallBackKey = closeCallBackKey;
    }

    public abstract String getFieldPropertyJSON(Object var1);

    public abstract String convertJSONToFieldProperty(String var1);

    public String getFieldProperty(Object returnData) {
        String fieldPropertyJSON = this.getFieldPropertyJSON(returnData);
        return this.convertJSONToFieldProperty(fieldPropertyJSON);
    }

    public void showFieldPropChooseView(IFormView billView, IDataModel dataModel, String pluginName) {
        FormShowParameter showParameter = this.createFormShowParameter(pluginName);
        billView.showForm(showParameter);
    }

    protected FormShowParameter createFormShowParameter(String pluginName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(this.formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(pluginName, this.closeCallBackKey);
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    protected ListShowParameter createListShowParameter(String pluginName, String billFormId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(this.formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(pluginName, this.closeCallBackKey);
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }
}

