/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.eas.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.ssc.task.eas.bill.EASTaskBillHandler;

public class EASMarketAccountBillHandler
extends EASTaskBillHandler {
    @Override
    public void process(DynamicObject dataEntity, Set<Long> costcompany) {
        DynamicObject company = dataEntity.getDynamicObject("company");
        if (company != null && company.getLong("id") > 0L) {
            costcompany.add(company.getLong("id"));
        }
    }

    @Override
    public void getOpinion(DynamicObject dataEntity, HashMap<String, Object> opinionMap) {
        DynamicObjectCollection dataCc = dataEntity.getDynamicObjectCollection("entries");
        if (dataCc != null && dataCc.size() > 0) {
            DynamicObject dataDb = (DynamicObject)dataCc.get(0);
            Long expenseTypeId = dataDb.getLong("expensetype_Id");
            opinionMap.put("fieldKey", expenseTypeId);
        }
    }

    public Map<String, Object> pack(DynamicObject billData, boolean isPass) {
        HashMap<String, Object> bizData = new HashMap<String, Object>();
        DynamicObjectCollection entries = (DynamicObjectCollection)billData.get("entries");
        ArrayList entryList = new ArrayList();
        BigDecimal amountApproved = new BigDecimal("0");
        for (DynamicObject d : entries) {
            HashMap<String, Object> entryData = new HashMap<String, Object>();
            entryData.put("amountApproved", d.get("amountapproved").toString());
            entryData.put("purpose", d.get("purpose").toString());
            if (d.get("expensetype.id") != null) {
                Object numberobj;
                HashMap<String, String> expensetype = new HashMap<String, String>();
                String expensetypeId = d.get("expensetype.easid").toString();
                expensetype.put("id", expensetypeId);
                Object nameobj = d.get("expensetype.name");
                if (nameobj != null) {
                    String expensetypeName = nameobj.toString();
                    expensetype.put("name", expensetypeName);
                }
                if ((numberobj = d.get("expensetype.number")) != null) {
                    String expensetypeNumber = numberobj.toString();
                    expensetype.put("number", expensetypeNumber);
                }
                entryData.put("expenseType", expensetype);
            }
            amountApproved = amountApproved.add(d.getBigDecimal("amountApproved"));
            entryList.add(entryData);
        }
        bizData.put("amountApproved", amountApproved.toString());
        bizData.put("amountencashed", billData.get("amountencashed").toString());
        bizData.put("amoundStriked", billData.get("amoundstriked").toString());
        bizData.put("entrys", entryList);
        return bizData;
    }

    public void validate(DynamicObject billData, boolean isPass) {
    }
}

