/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.eventSend.core.SscEventDistributor;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.task.ErpFactory;
import kd.ssc.task.approveRebuild.TaskApproveBatchService;
import kd.ssc.task.approveRebuild.TaskApproveService;
import kd.ssc.task.business.task.TaskPriorityHelper;
import kd.ssc.task.business.task.TaskServiceHelper;
import kd.ssc.task.create.CreateParTaskByWorkFlow;
import kd.ssc.task.create.CreateTaskByWorkflow;
import kd.ssc.task.create.CreateTaskWrapper;
import kd.ssc.task.create.helper.CreateTaskHelper;
import kd.ssc.task.createRebuild.TaskCreateService;
import kd.ssc.task.createrule.CreateTask4RuleBosImpl;
import kd.ssc.task.delete.util.DeleteTaskUtil;
import kd.ssc.task.image.TaskUploadImage;
import kd.ssc.task.service.ITaskService;
import kd.ssc.task.util.ExpenseBoardApiServiceUtil;
import kd.ssc.task.util.IncomeReceiptBoardApiServiceUtil;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;
import kd.ssc.task.util.TaskWorkFlowUtil;
import kd.ssc.task.withdraw.TaskWithdrawUtil;

public class TaskService
implements ITaskService {
    private static final Log log = LogFactory.getLog(TaskService.class);

    public void imageReady(String imageNumber) {
        ORM orm = ORM.create();
        DynamicObject imageMap = orm.queryOne("task_billimagemap", "id,billtype,billid", new QFilter[]{new QFilter("imagenumber", "=", (Object)imageNumber)});
        if (imageMap != null) {
            DynamicObject[] doa;
            DynamicObjectCollection doc = orm.query("task_task", new QFilter[]{new QFilter("billid", "=", imageMap.get("billid")), new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue())});
            for (DynamicObject d : doa = (DynamicObject[])doc.toArray((Object[])new DynamicObject[doc.size()])) {
                d.set("pooltype", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
                Date now = new Date();
                d.set("createtime", (Object)now);
            }
            orm.update(doa);
        }
    }

    public long createTask(Map param) {
        String sysNumber = param.get("sourceSys").toString();
        return ErpFactory.getCreateTask4ExternalSystem((String)sysNumber).createTask(param);
    }

    public String getAuditMessage(Map param) {
        HashMap msgMap = new HashMap();
        LinkedList approveMsg = new LinkedList();
        LinkedList innerMsg = new LinkedList();
        String billId = (String)param.get("billId");
        boolean isHasApprove = (Boolean)param.get("isHasApprove");
        boolean isHasInner = (Boolean)param.get("isHasInner");
        ORM orm = ORM.create();
        DynamicObjectCollection tasks = orm.query("task_taskhistory", "id", new QFilter[]{new QFilter("billid", "=", (Object)billId)}, "receivetime desc");
        for (DynamicObject task : tasks) {
            DynamicObjectCollection stateChanges = orm.query("task_statechangehis", "id,changetime,operation,message,innermsg", new QFilter[]{new QFilter("jobid", "=", task.getPkValue())}, "changetime desc");
            if (stateChanges != null && stateChanges.size() > 0) {
                for (DynamicObject change : stateChanges) {
                    HashMap<String, String> appMap = new HashMap<String, String>();
                    HashMap<String, String> innerMap = new HashMap<String, String>();
                    appMap.put("sub", (String)change.get("message"));
                    appMap.put("operation", (String)change.get("operation"));
                    appMap.put("time", change.get("changetime").toString());
                    innerMap.put("sub", (String)change.get("innermsg"));
                    innerMap.put("operation", (String)change.get("operation"));
                    innerMap.put("time", change.get("changetime").toString());
                    approveMsg.add(appMap);
                    innerMsg.add(innerMap);
                }
                continue;
            }
            DynamicObjectCollection stateChangesc = orm.query("task_statechange", "id,changetime,operation,message,innermsg", new QFilter[]{new QFilter("jobid", "=", task.getPkValue())}, "changetime desc");
            if (stateChangesc == null || stateChangesc.size() <= 0) continue;
            for (DynamicObject change : stateChangesc) {
                HashMap<String, String> appMap = new HashMap<String, String>();
                HashMap<String, String> innerMap = new HashMap<String, String>();
                appMap.put("sub", (String)change.get("message"));
                appMap.put("operation", (String)change.get("operation"));
                appMap.put("time", change.get("changetime").toString());
                innerMap.put("sub", (String)change.get("innermsg"));
                innerMap.put("operation", (String)change.get("operation"));
                innerMap.put("time", change.get("changetime").toString());
                approveMsg.add(appMap);
                innerMsg.add(innerMap);
            }
        }
        if (isHasApprove) {
            msgMap.put("approveMessages", approveMsg);
        }
        if (isHasInner) {
            msgMap.put("innerMsgs", innerMsg);
        }
        return SerializationUtils.toJsonString(msgMap);
    }

    public void addWFCommon(DynamicObject[] tasks, String msg, String result, Long person) {
        TaskWorkFlowUtil.addWorkFlowComment((DynamicObject[])tasks, (String)msg, (String)result, (Long)person);
    }

    public void updateWFNameAndPerson(DynamicObject[] tasks, String msg) {
        TaskWorkFlowUtil.updatePersonAndMsgDisTask((DynamicObject[])tasks, (String)msg);
    }

    public byte[] reqBoardData(Map<Object, Object> map) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        int a = 500;
        resultMap.put("test", a);
        try {
            return JSONUtils.toString(resultMap).getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "".getBytes(StandardCharsets.UTF_8);
        }
    }

    public String getCreditLevelByUserId(Map<String, Object> param) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String userid = (String)param.get("userid");
        if (StringUtils.isNotBlank((CharSequence)userid)) {
            long uid = Long.parseLong(userid);
            DynamicObject userArchive = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getCreditLevelByUserId", (Object[])new Object[]{uid});
            String creditLevel = "";
            if (userArchive != null) {
                creditLevel = userArchive.getString("creditlevel.name");
            }
            retMap.put("creditlevel", creditLevel);
        }
        return SerializationUtils.toJsonString(retMap);
    }

    public String getExpenseBoardShowData(Map<Object, Object> arg0) {
        List retList = ExpenseBoardApiServiceUtil.getExpenseBoardShowData(arg0);
        try {
            return SerializationUtils.toJsonString((Object)retList);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getExpenseBoardOrgData(Map<Object, Object> map) {
        Map retList = ExpenseBoardApiServiceUtil.getExpenseBoardOrgData();
        try {
            return SerializationUtils.toJsonString((Object)retList);
        }
        catch (Exception e) {
            return "";
        }
    }

    public void execute(String billTypeKey, String operationKey, DynamicObject[] colls, List successPkIds) {
        OperationContext context = new OperationContext();
        context.setEntityTypeId(billTypeKey);
        context.setOperationKey(operationKey);
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccessPkIds(successPkIds);
        new CreateTask4RuleBosImpl().execute(context, colls, operationResult);
    }

    public long createTaskByWf(long taskTypeID, long billTypeID, String billID, long sscID, String executeOprtNumber, String reverseOprtNumber, long taskSubjectID, String assignID) {
        return new CreateTaskByWorkflow().createTask(taskTypeID, billTypeID, billID, 0L, "", "", 0L, assignID);
    }

    public String getIncomeReceiptBoardData(Map<Object, Object> arg0) {
        Map retList = IncomeReceiptBoardApiServiceUtil.getIncomeReceiptBoardData();
        try {
            return SerializationUtils.toJsonString((Object)retList);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getCreditInfoByUserId(Map<String, Object> param) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String userId = (String)param.get("userid");
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            Long uid = Long.valueOf(userId);
            Object[] creditFiles = new DynamicObject[]{};
            DynamicObject creditFile = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getCreditFileByUserId", (Object[])new Object[]{uid});
            if (creditFile != null) {
                creditFiles = new DynamicObject[]{creditFile};
            }
            String creditInfo = DynamicObjectSerializeUtil.serialize((Object[])creditFiles, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"task_creditfiles"));
            retMap.put("creditinfo", creditInfo);
        }
        return SerializationUtils.toJsonString(retMap);
    }

    public void updateWFNameAndPersonNocheckPerson(DynamicObject[] tasks, String msg) {
        TaskWorkFlowUtil.updateMsgCreateTask((DynamicObject[])tasks, (String)msg);
    }

    public boolean createParTaskByWf(String billId, Long billTypeId, Long[] taskTypeId, long workFlowId) {
        return new CreateParTaskByWorkFlow().publishInialMessage(billId, billTypeId, taskTypeId, workFlowId);
    }

    public boolean canWithdraw(String billId, String entityNumber, long workFlowId) throws KDBizException {
        if (StringUtils.isEmpty((CharSequence)billId) || StringUtils.isEmpty((CharSequence)entityNumber)) {
            log.error(String.format("\u5de5\u4f5c\u6d41\u8282\u70b9\u64a4\u56de\u6821\u9a8c\uff0c\u53c2\u6570\u5f02\u5e38=>billId:%s,entityNumber:%s", billId, entityNumber));
            throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u8282\u70b9\u64a4\u56de\u6821\u9a8c\u53c2\u6570\u5f02\u5e38", (String)"TaskService_0", (String)"ssc-task-mservice", (Object[])new Object[0]));
        }
        log.info("\u5de5\u4f5c\u6d41\u8282\u70b9\u64a4\u56de\u6821\u9a8c, billId: " + billId);
        return TaskWithdrawUtil.canWithdraw((String)billId, (String)entityNumber, (long)workFlowId);
    }

    public boolean modifyWfAuditMsg(Long billId, Long workflowId, String activityId, List<IApprovalRecordItem> items) throws Exception {
        Map result = ParTaskAuditMsgUpdateUtil.modifyWfAuditMsgNew((Long)billId, (Long)workflowId, (String)activityId);
        return result.getOrDefault("callSucceed", Boolean.FALSE);
    }

    public Map<String, Object> modifyWfAuditMsgNew(Long billId, Long workflowId, String activityId) throws Exception {
        return ParTaskAuditMsgUpdateUtil.modifyWfAuditMsgNew((Long)billId, (Long)workflowId, (String)activityId);
    }

    public boolean uploadImage(Map<String, ImageInfo> billImageMap) {
        TaskUploadImage uploadImage = new TaskUploadImage();
        try {
            uploadImage.updateTaskInfo(billImageMap);
        }
        catch (Exception e) {
            log.error(".uploadImage() ", (Throwable)e);
            return false;
        }
        return true;
    }

    public Map<String, Object> updateTaskSuspendedState(Map<String, Object> param) {
        log.info("\u8c03\u7528\u66f4\u65b0\u4efb\u52a1\u6682\u6302\u72b6\u6001\u5fae\u670d\u52a1\u63a5\u53e3\uff0c\u53c2\u6570\uff1a" + param);
        Long taskId = (Long)param.get("taskId");
        String operate = (String)param.get("operate");
        List pendingOpinionList = (List)param.get("pendingOpinionList");
        String reason = (String)param.get("reason");
        if (taskId == null || taskId == 0L) {
            String billType = (String)param.get("billType");
            String billId = (String)param.get("billId");
            return TaskServiceHelper.updateTaskSuspendedStateByBill((String)billType, (String)billId, (String)operate, (String)reason);
        }
        return TaskServiceHelper.updateTaskSuspendedStateByTaskId((Long)taskId, (String)operate, (String)reason, (List)pendingOpinionList, null);
    }

    public List<Map<String, Object>> updateTaskPriority(List<Map<String, Object>> billInfoList, Integer taskPriority) {
        return TaskPriorityHelper.updateTaskPriority(billInfoList, (Integer)taskPriority);
    }

    @Deprecated
    public Long[] deleteTaskAfterProcessAbandon(List<Long> taskIds) {
        log.info("\u8c03\u7528\u4efb\u52a1\u5220\u9664\u5fae\u670d\u52a1\u63a5\u53e3\uff0c\u5f85\u5220\u9664\u4efb\u52a1\u6570\u636e\uff1a" + taskIds);
        return DeleteTaskUtil.deleteTaskAfterProcessAbandon((Long[])taskIds.toArray(new Long[0]));
    }

    public Long[] deleteTaskAfterProcessAbandon(Long sscId, List<Long> taskIds) {
        log.info("\u8c03\u7528\u4efb\u52a1\u5220\u9664\u5fae\u670d\u52a1\u63a5\u53e3\uff0c\u5f85\u5220\u9664\u4efb\u52a1\u6570\u636e\uff1a" + taskIds);
        Long[] successTaskIds = DeleteTaskUtil.deleteTaskAfterProcessAbandon((Long[])taskIds.toArray(new Long[0]));
        if (successTaskIds != null && successTaskIds.length > 0) {
            List<Long> taskIdList = Arrays.asList(successTaskIds);
            SscEventDistributor.taskSyncData((String)"task_task", (DataChangeTypeEnum)DataChangeTypeEnum.DELETE, (Long)sscId, taskIdList);
        }
        return successTaskIds;
    }

    public boolean taskWithdrawFromSSC(String billId, String wfTaskId) {
        log.info("\u5171\u4eab\u5ba1\u6838\u64a4\u56de");
        if (StringUtils.isBlank((CharSequence)billId) || StringUtils.isBlank((CharSequence)wfTaskId)) {
            log.error("\u5171\u4eab\u5ba1\u6838\u64a4\u56de\u5165\u53c2\u6709\u8bef\uff1a" + billId);
            return false;
        }
        log.info("\u5171\u4eab\u5ba1\u6838\u64a4\u56de\uff0c\u5355\u636eid: " + billId);
        return TaskWithdrawUtil.taskWithdraw((String)billId, (String)wfTaskId);
    }

    public boolean createTaskAfterWithdraw(Long taskId, Long wfTaskId) throws Exception {
        if (CreateTaskHelper.isLegitimateInput((Long)taskId, (Long)wfTaskId)) {
            CreateTaskHelper.createTaskByWithdraw((Long)taskId, (Long)wfTaskId);
        }
        return false;
    }

    public Map<String, Object> createTask4HRActivity(Map<String, Object> paramMap) {
        log.info("ITaskService.createTask4HRActivity(),paramMap=" + JSONObject.toJSONString(paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        Map resultMap = new CreateTaskWrapper().createTask4HRActivity(paramMap);
        log.info("ITaskService.createTask4HRActivity(),resultMap=" + JSONObject.toJSONString((Object)resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return resultMap;
    }

    public Map<String, Object> createTask4HRNotActivity(Map<String, Object> paramMap) {
        log.info("ITaskService.createTask4HRNotActivity(),paramMap=" + JSONObject.toJSONString(paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        Map resultMap = new CreateTaskWrapper().createTask4HRNotActivity(paramMap);
        log.info("ITaskService.createTask4HRNotActivity(),resultMap=" + JSONObject.toJSONString((Object)resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return resultMap;
    }

    public Map<String, Object> exactCreateTask4HRVerify(Map<String, Object> paramMap) {
        TaskCreateService taskCreateService = new TaskCreateService();
        return taskCreateService.exactCreateTask4HRVerify(paramMap);
    }

    public Map<String, Object> taskApproveSubmit(Map<String, Object> paramMap) {
        TaskApproveService TaskApproveService2 = new TaskApproveService();
        return TaskApproveService2.taskApproveSubmit(paramMap);
    }

    public Map<String, Object> taskApproveSubmitByPass(Map<String, Object> paramMap) {
        TaskApproveService TaskApproveService2 = new TaskApproveService();
        return TaskApproveService2.taskApproveSubmitByPass(paramMap);
    }

    public Map<String, Object> taskApproveSubmitByNoPass(Map<String, Object> paramMap) {
        TaskApproveService TaskApproveService2 = new TaskApproveService();
        return TaskApproveService2.taskApproveSubmitByNoPass(paramMap);
    }

    public Map<String, Object> taskApproveByPend(Map<String, Object> paramMap) {
        TaskApproveService TaskApproveService2 = new TaskApproveService();
        return TaskApproveService2.taskApproveByPend(paramMap);
    }

    public Map<String, Object> taskApproveByCancelPend(Map<String, Object> paramMap) {
        TaskApproveService TaskApproveService2 = new TaskApproveService();
        return TaskApproveService2.taskApproveByCancelPend(paramMap);
    }

    public Map<String, Object> taskApproveBySave(Map<String, Object> paramMap) {
        TaskApproveService TaskApproveService2 = new TaskApproveService();
        return TaskApproveService2.taskApproveBySave(paramMap);
    }

    public Map<String, Object> saveArtiCheckPointInfo(Map<String, Object> paramMap) {
        TaskApproveService TaskApproveService2 = new TaskApproveService();
        return TaskApproveService2.saveArtiCheckPointInfo(paramMap);
    }

    public Map<String, Object> taskApproveByComplete(Map<String, Object> paramMap) {
        log.info("ITaskService.taskApproveByComplete(),paramMap=" + JSONObject.toJSONString(paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        TaskApproveBatchService taskApproveService = new TaskApproveBatchService();
        Map resultMap = taskApproveService.doTaskApproveByComplete(paramMap);
        log.info("ITaskService.taskApproveByComplete(),resultMap=" + JSONObject.toJSONString((Object)resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return resultMap;
    }

    public Map<String, Object> taskApproveByTerminate(Map<String, Object> paramMap) {
        log.info("ITaskService.taskApproveByTerminate(),paramMap=" + JSONObject.toJSONString(paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        TaskApproveBatchService taskApproveService = new TaskApproveBatchService();
        Map resultMap = taskApproveService.doTaskApproveByTerminate(paramMap);
        log.info("ITaskService.taskApproveByTerminate(),resultMap=" + JSONObject.toJSONString((Object)resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return resultMap;
    }

    public Map<String, Object> taskQueryByBillId(Map<String, Object> paramMap) {
        log.info("ITaskService.taskQueryByBillId(),paramMap=" + JSONObject.toJSONString(paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        TaskApproveBatchService taskApproveService = new TaskApproveBatchService();
        Map resultMap = taskApproveService.doTaskQueryByBillId(paramMap);
        log.info("ITaskService.taskQueryByBillId(),resultMap=" + JSONObject.toJSONString((Object)resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return resultMap;
    }

    public Map<String, Object> taskDeleteByTaskId(Map<String, Object> paramMap) {
        log.info("ITaskService.taskDeleteByTaskId(),paramMap=" + JSONObject.toJSONString(paramMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        TaskApproveBatchService taskApproveService = new TaskApproveBatchService();
        Map resultMap = taskApproveService.doTaskDeleteByTaskId(paramMap);
        log.info("ITaskService.taskDeleteByTaskId(),resultMap=" + JSONObject.toJSONString((Object)resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return resultMap;
    }
}

