/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.achieve.preset;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.fi.ssc.extpoint.achieve.ICustomAchieveFactorPlugin;
import kd.ssc.achieve.StringFieldSumAggFunction;
import kd.ssc.achieve.TimeBitSetAggFunction;

public class OnDutyTimeCompute
implements ICustomAchieveFactorPlugin {
    private static final String ALGO_KEY = "fi.ssc.achieve.OnDutyTimeCompute";

    public Object getCustomAchieveFactor(Long mainOrgId, String assessType, Long assessObjectId, Date startDate, Date endDate) {
        Map<Long, Object> values = this.computeFactorValues(mainOrgId, assessType, Collections.singleton(assessObjectId), startDate, endDate);
        if (values != null) {
            return values.get(assessObjectId) != null ? values.get(assessObjectId) : Integer.valueOf(0);
        }
        return null;
    }

    public Map<Long, Object> getCustomAchieveFactorBatch(Long mainOrgId, String assessType, Set<Long> assessObjectIds, Date startDate, Date endDate) {
        return this.computeFactorValues(mainOrgId, assessType, assessObjectIds, startDate, endDate);
    }

    private Map<Long, Object> computeFactorValues(Long mainOrgId, String assessType, Set<Long> assessObjectIds, Date startDate, Date endDate) {
        if ("2".equals(assessType)) {
            QFilter[] filters = new QFilter[3];
            filters[0] = new QFilter("daten", ">=", (Object)startDate);
            filters[0].and(new QFilter("daten", "<=", (Object)endDate));
            filters[1] = new QFilter("userid", "in", assessObjectIds);
            filters[2] = new QFilter("sscid", "=", (Object)mainOrgId);
            String selectFields = "userid,daten,dutytimebitset";
            HashMap<Long, Object> result = new HashMap<Long, Object>();
            try (DataSet dSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"ssc_userondutytime", (String)selectFields, (QFilter[])filters, null);){
                DataSet oneDay = dSet.groupBy(new String[]{"userid", "daten"}).agg((CustomAggFunction)new TimeBitSetAggFunction(), "dutytimebitset", "dutyTimeOfOneDay").finish();
                if (oneDay.hasNext()) {
                    DataSet dutyTime = oneDay.groupBy(new String[]{"userid"}).agg((CustomAggFunction)new StringFieldSumAggFunction(), "dutyTimeOfOneDay", "dutyTime").finish();
                    for (Row row : dutyTime) {
                        result.put(row.getLong("userid"), row.getBigDecimal("dutyTime"));
                    }
                }
            }
            for (Long assessObj : assessObjectIds) {
                result.computeIfAbsent(assessObj, key -> 0);
            }
            return result;
        }
        return null;
    }
}

