/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.achieve.preset;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.sdk.fi.ssc.extpoint.achieve.ICustomAchieveFactorPlugin;

public class TaskInspectionFailedCountCompute
implements ICustomAchieveFactorPlugin {
    private static final String ALGO_KEY = "fi.ssc.achieve.presetFactor";
    private static final String TASK_ENTITY_NAME = "task_taskhistory";

    public Object getCustomAchieveFactor(Long mainOrgId, String assessType, Long assessObjectId, Date startDate, Date endDate) {
        String assessObjField = this.getAssessObjField(assessType);
        if (assessObjField == null) {
            return null;
        }
        return this.getSingleAssessObjValue(mainOrgId, assessObjField, assessObjectId, startDate, endDate);
    }

    public Map<Long, Object> getCustomAchieveFactorBatch(Long mainOrgId, String assessType, Set<Long> assessObjectIds, Date startDate, Date endDate) {
        int size = (int)Math.ceil((double)assessObjectIds.size() / 0.75);
        HashMap<Long, Object> result = new HashMap<Long, Object>(size);
        for (Long assessObj : assessObjectIds) {
            result.put(assessObj, 0);
        }
        String assessObjField = this.getAssessObjField(assessType);
        if (assessObjField == null) {
            return null;
        }
        for (Long assessObjectId : assessObjectIds) {
            int value = this.getSingleAssessObjValue(mainOrgId, assessObjField, assessObjectId, startDate, endDate);
            result.put(assessObjectId, value);
        }
        return result;
    }

    private int getSingleAssessObjValue(Long mainOrgId, String assessObjField, Long assessObjectId, Date startDate, Date endDate) {
        QFilter[] filters = new QFilter[3];
        filters[0] = new QFilter("completetime", ">=", (Object)startDate);
        filters[0].and(new QFilter("completetime", "<=", (Object)endDate));
        filters[1] = new QFilter("sscid", "=", (Object)mainOrgId);
        filters[2] = new QFilter(assessObjField, "=", (Object)assessObjectId);
        ArrayList idList = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY, TASK_ENTITY_NAME, "id", filters);){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        if (idList.size() < 1) {
            return 0;
        }
        QFilter[] filters2 = new QFilter[]{new QFilter("sourcetaskid", "in", idList), new QFilter("qualityresult", "=", (Object)"0")};
        return ORM.create().count(ALGO_KEY, TASK_ENTITY_NAME, filters2);
    }

    private String getAssessObjField(String assessObjType) {
        String assessObjField;
        if ("2".equals(assessObjType)) {
            assessObjField = "personid";
        } else if ("1".equals(assessObjType)) {
            assessObjField = "usergroup";
        } else {
            return null;
        }
        return assessObjField;
    }
}

