/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.query;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.business.boardv2.helper.TimingLogger;
import kd.ssc.task.business.boardv2.pojo.TaskTaskData;
import org.apache.commons.lang3.StringUtils;

public class TaskDataProcessor {
    private static final String TASK = "task_task";
    private static final Log log = LogFactory.getLog(TaskDataProcessor.class);

    public TaskTaskData realTimeQuery(long sscId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("qualitysamplelibrary", "=", (Object)0L), new QFilter("sscid", "=", (Object)sscId)};
        TaskTaskData taskTaskData = new TaskTaskData();
        taskTaskData.setSscId(sscId);
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfM = cal.get(5);
        int month = cal.get(2);
        int year = cal.get(1);
        TimingLogger timingLogger = new TimingLogger();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"realTimeQuery#task_task", (String)TASK, (String)"usergroup,pooltype,state,expirestate,createtime", (QFilter[])qFilters, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long userGroup = row.getLong("usergroup");
                String poolType = row.getString("pooltype");
                String state = row.getString("state");
                String expire = row.getString("expirestate");
                Date createTime = row.getDate("createtime");
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{poolType, state})) continue;
                this.processTime(taskTaskData, dayOfM, month, year, createTime);
                this.processData(taskTaskData, poolType, state, userGroup, expire);
            }
        }
        timingLogger.info("kd.ssc.task.business.boardv2.query.TaskDataProcessor.realTimeQuery", log);
        return taskTaskData;
    }

    private void processTime(TaskTaskData taskTaskData, int dayOfM, int month, int year, Date createTime) {
        if (createTime == null) {
            return;
        }
        int[] taskCount = taskTaskData.getTaskCount();
        Calendar cal = Calendar.getInstance();
        cal.setTime(createTime);
        int d = cal.get(5);
        int m = cal.get(2);
        int y = cal.get(1);
        if (dayOfM == d) {
            taskCount[0] = taskCount[0] + 1;
        }
        if (month == m) {
            taskCount[1] = taskCount[1] + 1;
        }
        if (year == y) {
            taskCount[2] = taskCount[2] + 1;
        }
    }

    private void processData(TaskTaskData taskTaskData, String poolType, String state, Long userGroup, String expire) {
        int[] sscData = taskTaskData.getSscData();
        if (TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue().equals(poolType)) {
            sscData[0] = sscData[0] + 1;
        } else if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(poolType)) {
            sscData[1] = sscData[1] + 1;
        } else if (TaskPoolTypeEnum.PROCESSING.getValue().equals(poolType) && userGroup != null) {
            Map<Long, int[]> groupsData = taskTaskData.getGroupsData();
            int[] groupData = groupsData.computeIfAbsent(userGroup, k -> new int[3]);
            groupData[0] = groupData[0] + 1;
            sscData[2] = sscData[2] + 1;
            if ("2".equals(expire)) {
                groupData[1] = groupData[1] + 1;
                sscData[3] = sscData[3] + 1;
            }
            if (TaskStateEnum.PAUSE.getValue().equals(state)) {
                groupData[2] = groupData[2] + 1;
            }
        }
    }
}

