/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.urge;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.fatvs.urge.IFatvsUrgeAttribPlugin;
import kd.bos.ext.fi.fatvs.urge.UrgePluginContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class FatvsUrgePluginImpl
implements IFatvsUrgeAttribPlugin {
    private static final Log log = LogFactory.getLog(FatvsUrgePluginImpl.class);
    private static final String ASSIGN_ID = "assignid";
    private static final String SOURCE_OBJ_NUM = "wf_execution";
    private static final String ATTRIB_TYPE = "radiofield";

    public Map<Object, Object> execute(UrgePluginContext urgePluginContext) {
        log.info("urgePluginContext :" + urgePluginContext);
        this.checkUrgeContextValue(urgePluginContext);
        Map<Object, Object> resultMap = this.buildResult(urgePluginContext);
        log.info("resultMap \uff1a" + resultMap);
        return resultMap;
    }

    private Map<Object, Object> buildResult(UrgePluginContext urgePluginContext) {
        Set<Long> wfExecutionIds = urgePluginContext.getSourceobjIds().stream().map(id -> Long.valueOf(id + "")).collect(Collectors.toSet());
        Map<Long, Long> wfAssignIdMap = this.queryWfAssignId(wfExecutionIds);
        Set<Long> existTaskAssignId = this.getExistTaskAssignId(wfAssignIdMap);
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>(16);
        for (Long wfExecutionId : wfExecutionIds) {
            Long currentTaskId = wfAssignIdMap.get(wfExecutionId);
            if (currentTaskId == null) {
                resultMap.put(wfExecutionId, Boolean.FALSE);
                continue;
            }
            boolean existTask = existTaskAssignId.contains(currentTaskId);
            resultMap.put(wfExecutionId, existTask);
        }
        return resultMap;
    }

    private void checkUrgeContextValue(UrgePluginContext urgePluginContext) {
        String sourceobjNum = urgePluginContext.getSourceobjNum();
        if (!StringUtils.equals((CharSequence)sourceobjNum, (CharSequence)SOURCE_OBJ_NUM)) {
            throw new KDException(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u4ec5\u652f\u6301\u6d41\u7a0b\u5b9e\u4f8b\u3002", (String)"FatvsUrgePluginImpl_0", (String)"ssc-task-business", (Object[])new Object[0]));
        }
        String attribType = urgePluginContext.getAttribType();
        if (!StringUtils.equals((CharSequence)attribType, (CharSequence)ATTRIB_TYPE)) {
            throw new KDException(ResManager.loadKDString((String)"\u5b57\u6bb5\u7c7b\u578b\u4ec5\u652f\u6301\u5e03\u5c14\u7c7b\u578b\u3002", (String)"FatvsUrgePluginImpl_1", (String)"ssc-task-business", (Object[])new Object[0]));
        }
        List sourceobjIds = urgePluginContext.getSourceobjIds();
        if (CollectionUtils.isEmpty((Collection)sourceobjIds)) {
            throw new KDException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61id\u96c6\u5408\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"FatvsUrgePluginImpl_2", (String)"ssc-task-business", (Object[])new Object[0]));
        }
    }

    private Map<Long, Long> queryWfAssignId(Set<Long> wfExecutionIds) {
        QFilter qFilter = new QFilter("parentid", "in", wfExecutionIds);
        QFilter taskIdFilter = new QFilter("currenttaskid", "!=", (Object)0L);
        DynamicObjectCollection wfProcessIns = QueryServiceHelper.query((String)SOURCE_OBJ_NUM, (String)"parentid,currenttaskid", (QFilter[])new QFilter[]{qFilter, taskIdFilter});
        if (CollectionUtils.isEmpty((Collection)wfProcessIns)) {
            return new HashMap<Long, Long>(8);
        }
        return wfProcessIns.stream().collect(Collectors.toMap(instance -> instance.getLong("parentid"), instance -> instance.getLong("currenttaskid")));
    }

    private Set<Long> getExistTaskAssignId(Map<Long, Long> wfAssignIds) {
        if (CollectionUtils.isEmpty(wfAssignIds)) {
            return new HashSet<Long>();
        }
        Set assignIdSet = wfAssignIds.values().stream().map(String::valueOf).collect(Collectors.toSet());
        QFilter qFilter = new QFilter(ASSIGN_ID, "in", assignIdSet);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_task", (String)ASSIGN_ID, (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return new HashSet<Long>(8);
        }
        return tasks.stream().map(task -> task.getString(ASSIGN_ID)).map(Long::valueOf).collect(Collectors.toSet());
    }
}

