/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.ssc.enums.Source;

public class OutSystemWorkLoadNodeChangeUtil {
    private static Log log = LogFactory.getLog(OutSystemWorkLoadNodeChangeUtil.class);

    public static void changeWorkLoadNode(DynamicObject[] jobs, IFormView view) {
        if (jobs == null || jobs.length == 0) {
            return;
        }
        ArrayList<Long> billTypeIdList = new ArrayList<Long>(jobs.length);
        for (DynamicObject job : jobs) {
            billTypeIdList.add(job.getLong("billtype.id"));
        }
        Map<Long, String> billTypeErpNumberMap = OutSystemWorkLoadNodeChangeUtil.buildJobMapTaskBillIDErpNumMap(billTypeIdList);
        OutSystemWorkLoadNodeChangeUtil.updateWorkFlow(jobs, billTypeErpNumberMap, view);
    }

    private static void updateWorkFlow(DynamicObject[] jobs, Map<Long, String> billTypeErpNumberMap, IFormView view) {
        StringBuilder jobTipDisBuf = new StringBuilder();
        for (DynamicObject job : jobs) {
            if (OutSystemWorkLoadNodeChangeUtil.isKdccBill(job)) continue;
            long billTypeId = job.getLong("billtype.id");
            String erpNum = billTypeErpNumberMap.get(billTypeId);
            try {
                long personId = job.get("personid") instanceof DynamicObject ? job.getLong("personid.id") : job.getLong("personid");
                if (personId <= 0L) continue;
                String extendNum = job.getString("billtype.externalerp.number");
                OutSystemWorkLoadNodeChangeUtil.updateAssignmentPerformer(extendNum, job.getLong("id"), job.getString("assignid"), personId);
            }
            catch (Exception e) {
                jobTipDisBuf.append(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5de5\u4f5c\u6d41\u5f53\u524d\u5904\u7406\u4eba\u5f02\u5e38\uff0c\u4efb\u52a1\u4e3b\u9898\uff1a%1$s\uff0c\u5355\u636e\u7c7b\u578bID\uff1a%2$s\uff0cerpNum\uff1a%3$s\uff0c\u5de5\u4f5c\u6d41\u4efb\u52a1\uff1a%4$s\uff0c\u5206\u914d\u4ebaID\uff1a%5$s\uff0c\u5f02\u5e38\u5185\u5bb9\uff1a%6$s", (String)"OutSystemWorkLoadNodeChangeUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), job.getString("subject"), billTypeId, erpNum, job.getString("assignid"), job.getString("personid"), e.getMessage() + "\r\n"));
                log.error(jobTipDisBuf.toString(), (Throwable)e);
            }
        }
        if (jobTipDisBuf.length() > 0 && view != null) {
            view.showMessage(jobTipDisBuf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAssignmentPerformer(String extendNum, Long jobid, String assignId, long userID) {
        HashMap<String, Object> updateAssignParam = new HashMap<String, Object>(8);
        updateAssignParam.put("extendNum", extendNum);
        updateAssignParam.put("jobid", jobid);
        updateAssignParam.put("assignId", assignId);
        updateAssignParam.put("userID", userID);
        log.info("\u5165\u961fMQ");
        log.info("assignId : " + assignId);
        log.info("\u521b\u5efaMQ\u6210\u529f");
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.eas.ssc_assignerup");){
            pub.publish(updateAssignParam);
        }
    }

    private static boolean isKdccBill(DynamicObject job) {
        String source = job.getString("source");
        String extendNum = job.getString("billtype.externalerp.number");
        return (source.equals(Integer.toString(Source.WorkFlow.getValue())) || source.equals(Integer.toString(Source.ParTask.getValue()))) && "KDCC".equalsIgnoreCase(extendNum);
    }

    private static Map<Long, String> buildJobMapTaskBillIDErpNumMap(List<Long> jobIds) {
        ORM orm = ORM.create();
        HashMap<Long, String> billTypeErpNumberMap = new HashMap<Long, String>(16);
        QFilter billIdFilter = new QFilter("id", "in", jobIds);
        try (DataSet taskBillDataSet = orm.queryDataSet(OutSystemWorkLoadNodeChangeUtil.class.getSimpleName() + ".query taskbill erpNum", "task_taskbill", "id,externalerp.number", new QFilter[]{billIdFilter});){
            for (Row row : taskBillDataSet) {
                billTypeErpNumberMap.put(row.getLong("id"), row.getString("externalerp.number"));
            }
        }
        return billTypeErpNumberMap;
    }
}

