/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.dis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTaskSourceEnum;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.exception.ExceptionPlatformUtil;
import kd.ssc.exception.TaskErrorCodeEnum;
import kd.ssc.exception.TaskKDExcetptionUtil;
import kd.ssc.task.business.service.credit.CreditDelayService;
import kd.ssc.task.common.OutSystemWorkLoadNodeChangeUtil;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.dis.ApplyCreditLevel;
import kd.ssc.task.dis.BillCusFilter;
import kd.ssc.task.dis.CreditDelayDis;
import kd.ssc.task.dis.CusDisRule;
import kd.ssc.task.dis.HisTaskDisRule;
import kd.ssc.task.dis.QulityJob;
import kd.ssc.task.dis.RobortRepulseRule;
import kd.ssc.task.dis.TaskChecker;
import kd.ssc.task.dis.WorkLoad;
import kd.ssc.task.disRebuild.engine.Distribution;
import kd.ssc.task.disRebuild.util.RobertUserGroupUtil;
import kd.ssc.task.helper.MessageHelper;
import kd.ssc.task.service.distask.WorkLoadService;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class TaskAutoDisTaskPro
extends AbstractTask {
    private static final Log log = LogFactory.getLog(TaskAutoDisTaskPro.class);
    private static final int TASKQUERYNUM = 10000;
    private boolean printLog;
    private QFilter taskBaseFilter = null;
    private Set<Long> successSampleLibIds = new HashSet<Long>(8);

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        this.autdoDis(null, DisTaskSourceEnum.AUTO_DIS_1, false);
    }

    private DynamicObjectCollection getImplementClass(String className) {
        QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("interfacename", "=", (Object)className);
        return QueryServiceHelper.query((String)"task_interfaceconfig", (String)"implementname", (QFilter[])new QFilter[]{qFilter1, qFilter2});
    }

    private DynamicObject[] getUndisTask(QFilter unDisfilter) {
        this.logInfo(ResManager.loadKDString((String)"kd.ssc.task.formplugin.TaskAutoDisTask.getUndisTask() \u5f00\u59cb\u83b7\u53d6\u672a\u5206\u914d\u4efb\u52a1", (String)"TaskAutoDisTask_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        QFilter unDisTaskFilter = this.buildDisTaskFilter(unDisfilter);
        int taskQueryNum = this.getAutoDisTaskQueryNum();
        return BusinessDataServiceHelper.load((String)"task_task", (String)"id,tasktypeid,oldtaskstate,state,billtype,receivetime,expirestate,personid,usergroup,sscid,pooltype,billid,source,orgid,bizdata_tag,assignid,subject,billnumber,creator.id,qualitystate,orignalperson,qualitysamplelibrary.id,autoprocess,hasallocated,sourcetaskid,tasklevelid.priority,billtype.externalerp.number,firstreceivetime", (QFilter[])new QFilter[]{unDisTaskFilter}, (String)"tasklevelid.priority,createtime", (int)taskQueryNum);
    }

    private int getAutoDisTaskQueryNum() {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)"autoDisTaskQueryNum")});
        if (dynamicObject == null) {
            return 10000;
        }
        try {
            int num = dynamicObject.getInt("paramvalue");
            if (num <= 0 || num > 10000) {
                return 10000;
            }
            return num;
        }
        catch (Exception e) {
            log.error("Error on parsing task_paramcontrol, autoDisTaskQueryNum = {}", dynamicObject.get("paramvalue"));
            return 10000;
        }
    }

    private QFilter buildDisTaskFilter(QFilter unDisfilter) {
        QFilter taskFilter;
        QFilter poolTypeFil = new QFilter("pooltype", "in", (Object)new String[]{TaskPoolTypeEnum.TO_BE_DIS.getValue(), TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue()});
        QFilter recycleFil = new QFilter("state", "!=", (Object)TaskStateEnum.RECYCLE.getValue());
        if (unDisfilter != null) {
            taskFilter = poolTypeFil.and(recycleFil).and(unDisfilter);
        } else {
            QFilter manualDisFil = new QFilter("state", "!=", (Object)TaskStateEnum.TO_BE_MANUAL_DIS.getValue());
            taskFilter = poolTypeFil.and(manualDisFil).and(recycleFil);
            this.taskBaseFilter = taskFilter.copy();
        }
        return taskFilter;
    }

    public void autdoDis(QFilter UnDisfilter, DisTaskSourceEnum disTaskSource, boolean sync) {
        if ("true".equals(TaskParamHelper.getTaskParamByName((String)"enableDisRebuild"))) {
            Distribution.autoDistribution(UnDisfilter, disTaskSource, sync);
        } else {
            this.printLog = this.isPrintLog();
            DynamicObject[] unDisTaskcol = this.getUndisTask(UnDisfilter);
            if (unDisTaskcol == null || unDisTaskcol.length == 0) {
                this.logInfo("auotDisTask:no not allot task");
                return;
            }
            this.disTask(unDisTaskcol);
            this.logInfo("autoDisTask execute end");
        }
    }

    private void disTask(DynamicObject[] unDisTaskcol) {
        DynamicObject[] normalTask;
        WorkLoadService workLoad;
        ArrayList<DynamicObject> stateChangeDyObjlist = new ArrayList<DynamicObject>();
        HisTaskDisRule hisTaskDisRule = new HisTaskDisRule(unDisTaskcol);
        hisTaskDisRule.prepareBaseData();
        hisTaskDisRule.setPrintLog(this.printLog);
        RobortRepulseRule robortRepulseRule = new RobortRepulseRule(hisTaskDisRule);
        robortRepulseRule.prepareData();
        robortRepulseRule.setPrintLog(this.printLog);
        ApplyCreditLevel applyCreditLevel = new ApplyCreditLevel(unDisTaskcol);
        applyCreditLevel.prepareData();
        applyCreditLevel.setPrintLog(this.printLog);
        DynamicObjectCollection creditDelayDisCollection = this.getImplementClass("CreditDelayService");
        CreditDelayDis creditDelayService = null;
        if (CollectionUtils.isEmpty((Collection)creditDelayDisCollection)) {
            creditDelayService = new CreditDelayDis();
        } else {
            try {
                String value = (String)((DynamicObject)creditDelayDisCollection.get(0)).get("implementname");
                Class<?> aClass = Class.forName(value);
                creditDelayService = (CreditDelayService)aClass.newInstance();
            }
            catch (Exception e) {
                log.error("kd.ssc.task.dis.TaskAutoDisTaskPro: \u53cd\u5c04CreditDelayService\u5b9e\u73b0\u7c7b\u5f02\u5e38", (Throwable)e);
                throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)TaskErrorCodeEnum.C_REFLECT_EXCEPTION.getCode(), (String)ResManager.loadKDString((String)"\u53cd\u5c04CreditDelayService\u5b9e\u73b0\u7c7b\u5f02\u5e38\u3002", (String)"ExceptionTaskReflect_0", (String)"ssc-task-common", (Object[])new Object[0]), (Object[])new Object[0]);
            }
        }
        creditDelayService.setUnDisTaskCol(unDisTaskcol);
        creditDelayService.setTaskBaseFilter(this.taskBaseFilter);
        creditDelayService.prepareData();
        creditDelayService.setPrintLog(this.printLog);
        BillCusFilter billCusFilter = new BillCusFilter();
        billCusFilter.prepareData();
        billCusFilter.setPrintLog(this.printLog);
        DynamicObjectCollection workLoadServices = this.getImplementClass("WorkLoadService");
        if (CollectionUtils.isEmpty((Collection)workLoadServices)) {
            workLoad = new WorkLoad();
        } else {
            try {
                String value = (String)((DynamicObject)workLoadServices.get(0)).get("implementname");
                Class<?> aClass = Class.forName(value);
                workLoad = (WorkLoadService)aClass.newInstance();
            }
            catch (Exception e) {
                log.error("kd.ssc.task.dis.TaskAutoDisTaskPro: \u53cd\u5c04WorkLoadService\u5b9e\u73b0\u7c7b\u5f02\u5e38", (Throwable)e);
                throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)TaskErrorCodeEnum.C_REFLECT_EXCEPTION.getCode(), (String)ResManager.loadKDString((String)"\u53cd\u5c04WorkLoadService\u5b9e\u73b0\u7c7b\u5f02\u5e38\uff01", (String)"ExceptionTaskReflect_2", (String)"ssc-task-common", (Object[])new Object[0]), (Object[])new Object[0]);
            }
        }
        workLoad.setRobortRepulseRule(robortRepulseRule);
        workLoad.setPrintLog(this.printLog);
        workLoad.prepareData();
        QulityJob qulityJob = new QulityJob(unDisTaskcol);
        qulityJob.prepareData();
        qulityJob.setPrintLog(this.printLog);
        CusDisRule cusDisRule = new CusDisRule(applyCreditLevel, billCusFilter, workLoad, robortRepulseRule, qulityJob);
        cusDisRule.prepareData();
        cusDisRule.setPrintLog(this.printLog);
        TaskChecker checker = new TaskChecker();
        checker.setPrintLog(this.printLog);
        workLoad.prepareWorkflowPersons(unDisTaskcol);
        HashMap<DynamicObject, Date> setStartTimeMap = new HashMap<DynamicObject, Date>(16);
        for (DynamicObject unDisTaskDynaObj : unDisTaskcol) {
            this.printDebugLogByDyObj(unDisTaskDynaObj, "tasktypeid,state,billtype,receivetime,expirestate,personid,sscid,pooltype,billid,source,orgid,bizdata_tag,hasallocated", ResManager.loadKDString((String)"\u4efb\u52a1\u5c5e\u6027\u4e3a\u7a7a", (String)"TaskAutoDisTask_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            try {
                int matchResult;
                this.logInfo("doing allot, disTaskId = " + unDisTaskDynaObj.get("id"));
                String billnumber = unDisTaskDynaObj.getString("billnumber");
                if (!checker.validate(unDisTaskDynaObj) || !creditDelayService.match(unDisTaskDynaObj)) continue;
                if (hisTaskDisRule.matched(unDisTaskDynaObj)) {
                    long person = hisTaskDisRule.getMatchPerson();
                    long group = hisTaskDisRule.getMatchGroup();
                    boolean isRobot = robortRepulseRule.isRobort(person);
                    boolean checkRedistribution = RobertUserGroupUtil.checkRedistribution(isRobot, person, group);
                    boolean checkWorkLoad = this.checkWorkLoad(isRobot, person, group, workLoad, billnumber, robortRepulseRule);
                    if (checkRedistribution && checkWorkLoad) {
                        if (this.isUpimageTask(unDisTaskDynaObj)) {
                            this.setUserGroup(unDisTaskDynaObj, group, TaskStateEnum.TO_UPLOAD_IMAGE.getValue());
                            continue;
                        }
                        this.setTaskSuccess(person, robortRepulseRule, stateChangeDyObjlist, unDisTaskDynaObj, group, setStartTimeMap);
                        if (!isRobot) {
                            workLoad.modifyWorkStatus(person + "_" + group);
                        }
                        log.info(String.format("\u5355\u636e\uff1a%s,\u6210\u529f\u5206\u914d\u7ed9\u4e4b\u524d\u7684\u4eba\u5ba1\u6279(%s),isRobot:%s", billnumber, person + "_" + group, isRobot));
                        continue;
                    }
                }
                if ((matchResult = cusDisRule.match(unDisTaskDynaObj)) == 3) {
                    long person = cusDisRule.getMatchPerson();
                    long group = cusDisRule.getMatchGroup();
                    if (this.isUpimageTask(unDisTaskDynaObj)) {
                        this.setUserGroup(unDisTaskDynaObj, group, TaskStateEnum.TO_UPLOAD_IMAGE.getValue());
                        continue;
                    }
                    this.setTaskSuccess(person, robortRepulseRule, stateChangeDyObjlist, unDisTaskDynaObj, group, setStartTimeMap);
                    continue;
                }
                if (matchResult == 2) {
                    long group = cusDisRule.getMatchGroup();
                    this.setTaskDisFalse(unDisTaskDynaObj, this.isUpimageTask(unDisTaskDynaObj), false, group);
                    continue;
                }
                this.setTaskDisFalse(unDisTaskDynaObj, this.isUpimageTask(unDisTaskDynaObj), true, 0L);
            }
            catch (Exception e) {
                ExceptionPlatformUtil.saveErrorInfo((String)((Object)((Object)this)).getClass().getName(), (String)"disTask", (String)("taskId= " + unDisTaskDynaObj.get("id")), (Throwable)e);
            }
        }
        if (unDisTaskcol.length == 0) {
            return;
        }
        if (!CollectionUtils.isEmpty(setStartTimeMap)) {
            QualityCheckSchemeUtil.setStartTimeBatch(setStartTimeMap);
        }
        QualityCheckSchemeUtil.setPlanEndTime(unDisTaskcol);
        this.setFirstReceiveTime(unDisTaskcol);
        SaveServiceHelper.save((DynamicObject[])unDisTaskcol);
        SaveServiceHelper.save((DynamicObject[])stateChangeDyObjlist.toArray(new DynamicObject[0]));
        if (!CollectionUtils.isEmpty(this.successSampleLibIds)) {
            QualityCheckSchemeUtil.changeQualitySampleLib4DisTask(this.successSampleLibIds);
        }
        DynamicObject[] disTaskcol = (DynamicObject[])Arrays.stream(unDisTaskcol).filter(item -> TaskWorkFlowUtil.getPersonID((DynamicObject)item) > 0L && StringUtils.equals((CharSequence)item.getString("pooltype"), (CharSequence)"1")).toArray(DynamicObject[]::new);
        try {
            normalTask = (DynamicObject[])Arrays.stream(disTaskcol).filter(x -> x.getLong("qualitysamplelibrary.id") <= TaskFilterEnum.NOTQUACHECKTASK).toArray(DynamicObject[]::new);
        }
        catch (Exception e) {
            log.error("kd.ssc.task.dis.TaskAutoDisTaskPro.disTask#\u8fc7\u6ee4\u5ba1\u5355\u4efb\u52a1\u5931\u8d25\uff01\u8bf7\u53ca\u65f6\u4fee\u590d\u95ee\u9898\uff01", (Throwable)e);
            normalTask = disTaskcol;
        }
        OutSystemWorkLoadNodeChangeUtil.changeWorkLoadNode(normalTask, null);
        TaskWorkFlowUtil.updatePersonAndMsgDisTask((DynamicObject[])normalTask, (String)ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"TaskAutoDisTask_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        try {
            ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterDist((DynamicObject[])normalTask);
        }
        catch (Exception e) {
            log.error("TaskAutoDisTaskPro.disTask: \u81ea\u52a8\u5206\u914d -> \u66f4\u6539\u8282\u70b9\u5ba1\u6279\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        MessageHelper.sendMessage((DynamicObject[])disTaskcol);
    }

    private boolean checkWorkLoad(boolean isRobot, Long person, long group, WorkLoadService workLoad, String billnumber, RobortRepulseRule robortRepulseRule) {
        if (isRobot && !robortRepulseRule.isRobotsDistriOnDuty(group)) {
            return true;
        }
        return workLoad.isPresent(person + "_" + group, billnumber);
    }

    private void setUserGroup(DynamicObject unDisTaskDynaObj, long group, String state) {
        unDisTaskDynaObj.set("usergroup", (Object)group);
        unDisTaskDynaObj.set("state", (Object)state);
    }

    private boolean isPrintLog() {
        boolean result = false;
        QFilter printLogFlter = new QFilter("number", "=", (Object)"autoDisPrintLog");
        DynamicObject logParam = BusinessDataServiceHelper.loadSingle((String)"task_paramcontrol", (String)"number,paramvalue", (QFilter[])new QFilter[]{printLogFlter});
        result = logParam == null ? false : "true".equals(logParam.getString("paramvalue"));
        return result;
    }

    private void printDebugLogByDyObj(DynamicObject disruleObj, String disruleProperty, String logMsgHead) {
        String[] disrulePropertyArray = disruleProperty.split(",");
        StringBuilder sb = new StringBuilder("printDebugLogByDyObj(). ");
        sb.append("taskId: ").append(disruleObj.getPkValue()).append(',');
        sb.append("task Property is null : ");
        for (String property : disrulePropertyArray) {
            if (disruleObj.get(property) != null) continue;
            sb.append(property).append(',');
        }
        this.logInfo(sb.toString());
    }

    private void setTaskSuccess(long person, RobortRepulseRule robortRepulseRule, List<DynamicObject> stateChangeDyObjlist, DynamicObject unDisTaskDynaObj, long userGroup, Map<DynamicObject, Date> setStartTimeMap) {
        boolean isQualityTask;
        Date date = new Date();
        String state = null;
        Long sampleLibraryId = unDisTaskDynaObj.getLong("qualitysamplelibrary.id");
        boolean bl = isQualityTask = sampleLibraryId > 0L;
        if (isQualityTask) {
            state = TaskStateEnum.CHECKING.getValue();
            this.setQualityTaskProperties(unDisTaskDynaObj, person, setStartTimeMap, date, sampleLibraryId);
        } else {
            state = TaskStateEnum.TO_BE_AUDIT.getValue();
            this.setAuditTaskProperties(unDisTaskDynaObj, robortRepulseRule, userGroup);
        }
        this.setTaskCommonProperties(unDisTaskDynaObj, userGroup, person, state, date);
        this.addSateChange(stateChangeDyObjlist, unDisTaskDynaObj, state, person);
    }

    private void setTaskCommonProperties(DynamicObject disTask, long userGroup, long person, String state, Date date) {
        disTask.set("receivetime", (Object)date);
        disTask.set("expirestate", (Object)Character.valueOf('1'));
        disTask.set("pooltype", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        disTask.set("usergroup", (Object)userGroup);
        disTask.set("personid", (Object)person);
        disTask.set("oldtaskstate", (Object)disTask.getString("state"));
        disTask.set("state", (Object)state);
    }

    private void setAuditTaskProperties(DynamicObject disTask, RobortRepulseRule robortRepulseRule, long userGroup) {
        if (robortRepulseRule.isRobortGroup(userGroup)) {
            disTask.set("autoprocess", (Object)Character.valueOf('1'));
        } else {
            disTask.set("autoprocess", (Object)Character.valueOf('0'));
        }
    }

    private void setQualityTaskProperties(DynamicObject disTask, long personId, Map<DynamicObject, Date> setStartTimeMap, Date date, Long sampleLibraryId) {
        disTask.set("orignalperson", (Object)personId);
        setStartTimeMap.put(disTask, date);
        this.successSampleLibIds.add(sampleLibraryId);
    }

    private void setTaskDisFalse(DynamicObject unDisTaskDynaObj, boolean isUpImageTask, boolean isError, long usergroup) {
        String manualDis;
        if (isUpImageTask) {
            unDisTaskDynaObj.set("usergroup", (Object)usergroup);
            return;
        }
        unDisTaskDynaObj.set("hasallocated", (Object)"1");
        String curState = unDisTaskDynaObj.getString("state");
        String oldState = unDisTaskDynaObj.getString("oldtaskstate");
        String newState = null;
        newState = isError ? TaskStateEnum.DIS_EXCEPTION.getValue() : ((manualDis = TaskStateEnum.TO_BE_MANUAL_DIS.getValue()).equals(curState) || manualDis.equals(oldState) ? manualDis : TaskStateEnum.TO_BE_DIS.getValue());
        if (TaskStateEnum.TO_BE_MANUAL_DIS.getValue().equals(curState)) {
            unDisTaskDynaObj.set("oldtaskstate", (Object)curState);
        }
        unDisTaskDynaObj.set("state", (Object)newState);
        unDisTaskDynaObj.set("usergroup", (Object)usergroup);
    }

    private boolean isUpimageTask(DynamicObject dynamicObject) {
        String pooltype = dynamicObject.getString("pooltype");
        return TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue().equals(pooltype);
    }

    private void addSateChange(List<DynamicObject> stateChangeDyObjlist, DynamicObject disTask, String newState, Long person) {
        ORM orm = ORM.create();
        DynamicObject stateChangeDyObj = orm.newDynamicObject("task_statechange");
        stateChangeDyObj.set("jobid", disTask.get("id"));
        stateChangeDyObj.set("newjobstate", (Object)newState);
        stateChangeDyObj.set("oldjobstate", disTask.get("oldtaskstate"));
        stateChangeDyObj.set("changetime", (Object)new Date());
        stateChangeDyObj.set("operatorid", (Object)0);
        stateChangeDyObj.set("allocatedpersonid", (Object)person);
        stateChangeDyObj.set("operation", (Object)8);
        stateChangeDyObj.set("tasktype", disTask.get("tasktypeid"));
        stateChangeDyObj.set("billtype", disTask.get("billtype"));
        stateChangeDyObjlist.add(stateChangeDyObj);
    }

    private void setFirstReceiveTime(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.getLong("qualitysamplelibrary.id") != 0L || dynamicObject.getDate("firstreceivetime") != null) continue;
            dynamicObject.set("firstreceivetime", (Object)dynamicObject.getDate("receivetime"));
        }
    }

    private void logInfo(String msg) {
        if (this.printLog) {
            log.info(msg);
        }
    }
}

