/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.core;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.disRebuild.core.CoreDistribution;
import kd.ssc.task.disRebuild.disenum.DisExceptionEnum;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.helper.MutexCacheHelper;

public class CoreDistributionSyncWrapper
extends CoreDistribution {
    private CoreDistribution distribution;

    public CoreDistributionSyncWrapper() {
        this.distribution = new CoreDistribution();
    }

    public CoreDistributionSyncWrapper(CoreDistribution distribution) {
        this.distribution = distribution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean distribute4Single(DisRequestCtx requestCtx, long taskId) {
        requestCtx.setDisTaskId(taskId);
        DynamicObject task = requestCtx.getDisTask();
        if (this.taskInDeal(task, requestCtx.getDisType())) {
            throw new KDException(new ErrorCode(DisExceptionEnum.SYNCHRONIZEDERROR.getCode(), this.getStateError(taskId)), new Object[0]);
        }
        boolean locked = this.getLock(taskId);
        if (!locked) {
            throw new KDException(new ErrorCode(DisExceptionEnum.SYNCHRONIZEDERROR.getCode(), this.getSyncError(taskId)), new Object[0]);
        }
        try {
            this.distribution.distribute4Single(requestCtx, taskId);
        }
        finally {
            this.releaseLock(taskId);
        }
        return true;
    }

    private boolean taskInDeal(DynamicObject task, DisTypeEnum disType) {
        if (disType == DisTypeEnum.NOPASS_DIS) {
            return false;
        }
        String taskState = task.getString("state");
        return TaskStateEnum.TO_BE_AUDIT.getValue().equals(taskState) || TaskStateEnum.CHECKING.getValue().equals(taskState);
    }

    private String getStateError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ecf\u88ab\u5206\u914d\uff0c\u4efb\u52a1id\uff1a%s", (String)"CoreDistributionSyncWrapper_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private String getSyncError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u88ab\u5206\u914d\uff0c\u4efb\u52a1id\uff1a%s", (String)"CoreDistributionSyncWrapper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private String getBizError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u914d\u5f02\u5e38\uff0c\u4efb\u52a1id\uff1a%s", (String)"CoreDistributionSyncWrapper_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private synchronized boolean getLock(long taskId) {
        if (MutexCacheHelper.containsMutexCache4Dist(taskId)) {
            return false;
        }
        MutexCacheHelper.putMutexCache4Dist(taskId);
        return true;
    }

    private void releaseLock(long taskId) {
        MutexCacheHelper.removeMutexCache4Dist(taskId);
    }

    public CoreDistribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(CoreDistribution distribution) {
        this.distribution = distribution;
    }
}

