/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.service.MatchRuleResult;
import kd.ssc.task.disRebuild.service.MatchRuleService;
import kd.ssc.task.disRebuild.util.ResultBuildUtil;
import kd.ssc.task.disRebuild.util.RobertUserGroupUtil;
import kd.ssc.task.service.distask.WorkLoadService;

public class AuditUserMatchRuleServiceImpl
implements MatchRuleService {
    private DisRequestCtx ctx;

    @Override
    public MatchRuleResult match(long taskId, MatchRuleResult result) {
        result.setSuccess(false);
        long userGroupId = this.getRequestCtx().getUsergroupId();
        WorkLoadService workload = this.getRequestCtx().getWorkload();
        DynamicObject task = this.getRequestCtx().getDisTask();
        assert (task.getLong("qualitysamplelibrary.id") == 0L);
        Set<Long> allRemovePersons = workload.deletePerson4Return(userGroupId, task);
        boolean allowAnyApplier = false;
        if (!this.getRequestCtx().getQualityTaskIds().contains(taskId) && !(allowAnyApplier = this.isAllowAnyApplier(task.getLong("billtype.id")))) {
            workload.deleteApplier(userGroupId, task.getLong("creator.id"));
            allRemovePersons.add(task.getLong("creator.id"));
        }
        if (this.getRequestCtx().getDisType() == DisTypeEnum.MANUAL_GET) {
            return this.matchByManualGet(result, userGroupId, task, allRemovePersons, allowAnyApplier);
        }
        boolean isRobot = RobertUserGroupUtil.isRobort(this.ctx.getSscid(), userGroupId);
        Set<Long> allPersons = this.getUsersFromGroup(userGroupId, isRobot);
        if (CollectionUtils.isNotEmpty(allPersons)) {
            return this.matchByAutoDis(result, userGroupId, workload, task, allRemovePersons, allowAnyApplier, allPersons);
        }
        if (isRobot) {
            Map<String, Object> appParameterMap = this.getRequestCtx().getAppParameterMap();
            Boolean isRobotsDistriOnDuty = (Boolean)appParameterMap.getOrDefault("robotsdistrionduty", Boolean.FALSE);
            if (isRobotsDistriOnDuty.booleanValue()) {
                this.buildFailedResult(result, ResManager.loadKDString((String)"\u6240\u6709\u7ec4\u5458\u4e0d\u5728\u5c97", (String)"AuditUserMatchRuleServiceImpl_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                this.buildFailedResult(result, ResManager.loadKDString((String)"\u673a\u5668\u7ec4\u6ca1\u6709\u4f7f\u7528\u72b6\u6001\u7684\u7528\u6237", (String)"AuditUserMatchRuleServiceImpl_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.buildFailedResult(result, ResManager.loadKDString((String)"\u6240\u6709\u7ec4\u5458\u4e0d\u5728\u5c97", (String)"AuditUserMatchRuleServiceImpl_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    private MatchRuleResult matchByAutoDis(MatchRuleResult result, long userGroupId, WorkLoadService workload, DynamicObject task, Set<Long> allRemovePersons, boolean allowAnyApplier, Set<Long> allPersons) {
        allRemovePersons.retainAll(allPersons);
        if (!allRemovePersons.isEmpty() || !allowAnyApplier) {
            this.buildFailedResult(result, allRemovePersons, allowAnyApplier, task.getLong("creator.id"));
        }
        long person = 0L;
        if (RobertUserGroupUtil.isRobort(this.ctx.getSscid(), userGroupId)) {
            Map<String, Object> appParameterMap = this.getRequestCtx().getAppParameterMap();
            Boolean isRobotsDistriOnDuty = (Boolean)appParameterMap.getOrDefault("robotsdistrionduty", Boolean.FALSE);
            if (!isRobotsDistriOnDuty.booleanValue()) {
                allPersons.removeAll(allRemovePersons);
                if (CollectionUtils.isNotEmpty(allPersons)) {
                    person = allPersons.iterator().next();
                }
            } else {
                person = workload.getMatchPerson(userGroupId, task.getString("billnumber"));
            }
        } else {
            person = workload.getMatchPerson(userGroupId, task.getString("billnumber"));
        }
        if (person == -1L || person == 0L) {
            this.buildFailedResult(result, ResManager.loadKDString((String)"\u8be5\u7528\u6237\u7ec4\u65e0\u4eba\u5728\u5c97\u6216\u8005\u5728\u5c97\u4eba\u5458\u90fd\u5df2\u6ee1\u8d1f\u8377\uff0c\u4efb\u52a1\u65e0\u6cd5\u5206\u914d\u7ed9\u8be5\u7528\u6237\u7ec4", (String)"AuditUserMatchRuleServiceImpl_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            result.setSuccess(true);
            result.setMatchRuleId(this.getRequestCtx().getCurrentRuleId());
            result.setMatchGroupId(userGroupId);
            result.setMatchPersonId(person);
            this.buildSuccessResult(result);
        }
        workload.addPerson(userGroupId);
        return result;
    }

    private MatchRuleResult matchByManualGet(MatchRuleResult result, long userGroupId, DynamicObject task, Set<Long> allRemovePersons, boolean allowAnyApplier) {
        long userId = this.getRequestCtx().getUserId();
        WorkerStatusPojo curGroupWorkStatus = this.getRequestCtx().getGroup2WorkerStatusPojo().get(userGroupId);
        if (curGroupWorkStatus == null) {
            this.buildFailedResult(result, userId, ResManager.loadKDString((String)"\u5728\u5f53\u524d\u9879\u76ee\u7ec4\u4e0b\uff0c\u672a\u627e\u5230\u8be5\u7528\u6237\u7684\u8d1f\u8377\u7edf\u8ba1\u4fe1\u606f", (String)"AuditUserMatchRuleServiceImpl_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else if (curGroupWorkStatus.getTaskTotal() >= curGroupWorkStatus.getTaskUpper()) {
            String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u8d85\u8d1f\u8377\uff0c\u5904\u7406\u4e2d\u4efb\u52a1\u6570\uff1a%1$s, \u8d1f\u8377\u4e0a\u9650\uff1a%2$s", (String)"AuditUserMatchRuleServiceImpl_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), curGroupWorkStatus.getTaskTotal(), curGroupWorkStatus.getTaskUpper());
            this.buildFailedResult(result, userId, message);
        } else if (allRemovePersons.contains(userId)) {
            result.setSuccess(false);
            allRemovePersons.removeIf(p -> p != userId);
            this.buildFailedResult(result, allRemovePersons, allowAnyApplier, task.getLong("creator.id"));
        } else {
            result.setSuccess(true);
            result.setMatchRuleId(this.getRequestCtx().getCurrentRuleId());
            result.setMatchGroupId(this.getRequestCtx().getUsergroupId());
            result.setMatchPersonId(this.getRequestCtx().getUserId());
            this.buildSuccessResult(result);
            curGroupWorkStatus.setTaskTotal(curGroupWorkStatus.getTaskTotal() + 1);
        }
        return result;
    }

    private void buildFailedResult(MatchRuleResult result, long userId, String message) {
        result.setSuccess(false);
        DisRequestCtx requestCtx = this.getRequestCtx();
        JSONObject uDetail = ResultBuildUtil.getOrDefault_u_detail(result.getDetail(), requestCtx.getCurrentRuleId(), requestCtx.getUsergroupId(), userId);
        uDetail.put("userId", (Object)userId);
        uDetail.put("message", (Object)message);
    }

    private void buildFailedResult(MatchRuleResult result, String message) {
        result.setSuccess(false);
        DisRequestCtx requestCtx = this.getRequestCtx();
        JSONObject gDetail = ResultBuildUtil.getOrDefault_g_detail(result.getDetail(), requestCtx.getCurrentRuleId(), requestCtx.getUsergroupId());
        gDetail.put("matched", (Object)false);
        gDetail.put("message", (Object)message);
    }

    private void buildFailedResult(MatchRuleResult result, Set<Long> removePersons, boolean allowAnyApplier, long creatorId) {
        boolean record = false;
        if (!allowAnyApplier && removePersons.contains(creatorId)) {
            this.buildFailedResult(result, creatorId, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u81ea\u63d0\u81ea\u5ba1", (String)"AuditUserMatchRuleServiceImpl_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            record = true;
        }
        for (long rmPersonId : removePersons) {
            if (record && rmPersonId == creatorId) continue;
            this.buildFailedResult(result, rmPersonId, ResManager.loadKDString((String)"\u4e0e\u524d\u7f6e\u5904\u7406\u4eba\u4e0d\u540c", (String)"AuditUserMatchRuleServiceImpl_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void buildSuccessResult(MatchRuleResult result) {
        JSONObject r_detail = ResultBuildUtil.getOrDefault_r_detail(result.getDetail(), this.getRequestCtx().getCurrentRuleId());
        r_detail.put("matched", (Object)true);
        JSONObject g_detail = ResultBuildUtil.getOrDefault_g_detail(result.getDetail(), this.getRequestCtx().getCurrentRuleId(), this.getRequestCtx().getUsergroupId());
        g_detail.put("matched", (Object)true);
    }

    private boolean isAllowAnyApplier(long billTypeId) {
        return this.getRequestCtx().getSourceBillMatch().isAllowAnyApplier(billTypeId);
    }

    private Set<Long> getUsersFromGroup(long userGroupId, boolean isRobot) {
        DynamicObject userGroup;
        Map<Long, DynamicObject> robertGroupMap;
        Map<String, Object> appParameterMap;
        Boolean isRobotsDistriOnDuty;
        Set<Long> groupInfos = this.getRequestCtx().getGroupInfos().get(userGroupId);
        if (isRobot && !(isRobotsDistriOnDuty = (Boolean)(appParameterMap = this.getRequestCtx().getAppParameterMap()).getOrDefault("robotsdistrionduty", Boolean.FALSE)).booleanValue() && (robertGroupMap = this.getRequestCtx().getRobertGroupMap()) != null && (userGroup = robertGroupMap.get(userGroupId)) != null) {
            HashSet<Long> robotSet = new HashSet<Long>();
            DynamicObjectCollection userColl = userGroup.getDynamicObjectCollection("entryentity");
            for (DynamicObject user : userColl) {
                Long userID = user.getLong("userfield.id");
                if (!user.getBoolean("usestatus")) continue;
                robotSet.add(userID);
            }
            return robotSet;
        }
        return groupInfos;
    }

    @Override
    public DisRequestCtx getRequestCtx() {
        return this.ctx;
    }

    @Override
    public void setRequestCtx(DisRequestCtx ctx) {
        this.ctx = ctx;
    }
}

