/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryAp;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConBarItemAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.mcontrol.MBarItemAp;
import kd.bos.util.StringUtils;

public class BillAttributeConfigFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BillAttributeConfigFormPlugin.class);
    private String splitChar = "_and_";
    private final String TABPAGE_FIELD = "tabpage_field";
    private final String SETTINGENTITY = "settingentity";
    private final String TABPAGE_BTN = "tabpage_btn";
    private final String SETTINGENTITY_BTN = "settingentity_btn";
    private final String TABPAGE_LI = "tabpage_li";
    private final String SETTINGENTITY_LI = "settingentity_li";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button control = (Button)this.getControl("btn_submit");
        control.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String entityNumber = (String)showParam.getCustomParam("entityNumber");
        if (StringUtils.isEmpty((String)entityNumber)) {
            log.error("showParam.getCustomParam(\"entityNumber\"):" + entityNumber);
            return;
        }
        this.initEntryEntity(entityNumber);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if ("btn_submit".equals(key)) {
            this.submitData();
        }
    }

    private void initEntryEntity(String entityNumber) {
        IDataModel model = this.getModel();
        HashMap<String, Object> fieldInfoMap = new HashMap<String, Object>(16);
        HashMap<String, Object> btnInfoMap = new HashMap<String, Object>(16);
        HashMap<String, Object> labelInfoMap = new HashMap<String, Object>(16);
        this.fetchBillAttritubeInfo(entityNumber, fieldInfoMap, btnInfoMap, labelInfoMap);
        Map<String, Object> billInfoSelected = this.setBillInfoSelected();
        this.setBillInfo(fieldInfoMap, billInfoSelected, model, "settingentity", "tabpage_field");
        this.setBillInfo(btnInfoMap, billInfoSelected, model, "settingentity_btn", "tabpage_btn");
        this.setBillInfo(labelInfoMap, billInfoSelected, model, "settingentity_li", "tabpage_li");
    }

    private void fetchBillAttritubeInfo(String entityNumber, Map<String, Object> fieldInfoMap, Map<String, Object> btnInfoMap, Map<String, Object> labelInfoMap) {
        String metaDataId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata formMetaData = (FormMetadata)MetadataDao.readRuntimeMeta((String)metaDataId, (MetaCategory)MetaCategory.Form);
        if (formMetaData == null) {
            log.error("\u83b7\u53d6\u8bbe\u8ba1\u65f6\u5143\u6570\u636e\u5f02\u5e38(" + entityNumber + ")");
            return;
        }
        HashMap<String, String> entryIdNameMap = new HashMap<String, String>();
        List items = formMetaData.getItems();
        for (ControlAp ctrlAp : items) {
            String ctrlApNumber = null;
            String ctrlApName = null;
            if (ctrlAp.isHidden()) continue;
            StringBuilder entryIds = new StringBuilder();
            if (ctrlAp instanceof EntryFieldAp || ctrlAp instanceof CardEntryFieldAp) {
                String entryIdName = this.getEntryIdName(entryIdNameMap, ctrlAp.getParentId(), entryIds, formMetaData);
                if (entryIdName == null) continue;
                ctrlApNumber = entryIdName.split(this.splitChar)[0] + "." + ctrlAp.getKey();
                ctrlApName = entryIdName.split(this.splitChar).length > 1 ? entryIdName.split(this.splitChar)[1] + "." + ctrlAp.getName().getLocaleValue() : ctrlAp.getName().getLocaleValue();
                fieldInfoMap.put(ctrlApNumber, ctrlApName);
                continue;
            }
            if (this.isHiddenForParentContainer(ctrlAp, formMetaData)) continue;
            Class<?> clazz = ctrlAp.getClass();
            if (BarItemAp.class.equals(clazz) || MBarItemAp.class.equals(clazz) || AdvConBarItemAp.class.equals(clazz)) {
                HashMap<String, String> info = new HashMap<String, String>(3);
                ControlAp toolBar = formMetaData.getItem(ctrlAp.getParentId());
                ctrlApNumber = toolBar.getKey() + "." + ctrlAp.getKey();
                ctrlApName = toolBar.getName().getLocaleValue() + "." + ctrlAp.getName().getLocaleValue();
                ButtonAp btn = (ButtonAp)ctrlAp;
                List dropdownItems = btn.getDropdownItems();
                if (dropdownItems != null && dropdownItems.size() > 0) {
                    this.parseDropdownItems(clazz, toolBar, dropdownItems, btnInfoMap);
                }
                info.put("ctrlapname", ctrlApName);
                info.put("opkey", btn.getOperationKey());
                info.put("ctrlaptype", clazz.getSimpleName());
                btnInfoMap.put(ctrlApNumber, info);
                if (BarItemAp.class.equals(clazz)) continue;
                info = new HashMap(3);
                info.put("ctrlapname", toolBar.getName().getLocaleValue());
                info.put("ctrlaptype", toolBar.getClass().getSimpleName());
                btnInfoMap.put(toolBar.getKey(), info);
                continue;
            }
            if (ctrlAp.getClass().equals(FieldAp.class) || ctrlAp.getClass().equals(AttachmentPanelAp.class)) {
                ctrlApNumber = ctrlAp.getKey();
                ctrlAp.getVisible();
                ctrlApName = ctrlAp.getName().getLocaleValue();
                fieldInfoMap.put(ctrlApNumber, ctrlApName);
                continue;
            }
            if (!(ctrlAp instanceof ButtonAp) || !ctrlAp.getClass().equals(ButtonAp.class) && (ctrlAp instanceof LabelAp && !((LabelAp)ctrlAp).isClickable() || ctrlAp instanceof ImageAp && !((ImageAp)ctrlAp).isClickable())) continue;
            String entryIdName = this.getEntryIdName(entryIdNameMap, ctrlAp.getParentId(), entryIds, formMetaData);
            if (entryIdName != null) {
                ctrlApNumber = entryIdName.split(this.splitChar)[0] + "." + ctrlAp.getKey();
                ctrlApName = entryIdName.split(this.splitChar).length > 1 ? entryIdName.split(this.splitChar)[1] + "." + ctrlAp.getName().getLocaleValue() : ctrlAp.getName().getLocaleValue();
            } else {
                ctrlApNumber = ctrlAp.getKey();
                ctrlApName = ctrlAp.getName().getLocaleValue();
            }
            if (ctrlAp instanceof LabelAp || ctrlAp instanceof ImageAp) {
                String crtlApVisible = ctrlAp.getVisible();
                if (!StringUtils.isNotEmpty((String)crtlApVisible) || !crtlApVisible.contains("view") && !crtlApVisible.contains("edit")) continue;
                labelInfoMap.put(ctrlApNumber, ctrlApName);
                continue;
            }
            fieldInfoMap.put(ctrlApNumber, ctrlApName);
        }
    }

    private String getEntryIdName(Map<String, String> entryIdNameMap, String entryId, StringBuilder entryIds, FormMetadata formMetadata) {
        String entryIdName = null;
        for (Map.Entry<String, String> entry : entryIdNameMap.entrySet()) {
            List<String> tempEntryIds = Arrays.asList(entry.getKey().split(","));
            if (!tempEntryIds.contains(entryId)) continue;
            entryIdName = entry.getValue();
            return entryIdName;
        }
        entryIds.append(entryId).append(',');
        ControlAp ctrlAp = formMetadata.getItem(entryId);
        if (ctrlAp != null && !ctrlAp.isHidden()) {
            if (ctrlAp.getClass().equals(EntryAp.class) || ctrlAp instanceof CardEntryAp || ctrlAp instanceof AdvConAp) {
                entryIdName = ctrlAp.getKey() + this.splitChar + ctrlAp.getName().getLocaleValue();
                if (this.isHiddenForParentContainer(ctrlAp, formMetadata)) {
                    entryIdName = null;
                }
                entryIdNameMap.put(entryIds.toString(), entryIdName);
            } else {
                entryIdName = this.getEntryIdName(entryIdNameMap, ctrlAp.getParentId(), entryIds, formMetadata);
            }
        } else {
            entryIdNameMap.put(entryIds.toString(), entryIdName);
        }
        return entryIdName;
    }

    private boolean isHiddenForParentContainer(ControlAp controlAp, FormMetadata formMetadata) {
        if (controlAp == null) {
            return false;
        }
        if (controlAp.isHidden()) {
            return true;
        }
        return this.isHiddenForParentContainer(formMetadata.getItem(controlAp.getParentId()), formMetadata);
    }

    private Map<String, Object> setBillInfoSelected() {
        String jsonString;
        HashMap<String, Object> billInfoSelected = new HashMap<String, Object>();
        Object jsonValue = this.getView().getFormShowParameter().getCustomParam("jsonvalue");
        if (jsonValue != null && StringUtils.isNotEmpty((String)(jsonString = jsonValue.toString()))) {
            List selectedValue = SerializationUtils.fromJsonStringToList((String)jsonString, Map.class);
            for (Map ctrlApInfo : selectedValue) {
                billInfoSelected.put(ctrlApInfo.get("ctrlapnumber").toString(), ctrlApInfo);
            }
        }
        return billInfoSelected;
    }

    private void setBillInfo(Map<String, Object> billInfoMap, Map<String, Object> billInfoSelected, IDataModel model, String entityName, String tabPageName) {
        boolean isVisible = false;
        if (billInfoMap != null && billInfoMap.size() > 0) {
            isVisible = true;
            Map entityInfo = null;
            int i = 0;
            for (Map.Entry<String, Object> ctrlApInfoEntry : billInfoMap.entrySet()) {
                String ctrlApNumber = ctrlApInfoEntry.getKey();
                boolean isHide = false;
                boolean isModify = false;
                if (ctrlApNumber == null) continue;
                model.createNewEntryRow(entityName);
                if ("settingentity".equals(entityName)) {
                    isHide = false;
                    isModify = false;
                } else if ("settingentity_btn".equals(entityName)) {
                    isHide = true;
                } else if ("settingentity_li".equals(entityName)) {
                    isHide = true;
                }
                entityInfo = (Map)billInfoSelected.get(ctrlApNumber);
                if (entityInfo != null) {
                    isHide = (Boolean)entityInfo.get("hide");
                    isModify = (Boolean)entityInfo.get("modify");
                }
                String ctrlApNam = null;
                if ("settingentity".equals(entityName)) {
                    ctrlApNam = (String)ctrlApInfoEntry.getValue();
                    model.setValue("fieldnumber", (Object)ctrlApNumber, i);
                    model.setValue("fieldname", (Object)ctrlApNam, i);
                    model.setValue("hide", (Object)isHide, i);
                    model.setValue("modify", (Object)isModify, i);
                }
                if ("settingentity_btn".equals(entityName)) {
                    Map info = (Map)ctrlApInfoEntry.getValue();
                    ctrlApNam = (String)info.get("ctrlapname");
                    model.setValue("btnnumber", (Object)ctrlApNumber, i);
                    model.setValue("btnname", (Object)ctrlApNam, i);
                    model.setValue("btnhide", (Object)isHide, i);
                    model.setValue("opkey", info.get("opkey"), i);
                    model.setValue("ctrlaptype", info.get("ctrlaptype"), i);
                }
                if ("settingentity_li".equals(entityName)) {
                    ctrlApNam = (String)ctrlApInfoEntry.getValue();
                    model.setValue("linumber", (Object)ctrlApNumber, i);
                    model.setValue("liname", (Object)ctrlApNam, i);
                    model.setValue("livisible", (Object)(!isHide ? 1 : 0), i);
                }
                ++i;
            }
        }
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{tabPageName});
    }

    private void submitData() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.getSubmitData(list, "settingentity");
        this.getSubmitData(list, "settingentity_btn");
        this.getSubmitData(list, "settingentity_li");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("jsonvalue", SerializationUtils.toJsonString(list));
        param.put("showvalue", this.convertToAlias(list));
        this.getView().returnDataToParent(param);
        this.getView().close();
    }

    private void getSubmitData(List<Map<String, Object>> list, String entityName) {
        int rowCount = this.getModel().getEntryRowCount(entityName);
        for (int i = 0; i < rowCount; ++i) {
            Object ctrlApName = null;
            Object ctrlApNumber = null;
            Boolean hide = Boolean.FALSE;
            Boolean modify = Boolean.FALSE;
            String opKey = null;
            String ctrlApType = "";
            if ("settingentity".equals(entityName)) {
                hide = Boolean.FALSE;
                modify = Boolean.FALSE;
            } else if ("settingentity_btn".equals(entityName)) {
                hide = Boolean.TRUE;
            } else if ("settingentity_li".equals(entityName)) {
                hide = Boolean.TRUE;
            }
            DynamicObject entryRow = this.getModel().getEntryRowEntity(entityName, i);
            if ("settingentity".equals(entityName)) {
                ctrlApName = entryRow.get("fieldname");
                ctrlApNumber = entryRow.get("fieldnumber");
                hide = (Boolean)entryRow.get("hide");
                modify = (Boolean)entryRow.get("modify");
                ctrlApType = "field";
            }
            if ("settingentity_btn".equals(entityName)) {
                ctrlApName = entryRow.get("btnname");
                ctrlApNumber = entryRow.get("btnnumber");
                hide = (Boolean)entryRow.get("btnhide");
                ctrlApType = entryRow.getString("ctrlaptype");
                opKey = entryRow.getString("opkey");
            }
            if ("settingentity_li".equals(entityName)) {
                ctrlApName = entryRow.get("liname");
                ctrlApNumber = entryRow.get("linumber");
                hide = (Boolean)entryRow.get("livisible") == false;
                ctrlApType = "labelorimage";
            }
            boolean fieldSaveCondition = "settingentity".equals(entityName) && (modify != false || hide != false);
            boolean btnSaveCondition = "settingentity_btn".equals(entityName);
            boolean labelSaveCondition = "settingentity_li".equals(entityName) && hide == false;
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            if (!fieldSaveCondition && !btnSaveCondition && !labelSaveCondition) continue;
            resultMap.put("hide", hide);
            resultMap.put("modify", modify);
            resultMap.put("ctrlapname", ctrlApName);
            resultMap.put("ctrlapnumber", ctrlApNumber);
            resultMap.put("ctrlaptype", ctrlApType);
            if (StringUtils.isNotEmpty((String)opKey)) {
                resultMap.put("opkey", opKey);
            }
            list.add(resultMap);
        }
    }

    private String convertToAlias(List<Map<String, Object>> list) {
        StringBuilder alias = new StringBuilder();
        List<String> ctrlApTypes = Arrays.asList("ToolbarAp", "AdvConToolbarAp", "BarItemAp", "MBarItemAp", "AdvConBarItemAp");
        for (Map<String, Object> map : list) {
            String ctrlApType = (String)map.get("ctrlaptype");
            boolean hide = (Boolean)map.get("hide");
            if (hide && ctrlApTypes.contains(ctrlApType)) continue;
            alias.append(map.get("ctrlapname")).append(':');
            if (hide) {
                alias.append(ResManager.loadKDString((String)"\u9690\u85cf", (String)"BillAttributeConfigFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                alias.append(ResManager.loadKDString((String)"\u663e\u793a", (String)"BillAttributeConfigFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            if (((Boolean)map.get("modify")).booleanValue()) {
                alias.append(',');
                alias.append(ResManager.loadKDString((String)"\u53ef\u4fee\u6539", (String)"BillAttributeConfigFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            alias.append(';');
        }
        return alias.toString();
    }

    private void parseDropdownItems(Class<?> clazz, ControlAp<?> toolBar, List<DropdownItem> dropdownItems, Map<String, Object> btnInfoMap) {
        for (DropdownItem item : dropdownItems) {
            HashMap<String, String> info = new HashMap<String, String>(3);
            String ctrlApNumber = toolBar.getKey() + "." + item.getKey();
            String ctrlApName = toolBar.getName().getLocaleValue() + "." + item.getTitle().getLocaleValue();
            info.put("ctrlapname", ctrlApName);
            info.put("opkey", item.getOperationKey());
            info.put("ctrlaptype", clazz.getSimpleName());
            btnInfoMap.put(ctrlApNumber, info);
        }
    }
}

