/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.MergeListColumn;
import kd.bos.list.ViewCommonUtil;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListUserConfig;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTaskSourceEnum;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.enums.TaskApprovePageInvokerEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.enums.approveRebuild.AppTypeEnum;
import kd.ssc.task.business.helper.DutyManageDataHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.ListColumnDisplay;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.common.SwitchBillListEntryEntity;
import kd.ssc.task.common.quality.QualityTaskHelper;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.dis.TaskAutoDisTaskPro;
import kd.ssc.task.factory.TaskCommonFilterFactory;
import kd.ssc.task.formplugin.TaskApprevalHelper;
import kd.ssc.task.formplugin.quality.QualityApprovalPendingHelper;
import kd.ssc.task.formplugin.util.SscUtil;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.helper.TaskQueryServiceHelper;
import kd.ssc.task.image.SscImageServiceHelper;
import kd.ssc.task.image.SscImageServiceUtil;
import kd.ssc.task.service.filter.TaskCommonFilterService;
import kd.ssc.task.service.filter.dto.CommonFilterDTO;
import kd.ssc.task.util.SscLicenseUtil;

public class QualityCheckManagementListPlugin
extends AbstractListPlugin
implements ClickListener,
ItemClickListener {
    private static final Log log = LogFactory.getLog(QualityCheckManagementListPlugin.class);
    private boolean isFirstInitialForCommonFilter = false;
    private List<IListColumn> listColumns = new ArrayList<IListColumn>();
    private List<FilterColumn> listFilterColumns = new ArrayList<FilterColumn>();
    private List<FilterColumn> fastFilterColumns = new ArrayList<FilterColumn>();
    private List<FilterColumn> schemeFilterColumns = new ArrayList<FilterColumn>(16);
    private String qualityCheckFilter = "qualitysamplelibrary.checkscheme.name";
    private String qualityLibraryFilter = "qualitysamplelibrary.number";
    private static Map<String, String> permissionMap = new HashMap<String, String>(7);
    private static final int RUNPAGESIZE = 1000;
    private static final String BILL_TYPE_JSON = "billTypeJson";

    public void beforeBindData(EventObject e) {
        ((FilterContainer)this.getControl("filtercontainerap")).addQueryByOrListener(event -> event.setQueryByOr(false));
    }

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void setFilter(SetFilterEvent e) {
        String pageCacheByKey;
        super.setFilter(e);
        List filters = e.getQFilters();
        QFilter filterQualityCheckTask = new QFilter("qualitysamplelibrary", ">", (Object)0);
        filters.add(filterQualityCheckTask);
        String somSchemeIdKey = CacheKey.getSOMKey((Object)"qualityCheckManager_schemeId");
        String schemeId = this.getPageCache(somSchemeIdKey) + "";
        String sscId = this.getPageCache("CACHE_QUALITYCHECKMANAGEMENT_SSCID");
        if (schemeId.equals("0") && StringUtils.isNotBlank((CharSequence)sscId)) {
            QFilter qFilter = new QFilter("ssccenter", "=", (Object)Long.parseLong(sscId));
            List schemeIds = QueryServiceHelper.queryPrimaryKeys((String)"task_smartcheckscheme", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
            QFilter delFilter = null;
            for (QFilter filter : filters) {
                if (!filter.getProperty().equals("qualitysamplelibrary.checkscheme.id")) continue;
                delFilter = filter;
                break;
            }
            if (delFilter != null) {
                filters.remove(delFilter);
            }
            filters.add(new QFilter("qualitysamplelibrary.smartcheckscheme.id", "in", (Object)schemeIds));
        }
        if (!"sysadmin".equals(pageCacheByKey = this.getPageCache("identity"))) {
            QFilter leaderGroupFilter = new QFilter("usergroup", "!=", (Object)0L);
            String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
            HashSet<Long> manageGroupSet = UserGroupUtil.getManageGroup(sscId, currUserId);
            QFilter leaderGroupFilter2 = new QFilter("usergroup", "in", manageGroupSet);
            filters.add(leaderGroupFilter);
            filters.add(leaderGroupFilter2);
        }
        e.setOrderBy("taskcreatetime desc,receivetime desc, qualitychecktime desc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        String isright;
        super.filterContainerInit(args);
        this.listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        this.fastFilterColumns = args.getFilterContainerInitEvent().getFastFilterColumns();
        this.schemeFilterColumns = args.getFilterContainerInitEvent().getSchemeFilterColumns();
        List<String> needRemoveColumnNameList = Arrays.asList("expirestate", "creator.name", "personid.name", "applytime", "expenseitem", "supplier", "billno");
        CommonFilterUtil.setCanRemove(this.listFilterColumns, false);
        this.removeFilterForCheck(this.listFilterColumns, needRemoveColumnNameList);
        this.removeFilterForCheck(this.fastFilterColumns, needRemoveColumnNameList);
        List<String> schemeRemove = Arrays.asList("applytime", "costdept.name", "expenseamount", "expenseitem", "supplier");
        this.removeFilterForCheck(this.schemeFilterColumns, schemeRemove);
        if (this.isFirstInitialForCommonFilter) {
            this.isFirstInitialForCommonFilter = false;
            this.reBuildCommonFilter(this.listFilterColumns, null);
            this.handleToolBarState(this.getView());
        }
        if ((isright = this.getPageCache().get("isright")) != null) {
            this.getView().close();
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put("caption", ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u5217\u8868", (String)"QualityCheckManagementListPlugin_64", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            TeamLeaderApi.showForm(this.getView(), paramMap);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (this.getPageCache("setListUserConfig") != null) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListUserConfig instance = new ListUserConfig();
            instance.setPageRows(billList.getPageRow());
            instance.store("qualitytask-admin");
            PageRowCacheUtils.clearPageRowcache((String)this.getView().getPageId());
        } else {
            this.setPageCache("setListUserConfig", "1");
        }
        String poolType = this.getPageCache("pooltype");
        if (TaskPoolTypeEnum.COMPLETE.getValue().contains(poolType)) {
            this.switchGridBillFormID("task_taskhistory", this.listFilterColumns);
        } else {
            this.switchGridBillFormID("task_task", this.listFilterColumns);
        }
        args.setListColumns(this.listColumns);
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        String fieldKey = args.getListFieldKey();
        if ("state".equals(fieldKey)) {
            List comboItems = args.getComboItems();
            List<TaskStateEnum> notNeedShowStates = Arrays.asList(TaskStateEnum.TO_UPLOAD_IMAGE, TaskStateEnum.TO_BE_AUDIT, TaskStateEnum.PAUSE, TaskStateEnum.RESCAN, TaskStateEnum.REUPLOAD_IMAGE, TaskStateEnum.AUDIT_PASSED, TaskStateEnum.AUDIT_NOTPASSED, TaskStateEnum.CANCEL, TaskStateEnum.FLOWBACK);
            comboItems.removeIf(p -> {
                TaskStateEnum taskState = TaskStateEnum.getTaskState((String)p.getValue());
                return taskState == null || notNeedShowStates.contains(taskState);
            });
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List listFieldName;
        List listValue;
        int i;
        super.filterContainerSearchClick(args);
        Map curCommonFilterMap = args.getCurrentCommonFilter();
        List<String> nullFieldValues = Arrays.asList("tasktypeid.id", "orgid.id", "billtype.id", "qualitysamplelibrary.checkscheme.id");
        boolean isCleared = false;
        boolean isClearLibrary = false;
        boolean isClearGroup = false;
        boolean isRequiredClearState = false;
        boolean selectCurMonthOnSearchClick = false;
        String somSchemeIdKey = CacheKey.getSOMKey((Object)"qualityCheckManager_schemeId");
        if (curCommonFilterMap != null) {
            List curFieldNames = (List)curCommonFilterMap.get("FieldName");
            String curComFieldName = curFieldNames.get(0).toString();
            if ("sscid.id".equals(curComFieldName) || "usergroup.id".equals(curComFieldName)) {
                isCleared = true;
                if ("sscid.id".equals(curComFieldName)) {
                    isClearGroup = true;
                    this.setPageCache(somSchemeIdKey, "");
                }
            } else if ("qualitysamplelibrary.checkscheme.id".equals(curComFieldName)) {
                isClearLibrary = true;
                List curValues = (List)curCommonFilterMap.get("Value");
                this.setPageCache(somSchemeIdKey, curValues.get(0).toString());
            } else if ("pooltype".equals(curFieldNames.get(0))) {
                isRequiredClearState = true;
                if (TaskPoolTypeEnum.COMPLETE.getValue().equals(((List)curCommonFilterMap.get("Value")).get(0))) {
                    selectCurMonthOnSearchClick = true;
                }
            } else if ("billtype.id".equals(curFieldNames.get(0))) {
                List collect = ((List)curCommonFilterMap.get("Value")).stream().filter(p -> p instanceof String).map(Object::toString).filter(kd.bos.util.StringUtils::isNotEmpty).collect(Collectors.toList());
                List billTypeIdList = collect.stream().map(Long::parseLong).collect(Collectors.toList());
                this.getPageCache().put(BILL_TYPE_JSON, SerializationUtils.toJsonString(billTypeIdList));
            }
        }
        ListView view = (ListView)this.getView();
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        String billFormId = "task_task";
        if (customlist != null && customlist.size() > 0) {
            for (i = 0; i < customlist.size(); ++i) {
                Map filterMap = (Map)customlist.get(i);
                listValue = (List)filterMap.get("Value");
                listFieldName = (List)filterMap.get("FieldName");
                String fieldName = null;
                String fieldValue = null;
                String curFieldName = listFieldName.get(0).toString();
                for (int j = 0; j < listFieldName.size(); ++j) {
                    fieldName = listFieldName.get(j).toString();
                    fieldValue = listValue.get(j).toString();
                    if ("pooltype".equalsIgnoreCase(fieldName)) {
                        if (TaskPoolTypeEnum.COMPLETE.getValue().contains(fieldValue)) {
                            billFormId = "task_taskhistory";
                        }
                        this.setPageCache("pooltype", fieldValue);
                        continue;
                    }
                    if ("sscid.id".equalsIgnoreCase(fieldName) || "sscid.name".equalsIgnoreCase(fieldName)) {
                        this.setPageCache("CACHE_QUALITYCHECKMANAGEMENT_SSCID", fieldValue);
                        continue;
                    }
                    if (!"usergroup.id".equals(fieldName)) continue;
                    String key = (String)listValue.get(0);
                    this.setPageCache("usergroupid", key);
                }
                if (nullFieldValues.contains(curFieldName) && isCleared) {
                    listValue.clear();
                    this.getPageCache().put(BILL_TYPE_JSON, "");
                    continue;
                }
                if ("qualitysamplelibrary.id".equals(curFieldName) && (isCleared || isClearLibrary)) {
                    listValue.clear();
                    continue;
                }
                if (!isRequiredClearState || !"state".equals(fieldName)) continue;
                listValue.clear();
            }
        }
        if (schemelist != null && schemelist.size() > 0) {
            for (i = 0; i < schemelist.size(); ++i) {
                Map schemeMap = (Map)schemelist.get(i);
                listValue = (List)schemeMap.get("Value");
                listFieldName = (List)schemeMap.get("FieldName");
                if ("pooltype".equals(listFieldName.get(0))) {
                    String pooltype = listValue.get(0).toString();
                    this.setPageCache("pooltype", pooltype);
                    if (!TaskPoolTypeEnum.COMPLETE.getValue().contains(pooltype)) continue;
                    billFormId = "task_taskhistory";
                    continue;
                }
                if (!"sscid.id".equals(listFieldName.get(0)) || null != listValue.get(0) && !StringUtils.isEmpty((CharSequence)listValue.get(0).toString())) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"QualityCheckManagementListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.reBuildCommonFilter(this.listFilterColumns, customlist);
        this.setUserGroupDefault(isClearGroup, customlist);
        this.handleToolBarState((IFormView)view);
        this.switchGridBillFormID(billFormId, this.listFilterColumns);
        if (customlist != null && selectCurMonthOnSearchClick) {
            for (Map customMap : customlist) {
                if (!"completetime".equals(((List)customMap.get("FieldName")).get(0))) continue;
                customMap.put("Value", Collections.singletonList(CompareTypeEnum.THISMONTH.getId()));
            }
        }
    }

    private void setUserGroupDefault(boolean isRequiredClearGroup, List<Map<String, List<Object>>> customlist) {
        if (!isRequiredClearGroup) {
            return;
        }
        for (Map<String, List<Object>> customMap : customlist) {
            List<Object> listValue = customMap.get("Value");
            List<Object> listFieldName = customMap.get("FieldName");
            String fieldName = (String)listFieldName.get(0);
            if (!"usergroup.id".equals(fieldName)) continue;
            String defaultValue = "";
            for (int k = 0; k < this.listFilterColumns.size(); ++k) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)this.listFilterColumns.get(k);
                if (!"usergroup.name".equals(commonFilterColumn.getFieldName())) continue;
                IPageCache pageCache = this.getPageCache();
                String identity = pageCache.get("identity");
                if ("sysadmin".equals(identity)) {
                    commonFilterColumn.setDefaultValue(defaultValue);
                    continue;
                }
                List comboItems = commonFilterColumn.getComboItems();
                if (comboItems == null || comboItems.size() == 0) {
                    return;
                }
                defaultValue = ((ComboItem)comboItems.get(0)).getValue();
                commonFilterColumn.setDefaultValue(defaultValue);
            }
            listValue.set(0, defaultValue);
            break;
        }
    }

    private void viewPhoto(Object selectedRowId) {
        String poolType = this.getPageCache("pooltype");
        boolean isHistoryTask = TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType);
        DynamicObjectCollection selectedRowData = TaskQueryServiceHelper.getDataTasklist(selectedRowId, isHistoryTask);
        String billid = (String)((DynamicObject)selectedRowData.get(0)).get("billid");
        String imageNumber = ((DynamicObject)selectedRowData.get(0)).getString("imagenumber");
        String billtype = ((DynamicObject)selectedRowData.get(0)).getString("billtype.bindbill.number");
        String isEdit = "0";
        SscImageServiceHelper.viewphoto((String)imageNumber, (String)billid, (String)billtype, (IFormView)this.getView(), (String)isEdit);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        switch (itemKey) {
            case "quality_delete": {
                if (selectedRows == null || selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckManagementListPlugin_34", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.permission(itemKey)) {
                    this.delete();
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u5220\u9664\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_29", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "refresh": {
                this.refreshBillList();
                break;
            }
            case "quality_assignimme": {
                if (selectedRows == null || selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckManagementListPlugin_34", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.permission(itemKey)) {
                    this.assign(selectedRows.getPrimaryKeyValues());
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u7acb\u5373\u5206\u914d\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_30", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quality_qingviewlist": {
                if (this.permission(itemKey)) {
                    this.qingView();
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u8f7b\u5206\u6790\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_31", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quality_export": {
                if (this.permission(itemKey)) {
                    this.getView().invokeOperation("exportlistbyselectfields");
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u5bfc\u51fa\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_32", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quality_returnassigntask": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckManagementListPlugin_34", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.permission(itemKey)) {
                    this.reAssign(selectedRows.getPrimaryKeyValues());
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u91cd\u5206\u914d\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_33", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quality_viewphoto": {
                if (selectedRows.size() > 1 || selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"QualityCheckManagementListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.permission(itemKey)) {
                    this.viewPhoto(selectedRows.get(0).getPrimaryKeyValue());
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u67e5\u770b\u5f71\u50cf\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_28", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quality_recycle": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckManagementListPlugin_34", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.permission(itemKey)) {
                    this.recycle(selectedRows.getPrimaryKeyValues());
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u56de\u6536\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_40", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quality_cancelrecycle": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckManagementListPlugin_34", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.permission(itemKey)) {
                    this.cancelRecycle(selectedRows.getPrimaryKeyValues());
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u53d6\u6d88\u56de\u6536\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_41", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quality_pause": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckManagementListPlugin_34", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.permission(itemKey)) {
                    this.qualityPause(selectedRows);
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u6682\u6302\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_43", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quality_cancelpause": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckManagementListPlugin_34", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.permission(itemKey)) {
                    this.qualityCancelPause(selectedRows);
                    this.refreshBillList();
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u53d6\u6d88\u6682\u6302\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_44", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quality_assigntask": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckManagementListPlugin_34", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.permission(itemKey)) {
                    this.assignTask(selectedRows.getPrimaryKeyValues());
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u4efb\u52a1\u5206\u914d\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_47", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            case "quality_discard": {
                if (selectedRows.size() == 0) {
                    return;
                }
                if (this.permission(itemKey)) {
                    this.discardTask(selectedRows.getPrimaryKeyValues());
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u8d28\u68c0\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u5e9f\u5f03\u201d\u7684\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_51", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void reAssign(Object[] selectedRowIds) {
        if (this.isUnHandingTask(selectedRowIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5904\u7406\u4e2d\u73af\u8282\u7684\u4efb\u52a1\u624d\u5141\u8bb8\u91cd\u5206\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"QualityCheckManagementListPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> taskidList = new ArrayList<Long>(10);
        StringBuilder sbTaskId = new StringBuilder();
        for (Object selectedRow : selectedRowIds) {
            taskidList.add((Long)selectedRow);
            sbTaskId.append(selectedRow);
            sbTaskId.append(',');
        }
        if (sbTaskId.length() > 0) {
            sbTaskId.deleteCharAt(sbTaskId.length() - 1);
        }
        this.getPageCache().put("CACHE_QUALITYCHECKMANAGEMENT_SELECTTASKID", sbTaskId.toString());
        this.openRedistributeForm(taskidList, "redistributetask");
    }

    private void assignTask(Object[] selectedRowIds) {
        if (this.isUnNeedToDoTask(selectedRowIds) || this.isRecycle(selectedRowIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5f85\u5206\u914d\u72b6\u6001\u7684\u8d28\u68c0\u4efb\u52a1\u652f\u6301\u5206\u914d\u3002", (String)"QualityCheckManagementListPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> taskidList = new ArrayList<Long>(10);
        StringBuilder sbTaskId = new StringBuilder();
        for (Object selectedRow : selectedRowIds) {
            taskidList.add((Long)selectedRow);
            sbTaskId.append(selectedRow);
            sbTaskId.append(',');
        }
        if (sbTaskId.length() > 0) {
            sbTaskId.deleteCharAt(sbTaskId.length() - 1);
        }
        this.getPageCache().put("CACHE_QUALITYCHECKMANAGEMENT_SELECTTASKID", sbTaskId.toString());
        this.openRedistributeForm(taskidList, "distributetask");
    }

    private void discardTask(Object[] selectedRowIds) {
        if (this.isUnNeedToDoTask(selectedRowIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5f85\u5206\u914d\u72b6\u6001\u7684\u8d28\u68c0\u4efb\u52a1\u652f\u6301\u5206\u914d\u3002", (String)"QualityCheckManagementListPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("btndiscard", (IFormPlugin)this);
        String strDeleteConfirmTip = ResManager.loadKDString((String)"\u5e9f\u5f03\u8d28\u68c0\u4efb\u52a1\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u786e\u8ba4\u5e9f\u5f03\u9009\u62e9\u7684\u8d28\u68c0\u4efb\u52a1\u5417\uff1f", (String)"QualityCheckManagementListPlugin_52", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, confirmCallBacks1);
    }

    private void qingView() {
        BillList list = (BillList)this.getControl("billlistap");
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("task_administrateqing");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        String pooltype = this.getPageCache("pooltype");
        String qFilter = this.getGeneralFiler(list);
        String qingbillFormID = "task_task";
        if (TaskPoolTypeEnum.COMPLETE.getValue().contains(pooltype)) {
            qingbillFormID = "task_taskhistory";
        }
        showParameter.setCustomParam("qFilter", (Object)qFilter);
        showParameter.setCustomParam("billFormId", (Object)qingbillFormID);
        showParameter.setCustomParam("pooltype", (Object)pooltype);
        showParameter.setCustomParam("personid", (Object)RequestContext.get().getUserId());
        String pageId = this.getView().getPageId();
        showParameter.setCustomParam("pageId", (Object)pageId);
        FormShowParameter parent = this.getView().getFormShowParameter();
        showParameter.setParentPageId(parent.getParentPageId());
        view.showForm(showParameter);
    }

    private void assign(Object[] selectedRowIds) {
        if (this.isUnNeedToDoTask(selectedRowIds) || this.isRecycle(selectedRowIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5f85\u5206\u914d\u72b6\u6001\u7684\u8d28\u68c0\u4efb\u52a1\u652f\u6301\u5206\u914d\u3002", (String)"QualityCheckManagementListPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("btnassigntask", (IFormPlugin)this);
        String strDeleteConfirmTip = ResManager.loadKDString((String)"\u60a8\u6240\u9009\u8d28\u68c0\u4efb\u52a1\u5c06\u5206\u914d\u7ed9\u8d28\u68c0\u5458\uff0c\u786e\u8ba4\u6267\u884c\uff1f", (String)"QualityCheckManagementListPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, confirmCallBacks1);
    }

    private void delete() {
        ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("deleteTask", (IFormPlugin)this);
        String strDeleteConfirmTip = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"QualityCheckManagementListPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, confirmCallBacks1);
    }

    private void recycle(Object[] selectedRowIds) {
        if (this.isUnChecking(selectedRowIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u8d28\u68c0\u72b6\u6001\u7684\u8d28\u68c0\u4efb\u52a1\u8fdb\u884c\u56de\u6536\u3002", (String)"QualityCheckManagementListPlugin_36", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("btnrecycle", (IFormPlugin)this);
        String strDeleteConfirmTip = ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u6267\u884c\u56de\u6536\u64cd\u4f5c\u5417\uff1f", (String)"QualityCheckManagementListPlugin_37", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, confirmCallBacks1);
    }

    private void cancelRecycle(Object[] selectedRowIds) {
        if (this.isUnRecycle(selectedRowIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56de\u6536\u72b6\u6001\u7684\u8d28\u68c0\u4efb\u52a1\u53d6\u6d88\u56de\u6536\u3002", (String)"QualityCheckManagementListPlugin_38", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("btncancelrecycle", (IFormPlugin)this);
        String strDeleteConfirmTip = ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u6267\u884c\u53d6\u6d88\u56de\u6536\u64cd\u4f5c\u5417\uff1f", (String)"QualityCheckManagementListPlugin_39", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, confirmCallBacks1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if ("deleteTask".equalsIgnoreCase(arg0.getCallBackId())) {
            Object row2;
            if (!MessageBoxResult.Yes.equals((Object)arg0.getResult())) return;
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            ArrayList<Object> ids = new ArrayList<Object>();
            for (Object row2 : selectedRows) {
                ids.add(row2.getPrimaryKeyValue());
            }
            if (this.isExistedUnToDoTasks(ids)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5f85\u5206\u914d\u201d\u72b6\u6001\u7684\u8d28\u68c0\u4efb\u52a1\u624d\u53ef\u4ee5\u88ab\u5220\u9664\u3002", (String)"QualityCheckManagementListPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            TXHandle h = TX.required();
            row2 = null;
            try {
                try {
                    if (ids.size() <= 0) return;
                    QFilter longNumberQfilter = new QFilter("id", "in", ids);
                    Map<Long, Integer> libIdAndTaskNum = TaskQueryServiceHelper.getQualitySampleLibraryId(ids);
                    this.addLog4DeletedTask(ids);
                    DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{longNumberQfilter});
                    ArrayList<Long> libIdList = new ArrayList<Long>();
                    libIdAndTaskNum.forEach((key, value) -> {
                        QualityCheckSchemeUtil.changeQualitySampleLib(key, value);
                        libIdList.add((Long)key);
                    });
                    this.setPlanFinishTimeIfNotExistTask(libIdList);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"QualityCheckManagementListPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                    return;
                }
                catch (Exception e) {
                    h.markRollback();
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"QualityCheckManagementListPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                    log.error("\u4efb\u52a1\u5220\u9664\u5931\u8d25", (Throwable)e);
                }
                return;
            }
            catch (Throwable e) {
                row2 = e;
                throw e;
            }
            finally {
                if (h != null) {
                    if (row2 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable e) {
                            ((Throwable)row2).addSuppressed(e);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        if ("btnassigntask".equalsIgnoreCase(arg0.getCallBackId())) {
            if (!MessageBoxResult.Yes.equals((Object)arg0.getResult())) return;
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            Object[] selectedRowIds = selectedRows.getPrimaryKeyValues();
            QFilter filterId = new QFilter("id", "in", (Object)selectedRowIds);
            new TaskAutoDisTaskPro().autdoDis(filterId, DisTaskSourceEnum.AUTO_DIS_3, true);
            int count = QualityCheckSchemeUtil.getDispatcherResult(selectedRowIds);
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7acb\u5373\u5206\u914d", "QualityCheckManagementListPlugin_62", "ssc-task-formplugin");
            this.addLog("assignTask", opName, Arrays.asList(selectedRowIds));
            if (count == 2) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u5df2\u5206\u914d\u6210\u529f\u3002", (String)"QualityCheckManagementListPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else if (count == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8d28\u68c0\u4efb\u52a1\u90e8\u5206\u5206\u914d\u6210\u529f\uff0c\u53ef\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u539f\u56e0\u3002", (String)"QualityCheckManagementListPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u5206\u914d\u5931\u8d25\u3002\u8bf7\u68c0\u67e5\u5458\u5de5\u5728\u5c97\u60c5\u51b5\u548c\u4efb\u52a1\u5206\u914d\u89c4\u5219\u914d\u7f6e\u3002", (String)"QualityCheckManagementListPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            this.refreshBillList();
            return;
        }
        if ("btnrecycle".equalsIgnoreCase(arg0.getCallBackId())) {
            int i;
            if (!MessageBoxResult.Yes.equals((Object)arg0.getResult())) return;
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            Object[] selectedRowIds = selectedRows.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRowIds);
            String selectRecycleIds = "id,pooltype,state,personid,expirestate,qualitysamplelibrary";
            DynamicObject[] recycleIds = BusinessDataServiceHelper.load((String)"task_task", (String)selectRecycleIds, (QFilter[])new QFilter[]{qFilter});
            String state = TaskStateEnum.RECYCLE.getValue();
            String pooltype = TaskPoolTypeEnum.TO_BE_DIS.getValue();
            for (i = 0; i < recycleIds.length; ++i) {
                DynamicObject lib2 = recycleIds[i];
                lib2.set("pooltype", (Object)pooltype);
                lib2.set("state", (Object)state);
                lib2.set("personid", (Object)0);
                lib2.set("expirestate", (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])recycleIds);
            for (i = 0; i < recycleIds.length; ++i) {
                DynamicObject idData = recycleIds[i];
                Long id = (Long)idData.get("qualitysamplelibrary.id");
                QualityCheckSchemeUtil.changeQualitySampleLib(id, 0);
            }
            List<Object> ids = Arrays.stream(recycleIds).map(r -> r.get("id")).collect(Collectors.toList());
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u56de\u6536", "QualityCheckManagementListPlugin_60", "ssc-task-formplugin");
            this.addLog("recycle", opName, ids);
            String msg = null;
            msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u56de\u6536\u6210\u529f%s\u6761\u3002", (String)"TaskAdministrateListPlugin_35", (String)"ssc-task-formplugin", (Object[])new Object[0]), recycleIds.length);
            this.getView().showSuccessNotification(msg, Integer.valueOf(2000));
            this.refreshBillList();
            return;
        }
        if ("btncancelrecycle".equalsIgnoreCase(arg0.getCallBackId())) {
            if (!MessageBoxResult.Yes.equals((Object)arg0.getResult())) return;
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            Object[] selectedRowIds = selectedRows.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRowIds);
            String selectRecycleIds = "id,qualitysamplelibrary,state";
            DynamicObject[] recycleIds = BusinessDataServiceHelper.load((String)"task_task", (String)selectRecycleIds, (QFilter[])new QFilter[]{qFilter});
            HashMap<Long, Long> qualityCheckSchemeIds = new HashMap<Long, Long>(16);
            HashMap<Long, Long> smartQualityCheckSchemeIds = new HashMap<Long, Long>(16);
            for (int i = 0; i < recycleIds.length; ++i) {
                Long qualityCheckSchemeId;
                Long taskId;
                boolean isSmart = (Boolean)recycleIds[i].get("qualitysamplelibrary.issmart");
                if (!isSmart) {
                    taskId = (Long)recycleIds[i].get("id");
                    qualityCheckSchemeId = (Long)recycleIds[i].get("qualitysamplelibrary.checkscheme.id");
                    qualityCheckSchemeIds.put(taskId, qualityCheckSchemeId);
                    continue;
                }
                taskId = (Long)recycleIds[i].get("id");
                qualityCheckSchemeId = (Long)recycleIds[i].get("qualitysamplelibrary.smartcheckscheme.id");
                smartQualityCheckSchemeIds.put(taskId, qualityCheckSchemeId);
            }
            HashSet<Long> ids = new HashSet<Long>(recycleIds.length);
            int successCount = 0;
            for (Map.Entry entry : qualityCheckSchemeIds.entrySet()) {
                Long value2 = (Long)entry.getValue();
                QFilter filter = new QFilter("id", "=", (Object)value2);
                String disMethods = "id,dismethod";
                DynamicObject[] idDisMethod = BusinessDataServiceHelper.load((String)"task_qualitycheckscheme", (String)disMethods, (QFilter[])new QFilter[]{filter});
                String disMethod = (String)idDisMethod[0].get("dismethod");
                Long key2 = (Long)entry.getKey();
                QFilter qfilter = new QFilter("id", "=", (Object)key2);
                String state = "id,state";
                DynamicObject[] idStates = BusinessDataServiceHelper.load((String)"task_task", (String)state, (QFilter[])new QFilter[]{qfilter});
                if (disMethod.equals("0")) {
                    idStates[0].set("state", (Object)TaskStateEnum.TO_BE_MANUAL_DIS.getValue());
                } else if (disMethod.equals("1")) {
                    idStates[0].set("state", (Object)TaskStateEnum.TO_BE_DIS.getValue());
                }
                SaveServiceHelper.save((DynamicObject[])idStates);
                ids.add(key2);
                ++successCount;
            }
            for (Map.Entry entry : smartQualityCheckSchemeIds.entrySet()) {
                Long value3 = (Long)entry.getValue();
                QFilter filter = new QFilter("id", "=", (Object)value3);
                String disMethods = "id,dismethod";
                DynamicObject[] idDisMethod = BusinessDataServiceHelper.load((String)"task_smartcheckscheme", (String)disMethods, (QFilter[])new QFilter[]{filter});
                String disMethod = (String)idDisMethod[0].get("dismethod");
                Long key3 = (Long)entry.getKey();
                QFilter qfilter = new QFilter("id", "=", (Object)key3);
                String state = "id,state";
                DynamicObject[] idStates = BusinessDataServiceHelper.load((String)"task_task", (String)state, (QFilter[])new QFilter[]{qfilter});
                if (disMethod.equals("0")) {
                    idStates[0].set("state", (Object)TaskStateEnum.TO_BE_MANUAL_DIS.getValue());
                } else if (disMethod.equals("1")) {
                    idStates[0].set("state", (Object)TaskStateEnum.TO_BE_DIS.getValue());
                }
                SaveServiceHelper.save((DynamicObject[])idStates);
                ids.add(key3);
                ++successCount;
            }
            for (int i = 0; i < recycleIds.length; ++i) {
                DynamicObject idData = recycleIds[i];
                Long id = (Long)idData.get("qualitysamplelibrary.id");
                QualityCheckSchemeUtil.changeQualitySampleLib(id, 0);
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d6\u6d88\u56de\u6536", "QualityCheckManagementListPlugin_59", "ssc-task-formplugin");
            this.addLog("cancelRecycle", opName, new ArrayList<Object>(ids));
            String msg = null;
            msg = String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u56de\u6536\u6210\u529f%s\u6761\u3002", (String)"QualityCheckManagementListPlugin_42", (String)"ssc-task-formplugin", (Object[])new Object[0]), successCount);
            this.getView().showSuccessNotification(msg, Integer.valueOf(2000));
            this.refreshBillList();
            return;
        }
        if (!"btndiscard".equalsIgnoreCase(arg0.getCallBackId()) || !MessageBoxResult.Yes.equals((Object)arg0.getResult())) return;
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        Object[] selectedRowIds = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)selectedRowIds);
        String selectRecycleIds = "id,pooltype,state,qualitysamplelibrary";
        DynamicObject[] discardTasks = BusinessDataServiceHelper.load((String)"task_task", (String)selectRecycleIds, (QFilter[])new QFilter[]{qFilter});
        String state = TaskStateEnum.DISCARD.getValue();
        String poolType = TaskPoolTypeEnum.COMPLETE.getValue();
        for (int i = 0; i < discardTasks.length; ++i) {
            DynamicObject task = discardTasks[i];
            task.set("pooltype", (Object)poolType);
            task.set("state", (Object)state);
        }
        try (TXHandle txHandle = TX.requiresNew((String)"som_do_qualitymanagement_discard");){
            try {
                SaveServiceHelper.save((DynamicObject[])discardTasks);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5e9f\u5f03", "QualityCheckManagementListPlugin_57", "ssc-task-formplugin");
                this.addLog("discard", opName, Arrays.stream(discardTasks).map(d -> d.get("id")).collect(Collectors.toList()));
                for (DynamicObject discardId : discardTasks) {
                    QualityTaskHelper.saveQualityHistoryTask(discardId.getLong("id"));
                }
                HashMap<Long, Integer> libTasks = new HashMap<Long, Integer>();
                for (int i = 0; i < discardTasks.length; ++i) {
                    DynamicObject idData = discardTasks[i];
                    Long id = (Long)idData.get("qualitysamplelibrary.id");
                    libTasks.compute(id, (k, v) -> v == null ? 1 : v + 1);
                }
                libTasks.forEach((lib, addNum) -> {
                    HashMap<String, Object> changeData = new HashMap<String, Object>(3);
                    changeData.put("addnum", addNum);
                    if (QualityCheckSchemeUtil.isCompleteQualityCheckLibrary(lib)) {
                        changeData.put("checkcompletetime", new Date());
                        changeData.put("state", "4");
                    } else {
                        changeData.put("state", QualityCheckSchemeUtil.getLibState(lib));
                    }
                    changeData.put("expirestate", QualityCheckSchemeUtil.getLibExpireState(lib));
                    QualityCheckSchemeUtil.changeQualitySampleLib((long)lib, changeData);
                });
            }
            catch (Exception e) {
                txHandle.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e9f\u5f03\u5931\u8d25\u3002", (String)"QualityCheckManagementListPlugin_54", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                log.error("\u5e9f\u5f03\u5931\u8d25\u3002", (Throwable)e);
                if (txHandle == null) return;
                if (var10_48 != null) {
                    try {
                        txHandle.close();
                        return;
                    }
                    catch (Throwable throwable) {
                        var10_48.addSuppressed(throwable);
                    }
                    return;
                } else {
                    txHandle.close();
                }
                return;
            }
        }
        String msg = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5e9f\u5f03\u6210\u529f%s\u6761\u3002", (String)"QualityCheckManagementListPlugin_53", (String)"ssc-task-formplugin", (Object[])new Object[0]), discardTasks.length);
        this.getView().showSuccessNotification(msg);
        this.refreshBillList();
    }

    private void addLog4DeletedTask(List<Object> deletedTaskIds) {
        AppInfo appInfo;
        IFormView view = this.getView();
        String appNumber = view.getFormShowParameter().getAppId();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        String entityId = view.getEntityId();
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u4efb\u52a1", "QualityCheckManagementListPlugin_55", "ssc-task-formplugin");
        MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u4efb\u52a1\u5355\u636e\u7f16\u53f7%s\uff0c\u5220\u9664\u6210\u529f\u3002", "TaskAdministrateListPlugin_86", "ssc-task-formplugin");
        Map<Long, String> taskBillNumMap = this.getTaskBillNumMap(deletedTaskIds);
        ArrayList<OpLogAppInfo> appLogInfoList = new ArrayList<OpLogAppInfo>(deletedTaskIds.size());
        for (Object taskId : deletedTaskIds) {
            OpLogAppInfo opLogAppInfo = new OpLogAppInfo();
            opLogAppInfo.setBizAppID(appId);
            opLogAppInfo.setBizObjID(entityId);
            opLogAppInfo.setOpName("deleteTask", opName);
            opLogAppInfo.setOpDesc(opDes, new String[]{taskBillNumMap.get(taskId)});
            appLogInfoList.add(opLogAppInfo);
        }
        LogServiceHelper.addBatchLog(appLogInfoList);
    }

    private Map<Long, String> getTaskBillNumMap(List<Object> taskIds) {
        QFilter filter = new QFilter("id", "in", taskIds);
        String selector = "id,billnumber";
        DynamicObject[] taskList = BusinessDataServiceHelper.load((String)"task_task", (String)selector, (QFilter[])filter.toArray());
        return Arrays.stream(taskList).collect(Collectors.toMap(dyo -> dyo.getLong("id"), dyo -> dyo.getString("billnumber")));
    }

    private void setPlanFinishTimeIfNotExistTask(List<Long> libIdList) {
        HashMap<Long, Date> receiveTimeMap = new HashMap<Long, Date>();
        for (Long l : libIdList) {
            QFilter filterProcess;
            QFilter filterLibId = new QFilter("qualitysamplelibrary", "=", (Object)l);
            if (QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterLibId, filterProcess = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue())})) continue;
            QFilter filterTask = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
            QFilter filterTaskHistory = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
            DynamicObjectCollection taskList = QueryServiceHelper.query((String)"task_task", (String)"id,receivetime,qualitysamplelibrary", (QFilter[])new QFilter[]{filterLibId, filterTask});
            DynamicObjectCollection taskHistoryList = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,receivetime,qualitysamplelibrary", (QFilter[])new QFilter[]{filterLibId, filterTaskHistory});
            if (taskList.isEmpty() && taskHistoryList.isEmpty()) continue;
            for (DynamicObject dynamicObject : taskList) {
                if (receiveTimeMap.get(l) == null) {
                    receiveTimeMap.put(l, dynamicObject.getDate("receivetime"));
                    continue;
                }
                if (((Date)receiveTimeMap.get(l)).compareTo(dynamicObject.getDate("receivetime")) >= 0) continue;
                receiveTimeMap.put(l, dynamicObject.getDate("receivetime"));
            }
            for (DynamicObject dynamicObject : taskHistoryList) {
                if (receiveTimeMap.get(l) == null) {
                    receiveTimeMap.put(l, dynamicObject.getDate("receivetime"));
                    continue;
                }
                if (((Date)receiveTimeMap.get(l)).compareTo(dynamicObject.getDate("receivetime")) >= 0) continue;
                receiveTimeMap.put(l, dynamicObject.getDate("receivetime"));
            }
        }
        for (Map.Entry entry : receiveTimeMap.entrySet()) {
            DynamicObject checkScheme = QualityCheckSchemeUtil.getQualityCheckScheme(Long.parseLong(entry.getKey() + ""));
            Date planFinishTime = QualityCheckSchemeUtil.getPlanFinishTime(checkScheme, (Date)entry.getValue());
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"task_qualitysamplelibrary");
            dyo.set("id", entry.getKey());
            dyo.set("planFinishTime", (Object)planFinishTime);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dyo});
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("redistributetask".equalsIgnoreCase(actionId) || "distributetask".equalsIgnoreCase(actionId)) {
            boolean isReDis = "redistributetask".equalsIgnoreCase(actionId);
            try {
                DynamicObject[] opName;
                String taskIdStr = this.getPageCache("CACHE_QUALITYCHECKMANAGEMENT_SELECTTASKID");
                String[] taskIds = StringUtils.split((String)taskIdStr, (String)",");
                HashSet<Long> taskIdSet = new HashSet<Long>(16);
                for (String taskId : taskIds) {
                    taskIdSet.add(Long.valueOf(taskId));
                }
                QFilter filterId = new QFilter("id", "in", taskIdSet);
                DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"task_task", (String)"id,personid,usergroup,orignalperson,receivetime,state,reformperson,matchrule,pooltype,qualitysamplelibrary.id", (QFilter[])new QFilter[]{filterId});
                if (tasks == null || tasks.length == 0) {
                    if (isReDis) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u91cd\u5206\u914d\u5931\u8d25\u3002\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u60a8\u9009\u62e9\u7684\u8d28\u68c0\u4efb\u52a1\u4fe1\u606f\u3002", (String)"QualityCheckManagementListPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u5206\u914d\u5931\u8d25\u3002\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u60a8\u9009\u62e9\u7684\u8d28\u68c0\u4efb\u52a1\u4fe1\u606f\u3002", (String)"QualityCheckManagementListPlugin_48", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                if (isReDis) {
                    opName = new MultiLangEnumBridge("\u91cd\u5206\u914d", "QualityCheckManagementListPlugin_58", "ssc-task-formplugin");
                    this.addLog("reDistributeTask", (MultiLangEnumBridge)opName, Arrays.stream(tasks).map(t -> t.get("id")).collect(Collectors.toList()));
                } else {
                    opName = new MultiLangEnumBridge("\u4efb\u52a1\u5206\u914d", "QualityCheckManagementListPlugin_61", "ssc-task-formplugin");
                    this.addLog("distributeTask", (MultiLangEnumBridge)opName, Arrays.stream(tasks).map(t -> t.get("id")).collect(Collectors.toList()));
                }
                for (DynamicObject item : tasks) {
                    String[] splits = ((String)returnData).split("_");
                    item.set("personid", (Object)splits[0]);
                    String taskState = item.getString("state");
                    if (taskState.equals(TaskStateEnum.RECTIFYING.getValue()) || taskState.equals(TaskStateEnum.PAUSE_RECTIFYING.getValue())) {
                        item.set("reformperson", (Object)splits[0]);
                    } else {
                        item.set("orignalperson", (Object)splits[0]);
                    }
                    item.set("usergroup", (Object)splits[1]);
                    item.set("receivetime", (Object)new Date());
                    item.set("matchrule", (Object)0L);
                    if (isReDis) continue;
                    item.set("state", (Object)TaskStateEnum.CHECKING.getValue());
                    item.set("pooltype", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
                }
                SaveServiceHelper.save((DynamicObject[])tasks);
                if ("distributetask".equalsIgnoreCase(actionId)) {
                    QualityCheckSchemeUtil.setPlanEndTime(tasks);
                }
                Set<Long> libs = Arrays.stream(tasks).filter(t -> t.getLong("qualitysamplelibrary.id") != 0L).map(t -> t.getLong("qualitysamplelibrary.id")).collect(Collectors.toSet());
                libs.forEach(lib -> QualityCheckSchemeUtil.changeQualitySampleLib(lib, 0));
                if (isReDis) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u91cd\u5206\u914d\u6210\u529f\u3002", (String)"QualityCheckManagementListPlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u5df2\u6210\u529f\u5206\u914d\u3002", (String)"QualityCheckManagementListPlugin_49", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                }
                this.refreshBillList();
            }
            catch (Exception exp) {
                if (isReDis) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u91cd\u5206\u914d\u5931\u8d25\u3002", (String)"QualityCheckManagementListPlugin_21", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u4efb\u52a1\u5206\u914d\u5931\u8d25\u3002", (String)"QualityCheckManagementListPlugin_50", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
            }
        } else if ("action_quality_pause".equals(actionId)) {
            QualityApprovalPendingHelper.qualityPauseAction(this.getView(), (Map)returnData);
            this.refreshBillList();
        }
    }

    public void afterCreateNewData(EventObject e) {
        List poolTypeList;
        super.afterCreateNewData(e);
        this.isFirstInitialForCommonFilter = true;
        Map<String, Object> params = this.getCustomParams();
        List list = poolTypeList = params.get("pooltype") == null ? null : (List)params.get("pooltype");
        if (poolTypeList != null && poolTypeList.size() > 0) {
            this.setPageCache("pooltype", (String)poolTypeList.get(0));
        } else {
            this.setPageCache("pooltype", TaskPoolTypeEnum.TO_BE_DIS.getValue());
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs hyperlinkclickargs) {
        super.billListHyperLinkClick(hyperlinkclickargs);
        hyperlinkclickargs.setCancel(true);
        HyperLinkClickEvent args = hyperlinkclickargs.getHyperLinkClickEvent();
        IFormView view = this.getView();
        String fieldName = args.getFieldName();
        if ("subject".equals(fieldName)) {
            ListSelectedRow row = ((BillList)view.getControl("billlistap")).getCurrentSelectedRowInfo();
            if (row == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"QualityCheckManagementListPlugin_22", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            Long taskId = Long.valueOf(row.getPrimaryKeyValue() + "");
            String poolType = this.getPageCache("pooltype");
            boolean isHisTask = TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType);
            TaskApprevalHelper.showFormToQualityCheck(view, taskId, isHisTask, null, TaskApprovePageInvokerEnum.QUALITY_CHECK_MANAGE_LIST.getValue(), false);
        }
    }

    private void removeFilterForCheck(List<FilterColumn> filterColumns, List<String> needRemoveColumnNameList) {
        filterColumns.removeIf(p -> needRemoveColumnNameList.contains(p.getFieldName()));
    }

    private String getPageCache(String key) {
        return this.getPageCache().get(key);
    }

    private void setPageCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private void refreshBillList() {
        BillList list = (BillList)this.getControl("billlistap");
        list.clearSelection();
        list.refresh();
    }

    private String getGeneralFiler(BillList list) {
        List generalfilter = list.generalFilterParameter().getQFilters();
        QFilter generalqf = new QFilter("1", "=", (Object)1);
        for (QFilter f : generalfilter) {
            generalqf = generalqf.and(f);
        }
        String qFilter = generalqf.toSerializedString();
        return qFilter;
    }

    private void switchGridBillFormID(String localBillFormId, List<FilterColumn> listFilter) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setBillFormId(localBillFormId);
        billList.setEntityId("");
        billList.setOrderBy("taskcreatetime desc,receivetime desc, qualitychecktime desc");
        this.setMetaData(localBillFormId);
        HashMap<String, List<String>> entryFields = new HashMap<String, List<String>>(1);
        entryFields.put("billinfoentry", Arrays.asList("costdept", "expenseitem", "expenseamount", "supplier"));
        SwitchBillListEntryEntity switchEntryEntity = new SwitchBillListEntryEntity();
        switchEntryEntity.setEntityName(localBillFormId);
        switchEntryEntity.setEntryFileds(entryFields);
        switchEntryEntity.setFilterColumns(this.fastFilterColumns, this.listFilterColumns, this.schemeFilterColumns);
        switchEntryEntity.setListColumns(this.listColumns);
        switchEntryEntity.switchAction(billList);
        this.rebuildGridColumn();
    }

    private void setMetaData(String billFormId) {
        BillList billList = (BillList)this.getControl("billlistap");
        Map meta = FormMetadataCache.getListMeta((String)billFormId);
        if (meta != null && meta.containsKey(BillList.class.getSimpleName())) {
            String strBillList = (String)meta.get(BillList.class.getSimpleName());
            BillList list = (BillList)ControlTypes.fromJsonString((String)strBillList);
            billList.setPageRow(list.getPageRow());
            billList.setEntityId(list.getEntityId());
            billList.getItems().clear();
            billList.getItems().addAll(list.getItems());
            ListUserConfig userConfig = ListUserConfig.retrieve((String)"qualitytask-admin");
            if (userConfig != null) {
                billList.setPageRow(userConfig.getPageRows());
            }
        }
        BeforeCreateListColumnsArgs beforeCreateListColumnsArgs = ViewCommonUtil.createBeforeCreateListColumnArgs((BillList)billList);
        billList.setBeforeCreateListColumnsArgs(beforeCreateListColumnsArgs);
        this.listColumns = beforeCreateListColumnsArgs.getListColumns();
    }

    private void handleToolBarState(IFormView view) {
        String poolType = this.getPageCache("pooltype");
        if (StringUtils.isEmpty((CharSequence)poolType) || TaskPoolTypeEnum.TO_BE_DIS.getValue().equalsIgnoreCase(poolType)) {
            this.setUndistributedState(view);
        } else {
            this.setDistributedState(view, poolType);
        }
        this.setImageButton();
    }

    private void setUndistributedState(IFormView view) {
        List<String> hideButtons = Arrays.asList("mytask_pass", "mytask_nopass", "mytask_repulseonly", "mytask_viewphoto", "mytask_viewphotocheck", "mytask_pause", "mytask_modifypriority", "mytask_ask", "mytask_viewflowchart", "mytask_qingviewlist", "mytask_more", "admin_repulse", "admin_viewphoto", "admin_pause", "admin_redistribution", "admin_qingviewlist", "admin_assigntask", "admin_modifypriority", "admin_viewflowchart", "admin_back", "admin_cancleback", "admin_more", "maintenance", "identifyinginvoice", "quality_returnassigntask", "checkvoucherbtn", "quality_recycle", "removemutexcache", "admin_checkvoucher", "quality_pause", "quality_cancelpause", "recalctime", "btncirculation", "circulatelog");
        List<String> showButtons = Arrays.asList("quality_discard", "quality_delete", "quality_assignimme", "quality_assigntask", "quality_qingviewlist", "quality_export", "quality_cancelrecycle");
        view.setVisible(Boolean.FALSE, hideButtons.toArray(new String[29]));
        view.setVisible(Boolean.TRUE, showButtons.toArray(new String[7]));
    }

    private void setDistributedState(IFormView view, String poolType) {
        List<String> hideButtons = Arrays.asList("mytask_pass", "mytask_nopass", "mytask_repulseonly", "mytask_viewphoto", "mytask_viewphotocheck", "mytask_pause", "mytask_modifypriority", "mytask_ask", "mytask_viewflowchart", "mytask_qingviewlist", "mytask_more", "admin_repulse", "admin_viewphoto", "admin_pause", "admin_redistribution", "admin_qingviewlist", "admin_assigntask", "admin_modifypriority", "admin_viewflowchart", "admin_back", "admin_cancleback", "admin_more", "maintenance", "identifyinginvoice", "quality_delete", "quality_assignimme", "quality_assigntask", "checkvoucherbtn", "quality_cancelrecycle", "removemutexcache", "admin_checkvoucher", "recalctime", "quality_discard", "btncirculation", "circulatelog");
        List<String> showButton = Arrays.asList("quality_qingviewlist", "quality_export");
        view.setVisible(Boolean.FALSE, hideButtons.toArray(new String[29]));
        view.setVisible(Boolean.TRUE, showButton.toArray(new String[5]));
        if (TaskPoolTypeEnum.PROCESSING.getValue().equalsIgnoreCase(poolType)) {
            view.setVisible(Boolean.TRUE, new String[]{"quality_returnassigntask"});
            view.setVisible(Boolean.TRUE, new String[]{"quality_recycle"});
            view.setVisible(Boolean.TRUE, new String[]{"quality_pause", "quality_cancelpause"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"quality_returnassigntask"});
            view.setVisible(Boolean.FALSE, new String[]{"quality_recycle"});
            view.setVisible(Boolean.FALSE, new String[]{"quality_pause", "quality_cancelpause"});
        }
    }

    private boolean isUnNeedToDoTask(Object ids) {
        ORM orm = ORM.create();
        QFilter filterId = new QFilter("id", "in", ids);
        QFilter filterPoolType = new QFilter("pooltype", "!=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        return orm.exists("task_task", new QFilter[]{filterId, filterPoolType});
    }

    private boolean isUnHandingTask(Object ids) {
        QFilter filterId = new QFilter("id", "in", ids);
        QFilter filterPoolType = new QFilter("pooltype", "!=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        return QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterId, filterPoolType});
    }

    private boolean isUnChecking(Object ids) {
        QFilter filterId = new QFilter("id", "in", ids);
        QFilter filterState = new QFilter("state", "!=", (Object)TaskStateEnum.CHECKING.getValue());
        return QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterId, filterState});
    }

    private boolean isUnRecycle(Object ids) {
        QFilter filterId = new QFilter("id", "in", ids);
        QFilter filterState = new QFilter("state", "!=", (Object)TaskStateEnum.RECYCLE.getValue());
        return QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterId, filterState});
    }

    private boolean isRecycle(Object ids) {
        QFilter filterId = new QFilter("id", "in", ids);
        QFilter filterState = new QFilter("state", "=", (Object)TaskStateEnum.RECYCLE.getValue());
        return QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterId, filterState});
    }

    private Map<String, Object> getCustomParams() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        return paramMap;
    }

    private boolean isExistedUnToDoTasks(List<Object> ids) {
        QFilter filterIds = new QFilter("id", "in", ids);
        QFilter filterPoolType = new QFilter("pooltype", "!=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        if (QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{filterIds, filterPoolType})) {
            return true;
        }
        return QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])new QFilter[]{filterIds, filterPoolType});
    }

    private void reBuildCommonFilter(List<FilterColumn> listFilter, List<Map<String, List<Object>>> customlist) {
        for (FilterColumn filterColumn : listFilter) {
            String columnName = filterColumn.getFieldName();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (columnName.equals(this.qualityLibraryFilter)) {
                filterColumn.getFilterColumns().clear();
            }
            if (TaskCommonFilterFactory.getQualityListFieldSet().contains(columnName)) {
                TaskCommonFilterService service = TaskCommonFilterFactory.getFilterService(columnName);
                CommonFilterDTO commonFilterDTO = new CommonFilterDTO(commonFilterColumn, this.getPageCache(), this.getView(), (FilterContainer)this.getControl("filtercontainerap"));
                service.invokeQualityList(commonFilterDTO);
            }
            String sscId = this.getPageCache("CACHE_QUALITYCHECKMANAGEMENT_SSCID");
            if (columnName.equals(this.qualityCheckFilter) && StringUtils.isNotBlank((CharSequence)sscId)) {
                CommonFilterUtil.createSmartSchemeFilter(commonFilterColumn, Long.parseLong(sscId));
            }
            String somSchemeIdKey = CacheKey.getSOMKey((Object)"qualityCheckManager_schemeId");
            String schemeId = this.getPageCache(somSchemeIdKey);
            if (!columnName.equals(this.qualityLibraryFilter) || !StringUtils.isNotBlank((CharSequence)sscId)) continue;
            if ("0".equals(schemeId)) {
                this.createSmartLibraryFilter(commonFilterColumn, Long.parseLong(sscId));
                this.setPageCache(somSchemeIdKey, "0");
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)schemeId)) continue;
            this.createSmartLibraryFilter2(commonFilterColumn, Long.parseLong(sscId));
        }
        this.removeFilterColsByPoolType();
        if (null != customlist) {
            this.setTimeFilterColsByPoolType(listFilter, customlist);
        }
    }

    private void createSmartLibraryFilter(CommonFilterColumn filterColumn, Long sscId) {
        QFilter filters = new QFilter("smartcheckscheme.ssccenter.id", "=", (Object)sscId);
        filters.and(new QFilter("issmart", "=", (Object)"1"));
        DynamicObjectCollection sampleLibraries = QueryServiceHelper.query((String)"task_qualitysamplelibrary", (String)"id,number,name", (QFilter[])new QFilter[]{filters});
        if (!sampleLibraries.isEmpty()) {
            List hadComboItems = filterColumn.getComboItems();
            sampleLibraries.forEach(lib -> hadComboItems.add(new ComboItem(new LocaleString(lib.get("number") + ""), lib.get("id") + "")));
        }
    }

    private void createSmartLibraryFilter2(CommonFilterColumn filterColumn, Long sscId) {
        List hadComboItems = filterColumn.getComboItems();
        QFilter filters = new QFilter("smartcheckscheme.ssccenter.id", "=", (Object)sscId);
        filters.and(new QFilter("issmart", "=", (Object)"1"));
        DynamicObjectCollection sampleLibraries = QueryServiceHelper.query((String)"task_qualitysamplelibrary", (String)"id,number,name", (QFilter[])new QFilter[]{filters});
        if (!sampleLibraries.isEmpty()) {
            ArrayList comboItems = new ArrayList(10);
            comboItems.addAll(hadComboItems);
            sampleLibraries.forEach(lib -> comboItems.add(new ComboItem(new LocaleString(lib.get("number") + ""), lib.get("id") + "")));
            filterColumn.setComboItems(comboItems);
        }
    }

    private void removeFilterColsByPoolType() {
        String poolType = this.getPageCache("pooltype");
        HashSet<String> needRemoveCols = new HashSet<String>(4);
        int size = this.listFilterColumns.size();
        for (int i = 0; i < size; ++i) {
            CommonFilterColumn filterColumn = (CommonFilterColumn)this.listFilterColumns.get(i);
            if (!filterColumn.getFieldName().equals("pooltype")) continue;
            if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(poolType)) {
                needRemoveCols.add("receivetime");
                needRemoveCols.add("completetime");
                break;
            }
            if (TaskPoolTypeEnum.PROCESSING.getValue().equals(poolType)) {
                needRemoveCols.add("taskcreatetime");
                needRemoveCols.add("completetime");
                break;
            }
            if (!TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) break;
            needRemoveCols.add("taskcreatetime");
            needRemoveCols.add("receivetime");
            break;
        }
        if (!needRemoveCols.isEmpty()) {
            this.listFilterColumns.removeIf(o -> needRemoveCols.contains(o.getFieldName()));
        }
    }

    private void setTimeFilterColsByPoolType(List<FilterColumn> listFilter, List<Map<String, List<Object>>> customlist) {
        Set<String> timeFieldSet = TaskCommonFilterFactory.getQuaAdminTimeFieldSet();
        String pooltype = this.getPageCache("pooltype");
        if (StringUtils.isEmpty((CharSequence)pooltype)) {
            pooltype = TaskPoolTypeEnum.TO_BE_DIS.getValue();
        }
        String timeFieldName = "taskcreatetime";
        TaskPoolTypeEnum poolTypeEnum = TaskPoolTypeEnum.getTaskPoolType((String)pooltype);
        switch (poolTypeEnum) {
            case PROCESSING: {
                timeFieldName = "receivetime";
                break;
            }
            case COMPLETE: {
                timeFieldName = "completetime";
                break;
            }
        }
        for (FilterColumn filterColumn : listFilter) {
            String columnName = filterColumn.getFieldName();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (!timeFieldSet.contains(columnName)) continue;
            for (Map<String, List<Object>> customMap : customlist) {
                List<Object> listValue = customMap.get("Value");
                List<Object> listFieldName = customMap.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (!"taskcreatetime".equals(listFieldName.get(j)) && !"receivetime".equals(listFieldName.get(j)) && !"completetime".equals(listFieldName.get(j))) continue;
                    commonFilterColumn.setDefaultValues(listValue);
                    listFieldName.set(j, timeFieldName);
                }
            }
        }
    }

    private void rebuildGridColumn() {
        String poolType = this.getPageCache("pooltype");
        this.setColumnVisable(this.listColumns, poolType);
    }

    private void setColumnVisable(List<IListColumn> listColumns, String poolType) {
        List<String> needShowFields = Arrays.asList("fseq", "qualitysamplelibrary.number", "subject", "billtype.name", "createtime", "receivetime", "qualitychecktime", "completetime", "expirestate", "qualityresult", "qualitystate", "state", "autoprocessforcheck", "billnumber", "creator.number");
        needShowFields = new ArrayList<String>(needShowFields);
        List<String> voucherFields = Arrays.asList("voucherno", "voucherstat", "isgenvoucher");
        String sscId = this.getPageCache().get("CACHE_QUALITYCHECKMANAGEMENT_SSCID");
        boolean flag = false;
        if (StringUtils.isNotEmpty((CharSequence)poolType)) {
            if (!TaskPoolTypeEnum.COMPLETE.getValue().equals(poolType)) {
                needShowFields.remove("completetime");
            }
            if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(poolType)) {
                needShowFields.remove("receivetime");
                needShowFields.remove("qualitychecktime");
                needShowFields.remove("expirestate");
                needShowFields.remove("qualityresult");
                flag = true;
            }
        }
        for (IListColumn iListColumn : listColumns) {
            if (iListColumn instanceof MergeListColumn) {
                List listColumnsMerges = ((MergeListColumn)iListColumn).getItems();
                for (Control listMergeColumn : listColumnsMerges) {
                    IListColumn listColumn = (IListColumn)listMergeColumn;
                    String key = listColumn.getListFieldKey();
                    if ("personid.name".equalsIgnoreCase(key)) {
                        iListColumn.setVisible(ListColumnDisplay.hide.getValue());
                        continue;
                    }
                    if (!"orignalperson.name".equalsIgnoreCase(key) || !flag) continue;
                    iListColumn.setVisible(ListColumnDisplay.hide.getValue());
                }
                continue;
            }
            if (iListColumn instanceof DynamicTextListColumn) continue;
            ListColumn listcolumn = (ListColumn)iListColumn;
            String key = listcolumn.getListFieldKey();
            if (needShowFields != null && needShowFields.contains(key)) {
                listcolumn.setVisible(ListColumnDisplay.show.getValue());
            } else {
                listcolumn.setVisible(ListColumnDisplay.hide.getValue());
            }
            if (voucherFields.contains(key)) {
                String sscType = DutyManageDataHelper.getSSCType((long)Long.parseLong(sscId));
                if (SSCTypeEnum.FI.getValue().equals(sscType)) {
                    iListColumn.setVisible(ListColumnDisplay.show.getValue());
                } else {
                    iListColumn.setVisible(ListColumnDisplay.hide.getValue());
                }
            }
            if (!"subject".equals(key)) continue;
            listcolumn.setHyperlink(true);
        }
    }

    private void openRedistributeForm(List<Long> taskidList, String closeCallBackId) {
        ArrayList<String> tTypeBTypeList = new ArrayList<String>();
        ArrayList<String> orgIDList = new ArrayList<String>();
        ArrayList<String> sscList = new ArrayList<String>();
        HashSet<Long> userGroupSet = new HashSet<Long>(8);
        ORM orm = ORM.create();
        String selectFields = "id,tasktypeid,billtype,state,orgid,sscid";
        List<List<Long>> taskIdListList = this.splitTaskIdList(taskidList);
        boolean isRectification = false;
        for (List<Long> taskIdList : taskIdListList) {
            QFilter taskIdFilter = new QFilter("id", "in", taskIdList);
            DynamicObjectCollection taskObjects = orm.query("task_task", "id,tasktypeid,billtype,state,orgid,sscid, autoprocess, sourcetaskid,autoprocessforcheck,qualitysamplelibrary,usergroup", new QFilter[]{taskIdFilter});
            Set<Long> libIdSet = taskObjects.stream().map(dy -> dy.getLong("qualitysamplelibrary")).collect(Collectors.toSet());
            String approvalType = null;
            String dislueType = null;
            String tTypeBType = null;
            boolean autoprocess = false;
            boolean quaCheckDisRule = false;
            Map<Long, DynamicObject> libMapSchemeObject = QualityCheckSchemeUtil.getLibMapSchemeObject(libIdSet);
            for (DynamicObject taskRow : taskObjects) {
                Long libId = taskRow.getLong("qualitysamplelibrary");
                String state = taskRow.getString("state");
                userGroupSet.add(taskRow.getLong("usergroup"));
                DynamicObject dyScheme = libMapSchemeObject.get(libId);
                if (dyScheme == null) continue;
                approvalType = dyScheme.getString("isautoprocess");
                quaCheckDisRule = this.isQualityCheckDisRule(approvalType, dislueType = dyScheme.getString("disrule"), autoprocess = taskRow.getBoolean("autoprocess"), state);
                if (quaCheckDisRule) {
                    tTypeBType = taskRow.getString("tasktypeid") + "," + taskRow.getString("billtype");
                    tTypeBTypeList.add(tTypeBType);
                    orgIDList.add(taskRow.getString("orgid"));
                    sscList.add(taskRow.getString("sscid"));
                    continue;
                }
                Long sourcetaskid = taskRow.getLong("sourcetaskid");
                QFilter filterHistoryTaskId = new QFilter("id", "=", (Object)sourcetaskid);
                DynamicObject taskHistory = orm.queryOne("task_taskhistory", selectFields, new QFilter[]{filterHistoryTaskId});
                tTypeBType = taskHistory.getString("tasktypeid") + "," + taskHistory.getString("billtype");
                tTypeBTypeList.add(tTypeBType);
                orgIDList.add(taskHistory.getString("orgid"));
                sscList.add(taskHistory.getString("sscid"));
                isRectification = true;
            }
        }
        String pageCacheByKey = this.getPageCache("identity");
        if (!"sysadmin".equals(pageCacheByKey) && !UserGroupUtil.allMyManageGroup(sscList, userGroupSet, this.getView())) {
            return;
        }
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setCustomParam("operation", null);
        parameEdit.setCustomParam("taskdis", taskidList);
        parameEdit.setCustomParam("taskdisParameters", tTypeBTypeList);
        parameEdit.setCustomParam("orgIDList", orgIDList);
        parameEdit.setCustomParam("sscs", sscList);
        parameEdit.setCustomParam("isexceptrebots", (Object)Boolean.TRUE);
        parameEdit.setCustomParam("isRectification", (Object)isRectification);
        parameEdit.setCustomParam("identity", (Object)pageCacheByKey);
        parameEdit.setFormId("task_userworkload");
        parameEdit.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, closeCallBackId);
        parameEdit.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameEdit);
    }

    private boolean isQualityCheckDisRule(String approvalType, String dislueType, boolean autoprocess, String state) {
        if (TaskStateEnum.RECTIFYING.getValue().equals(state) || TaskStateEnum.PAUSE_RECTIFYING.getValue().equals(state)) {
            return false;
        }
        if ("0".equals(approvalType)) {
            return true;
        }
        if ("1".equals(approvalType)) {
            if ("0".equals(dislueType)) {
                return true;
            }
        } else if ("2".equals(approvalType)) {
            if ("0".equals(dislueType)) {
                return true;
            }
            if (!autoprocess && "1".equals(dislueType)) {
                return true;
            }
        }
        return false;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String userId = RequestContext.get().getUserId();
        List qfilters = args.getQfilters();
        String name = args.getFieldName();
        String sscId = this.getPageCache("CACHE_QUALITYCHECKMANAGEMENT_SSCID");
        if (StringUtils.isNotEmpty((CharSequence)sscId)) {
            switch (name) {
                case "billtype.id": {
                    args.addCustomParam("showDisabledCheckbox", (Object)Boolean.FALSE);
                    qfilters.add(new QFilter("ssccenter", "=", (Object)Long.valueOf(sscId)));
                    break;
                }
                case "qualitysamplelibrary.id": {
                    String somSchemeIdKey = CacheKey.getSOMKey((Object)"qualityCheckManager_schemeId");
                    String checkSchemeId = this.getPageCache(somSchemeIdKey);
                    QFilter filter = new QFilter("checkscheme.ssccenter", "=", (Object)Long.valueOf(sscId));
                    filter.or(new QFilter("smartcheckscheme.ssccenter", "=", (Object)Long.valueOf(sscId)));
                    if ("0".equals(checkSchemeId)) {
                        filter.and(new QFilter("issmart", "=", (Object)"1"));
                    }
                    qfilters.add(filter);
                    args.addCustomParam("showDisabledCheckbox", (Object)Boolean.FALSE);
                    break;
                }
                case "qualitysamplelibrary.checkscheme.id": {
                    qfilters.add(new QFilter("ssccenter", "=", (Object)Long.valueOf(sscId)));
                    break;
                }
                case "sscid.id": 
                case "sscid.name": {
                    String schemeFilter = this.getPageCache().get("schemeFilter");
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)schemeFilter)) break;
                    ArrayList sscIdList = (ArrayList)SerializationUtils.fromJsonStringToList((String)schemeFilter, String.class);
                    HashSet<Long> sscIdLong = new HashSet<Long>(16);
                    this.filterSscBySscTpe(sscIdList, sscIdLong);
                    qfilters.add(new QFilter("id", "in", sscIdLong));
                    break;
                }
                case "usergroup.id": {
                    qfilters.add(new QFilter("createorg", "=", (Object)Long.valueOf(sscId)));
                    break;
                }
                case "usergroup.name": {
                    ArrayList gids = new ArrayList(16);
                    List sscNames = this.getControlFilters().getFilter("sscid.name");
                    QFilter nameFilter = new QFilter("name", "in", (Object)sscNames);
                    DynamicObjectCollection ids = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{nameFilter});
                    if (ids != null && !ids.isEmpty()) {
                        for (DynamicObject obj : ids) {
                            DynamicObjectCollection groupIds;
                            Long sid = obj.getLong("id");
                            QFilter gfilter = new QFilter("createorg", "=", (Object)sid);
                            if (TeamLeaderApi.isOpenTeamleader(String.valueOf(sid))) {
                                gfilter.and("entryentity.userfield", "=", (Object)Long.valueOf(userId));
                                gfilter.and("entryentity.teamleader", "=", (Object)Character.valueOf('1'));
                            }
                            if ((groupIds = QueryServiceHelper.query((String)"task_usergroup", (String)"id", (QFilter[])new QFilter[]{gfilter})) == null || groupIds.isEmpty()) continue;
                            gids.addAll(groupIds.stream().map(g -> g.getLong("id")).collect(Collectors.toList()));
                        }
                    }
                    qfilters.add(new QFilter("id", "in", gids));
                    break;
                }
            }
        }
    }

    private boolean permission(String operationKey) {
        String permissionId;
        Long sscId;
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = StringUtils.isNotEmpty((CharSequence)appId) ? BizAppServiceHelp.getAppIdByAppNumber((String)appId) : "/K1N3DDJX/R9";
        String entityName = "task_doqualitymanagement";
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        int result = PermissionServiceHelper.checkPermission((Long)userId, (Long)(sscId = Long.valueOf(Long.parseLong(this.getPageCache("CACHE_QUALITYCHECKMANAGEMENT_SSCID")))), (String)appId, (String)entityName, (String)(permissionId = permissionMap.get(operationKey)));
        return result == 1;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String formId = "task_doqualitymanagement";
        boolean hasLicense = SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)formId);
        if (!hasLicense) {
            return;
        }
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), formId, e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"QualityCheckManagementListPlugin_35", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private List<List<Long>> splitTaskIdList(List<Long> taskIdList) {
        int inputSize = taskIdList.size();
        int times = (int)Math.ceil((double)inputSize * 1.0 / 1000.0);
        ArrayList<List<Long>> taskIdListList = new ArrayList<List<Long>>(times);
        int fromIndex = 0;
        int toIndex = Math.min(inputSize, 1000);
        while (times-- > 0) {
            taskIdListList.add(taskIdList.subList(fromIndex, toIndex));
            fromIndex = toIndex;
            toIndex = Math.min(inputSize, toIndex + 1000);
        }
        return taskIdListList;
    }

    private void qualityPause(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> taskIds = new ArrayList<Long>(8);
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter idFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObject[] taskDos = BusinessDataServiceHelper.load((String)"task_task", (String)"id,personid,pooltype,state", (QFilter[])new QFilter[]{idFilter});
        int abnormalQualityTask = 0;
        for (DynamicObject taskDo : taskDos) {
            long id = taskDo.getLong("id");
            taskIds.add(id);
            String state = taskDo.getString("state");
            if (QualityApprovalPendingHelper.isPause(state)) continue;
            ++abnormalQualityTask;
        }
        if (taskIds.size() == abnormalQualityTask) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u8d28\u68c0\u3001\u5f85\u6574\u6539\u6216\u5f85\u590d\u6838\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"QualityCheckManagementListPlugin_45", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openQualityPendingDialog(taskIds);
    }

    private void openQualityPendingDialog(List<Long> taskIds) {
        if (!CollectionUtils.isEmpty(taskIds)) {
            IFormView view = this.getView();
            FormShowParameter para = new FormShowParameter();
            para.setFormId("task_qcpendingreasonsel");
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.getOpenStyle().setTargetKey("tabap");
            para.setHasRight(true);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "action_quality_pause"));
            para.setCustomParam("taskIds", taskIds);
            view.showForm(para);
        }
    }

    private void qualityCancelPause(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> taskIds = new ArrayList<Long>(8);
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter idFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObject[] taskDos = BusinessDataServiceHelper.load((String)"task_task", (String)"id,personid,pooltype,state", (QFilter[])new QFilter[]{idFilter});
        int abnormalQualityTask = 0;
        for (DynamicObject taskDo : taskDos) {
            long id = taskDo.getLong("id");
            taskIds.add(id);
            String state = taskDo.getString("state");
            if (QualityApprovalPendingHelper.isCancelPause(state)) continue;
            ++abnormalQualityTask;
        }
        if (taskIds.size() == abnormalQualityTask) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8d28\u68c0\u6682\u6302\u201d\u3001\u201c\u6574\u6539\u6682\u6302\u201d\u6216\u201c\u590d\u6838\u6682\u6302\u201d\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"QualityCheckManagementListPlugin_46", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> returnData = QualityApprovalPendingHelper.qualityCancelPending(taskIds);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d6\u6d88\u6682\u6302", "QualityCheckManagementListPlugin_56", "ssc-task-formplugin");
        this.addLog("qualityCancelPause", opName, new ArrayList<Object>(taskIds));
        QualityApprovalPendingHelper.qualityCancelPauseAction(this.getView(), returnData);
    }

    private void addLog(String opKey, MultiLangEnumBridge opName, List<Object> ids) {
        AppInfo appInfo;
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String poolType = this.getPageCache("pooltype");
        String formId = "task_task";
        if (TaskPoolTypeEnum.COMPLETE.getValue().contains(poolType)) {
            formId = "task_taskhistory";
        }
        IFormView view = this.getView();
        String appNumber = view.getFormShowParameter().getAppId();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        String bizAppID = appId;
        String bizObjID = formId;
        Map<Long, String> taskBillNumMap = this.getTaskBillNumMap(ids);
        MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u4efb\u52a1\u5355\u636e\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f\u3002", "QualityCheckManagementListPlugin_63", "ssc-task-formplugin");
        String localOpName = opName.getDescription();
        List logs = taskBillNumMap.values().stream().map(row -> {
            OpLogAppInfo opLogAppInfo = new OpLogAppInfo();
            opLogAppInfo.setBizAppID(bizAppID);
            opLogAppInfo.setBizObjID(bizObjID);
            opLogAppInfo.setOpName(opKey, opName);
            opLogAppInfo.setOpDesc(opDes, new String[]{row, localOpName});
            return opLogAppInfo;
        }).collect(Collectors.toList());
        try {
            LogServiceHelper.addBatchLog(logs);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void filterSscBySscTpe(ArrayList<String> sscIdList, HashSet<Long> sscIdLong) {
        String appId = this.getView().getFormShowParameter().getAppId();
        String cusAppId = (String)this.getView().getFormShowParameter().getCustomParam("cusAppId");
        if (StringUtils.isNotEmpty((CharSequence)cusAppId)) {
            appId = cusAppId;
        }
        for (String item : sscIdList) {
            Long sscId = Long.valueOf(item);
            String sscType = DutyManageDataHelper.getSSCType((long)sscId);
            if (AppTypeEnum.HSTC.getValue().equals(appId)) {
                if (!SSCTypeEnum.HR.getValue().equals(sscType)) continue;
                sscIdLong.add(sscId);
                continue;
            }
            if (SSCTypeEnum.HR.getValue().equals(sscType)) continue;
            sscIdLong.add(sscId);
        }
    }

    private void setImageButton() {
        boolean displayImage = this.imageDisplayCtrl();
        if (displayImage) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"quality_viewphoto"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"quality_viewphoto"});
        }
    }

    private boolean imageDisplayCtrl() {
        String sscIdStr = this.getView().getPageCache().get("CACHE_QUALITYCHECKMANAGEMENT_SSCID");
        Long sscId = null;
        if (StringUtils.isNotEmpty((CharSequence)sscIdStr)) {
            sscId = Long.valueOf(sscIdStr);
        } else {
            log.info("imageDisplayCtrl()\uff1a\u5f53\u524d\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3id\u4e3a\u7a7a");
        }
        String billTypeJson = this.getView().getPageCache().get(BILL_TYPE_JSON);
        List billTypeIdList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)billTypeJson)) {
            billTypeIdList = (List)SerializationUtils.fromJsonString((String)billTypeJson, List.class);
        }
        return SscImageServiceUtil.imageDisplayCtrl((Long)sscId, billTypeIdList);
    }

    static {
        permissionMap.put("quality_delete", "4715e1f1000000ac");
        permissionMap.put("quality_assignimme", "3FM3FR5W5OOB");
        permissionMap.put("quality_assigntask", "2STQTJ0/14T6");
        permissionMap.put("quality_returnassigntask", "16G+3Q55J2QA");
        permissionMap.put("quality_viewphoto", "/KT4ZAX6VRY0");
        permissionMap.put("quality_qingviewlist", "16G+83U7CY=/");
        permissionMap.put("quality_export", "4730fc9f000004ae");
        permissionMap.put("quality_recycle", "350U13O0WKB+");
        permissionMap.put("quality_cancelrecycle", "350UZ94KHS0L");
        permissionMap.put("quality_pause", "3D0XKLZXMPM8");
        permissionMap.put("quality_cancelpause", "3D0XNHQU6KKI");
        permissionMap.put("quality_discard", "3G+67S/Q53RL");
    }
}

