/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.formplugin.QualityCheckTaskParentPlugin;
import kd.ssc.task.formplugin.TaskApprevalHelper;
import kd.ssc.task.formplugin.quality.QualityApprovalPendingHelper;

public class QualityCheckTaskHandlingPlugin
extends QualityCheckTaskParentPlugin
implements ClickListener,
ItemClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(QualityCheckTaskHandlingPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"successimg", "errorimg"});
        BasedataEdit reformperson = (BasedataEdit)this.getControl("reformperson");
        reformperson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getPageCache().put("pooltype", (String)formShowParameter.getCustomParam("pooltype"));
        this.getPageCache().put("pooltype-mytask", (String)formShowParameter.getCustomParam("pooltype-mytask"));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        DynamicObjectCollection checks;
        super.itemClick(evt);
        String key = evt.getItemKey();
        String personid = this.getPageCache().get("personid");
        Object objReformperson = this.getModel().getValue("reformperson");
        String reformperson = null;
        if (objReformperson != null) {
            DynamicObject dyReformperson = (DynamicObject)objReformperson;
            reformperson = dyReformperson.getString("id");
        }
        if ((checks = this.getModel().getEntryEntity("entryentitycheck")) == null || checks.size() == 0) {
            return;
        }
        boolean isAllPass = true;
        ArrayList<Long> failPointIds = new ArrayList<Long>();
        if ("checksubmit".equalsIgnoreCase(key)) {
            for (DynamicObject item : checks) {
                boolean isSuccess = item.getBoolean("checksuccess");
                String name = item.getString("point.name");
                if (StringUtils.isBlank((CharSequence)item.getString("checkinfo"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u7ed9\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u8d28\u68c0\u70b9\u586b\u5199\u8d28\u68c0\u8bf4\u660e\u3002", (String)"QualityCheckTaskHandlingPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), name));
                    return;
                }
                if (isSuccess) continue;
                failPointIds.add(item.getLong("point.id"));
                isAllPass = false;
            }
        }
        if (!isAllPass && (StringUtils.isEmpty((CharSequence)reformperson) || "0".equals(reformperson))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6574\u6539\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QualityCheckTaskHandlingPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("save".equals(key)) {
            this.save(checks, personid, reformperson);
        } else if ("checksubmit".equals(key)) {
            this.checkSubmit(isAllPass, checks, personid, reformperson, failPointIds);
        } else if ("bar_pending".equalsIgnoreCase(key)) {
            this.pending();
        } else if ("bar_cancelpause".equalsIgnoreCase(key)) {
            this.cancelPause(personid, reformperson);
        } else if ("bar_nexttask".equalsIgnoreCase(key)) {
            long curId = Long.parseLong(this.getPageCache().get("taskid"));
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)curId, (String)"task_task");
            String poolType = this.getPageCache().get("pooltype");
            String poolTask = this.getPageCache().get("pooltype-mytask");
            TaskApprevalHelper.getNextTask(task, this.getView(), poolType, poolTask, null);
        } else if ("subandnext".equalsIgnoreCase(key)) {
            this.subAndNext(isAllPass, checks, personid, reformperson);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("entryentitycheck");
        int num = this.getModel().getEntryEntity("entryentitycheck").size();
        if ("checksuccess".equalsIgnoreCase(propName)) {
            this.getPageCache().remove("allpass");
            model.beginInit();
            this.setCheckbox(model, index, "checksuccess");
            model.endInit();
            this.getView().updateView("entryentitycheck");
            Integer noPassNum = Integer.parseInt(this.getPageCache().get("nopassnum"));
            if (noPassNum == 0) {
                model.setValue("allpass", (Object)Boolean.TRUE);
            } else {
                if (((Boolean)model.getValue("allpass")).booleanValue()) {
                    this.getPageCache().put("allpass", "");
                }
                model.setValue("allpass", (Object)Boolean.FALSE);
            }
        } else if ("reformperson".equalsIgnoreCase(propName)) {
            DynamicObject reformperson;
            DynamicObject dynamicObject = reformperson = model.getValue("reformperson") == null ? null : (DynamicObject)model.getValue("reformperson");
            if (reformperson != null) {
                this.getPageCache().put("reformperson", reformperson.getString("id"));
            }
        } else if ("allpass".equalsIgnoreCase(propName)) {
            if (num > 1 && !((Boolean)model.getValue("allpass")).booleanValue() && this.getPageCache().get("allpass") != null) {
                return;
            }
            model.beginInit();
            for (int i = 0; i < num; ++i) {
                if (model.getValue("checksuccess", i).equals(model.getValue("allpass"))) continue;
                this.setCheckbox(model, i, "allpass");
            }
            model.endInit();
            this.getView().updateView("entryentitycheck");
            if (Integer.parseInt(this.getPageCache().get("nopassnum")) == 0) {
                model.setValue("allpass", (Object)Boolean.TRUE);
            } else {
                this.getPageCache().remove("allpass");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        e.setCancel(true);
        e.getSourceMethod();
        if (e.getSourceMethod().equals("click")) {
            BasedataEdit edit = (BasedataEdit)e.getSource();
            String key = edit.getKey();
            if ("reformperson".equalsIgnoreCase(key)) {
                this.selectReformPerson();
            }
        } else if ("setItemByNumber".equals(e.getSourceMethod())) {
            DynamicObject reformperson;
            DynamicObject dynamicObject = reformperson = this.getModel().getValue("reformperson") == null ? null : (DynamicObject)this.getModel().getValue("reformperson");
            if (reformperson != null) {
                this.getPageCache().put("reformperson", reformperson.getString("id"));
                this.getModel().setValue("reformperson", (Object)"");
                this.getModel().setValue("reformperson", reformperson.get("id"));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("reformperson".equalsIgnoreCase(actionId)) {
            Object objReformperson;
            IDataModel model = this.getModel();
            Object userID = e.getReturnData();
            if (userID == null && (objReformperson = model.getValue("reformperson")) != null) {
                DynamicObject dyReformperson = (DynamicObject)objReformperson;
                userID = dyReformperson.getPkValue();
            }
            model.setValue("reformperson", userID);
        } else if ("action_quality_pause".equalsIgnoreCase(actionId)) {
            Object returnData = e.getReturnData();
            if (returnData == null) {
                return;
            }
            this.qualityPauseAction((Map)returnData);
        }
    }

    private void selectReformPerson() {
        String taskId = this.getPageCache().get("taskid");
        long taskIdInt = Long.parseLong(taskId);
        List<Long> taskidList = Collections.singletonList(taskIdInt);
        ArrayList<String> tTypeBTypeList = new ArrayList<String>();
        ArrayList<String> orgIDList = new ArrayList<String>();
        ArrayList<String> sscList = new ArrayList<String>();
        QFilter taskIdFilter = new QFilter("id", "in", taskidList);
        ORM orm = ORM.create();
        String selectFields = "id,tasktypeid,billtype,state,orgid,sscid";
        try (DataSet taskDS = orm.queryDataSet(((Object)((Object)this)).getClass().getName() + ".query task", "task_task", "id,tasktypeid,billtype,state,orgid,sscid, autoprocess, sourcetaskid,autoprocessforcheck", new QFilter[]{taskIdFilter});){
            for (Row taskRow : taskDS) {
                Long sourcetaskid = taskRow.getLong("sourcetaskid");
                QFilter filterHistoryTaskId = new QFilter("id", "=", (Object)sourcetaskid);
                DynamicObject taskHistory = orm.queryOne("task_taskhistory", selectFields, new QFilter[]{filterHistoryTaskId});
                String tTypeBType = taskHistory.getString("tasktypeid") + "," + taskHistory.getString("billtype");
                tTypeBTypeList.add(tTypeBType);
                orgIDList.add(taskHistory.getString("orgid"));
                sscList.add(taskHistory.getString("sscid"));
            }
        }
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setCustomParam("operation", null);
        parameEdit.setCustomParam("taskdis", taskidList);
        parameEdit.setCustomParam("taskdisParameters", tTypeBTypeList);
        parameEdit.setCustomParam("orgIDList", orgIDList);
        parameEdit.setCustomParam("sscs", sscList);
        parameEdit.setCustomParam("isexceptrebots", (Object)Boolean.TRUE);
        parameEdit.setCustomParam("isRectification", (Object)Boolean.TRUE);
        parameEdit.setCustomParam("identity", (Object)"sysadmin");
        parameEdit.setFormId("task_userworkload");
        parameEdit.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "reformperson");
        parameEdit.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameEdit);
    }

    private void setCheckbox(IDataModel model, int index, String key) {
        boolean isPass = (Boolean)model.getValue(key);
        if (isPass) {
            model.setValue("checksuccess", (Object)Boolean.TRUE, index);
            model.setValue("checkinfo", (Object)ResManager.loadKDString((String)"\u8d28\u68c0\u5408\u683c", (String)"QualityCheckTaskHandlingPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]), index);
        } else {
            model.setValue("checksuccess", (Object)Boolean.FALSE, index);
            model.setValue("checkinfo", null, index);
        }
        int noPassNum = Integer.parseInt(this.getPageCache().get("nopassnum"));
        int n = noPassNum = isPass ? noPassNum - 1 : noPassNum + 1;
        if (noPassNum > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"allpasslabel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nopasslabel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nopasslabel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"allpasslabel"});
        }
        this.getPageCache().put("nopassnum", noPassNum + "");
    }

    private void save(DynamicObjectCollection checks, String personid, String reformperson) {
        String taskId = this.getPageCache().get("taskid");
        long taskIdInt = Long.parseLong(taskId);
        boolean isSaveSuccess = false;
        try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "save"));){
            try {
                super.saveMessage(checks, false, taskIdInt, "0", TaskStateEnum.CHECKING.getValue());
                super.saveTask(taskIdInt, Long.parseLong(personid), TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.CHECKING.getValue(), personid, reformperson);
                isSaveSuccess = true;
            }
            catch (Throwable e) {
                h.markRollback();
                log.error("\u8d28\u68c0\u4efb\u52a1\u4fdd\u5b58\u51fa\u9519", e);
                isSaveSuccess = false;
            }
        }
        if (isSaveSuccess) {
            this.fireSaveAttachments("qcattachment", taskIdInt, 0L);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"QualityCheckTaskHandlingPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"QualityCheckTaskHandlingPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void cancelPause(String personid, String reformperson) {
        long taskIdInt = Long.parseLong(this.getPageCache().get("taskid"));
        if (!this.isPendingState(taskIdInt)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u6682\u6302\u7684\u8d28\u68c0\u4efb\u52a1\u6267\u884c\u53d6\u6d88\u6682\u6302\u64cd\u4f5c\u3002", (String)"QualityCheckTaskHandlingPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        ArrayList<Long> taskIds = new ArrayList<Long>(8);
        taskIds.add(taskIdInt);
        Map<String, Object> returnData = QualityApprovalPendingHelper.qualityCancelPending(taskIds);
        this.qualityCancelPauseAction(taskIdInt, personid, reformperson, returnData);
    }

    private void subAndNext(boolean isAllPass, DynamicObjectCollection checks, String personid, String reformperson) {
        Throwable throwable;
        TXHandle h;
        long taskId = Long.parseLong(this.getPageCache().get("taskid"));
        long sampraryLibIdInt = Long.parseLong(this.getPageCache().get("sampraryLibId"));
        String poolType = this.getPageCache().get("pooltype");
        String poolTask = this.getPageCache().get("pooltype-mytask");
        boolean isSubmitSuccess = false;
        Object newTaskId = null;
        if (isAllPass) {
            h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "checksubmit"));
            throwable = null;
            try {
                try {
                    super.saveMessage(checks, true, taskId, "0", TaskStateEnum.CHECKING.getValue());
                    super.saveTask(taskId, Long.parseLong(personid), TaskPoolTypeEnum.COMPLETE.getValue(), TaskStateEnum.QUA_CHECK_COMPLETED.getValue(), personid, null);
                    newTaskId = this.saveQualityHistoryTask(taskId);
                    HashMap<String, Object> changeData = new HashMap<String, Object>(3);
                    changeData.put("addnum", 1);
                    if (this.isCompleteQualityCheckLibrary(sampraryLibIdInt)) {
                        changeData.put("checkcompletetime", new Date());
                        changeData.put("state", "4");
                    }
                    this.changeQualitySampleLib(sampraryLibIdInt, changeData);
                    this.getView().returnDataToParent((Object)"hasreviewd");
                    isSubmitSuccess = true;
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u63d0\u4ea4\u51fa\u9519", e);
                    isSubmitSuccess = false;
                }
            }
            catch (Throwable e) {
                throwable = e;
                throw e;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable e) {
                            throwable.addSuppressed(e);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        } else {
            h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "checksubmit"));
            throwable = null;
            try {
                try {
                    super.saveMessage(checks, true, taskId, "0", TaskStateEnum.CHECKING.getValue());
                    super.saveTask(taskId, Long.parseLong(reformperson), TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.RECTIFYING.getValue(), personid, reformperson);
                    if (!this.isExistToDoQualityCheckTask(sampraryLibIdInt)) {
                        HashMap<String, Object> changeData = new HashMap<String, Object>();
                        changeData.put("state", "1");
                        this.changeQualitySampleLib(sampraryLibIdInt, changeData);
                    }
                    this.getView().returnDataToParent((Object)"haschecked");
                    isSubmitSuccess = true;
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u63d0\u4ea4\u51fa\u9519", e);
                    isSubmitSuccess = false;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        if (isSubmitSuccess) {
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"task_task");
            HashMap<String, Object> changeData = new HashMap<String, Object>();
            this.changeQualitySampleLib(sampraryLibIdInt, changeData);
            if (newTaskId != null) {
                taskId = (Long)newTaskId;
            }
            this.fireSaveAttachments("qcattachment", taskId, 0L);
            TaskApprevalHelper.getNextTask(task, this.getView(), poolType, poolTask, null);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5\u3002", (String)"QualityCheckTaskHandlingPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkSubmit(boolean isAllPass, DynamicObjectCollection checks, String personid, String reformperson, List<Long> failPointIds) {
        TXHandle h;
        long taskIdInt = Long.parseLong(this.getPageCache().get("taskid"));
        long sampraryLibIdInt = Long.parseLong(this.getPageCache().get("sampraryLibId"));
        boolean isSubmitSuccess = false;
        Object newTaskId = null;
        if (isAllPass) {
            h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "checksubmit"));
            Throwable throwable = null;
            try {
                try {
                    super.saveMessage(checks, true, taskIdInt, "0", TaskStateEnum.CHECKING.getValue());
                    super.saveTask(taskIdInt, Long.parseLong(personid), TaskPoolTypeEnum.COMPLETE.getValue(), TaskStateEnum.QUA_CHECK_COMPLETED.getValue(), personid, null);
                    newTaskId = this.saveQualityHistoryTask(taskIdInt);
                    HashMap<String, Object> changeData = new HashMap<String, Object>(3);
                    changeData.put("addnum", 1);
                    if (this.isCompleteQualityCheckLibrary(sampraryLibIdInt)) {
                        changeData.put("checkcompletetime", new Date());
                        changeData.put("state", "4");
                    }
                    this.changeQualitySampleLib(sampraryLibIdInt, changeData);
                    this.getView().returnDataToParent((Object)"hasreviewd");
                    isSubmitSuccess = true;
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u63d0\u4ea4\u51fa\u9519", e);
                    isSubmitSuccess = false;
                }
            }
            catch (Throwable e) {
                throwable = e;
                throw e;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable e) {
                            throwable.addSuppressed(e);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        } else {
            h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "checksubmit"));
            Throwable throwable = null;
            try {
                try {
                    super.saveMessage(checks, true, taskIdInt, "0", TaskStateEnum.CHECKING.getValue());
                    super.saveTask(taskIdInt, Long.parseLong(reformperson), TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.RECTIFYING.getValue(), personid, reformperson);
                    if (!this.isExistToDoQualityCheckTask(sampraryLibIdInt)) {
                        HashMap<String, Object> changeData = new HashMap<String, Object>();
                        changeData.put("state", "1");
                        this.changeQualitySampleLib(sampraryLibIdInt, changeData);
                    }
                    this.getView().returnDataToParent((Object)"haschecked");
                    isSubmitSuccess = true;
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u63d0\u4ea4\u51fa\u9519", e);
                    isSubmitSuccess = false;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        if (isSubmitSuccess) {
            HashMap<String, Object> changeData = new HashMap<String, Object>();
            this.changeQualitySampleLib(sampraryLibIdInt, changeData);
            if (newTaskId != null) {
                taskIdInt = (Long)newTaskId;
            }
            this.fireSaveAttachments("qcattachment", taskIdInt, 0L);
            this.getView().close();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5\u3002", (String)"QualityCheckTaskHandlingPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void pending() {
        long taskIdInt = Long.parseLong(this.getPageCache().get("taskid"));
        if (this.isPendingState(taskIdInt)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d28\u68c0\u4efb\u52a1\u5df2\u5904\u4e8e\u6682\u6302\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"QualityCheckTaskHandlingPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            return;
        }
        super.openQualityPendingDialog(taskIdInt);
    }

    private void qualityPauseAction(Map<String, Object> returnData) {
        IDataModel model = this.getModel();
        Map<String, Object> dataMap = returnData;
        Integer totalSuccessCount = (Integer)dataMap.get("totalSuccessCount");
        String errorMsg = (String)dataMap.get("errorMsg");
        if (totalSuccessCount == 1) {
            String personid = this.getPageCache().get("personid");
            String taskId = this.getPageCache().get("taskid");
            long taskIdInt = Long.parseLong(taskId);
            DynamicObjectCollection checks = this.getModel().getEntryEntity("entryentitycheck");
            Object objReformperson = this.getModel().getValue("reformperson");
            String reformperson = null;
            if (objReformperson != null) {
                DynamicObject dyReformperson = (DynamicObject)objReformperson;
                reformperson = dyReformperson.getString("id");
            }
            boolean isSaveSuccess = false;
            try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "bar_pending"));){
                try {
                    super.saveMessage(checks, false, taskIdInt, "0", TaskStateEnum.CHECKING.getValue());
                    super.saveTask(taskIdInt, Long.parseLong(personid), TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.PAUSE_CHECKING.getValue(), personid, reformperson);
                    isSaveSuccess = true;
                }
                catch (Throwable ex) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u6682\u6302\u540e\u8fdb\u884c\u4fdd\u5b58\u9519\u8bef", ex);
                    isSaveSuccess = false;
                }
            }
            if (isSaveSuccess) {
                this.fireSaveAttachments("qcattachment", taskIdInt, 0L);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6682\u6302\u6210\u529f\u3002", (String)"QualityCheckTaskHandlingPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.setPageControlState(false, TaskStateEnum.CHECKING.getValue());
            this.getModel().setValue("qcpend", (Object)1);
        } else {
            this.getView().showErrorNotification(errorMsg);
            model.setValue("qcpend", (Object)0);
        }
    }

    private void qualityCancelPauseAction(long taskIdInt, String personid, String reformperson, Map<String, Object> returnData) {
        IDataModel model = this.getModel();
        Map<String, Object> dataMap = returnData;
        Integer totalSuccessCount = (Integer)dataMap.get("totalSuccessCount");
        String errorMsg = (String)dataMap.get("errorMsg");
        if (totalSuccessCount == 1) {
            try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "bar_cancelpause"));){
                try {
                    super.saveTask(taskIdInt, Long.parseLong(personid), TaskPoolTypeEnum.PROCESSING.getValue(), TaskStateEnum.CHECKING.getValue(), personid, reformperson);
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("\u8d28\u68c0\u4efb\u52a1\u53d6\u6d88\u6682\u6302\u540e\u8fdb\u884c\u4fdd\u5b58\u9519\u8bef", e);
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6682\u6302\u6210\u529f\u3002", (String)"QualityCheckTaskHandlingPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.setPageControlState(true, TaskStateEnum.CHECKING.getValue());
            model.setValue("qcpend", (Object)0);
        } else {
            this.getView().showErrorNotification(errorMsg);
            model.setValue("qcpend", (Object)1);
        }
    }
}

