/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.ssc.task.common.LogBuildUtil;

public class WithdrawalDealDynamicPlugin
extends AbstractListPlugin
implements ClickListener {
    private static final Log log = LogFactory.getLog(WithdrawalDealDynamicPlugin.class);
    private FormShowParameter paramter;

    public void initialize() {
        super.initialize();
        this.paramter = this.getView().getFormShowParameter();
        Button btn = (Button)this.getView().getControl("btncancel");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObjectCollection effectiveBizBills = this.getTaskTypeData("1");
        if (effectiveBizBills != null && effectiveBizBills.size() > 0) {
            int pos = 0;
            model.batchCreateNewEntryRow("entryentity", effectiveBizBills.size());
            for (DynamicObject bizBill : effectiveBizBills) {
                model.setValue("billtypeid", bizBill.get("billtypeid"), pos);
                model.setValue("billtypename", bizBill.get("billtypename"), pos);
                model.setValue("effective", bizBill.get("effective"), pos);
                model.setValue("tasktypeid", bizBill.get("tasktypeid"), pos);
                model.setValue("tasktype", bizBill.get("tasktype"), pos);
                ++pos;
            }
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        if ("includeonway".equals(propName)) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            if (((Boolean)propValue).booleanValue()) {
                DynamicObjectCollection onWayBizBills = this.getTaskTypeData("2");
                if (onWayBizBills == null) {
                    return;
                }
                for (DynamicObject bizBill : onWayBizBills) {
                    DynamicObject addNew = entryEntity.addNew();
                    addNew.set("billtypeid", bizBill.get("billtypeid"));
                    addNew.set("billtypename", bizBill.get("billtypename"));
                    addNew.set("effective", bizBill.get("effective"));
                    addNew.set("tasktypeid", bizBill.get("tasktypeid"));
                    addNew.set("tasktype", bizBill.get("tasktype"));
                }
            } else {
                entryEntity.removeIf(en -> "2".equals(en.getString("effective")));
            }
            model.getDataEntity(true).set("entryentity", (Object)entryEntity);
            this.getView().updateView("entryentity");
        }
    }

    private String getSscIdFromParam() {
        return (String)this.paramter.getCustomParams().get("sscid");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            MultiLangEnumBridge opDes;
            boolean deal = this.dealBusUnpassReaList();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5206\u914d", "WithdrawalDealDynamicPlugin_1", "ssc-task-formplugin");
            if (deal) {
                this.getView().returnDataToParent((Object)"assignok");
                this.getView().close();
                opDes = new MultiLangEnumBridge("\u5206\u914d\u4efb\u52a1\u6210\u529f\u3002", "WithdrawalDealDynamicPlugin_3", "ssc-task-formplugin");
            } else {
                opDes = new MultiLangEnumBridge("\u5206\u914d\u4efb\u52a1\u5931\u8d25\u3002", "WithdrawalDealDynamicPlugin_4", "ssc-task-formplugin");
            }
            this.writeLog("assignTask", opName, opDes);
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u53d6\u6d88", "WithdrawalDealDynamicPlugin_2", "ssc-task-formplugin");
            MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u53d6\u6d88\u6210\u529f\u3002", "WithdrawalDealDynamicPlugin_9", "ssc-task-formplugin");
            this.writeLog("cancel", opName, opDes);
        }
    }

    private void writeLog(String operateKey, MultiLangEnumBridge opName, MultiLangEnumBridge opDes) {
        long userId = RequestContext.get().getCurrUserId();
        Long mainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
        OpLogAppInfo opLogAppInfo = LogBuildUtil.buildLogInfo(this.getView(), mainOrgId, "task_withdrawal_deal", operateKey, opName, opDes, new String[0]);
        LogServiceHelper.addLog((AppLogInfo)opLogAppInfo);
    }

    protected AppLogInfo buildLogInfo(String msg, Long orgId, String entityId, String operateName) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(this.getView().getFormShowParameter().getAppId());
        logInfo.setBizObjID(entityId);
        logInfo.setOrgID(orgId);
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(operateName);
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    private boolean dealBusUnpassReaList() {
        List<Map<String, Object>> list = this.getCurrentSelector();
        if (list == null || list.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"WithdrawalDealDynamicPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        List ids = (List)this.paramter.getCustomParam("busUnpassReaList");
        return this.saveData(list, ids);
    }

    private boolean saveData(List<Map<String, Object>> list, List<Long> ids) {
        String sscid = this.getPageCache().get("sscid");
        ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> m = list.get(i);
            for (int j = 0; j < ids.size(); ++j) {
                Long withdrawalid = ids.get(j);
                if (this.checkIsExist(m, withdrawalid, sscid)) continue;
                DynamicObject taskWithdrawalDeal = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_withdrawal_re"));
                taskWithdrawalDeal.set("billtypeid", (Object)Long.valueOf((String)m.get("billtypeid")));
                taskWithdrawalDeal.set("tasktypeid", (Object)Long.valueOf((String)m.get("tasktypeid")));
                taskWithdrawalDeal.set("useorg", (Object)Long.valueOf(sscid));
                taskWithdrawalDeal.set("createorg", (Object)Long.valueOf(sscid));
                taskWithdrawalDeal.set("withdrawalid", (Object)withdrawalid);
                taskWithdrawalDeal.set("status", (Object)"A");
                taskWithdrawalDeal.set("enable", (Object)"1");
                taskWithdrawalDeal.set("createtime", (Object)new Date());
                taskWithdrawalDeal.set("number", (Object)(withdrawalid + ""));
                taskWithdrawalDeal.set("name", (Object)(withdrawalid + ""));
                saveDataList.add(taskWithdrawalDeal);
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveDataList.toArray(new DynamicObject[0]));
        return true;
    }

    private boolean checkIsExist(Map<String, Object> m, Long withdrawalid, String sscid) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("billtypeid", "=", (Object)Long.valueOf(m.get("billtypeid").toString())));
        filterList.add(new QFilter("tasktypeid", "=", (Object)Long.valueOf(m.get("tasktypeid").toString())));
        filterList.add(new QFilter("withdrawalid", "=", (Object)withdrawalid));
        filterList.add(new QFilter("useorg", "=", (Object)Long.valueOf(sscid)));
        boolean isExists = QueryServiceHelper.exists((String)"task_withdrawal_re", (QFilter[])filterList.toArray(new QFilter[0]));
        return isExists;
    }

    private List<Map<String, Object>> getCurrentSelector() {
        ArrayList<Map<String, Object>> returnData = new ArrayList<Map<String, Object>>(16);
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        int[] selectedRows = grid.getEntryState().getSelectedRows();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (int rows : selectedRows) {
            HashMap<String, String> ret = new HashMap<String, String>(2);
            DynamicObject dyo = (DynamicObject)entryentity.get(rows);
            ret.put("tasktypeid", dyo.getString("tasktypeid"));
            ret.put("billtypeid", dyo.getString("billtypeid"));
            returnData.add(ret);
        }
        return returnData;
    }

    private DynamicObjectCollection getTaskTypeData(String effectiveStatus) {
        String sscId = this.getPageCache().get("sscid");
        if (sscId == null) {
            sscId = this.getSscIdFromParam();
            this.getPageCache().put("sscid", sscId);
        }
        if (StringUtils.isNotBlank((CharSequence)sscId)) {
            String selectFields = "id billtypeid,name billtypename,effective,entryentity.tasktype.id tasktypeid,entryentity.tasktype.name tasktype";
            QFilter qFilterOnWay = new QFilter("effective", "=", (Object)effectiveStatus);
            QFilter qFilterSsc = new QFilter("ssccenter", "=", (Object)Long.valueOf(sscId));
            return QueryServiceHelper.query((String)"task_taskbill", (String)selectFields, (QFilter[])new QFilter[]{qFilterOnWay, qFilterSsc});
        }
        return null;
    }
}

