/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.UnAudit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.enums.achieve.ScoreComputeTypeEnum;
import kd.ssc.task.formplugin.util.AchieveUtil;

public class AchieveSchemeFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Set<String> singleSelect = new HashSet<String>(8);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String tag : singleSelect) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(tag);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit userids = (BasedataEdit)this.getControl("userids");
        userids.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit poachieveId = (BasedataEdit)this.getControl("poachieveid");
        poachieveId.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        view.setVisible(Boolean.FALSE, new String[]{"userids"});
        view.setVisible(Boolean.FALSE, new String[]{"roleids"});
        String value = (String)model.getValue("assessobject");
        this.hideField(view, value);
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection entryentity_po;
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean entryCanModify = true;
        if (OperationStatus.EDIT.equals((Object)status) || OperationStatus.ADDNEW.equals((Object)status)) {
            QFilter filter;
            DynamicObject obj;
            String value = (String)model.getValue("assessobject");
            this.hideField(view, value);
            if ("0".equals(this.getModel().getValue("enable"))) {
                view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
                entryCanModify = false;
            }
            if ("C".equals(this.getModel().getValue("status"))) {
                this.setHideOrShow(Boolean.FALSE);
                view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
                view.setEnable(Boolean.FALSE, new String[]{"bar_submit"});
                entryCanModify = false;
            }
            if ((obj = QueryServiceHelper.queryOne((String)"ssc_achieveevalute", (String)"id", (QFilter[])new QFilter[]{filter = new QFilter("assessplanid", "=", this.getModel().getDataEntity().getPkValue())})) != null) {
                this.setHideOrShow(Boolean.FALSE);
                view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
                view.setEnable(Boolean.FALSE, new String[]{"bar_submit"});
                entryCanModify = false;
            }
        }
        if (OperationStatus.EDIT.equals((Object)status)) {
            entryCanModify = this.checkPermissionAndSetStyle();
        }
        if ((entryentity_po = this.getModel().getEntryEntity("entryentity_po")) != null && entryentity_po.size() > 0) {
            for (int i = 0; i < entryentity_po.size(); ++i) {
                DynamicObject achieveTarget;
                DynamicObject entry = (DynamicObject)entryentity_po.get(i);
                if (entry == null || (achieveTarget = entry.getDynamicObject("poachieveid")) == null) continue;
                DynamicObject group = achieveTarget.getDynamicObject("group");
                if (group != null) {
                    this.getModel().setValue("potargetclassify", (Object)group, i);
                }
                if (!entryCanModify) continue;
                this.setEntryStyle(achieveTarget, i);
            }
            model.setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String propertyName = e.getProperty().getName();
        DynamicObject newTarget = null;
        int index = 0;
        switch (propertyName) {
            case "assessobject": {
                String newValue = (String)e.getChangeSet()[0].getNewValue();
                this.hideField(view, newValue);
                break;
            }
            case "poachieveid": {
                newTarget = (DynamicObject)e.getChangeSet()[0].getNewValue();
                index = e.getChangeSet()[0].getRowIndex();
                if (newTarget == null) {
                    return;
                }
                DynamicObject dynamicObject = newTarget.getDynamicObject("unitid");
                String targetType = newTarget.getString("targettype");
                model.setValue("potargettype", (Object)targetType, index);
                model.setValue("pounitid", (Object)dynamicObject, index);
                DynamicObject classify = newTarget.getDynamicObject("group");
                model.setValue("potargetclassify", (Object)classify, index);
                this.clearOldEntryStyle(index);
                this.setEntryStyle(newTarget, index);
                break;
            }
        }
    }

    private void clearOldEntryStyle(int index) {
        this.getView().setEnable(Boolean.TRUE, index, new String[]{"pounitid", "postandard", "potarget"});
        this.getModel().setValue("potarget", null, index);
    }

    private void setEntryStyle(DynamicObject achieveTarget, int index) {
        String targetType = achieveTarget.getString("targettype");
        String scoringmethod = achieveTarget.getString("scoringmethod");
        if (ScoreComputeTypeEnum.RATIO.getValue().equals(scoringmethod)) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"postandard"});
        } else if (ScoreComputeTypeEnum.DIRECT.getValue().equals(scoringmethod)) {
            this.getModel().setValue("potarget", (Object)new BigDecimal(100), index);
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"postandard", "potarget"});
            if ("1".equals(targetType)) {
                this.getModel().setValue("pounitid", null, index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"pounitid"});
            }
        }
        if ("0".equals(targetType)) {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{"pounitid"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        QFilter filter;
        DynamicObject obj;
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        String value = (String)model.getValue("assessobject");
        Object source = args.getSource();
        if (source instanceof Save && "save".equals(((Save)source).getOperateKey()) || source instanceof Submit && "submit".equals(((Submit)source).getOperateKey())) {
            boolean result = this.validate(model);
            if (!result) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ee9\u6548\u53c2\u6570\u4e2d\u6240\u6709\u6307\u6807\u6743\u91cd\u4e4b\u548c\u5e94\u4e3a100%\u3002", (String)"AchieveSchemeFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String assessName = "";
            switch (value) {
                case "1": {
                    assessName = this.setAssessName(model, "groupids", args);
                    break;
                }
                case "2": {
                    assessName = this.setAssessName(model, "userids", args);
                    break;
                }
                default: {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8003\u6838\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"AchieveSchemeFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            model.setValue("assessname", (Object)assessName);
            DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity_po");
            for (int i = 0; i < entry.size(); ++i) {
                for (int j = 0; j < entry.size() - 1; ++j) {
                    try {
                        Long pkValue1 = (Long)((DynamicObject)entry.get(j)).getDynamicObject("poachieveid").getDynamicObject("group").getPkValue();
                        Long pkValue2 = (Long)((DynamicObject)entry.get(j + 1)).getDynamicObject("poachieveid").getDynamicObject("group").getPkValue();
                        if (pkValue1.compareTo(pkValue2) <= 0) continue;
                        this.getModel().moveEntryRowDown("entryentity_po", j);
                        continue;
                    }
                    catch (Exception e) {
                        boolean jPAchieveIsNull;
                        boolean jPIsNull;
                        boolean jIsNull = entry.get(j) == null;
                        boolean bl = jPIsNull = entry.get(j + 1) == null;
                        if (jIsNull || jPIsNull) continue;
                        boolean jAchieveIsNull = ((DynamicObject)entry.get(j)).getDynamicObject("poachieveid") == null;
                        boolean bl2 = jPAchieveIsNull = ((DynamicObject)entry.get(j + 1)).getDynamicObject("poachieveid") == null;
                        if (!jAchieveIsNull && jPAchieveIsNull) continue;
                    }
                }
            }
            this.getView().updateView("entryentity_po");
        } else if (source instanceof UnAudit && "unaudit".equals(((UnAudit)source).getOperateKey()) && (obj = QueryServiceHelper.queryOne((String)"ssc_achieveevalute", (String)"id", (QFilter[])new QFilter[]{filter = new QFilter("assessplanid", "=", this.getModel().getDataEntity().getPkValue())})) != null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u7ee9\u6548\u62a5\u544a\u7684\u65b9\u6848\u4e0d\u80fd\u64a4\u9500\u3002", (String)"AchieveSchemeFormPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        IFormView view = this.getView();
        String source = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        switch (source) {
            case "submit": {
                if (operationResult.isSuccess()) {
                    view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
                    view.setEnable(Boolean.FALSE, new String[]{"bar_submit"});
                    this.setHideOrShow(Boolean.FALSE);
                }
                this.setEntryStyleAfterDoOperation();
                break;
            }
            case "save": 
            case "unaudit": {
                if (!operationResult.isSuccess()) break;
                view.setVisible(Boolean.TRUE, new String[]{"bar_save"});
                view.setEnable(Boolean.TRUE, new String[]{"bar_submit"});
                this.setHideOrShow(Boolean.TRUE);
                this.setEntryStyleAfterDoOperation();
                break;
            }
        }
    }

    private void setEntryStyleAfterDoOperation() {
        DynamicObjectCollection entryentity_po = this.getModel().getEntryEntity("entryentity_po");
        if (entryentity_po != null && entryentity_po.size() > 0) {
            for (int i = 0; i < entryentity_po.size(); ++i) {
                DynamicObject achieveTarget;
                DynamicObject entry = (DynamicObject)entryentity_po.get(i);
                if (entry == null || (achieveTarget = entry.getDynamicObject("poachieveid")) == null) continue;
                this.setEntryStyle(achieveTarget, i);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        long sscid = ((DynamicObject)this.getModel().getValue("sscid")).getLong("id");
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        if (singleSelect.contains(name)) {
            showParam.setMultiSelect(false);
        }
        List treeQFilters = showParam.getTreeFilterParameter().getQFilters();
        List listFilters = showParam.getListFilterParameter().getQFilters();
        QFilter listFilter = null;
        switch (name) {
            case "poachieveid": {
                IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
                QFilter useOrgFilter = baseDataService.getBaseDataFilter("ssc_achieveclassify", Long.valueOf(sscid));
                QFilter groupFilter = null;
                QFilter achieveUseOrgFilter = baseDataService.getBaseDataFilter("ssc_achievetarget", Long.valueOf(sscid));
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"ssc_achievetarget", (String)"group", (QFilter[])new QFilter[]{enableFilter, achieveUseOrgFilter});
                if (collection != null && collection.size() > 0) {
                    Set group = collection.stream().map(dynamicObject -> dynamicObject.getLong("group")).collect(Collectors.toSet());
                    groupFilter = new QFilter("id", "in", group);
                }
                if (groupFilter != null) {
                    useOrgFilter.or(groupFilter);
                }
                treeQFilters.add(useOrgFilter);
                DynamicObjectCollection entryentity_po = this.getModel().getEntryEntity("entryentity_po");
                if (entryentity_po != null && entryentity_po.size() > 0) {
                    ArrayList<Long> selectedAchieveId = new ArrayList<Long>(entryentity_po.size());
                    for (int i = 0; i < entryentity_po.size(); ++i) {
                        DynamicObject entry = (DynamicObject)entryentity_po.get(i);
                        DynamicObject achieve = entry.getDynamicObject("poachieveid");
                        if (achieve == null) continue;
                        long achieveId = entry.getDynamicObject("poachieveid").getLong("id");
                        selectedAchieveId.add(achieveId);
                    }
                    if (selectedAchieveId.size() > 0) {
                        listFilters.add(new QFilter("id", "not in", selectedAchieveId));
                    }
                }
                listFilters.add(new QFilter("targettype", "in", Arrays.asList("0", "1")));
                break;
            }
            case "userids": {
                showParam.setF7Style(3);
                ArrayList<Long> userIds = new ArrayList<Long>(16);
                List<Long> groups = AchieveUtil.getGroups(sscid);
                for (Long gid : groups) {
                    List<Long> users = AchieveUtil.getUsers(sscid, gid);
                    userIds.addAll(users);
                }
                listFilter = new QFilter("id", "in", userIds);
                listFilters.add(listFilter);
                break;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Set<Long> achieveTargetIds = this.getAchieveTargetIds(model);
        if (CollectionUtils.isEmpty(achieveTargetIds)) {
            return;
        }
        this.setEntryAchieveTarget(model, achieveTargetIds);
    }

    private void setEntryAchieveTarget(IDataModel model, Set<Long> achieveTargetIds) {
        QFilter qFilter = new QFilter("id", "in", achieveTargetIds);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"ssc_achievetarget", (QFilter[])qFilter.toArray());
        DynamicObjectCollection entityPO = model.getEntryEntity("entryentity_po");
        for (int i = 0; i < entityPO.size(); ++i) {
            long id;
            DynamicObject object;
            DynamicObject achieveTarget;
            DynamicObject dynamicObject = (DynamicObject)entityPO.get(i);
            if (Objects.isNull(dynamicObject) || Objects.isNull(achieveTarget = dynamicObject.getDynamicObject("poachieveid")) || !Objects.isNull(object = (DynamicObject)dynamicObjectMap.get(id = achieveTarget.getLong("id"))) && !"0".equals(object.getString("enable"))) continue;
            model.setValue("poachieveid", null, i);
            model.setValue("potargettype", null, i);
            model.setValue("pounitid", null, i);
            model.setValue("potargetclassify", null, i);
        }
    }

    private Set<Long> getAchieveTargetIds(IDataModel model) {
        HashSet<Long> achievetargetIds = new HashSet<Long>(8);
        DynamicObjectCollection entityPO = model.getEntryEntity("entryentity_po");
        for (DynamicObject dy : entityPO) {
            DynamicObject dynamicObject = dy.getDynamicObject("poachieveid");
            if (Objects.isNull(dynamicObject)) continue;
            achievetargetIds.add(dynamicObject.getLong("id"));
        }
        return achievetargetIds;
    }

    private void hideField(IFormView view, String value) {
        switch (value) {
            case "1": {
                view.setVisible(Boolean.TRUE, new String[]{"groupids"});
                view.setVisible(Boolean.FALSE, new String[]{"userids"});
                view.setVisible(Boolean.FALSE, new String[]{"roleids"});
                break;
            }
            case "2": {
                view.setVisible(Boolean.FALSE, new String[]{"groupids"});
                view.setVisible(Boolean.TRUE, new String[]{"userids"});
                view.setVisible(Boolean.FALSE, new String[]{"roleids"});
                break;
            }
            case "3": {
                view.setVisible(Boolean.FALSE, new String[]{"groupids"});
                view.setVisible(Boolean.FALSE, new String[]{"userids"});
                view.setVisible(Boolean.TRUE, new String[]{"roleids"});
                break;
            }
        }
    }

    private String setAssessName(IDataModel model, String target, BeforeDoOperationEventArgs args) {
        StringBuilder sb = new StringBuilder();
        Set<Object> names = new HashSet(16);
        DynamicObjectCollection objects = (DynamicObjectCollection)model.getValue(target);
        if (objects != null && !objects.isEmpty()) {
            names = objects.stream().map(r -> r.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toSet());
            for (String string : names) {
                sb.append(string).append(';');
            }
        } else {
            String value;
            switch (value = (String)model.getValue("assessobject")) {
                case "1": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AchieveSchemeFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5458\u5de5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AchieveSchemeFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "3": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AchieveSchemeFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
            args.setCancel(true);
        }
        return sb.toString();
    }

    private boolean validate(IDataModel model) {
        int percentage = this.countPercent(model, "entryentity_po", "poweight");
        return percentage == 100;
    }

    private int countPercent(IDataModel model, String entryEntityTag, String weightTag) {
        int percent = 0;
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryEntityTag);
        if (entryEntity != null && !entryEntity.isEmpty()) {
            for (DynamicObject entity : entryEntity) {
                percent += entity.getInt(weightTag);
            }
        }
        return percent;
    }

    public void setHideOrShow(Boolean b) {
        IFormView view = this.getView();
        view.setVisible(b, new String[]{"advcontoolbarap"});
    }

    private boolean checkPermissionAndSetStyle() {
        Long sscId;
        int hasPermission;
        String appId = this.getView().getFormShowParameter().getAppId();
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue("sscid");
        if (createOrg != null && (hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)(sscId = Long.valueOf(createOrg.getLong("id"))), (String)"12", (String)appId, (String)"ssc_achievescheme", (String)"0AQ3YJ2LET+U")) != 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "number", "sscid", "assessperiod", "assessobject", "userids", "description", "po_add", "po_del", "po_up", "po_down"});
            int rowCount = this.getModel().getEntryRowCount("entryentity_po");
            if (rowCount > 0) {
                for (int i = 0; i < rowCount; ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"poachieveid", "potargettype", "pounitid", "postandard", "potarget", "poweight", "podescription"});
                }
            }
            return false;
        }
        return true;
    }

    static {
        singleSelect.addAll(Arrays.asList("poachieveid", "pounitid"));
    }
}

