/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.formplugin.util.AchieveUtil;
import kd.ssc.task.util.SscLicenseUtil;

public class AchieveSchemeListPlugin
extends AbstractListPlugin {
    private static Set<String> operations = new HashSet<String>(5);
    private static final String BTN_CREATEACHIEVERPT = "createachieverpt";
    private static final String BTN_QUERYACHIEVERPT = "queryachieverpt";

    public void preOpenForm(PreOpenFormEventArgs e) {
        SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)"ssc_achievescheme");
    }

    public void initialize() {
        super.initialize();
    }

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IFormView formView = this.getView();
        if (BTN_CREATEACHIEVERPT.equals(operateKey) && operationResult.isSuccess()) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            ListSelectedRowCollection selectedRows = ((IListView)formView).getSelectedRows();
            if (selectedRows.size() > 1) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u64cd\u4f5c\u3002", (String)"AchieveSchemeListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            if (!selectedRow.getBillStatus().equals("C")) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u5df2\u5ba1\u6838\u7684\u6570\u636e\u64cd\u4f5c\u3002", (String)"AchieveSchemeListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            Long pkId = Long.valueOf(selectedRow.getPrimaryKeyValue().toString());
            QFilter filter = new QFilter("id", "=", (Object)pkId);
            filter.and("enable", "=", (Object)"1");
            if (!QueryServiceHelper.exists((String)"ssc_achievescheme", (QFilter[])new QFilter[]{filter})) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u53ef\u7528\u7684\u6570\u636e\u64cd\u4f5c\u3002", (String)"AchieveSchemeListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            map.put("schemeId", pkId);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_CREATEACHIEVERPT);
            this.showForm("ssc_assessperiod", closeCallBack, ShowType.Modal, map);
        } else if (BTN_QUERYACHIEVERPT.equals(operateKey) && operationResult.isSuccess()) {
            List<Long> selectIds = AchieveUtil.getSelectedRowIds((IListView)formView);
            QFilter filter = new QFilter("id", "in", selectIds);
            filter.and("enable", "=", (Object)"1");
            filter.and("status", "!=", (Object)"A");
            DynamicObjectCollection ids = QueryServiceHelper.query((String)"ssc_achievescheme", (String)"id", (QFilter[])new QFilter[]{filter}, null, (int)selectIds.size());
            if (ids.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u4e2d\u4e00\u6761\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u6570\u636e\u3002", (String)"AchieveSchemeListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Long> chooseIds = ids.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_QUERYACHIEVERPT);
            this.showForm("ssc_achieveevalute", closeCallBack, ShowType.MainNewTabPage, chooseIds);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        List<Long> selectIds;
        String itemKey = evt.getItemKey();
        if (operations.contains(itemKey)) {
            if (!AchieveUtil.codeRule("ssc_achievescheme")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6216\u5df2\u7981\u7528\u7ee9\u6548\u8003\u6838\u65b9\u6848\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (String)"AchieveSchemeListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        } else if ("tbldel".equals(itemKey) && (selectIds = AchieveUtil.getSelectedRowIds((IListView)this.getView())).size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u64cd\u4f5c\u3002", (String)"AchieveSchemeListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        IFormView view = this.getView();
        if (BTN_CREATEACHIEVERPT.equalsIgnoreCase(evt.getActionId()) && evt.getReturnData() != null) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u751f\u6210\u6210\u529f\u3002", (String)"AchieveSchemeListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs event) {
        super.filterContainerInit(event);
        List comFilters = event.getCommonFilterColumns();
        for (FilterColumn column : comFilters) {
            CommonFilterColumn comFilter = (CommonFilterColumn)column;
            if (!comFilter.getFieldName().equals("sscid.name")) continue;
            List defaultValues = comFilter.getDefaultValues();
            String userId = RequestContext.get().getUserId();
            List<ComboItem> allPermSSC = AchieveUtil.getAllPermSSC(Long.parseLong(userId), "ssc_achievescheme");
            if (allPermSSC == null || allPermSSC.isEmpty()) {
                if (defaultValues == null || defaultValues.isEmpty()) {
                    comFilter.setDefaultValue("0");
                }
            } else if (defaultValues == null || defaultValues.isEmpty()) {
                comFilter.setDefaultValue(allPermSSC.get(0).getValue());
            }
            comFilter.setComboItems(allPermSSC);
        }
    }

    private void showForm(String formId, CloseCallBack closeCallBack, ShowType showType, Map params) {
        params.put("formId", formId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter((Map)params);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.setCustomParams(params);
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(showParameter);
    }

    private void showForm(String formId, CloseCallBack closeCallBack, ShowType showType, List<Long> schemeIds) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(formId);
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(showType);
        listShowParameter.setLookUp(false);
        if (closeCallBack != null) {
            listShowParameter.setCloseCallBack(closeCallBack);
        }
        IListView listView = (IListView)this.getView();
        List sscIds = listView.getSelectedMainOrgIds();
        Long sscId = (Long)sscIds.get(0);
        listShowParameter.setCustomParam("sscid", (Object)sscId);
        listShowParameter.setCustomParam("source", (Object)"scheme");
        QFilter filter = new QFilter("assessplanid", "in", schemeIds);
        listShowParameter.getListFilterParameter().setFilter(filter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    static {
        operations.addAll(Arrays.asList("tblnew", "tblcopy", BTN_CREATEACHIEVERPT, BTN_QUERYACHIEVERPT, "tblrefresh"));
    }
}

