/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.boardv2;

import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.IFrameMessage;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.task.business.boardv2.facade.BoardDataHelper;
import kd.ssc.task.business.boardv2.pojo.BoardResult;
import kd.ssc.task.util.UUIDUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class FSOMBoardPlugin
extends AbstractFormPlugin {
    private static final String IFRAMEAP = "iframeap";
    private static final String URL = "kingdee/fi/ssc/som_index/default.html#/overall/";
    private static final Log log = LogFactory.getLog(FSOMBoardPlugin.class);
    private static final String PAGE_CACHE_CHECKED_ORG = "page_cache_checked_org";

    public void preOpenForm(PreOpenFormEventArgs e) {
        HasPermOrgResult allPermOrgs;
        FormShowParameter showParameter = e.getFormShowParameter().getShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.NewBrowserPage);
        showParameter.setPageId(UUIDUtil.generateUuid());
        String formId = showParameter.getFormId();
        long currUserId = RequestContext.get().getCurrUserId();
        String appId = e.getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "som";
        }
        if (!(allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)currUserId, (String)"12", (String)appId, (String)formId, (String)"47150e89000000ac")).hasAllOrgPerm() && !PermissionServiceHelper.isSuperUser((long)currUserId)) {
            QFilter[] filters;
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            if (hasPermOrgs != null && !hasPermOrgs.isEmpty() && QueryServiceHelper.exists((String)"bos_org", (QFilter[])(filters = new QFilter[]{new QFilter("fisscc", "=", (Object)Character.valueOf('1')), new QFilter("id", "in", (Object)hasPermOrgs)}))) {
                return;
            }
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u60a8\u62e5\u6709\u7ec4\u7ec7\u7684\u804c\u80fd\u7c7b\u578b\u4e0e\u5f53\u524d\u83dc\u5355\uff08\u5171\u4eab\u4e2d\u5fc3\uff09\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u6253\u5f00\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FSOMBoardPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFrame iframe = (IFrame)this.getControl(IFRAMEAP);
        String boardUrl = TaskParamHelper.getTaskParamByName((String)"board_url");
        boardUrl = StringUtils.isBlank((CharSequence)boardUrl) ? URL : boardUrl;
        boardUrl = boardUrl + this.getUrlSuffix();
        iframe.setSrc(boardUrl);
    }

    public void customEvent(CustomEventArgs e) {
        if (StringUtils.isEmpty((CharSequence)e.getEventArgs())) {
            log.warn("customEvent() end. error: getEventArgs() is empty");
            return;
        }
        Map argMap = (Map)SerializationUtils.fromJsonString((String)e.getEventArgs(), LinkedHashMap.class);
        log.info("customEvent argMap : " + argMap.toString());
        Object content = argMap.get("content");
        if (content == null) {
            log.error("customEvent() end. error: content is null");
            return;
        }
        Map contentMap = (Map)content;
        String msgType = (String)contentMap.get("msgType");
        if (StringUtils.isEmpty((CharSequence)msgType)) {
            log.error("customEvent() end. error: mgsType is empty");
            return;
        }
        String board = (String)contentMap.get("board");
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("init".equalsIgnoreCase(msgType)) {
            String org = this.getPageCache().get(PAGE_CACHE_CHECKED_ORG);
            BoardResult defaultBoard = new BoardDataHelper(appId).getDefaultBoard(StringUtils.isNotBlank((CharSequence)org) ? Long.parseLong(org) : 0L, StringUtils.isNotBlank((CharSequence)org), board);
            this.postMessage((Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)defaultBoard), LinkedHashMap.class), msgType);
        } else if ("loadData".equalsIgnoreCase(msgType)) {
            long org = NumberUtils.toLong((String)(contentMap.get("org") + ""), (long)0L);
            if (org == 0L || StringUtils.isBlank((CharSequence)board)) {
                return;
            }
            this.getPageCache().put(PAGE_CACHE_CHECKED_ORG, String.valueOf(org));
            BoardResult defaultBoard = new BoardDataHelper(appId).getDefaultBoard(org, false, board);
            this.postMessage((Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)defaultBoard), LinkedHashMap.class), msgType);
        }
    }

    private void postMessage(Map<String, Object> result, String msgType) {
        IFrame iframe = (IFrame)this.getControl(IFRAMEAP);
        IFrameMessage message = new IFrameMessage();
        message.setType(msgType);
        message.setOrigin("*");
        message.setContent(result);
        iframe.postMessage(message);
    }

    protected String getUrlSuffix() {
        String formId;
        switch (formId = this.getView().getFormShowParameter().getFormId()) {
            case "som_board_efficiency": {
                return "efficiency";
            }
            case "som_board_quality": {
                return "quality";
            }
            case "som_board_credit": {
                return "credit";
            }
        }
        return "index";
    }
}

