/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.condition.ConFieldTypeEnum;

public class PropTreeFormPlugin
extends AbstractFormPlugin {
    private static final String CACHE_KEY_TREE_NODE = "treeNode";
    private static final String BUTTON_KEY_OK = "btnok";
    private static final String CONTROL_KEY_TREE = "proptree";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_KEY_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    private void initTree() {
        MainEntityType dataEntityType;
        FormShowParameter param = this.getView().getFormShowParameter();
        String entityNumber = (String)param.getCustomParam("entityNumber");
        if (StringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        String conFieldType = (String)param.getCustomParam("conFieldType");
        ConFieldTypeEnum typeEnum = ConFieldTypeEnum.getTypeEnum((String)conFieldType);
        if (typeEnum == null) {
            return;
        }
        Class propType = typeEnum.getPropType();
        if (propType == null) {
            return;
        }
        String baseDataType = (String)param.getCustomParam("baseDataType");
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        catch (Exception e) {
            return;
        }
        String entityName = dataEntityType.getDisplayName().getLocaleValue();
        TreeNode root = new TreeNode(null, "root", entityName);
        for (IDataEntityProperty property : dataEntityType.getAllFields().values()) {
            String baseEntityId;
            boolean assignableFrom = propType.isAssignableFrom(property.getClass());
            if (!assignableFrom || ConFieldTypeEnum.BASE_DATA == typeEnum && ((baseEntityId = ((BasedataProp)property).getBaseEntityId()) == null || !baseEntityId.equals(baseDataType))) continue;
            String localeValue = property.getDisplayName().getLocaleValue();
            root.addChild(new TreeNode("root", property.getName(), localeValue));
        }
        root.setIsOpened(true);
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_TREE);
        tree.expand("root");
        tree.addNode(root);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BUTTON_KEY_OK.equals(key)) {
            TreeView tree = (TreeView)this.getControl(CONTROL_KEY_TREE);
            Map focusNode = tree.getTreeState().getFocusNode();
            if (focusNode == null || focusNode.get("id") == null || "root".equals(focusNode.get("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u5b57\u6bb5\u3002", (String)"PropTreeFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String id = focusNode.get("id").toString();
            String nodeText = focusNode.get("text").toString();
            HashMap<String, String> returnData = new HashMap<String, String>();
            returnData.put("number", id);
            returnData.put("name", nodeText);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

