/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.imports;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TaskImportHelper {
    private static final Log log = LogFactory.getLog(TaskImportHelper.class);
    public static final String SSC_ID = "sscId";
    public static final String SSC_NUMBER = "sscNumber";
    public static final String BILL_FORM_ID = "billFormId";
    public static final String BILL_FORM_NAME = "billFormName";

    public static void invalidSsc4PerBill(List<ImportBillData> billdatas, ImportLogger logger, String sscNumber) {
        if (billdatas.isEmpty()) {
            return;
        }
        String sscField = TaskImportHelper.detectSscField(billdatas);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData bill = it.next();
            if (bill.isEmpty()) continue;
            try {
                String curSscId = bill.getData().getJSONObject(sscField).getString("number");
                if (sscNumber.equals(curSscId)) continue;
                logger.log(Integer.valueOf(bill.getStartIndex()), String.format(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u7f16\u7801\u4e0d\u5339\u914d\uff0c\u76ee\u6807\u7f16\u7801\u4e3a%1$s\uff0c\u5f53\u524d\u884c\u7f16\u7801\u4e3a%2$s\u3002", (String)"TaskImportHelper_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), sscNumber, curSscId));
                it.remove();
                logger.fail();
            }
            catch (Throwable throwable) {
                log.error(throwable);
                logger.log(Integer.valueOf(billdatas.get(0).getStartIndex()), ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"TaskImportHelper_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                it.remove();
                logger.fail();
            }
        }
    }

    private static String detectSscField(List<ImportBillData> billdatas) {
        List<String> fieldNames = Arrays.asList("ssccenter", "orgfield", "createorg");
        JSONObject first = billdatas.get(0).getData();
        for (String fieldName : fieldNames) {
            if (!first.containsKey((Object)fieldName)) continue;
            return fieldName;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5171\u4eab\u4e2d\u5fc3\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6570\u636e\u548c\u6a21\u677f\u3002", (String)"TaskImportHelper_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }

    public static void checkUniqueForFieldInFile(AbstractFormPlugin plugin, String field, String name, String value, BeforeImportDataEventArgs e) {
        if (field == null || value == null || e == null) {
            return;
        }
        Object valueSetObj = plugin.getView().getFormShowParameter().getCustomParam(field);
        if (valueSetObj == null) {
            HashSet<String> valueSet = new HashSet<String>();
            valueSet.add(value);
            plugin.getView().getFormShowParameter().setCustomParam(field, valueSet);
            return;
        }
        HashSet valueSet = (HashSet)valueSetObj;
        if (valueSet.contains(value)) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u91cd\u590d\u51fa\u73b0\u3002", (String)"TaskImportHelper_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), value, name != null ? name : ""));
        } else {
            valueSet.add(value);
        }
    }

    public static void checkUniqueForFieldInFile(AbstractFormPlugin plugin, String field, String value, BeforeImportDataEventArgs e) {
        TaskImportHelper.checkUniqueForFieldInFile(plugin, field, null, value, e);
    }
}

