/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.indicators;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.enums.indicators.IndicatorsTypeEnum;
import kd.ssc.task.business.indicators.CalFormulaUtil;

public class CompositeFormulaPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
RowClickEventListener {
    private static final String INDICATORS_GROUP_NUMBER = "som_indicators_group";
    private static final String INDICATORS_LIB = "som_indicators_lib";
    private static final String ROOT_NODE_ID = "0";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String COMPOSITE_INDICATORS_TYPE_ID = "1570359605291622400";
    private static final String Key_FExpression = "fexpression";
    private static final String Key_FDescription = "fdescription";
    private static final String Key_FTranExpr = "ftranexpr";
    private static final String CACHED_NUMBER_ID = "cachedNumberId";
    private static final String CACHED_NUMBER_NAME = "cachedNumberName";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnnotequal", "btnmoreequal", "btnand", "btnor", "btnleft", "btnright", "clr", "backspace", "btnok", "btncancel"});
        this.addClickListeners(new String[]{"trycal"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTreeNode();
        this.initIndicators(null);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formula = (String)formShowParameter.getCustomParam("formula");
        CRFormula formulaObj = this.deserialize(formula);
        this.buildTranCache(formulaObj);
        this.setFormulaObj(formulaObj);
    }

    private void buildTranCache(CRFormula crFormula) {
        QFilter numberFilter;
        DynamicObject[] indicators;
        BOSExpression bosExpression = new BOSExpression(crFormula.getExpression());
        Set vars = bosExpression.getVars();
        if (vars != null && !vars.isEmpty() && (indicators = BusinessDataServiceHelper.load((String)INDICATORS_LIB, (String)"number,name", (QFilter[])new QFilter[]{numberFilter = new QFilter("number", "in", (Object)vars)})) != null && indicators.length > 0) {
            HashMap<String, String> numberNameMap = new HashMap<String, String>(indicators.length);
            for (DynamicObject dynamicObject : indicators) {
                String name = dynamicObject.getString("name");
                String number = dynamicObject.getString("number");
                numberNameMap.put(number, name);
            }
            this.getPageCache().put(CACHED_NUMBER_NAME, SerializationUtils.toJsonString(numberNameMap));
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        this.getPageCache().put("cachedSearchText", text);
        this.initIndicators(text);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        this.initIndicators(this.getPageCache().get("cachedSearchText"));
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        String openStatus = (String)this.getView().getFormShowParameter().getCustomParam("openstatus");
        if ("EDIT".equals(openStatus)) {
            return;
        }
        int row = evt.getRow();
        String indicatorsNumber = (String)this.getModel().getValue("indicatorsnumber", row);
        String indicatorsId = String.valueOf(this.getModel().getValue("indicatorsid", row));
        String indicatorsName = (String)this.getModel().getValue("indicatorsname", row);
        String cachedNumberIdJson = this.getPageCache().get(CACHED_NUMBER_ID);
        JSONObject idJSONObject = StringUtils.isEmpty((CharSequence)cachedNumberIdJson) ? new JSONObject() : JSONObject.parseObject((String)cachedNumberIdJson);
        idJSONObject.put(indicatorsNumber, (Object)indicatorsId);
        String cachedNumberNameJson = this.getPageCache().get(CACHED_NUMBER_NAME);
        JSONObject nameJSONObject = StringUtils.isEmpty((CharSequence)cachedNumberNameJson) ? new JSONObject() : JSONObject.parseObject((String)cachedNumberNameJson);
        nameJSONObject.put(indicatorsNumber, (Object)indicatorsName);
        this.getPageCache().put(CACHED_NUMBER_ID, JSONObject.toJSONString((Object)idJSONObject));
        this.getPageCache().put(CACHED_NUMBER_NAME, JSONObject.toJSONString((Object)nameJSONObject));
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)ENTRY_ENTITY, (String)Key_FExpression, (String)indicatorsNumber);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String openStatus = (String)this.getView().getFormShowParameter().getCustomParam("openstatus");
        if ("EDIT".equals(openStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnnotequal", "btnmoreequal", Key_FExpression, Key_FDescription, "btnand", "btnor", "btnleft", "btnright", "clr", "backspace"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnok"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String key = ctlSource.getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            CRFormula formulaObj = this.checkCRFormula();
            if (formulaObj == null) {
                return;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("formula", (Object)SerializationUtils.toJsonString((Object)formulaObj));
            jsonObject.put("idParam", (Object)this.getPageCache().get(CACHED_NUMBER_ID));
            jsonObject.put("nameParam", (Object)this.getPageCache().get(CACHED_NUMBER_NAME));
            view.returnDataToParent((Object)jsonObject);
            view.close();
        } else if ("btncancel".equalsIgnoreCase(key)) {
            view.close();
        } else if ("clr".equalsIgnoreCase(key)) {
            model.setValue(Key_FExpression, (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)view, (String)Key_FExpression, (int)0);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"backspace")) {
            FormulaEditHelper.backSpaceExpression((IFormView)view, (String)"backspace", (String)Key_FExpression);
        } else if ("trycal".equals(key)) {
            CRFormula crFormula = this.checkCRFormula();
            if (crFormula != null) {
                Object result = null;
                try {
                    result = CalFormulaUtil.tryCompositeIndicators((CRFormula)crFormula);
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bd5\u7b97\u5931\u8d25\uff1a%s\u3002", (String)"CompositeFormulaPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage()));
                    return;
                }
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u8bd5\u7b97\u6210\u529f\uff0c\u7ed3\u679c\u4e3a\uff1a%s\u3002", (String)"CompositeFormulaPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]), result));
            }
        } else {
            this.clickCompareButton(key);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(Key_FExpression)) {
            String expression = (String)this.getModel().getValue(Key_FExpression);
            String tranExpr = "";
            try {
                tranExpr = this.tranExpression(expression);
            }
            catch (FormulaException exp) {
                tranExpr = exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage();
            }
            catch (Exception exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"CompositeFormulaPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
        }
    }

    private void initTreeNode() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        TreeNode root = new TreeNode("", ROOT_NODE_ID, ResManager.loadKDString((String)"\u5168\u90e8\u5206\u7c7b", (String)"CompositeFormulaPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]), true);
        root.setIsOpened(true);
        List<Long> sscIds = this.userSSCIds();
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        QFilter strategyFilter = baseDataService.getBaseDataFilter(INDICATORS_GROUP_NUMBER, sscIds, true);
        strategyFilter.or(new QFilter("ctrlstrategy", "=", (Object)"7"));
        DynamicObject[] groups = BusinessDataServiceHelper.load((String)INDICATORS_GROUP_NUMBER, (String)"id,number,name", (QFilter[])new QFilter[]{strategyFilter});
        if (groups == null || groups.length == 0) {
            this.getPageCache().put("noSSC", "true");
            return;
        }
        ArrayList<TreeNode> groupNodes = new ArrayList<TreeNode>(groups.length);
        for (DynamicObject dynamicObject : groups) {
            TreeNode node = new TreeNode(ROOT_NODE_ID, dynamicObject.getString("id"), dynamicObject.getString("name"), false);
            groupNodes.add(node);
        }
        root.setChildren(groupNodes);
        treeView.addNode(root);
        treeView.focusNode(root);
    }

    private List<Long> userSSCIds() {
        Long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        if (userHasPermOrgs.hasAllOrgPerm()) {
            return orgService.getAllOrg("12");
        }
        List orgIds = userHasPermOrgs.getHasPermOrgs();
        return orgService.filterOrgDuty(orgIds, "12");
    }

    private void initIndicators(String searchText) {
        QFilter enableFilter;
        DynamicObject[] indicatorsData;
        String noSSC = this.getPageCache().get("noSSC");
        if (StringUtils.isNotEmpty((CharSequence)noSSC)) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        ArrayList<Long> sscIds = new ArrayList<Long>(1);
        String sscId = (String)this.getView().getFormShowParameter().getCustomParam("sscId");
        sscIds.add(Long.valueOf(sscId));
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        QFilter strategyFilter = baseDataService.getBaseDataFilter(INDICATORS_LIB, sscIds, true);
        strategyFilter.or(new QFilter("ctrlstrategy", "=", (Object)"7"));
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        Map focusNode = treeView.getTreeState().getFocusNode();
        String focusNodeId = (String)focusNode.get("id");
        QFilter groupFilter = null;
        if (!ROOT_NODE_ID.equals(focusNodeId)) {
            groupFilter = new QFilter("group", "=", (Object)Long.valueOf(focusNodeId));
        }
        QFilter nameNumberFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            nameNumberFilter = new QFilter("number", "like", (Object)("%" + searchText + "%")).or(new QFilter("name", "like", (Object)("%" + searchText + "%")));
        }
        if ((indicatorsData = BusinessDataServiceHelper.load((String)INDICATORS_LIB, (String)"id,name,number", (QFilter[])new QFilter[]{strategyFilter, groupFilter, nameNumberFilter, enableFilter = new QFilter("enable", "=", (Object)"1")})) == null || indicatorsData.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : indicatorsData) {
            int entryRow = model.createNewEntryRow(ENTRY_ENTITY);
            Long id = dynamicObject.getLong("id");
            this.getModel().setValue("indicatorsid", (Object)id, entryRow);
            String number = dynamicObject.getString("number");
            this.getModel().setValue("indicatorsnumber", (Object)number, entryRow);
            String name = dynamicObject.getString("name");
            this.getModel().setValue("indicatorsname", (Object)name, entryRow);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.setPageIndex(1);
    }

    private CRFormula deserialize(String json) {
        CRFormula formulaObj = null;
        formulaObj = StringUtils.isBlank((CharSequence)json) ? new CRFormula() : (CRFormula)SerializationUtils.fromJsonString((String)json, CRFormula.class);
        return formulaObj;
    }

    private void getFormulaObj(CRFormula formulaObj) {
        String expression = (String)this.getModel().getValue(Key_FExpression);
        formulaObj.setExpression(expression);
        String desc = (String)this.getModel().getValue(Key_FDescription);
        formulaObj.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc);
    }

    private String tranFormula(CRFormula formulaObj) {
        String expressionDesc = this.tranExpression(formulaObj.getExpression());
        this.checkVariables(formulaObj.getExpression());
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            this.checkCycleReference(formulaObj.getExpression(), number);
        }
        return expressionDesc;
    }

    private void checkVariables(String expression) {
        BOSExpression bosExpression = new BOSExpression(expression);
        Set vars = bosExpression.getVars();
        QFilter numberSetFilter = new QFilter("number", "in", (Object)vars);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)INDICATORS_LIB, (String)"id,number", (QFilter[])new QFilter[]{numberSetFilter});
        Set resultNumberSet = Arrays.stream(result).map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toSet());
        vars.removeAll(resultNumberSet);
        if (!vars.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u6807%s\u4e0d\u5b58\u5728\u3002", (String)"CompositeFormulaPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), vars));
        }
    }

    private void checkCycleReference(String expression, String number) {
        BOSExpression bosExpression = new BOSExpression(expression);
        Set vars = bosExpression.getVars();
        if (vars.contains(number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u6807\u4e4b\u95f4\u5b58\u5728\u5faa\u73af\u5f15\u7528\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6b63\u3002", (String)"CompositeFormulaPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        QFilter numberSetFilter = new QFilter("number", "in", (Object)vars);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)INDICATORS_LIB, (String)"id,number,indicatorstype,calformulajson", (QFilter[])new QFilter[]{numberSetFilter});
        if (result != null && result.length > 0) {
            for (DynamicObject dynamicObject : result) {
                String type = dynamicObject.getString("indicatorstype");
                if (!IndicatorsTypeEnum.COMPOSITE.getType().equals(type)) continue;
                CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)dynamicObject.getString("calformulajson"), CRFormula.class);
                this.checkCycleReference(crFormula.getExpression(), number);
            }
        }
    }

    protected String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        String json = this.getPageCache().get(CACHED_NUMBER_NAME);
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            jsonObject = JSONObject.parseObject((String)json);
        }
        ArrayList<String> orderVars = new ArrayList<String>(10);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return o2.compareTo((String)o1);
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            String tranValue = jsonObject.getString(string);
            if (tranValue != null) {
                varCaption = tranValue;
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "=";
                break;
            }
            case "btnnotequal": {
                compareValue = "<>";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "and";
                break;
            }
            case "btnor": {
                compareValue = "or";
                break;
            }
            case "btnleft": {
                compareValue = "(";
                break;
            }
            case "btnright": {
                compareValue = ")";
                break;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)compareKey, (String)Key_FExpression, (String)compareValue);
        }
    }

    protected void setFormulaObj(CRFormula formulaObj) {
        this.getModel().setValue(Key_FExpression, (Object)formulaObj.getExpression());
        this.getModel().setValue(Key_FDescription, (Object)formulaObj.getDescription().toString());
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
    }

    private CRFormula checkCRFormula() {
        String conditionJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        CRFormula formulaObj = this.deserialize(conditionJson);
        this.getFormulaObj(formulaObj);
        String expression = formulaObj.getExpression();
        if (expression.length() > 255) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u957f\u5ea6\u8d85\u51fa\u9650\u5236\u3002", (String)"CompositeFormulaPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        try {
            String tranExpr = this.tranFormula(formulaObj);
            formulaObj.setExprTran(tranExpr);
        }
        catch (FormulaException exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"CompositeFormulaPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
            return null;
        }
        catch (Exception exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"CompositeFormulaPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), exp.getMessage()));
            return null;
        }
        return formulaObj;
    }
}

