/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.nsynprocess;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.OpBatchExecuter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.task.formplugin.MytaskListPlugin;
import kd.ssc.task.util.ObjectCloneUtil;

public class NsynTaskAuditProcess
implements Runnable {
    private static final Log log = LogFactory.getLog(OpBatchExecuter.class);
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private String taskId;
    private int batchCount;
    private String opkey;
    private List<Long> pkIds;
    private List<Long> taskIds;
    private List<Object> decisionItemIds;
    private String opinion;
    private String innerMsg;
    private Boolean isEmbed;
    private IFormView formView;

    public NsynTaskAuditProcess(String taskId, int batchCount, String opkey, List<Long> pkIds, List<Long> taskIds, List<Object> decisionItemIds, String opinion, String innerMsg, Boolean isEmbed, IFormView formView) {
        this.taskId = taskId;
        this.batchCount = batchCount;
        this.opkey = opkey;
        this.pkIds = (List)ObjectCloneUtil.cloneObject(pkIds);
        this.taskIds = (List)ObjectCloneUtil.cloneObject(taskIds);
        this.decisionItemIds = (List)ObjectCloneUtil.cloneObject(decisionItemIds);
        this.opinion = opinion;
        this.innerMsg = innerMsg;
        this.isEmbed = isEmbed;
        this.formView = formView;
    }

    @Override
    public void run() {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            NsynTaskAuditProcess.setInterruption(this.taskId, true);
            log.error("BatchAllocateTaskException:" + e.getMessage(), (Throwable)e);
        }
        finally {
            NsynTaskAuditProcess.setFinished(this.taskId, true);
        }
    }

    private void doExecute() {
        List<Long> ids;
        int seq;
        boolean decesionItemIsEmpty = this.decesionItemIsEmpty();
        int totalCount = decesionItemIsEmpty ? this.pkIds.size() : this.taskIds.size();
        int times = totalCount / this.batchCount + 1;
        int finishCount = seq * this.batchCount;
        MytaskListPlugin taskListPlugin = new MytaskListPlugin();
        for (seq = NsynTaskAuditProcess.getBatchSeq(this.taskId); seq < times && !(ids = this.getCurrIds(seq, decesionItemIsEmpty)).isEmpty(); ++seq) {
            if (this.isEmbed.booleanValue()) {
                if (decesionItemIsEmpty) {
                    taskListPlugin.getTaskAndAppreval(this.opkey, ids, this.opinion, this.innerMsg, null, this.formView, true);
                } else {
                    taskListPlugin.getTaskAndApprevalExt(this.opkey, this.opinion, this.innerMsg, ids, this.decisionItemIds, null, this.formView, true);
                }
            } else {
                taskListPlugin.getTaskAndApprevalNew(this.opkey, ids, this.opinion, this.innerMsg, this.decisionItemIds, null, null, this.formView);
            }
            int percent = (finishCount += ids.size()) * 100 / totalCount;
            String tip = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5206\u6279\u5904\u7406\u4e2d\uff0c\u6bcf\u6279%1$s\u5f20\uff0c\u5df2\u5b8c\u6210 %2$s/%3$s\u5f20", (String)"NsynTaskAuditProcess_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), this.batchCount, finishCount, totalCount);
            NsynTaskAuditProcess.setProgress(this.taskId, percent);
            NsynTaskAuditProcess.setProgressTip(this.taskId, tip);
        }
        if (finishCount >= totalCount) {
            NsynTaskAuditProcess.setCompleted(this.taskId, true);
        } else {
            NsynTaskAuditProcess.setInterruption(this.taskId, true);
        }
    }

    private List<Long> getCurrIds(int seq, boolean decesionItemIsEmpty) {
        ArrayList<Long> ids = new ArrayList<Long>();
        int begin = seq * this.batchCount;
        int end = begin + this.batchCount;
        if (decesionItemIsEmpty) {
            for (int i = begin; i < end && i < this.pkIds.size(); ++i) {
                ids.add(this.pkIds.get(i));
            }
        } else {
            for (int i = begin; i < end && i < this.taskIds.size(); ++i) {
                ids.add(this.taskIds.get(i));
            }
        }
        return ids;
    }

    private boolean decesionItemIsEmpty() {
        return this.decisionItemIds == null || this.decisionItemIds.size() == 0;
    }

    public static boolean isFinished(String taskId) {
        String finish = (String)CACHE.get(NsynTaskAuditProcess.buildCacheType(taskId), "finish");
        return !StringUtils.isBlank((CharSequence)finish) && Boolean.parseBoolean(finish);
    }

    public static void setFinished(String taskId, boolean finisih) {
        CACHE.put(NsynTaskAuditProcess.buildCacheType(taskId), "finish", (Object)String.valueOf(finisih));
    }

    public static boolean isCompleted(String taskId) {
        String finish = (String)CACHE.get(NsynTaskAuditProcess.buildCacheType(taskId), "complete");
        return !StringUtils.isBlank((CharSequence)finish) && Boolean.parseBoolean(finish);
    }

    public static void setCompleted(String taskId, boolean complete) {
        CACHE.put(NsynTaskAuditProcess.buildCacheType(taskId), "complete", (Object)String.valueOf(complete));
    }

    public static boolean isInteruption(String taskId) {
        String finish = (String)CACHE.get(NsynTaskAuditProcess.buildCacheType(taskId), "interruption");
        return !StringUtils.isBlank((CharSequence)finish) && Boolean.parseBoolean(finish);
    }

    public static void setInterruption(String taskId, boolean interruption) {
        CACHE.put(NsynTaskAuditProcess.buildCacheType(taskId), "interruption", (Object)String.valueOf(interruption));
    }

    public static int getBatchSeq(String taskId) {
        String seq = (String)CACHE.get(NsynTaskAuditProcess.buildCacheType(taskId), "batchseq");
        return StringUtils.isBlank((CharSequence)seq) ? 0 : Integer.parseInt(seq);
    }

    public static int getProgress(String taskId) {
        String progress = (String)CACHE.get(NsynTaskAuditProcess.buildCacheType(taskId), "progress");
        return StringUtils.isBlank((CharSequence)progress) ? 0 : Integer.parseInt(progress);
    }

    public static void setProgress(String taskId, int progress) {
        CACHE.put(NsynTaskAuditProcess.buildCacheType(taskId), "progress", (Object)String.valueOf(progress));
    }

    public static String getProgressTip(String taskId) {
        return (String)CACHE.get(NsynTaskAuditProcess.buildCacheType(taskId), "tip");
    }

    public static void setProgressTip(String taskId, String tip) {
        CACHE.put(NsynTaskAuditProcess.buildCacheType(taskId), "tip", (Object)tip);
    }

    private static String buildCacheType(String taskId) {
        return "NsynTaskAuditProcess_" + taskId;
    }
}

