/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.quality;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.enums.quality.QcPendingRecordOperationEnum;
import kd.ssc.task.business.task.TaskQcPendingRecordHelper;
import kd.ssc.task.formplugin.quality.QualityApprovalPendingHelper;

public class QualityApprovalPendingListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if ("btnok".equalsIgnoreCase(key)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(15);
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            Object[] selectPendingIds = selectedRows.getPrimaryKeyValues();
            if (selectPendingIds == null || selectPendingIds.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d28\u68c0\u6682\u6302\u539f\u56e0\u3002", (String)"QualityApprovalPendingListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            List taskIds = (List)showParameter.getCustomParam("taskIds");
            Integer totalTaskCount = taskIds.size();
            Integer totalSuccessCount = 0;
            StringBuilder errorMsg = new StringBuilder();
            QFilter idFilter = new QFilter("id", "in", (Object)taskIds);
            DynamicObject[] taskDos = BusinessDataServiceHelper.load((String)"task_task", (String)"id,billnumber,state,pendingopinion", (QFilter[])new QFilter[]{idFilter});
            if (taskDos != null && taskDos.length > 0) {
                for (DynamicObject task : taskDos) {
                    long taskId = task.getLong("id");
                    String state = task.getString("state");
                    String billNumber = task.getString("billnumber");
                    if (!QualityApprovalPendingHelper.isPause(state)) {
                        String result = String.format(ResManager.loadKDString((String)"%s\uff1a\u8bf7\u9009\u62e9\u5f85\u8d28\u68c0\u3001\u5f85\u6574\u6539\u3001\u5f85\u590d\u6838\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"QualityApprovalPendingListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), billNumber);
                        errorMsg.append(result).append("\n");
                        continue;
                    }
                    long currUserId = RequestContext.get().getCurrUserId();
                    QcPendingRecordOperationEnum operation = QcPendingRecordOperationEnum.PAUSE_CHECKING;
                    if (TaskStateEnum.CHECKING.getValue().equals(state)) {
                        operation = QcPendingRecordOperationEnum.PAUSE_CHECKING;
                        task.set("state", (Object)TaskStateEnum.PAUSE_CHECKING.getValue());
                    } else if (TaskStateEnum.RECTIFYING.getValue().equals(state)) {
                        operation = QcPendingRecordOperationEnum.PAUSE_RECTIFYING;
                        task.set("state", (Object)TaskStateEnum.PAUSE_RECTIFYING.getValue());
                    } else if (TaskStateEnum.REVIEW.getValue().equals(state)) {
                        operation = QcPendingRecordOperationEnum.PAUSE_REVIEW;
                        task.set("state", (Object)TaskStateEnum.PAUSE_REVIEW.getValue());
                    }
                    List pendingIdList = Arrays.stream(selectPendingIds).map(Long.class::cast).collect(Collectors.toList());
                    TaskQcPendingRecordHelper.savePendingRecord((Long)taskId, (Long)currUserId, (QcPendingRecordOperationEnum)operation, pendingIdList);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
                    Integer n = totalSuccessCount;
                    Integer n2 = totalSuccessCount = Integer.valueOf(totalSuccessCount + 1);
                }
            }
            returnData.put("totalTaskCount", totalTaskCount);
            returnData.put("totalSuccessCount", totalSuccessCount);
            returnData.put("digest", this.createTipDigest(totalTaskCount, totalSuccessCount));
            returnData.put("errorMsg", errorMsg.toString());
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public String createTipDigest(Integer totalTaskCount, Integer totalSuccessCount) {
        String digest = ResManager.loadKDString((String)"\u5171%1$s\u6761\u4efb\u52a1\uff0c\u6682\u6302\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"QualityApprovalPendingListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        digest = String.format(digest, totalTaskCount, totalSuccessCount, totalTaskCount - totalSuccessCount);
        return digest;
    }
}

