/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.FilterColumn;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.formplugin.rpt.RptConstant;
import kd.ssc.task.formplugin.rpt.RptDimensionParam;

public class RptQualityCheckCommon {
    private static final String ENTITY_TASK = "task_task";
    private static final String ENTITY_TASKHISTORY = "task_taskhistory";
    private static final String ENTITY_CHECKINGPOINT = "task_checkingpoint";
    private static final String ENTITY_MESSAGERECORD = "task_qualitymessagerecord";
    private static final String ENTITY_SAMPLELIBRARY = "task_qualitysamplelibrary";
    private static final String ENTITY_QUALITYCHECKSCHEME = "task_qualitycheckscheme";
    private static final String ENTITY_SMARTCHECKSCHEME = "task_smartcheckscheme";
    private static final String ENTITY_BOSUSER = "bos_user";
    private static final String ENTITY_BOORG = "bos_org";
    private static final String ENTITY_BILLTYPE = "task_taskbill";
    private static final String FIELDS_TASKANDTASKHISTORY = "id,orignalperson as personid,qualitysamplelibrary,state,qualityresult";

    public static List<QFilter> getFilters(ReportQueryParam rqParam) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter filterQualityCheckTask = new QFilter("qualitysamplelibrary", ">", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        filterList.add(filterQualityCheckTask);
        FilterInfo filter = rqParam.getFilter();
        List filterItems = filter.getFilterItems();
        QFilter qFilter = null;
        for (FilterItemInfo itemInfo : filterItems) {
            List<Long> ids;
            String propName = itemInfo.getPropName();
            if ("receivetime".equalsIgnoreCase(propName)) {
                qFilter = new QFilter("receivetime", itemInfo.getCompareType(), itemInfo.getValue());
                filterList.add(qFilter);
                continue;
            }
            if ("sharecenter.id".equalsIgnoreCase(propName)) {
                qFilter = new QFilter("sscid.id", itemInfo.getCompareType(), itemInfo.getValue());
                filterList.add(qFilter);
                continue;
            }
            if ("sharecenter.name".equalsIgnoreCase(propName)) {
                ids = RptQualityCheckCommon.getOrgIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("sscid.id", "in", ids);
                filterList.add(qFilter);
                continue;
            }
            if ("org.id".equals(propName)) {
                qFilter = new QFilter("orgid.id", itemInfo.getCompareType(), itemInfo.getValue());
                filterList.add(qFilter);
                continue;
            }
            if ("org.name".equals(propName)) {
                ids = RptQualityCheckCommon.getOrgIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("orgid.id", "in", ids);
                filterList.add(qFilter);
                continue;
            }
            if ("aduittype".equals(propName)) {
                qFilter = new QFilter("autoprocess", itemInfo.getCompareType(), itemInfo.getValue());
                filterList.add(qFilter);
                continue;
            }
            if ("qualitycheckscheme.id".equals(propName)) {
                QFilter tempFilter = "0".equals(itemInfo.getValue() + "") ? new QFilter("issmart", "=", (Object)Character.valueOf('1')) : new QFilter("checkscheme", itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = RptQualityCheckCommon.qualitySampleLibraryFilter(tempFilter);
                if (qFilter != null) {
                    filterList.add(qFilter);
                    continue;
                }
                qFilter = new QFilter("qualitysamplelibrary.id", "=", (Object)-1);
                filterList.add(qFilter);
                continue;
            }
            if ("qualitycheckscheme.name".equals(propName)) {
                ids = RptQualityCheckCommon.getSchemeIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                QFilter tempFilter = new QFilter("checkscheme", "in", ids);
                qFilter = RptQualityCheckCommon.qualitySampleLibraryFilter(tempFilter);
                if (qFilter == null) continue;
                filterList.add(qFilter);
                continue;
            }
            if ("personid".equalsIgnoreCase(propName)) {
                qFilter = new QFilter("orignalperson", "=", itemInfo.getValue());
                filterList.add(qFilter);
                continue;
            }
            if ("preperson.id".equalsIgnoreCase(propName)) {
                qFilter = new QFilter("orignalperson", "=", itemInfo.getValue());
                filterList.add(qFilter);
                continue;
            }
            if ("preperson.name".equalsIgnoreCase(propName)) {
                ids = RptQualityCheckCommon.getUserIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("orignalperson", "in", ids);
                filterList.add(qFilter);
                continue;
            }
            if (!"qualitysamplelibrary.id".equalsIgnoreCase(propName)) continue;
            qFilter = new QFilter("qualitysamplelibrary.id", itemInfo.getCompareType(), itemInfo.getValue());
            filterList.add(qFilter);
        }
        return filterList;
    }

    public static Object getDefaultFilterValue(ReportQueryParam rqParam, String filterProperty) {
        Object value = null;
        FilterInfo filter = rqParam.getFilter();
        List filterItems = filter.getFilterItems();
        Date startDate = null;
        Date endDate = null;
        if ("sharecenter.name".equalsIgnoreCase(filterProperty)) {
            filterProperty = "sharecenter.id";
        } else if ("org".equalsIgnoreCase(filterProperty)) {
            filterProperty = "org.id";
        } else if ("qualitycheckscheme".equalsIgnoreCase(filterProperty)) {
            filterProperty = "qualitycheckscheme.id";
        }
        for (FilterItemInfo itemInfo : filterItems) {
            String propName = itemInfo.getPropName();
            if ("receivetime".equalsIgnoreCase(filterProperty)) {
                if (">=".equals(itemInfo.getCompareType())) {
                    startDate = (Date)itemInfo.getValue();
                    continue;
                }
                if (!"<=".equals(itemInfo.getCompareType())) continue;
                endDate = (Date)itemInfo.getValue();
                continue;
            }
            if (!propName.equalsIgnoreCase(filterProperty)) continue;
            value = itemInfo.getValue() == null ? null : itemInfo.getValue();
            return value;
        }
        if (startDate != null && endDate != null) {
            value = RptQualityCheckCommon.getDateDefaultValue(startDate, endDate);
        }
        return value;
    }

    private static String getDateDefaultValue(Date startDate, Date endDate) {
        int months = RptQualityCheckCommon.getMonthsBetween(startDate, endDate);
        if (months == 3) {
            return "24";
        }
        if (months == 0) {
            int days = RptQualityCheckCommon.daysBetween(startDate, endDate);
            if (days == 0) {
                return "13";
            }
            if (days == 6) {
                return "10";
            }
            if (days > 6 && days <= 31) {
                if (RptQualityCheckCommon.isCurrentMonth(startDate)) {
                    return "63";
                }
                return "92";
            }
        } else {
            return null;
        }
        return null;
    }

    private static boolean isCurrentMonth(Date date) {
        Date curDate = new Date();
        Calendar curCal = Calendar.getInstance();
        Calendar tagCal = Calendar.getInstance();
        curCal.setTime(curDate);
        tagCal.setTime(date);
        return curCal.get(2) == tagCal.get(2);
    }

    private static int getMonthsBetween(Date startDate, Date endDate) {
        Calendar bef = Calendar.getInstance();
        Calendar aft = Calendar.getInstance();
        bef.setTime(startDate);
        aft.setTime(endDate);
        int result = aft.get(2) - bef.get(2);
        int month = (aft.get(1) - bef.get(1)) * 12;
        return Math.abs(month + result);
    }

    private static final int daysBetween(Date early, Date late) {
        Calendar calst = Calendar.getInstance();
        Calendar caled = Calendar.getInstance();
        calst.setTime(early);
        caled.setTime(late);
        calst.set(11, 0);
        calst.set(12, 0);
        calst.set(13, 0);
        caled.set(11, 0);
        caled.set(12, 0);
        caled.set(13, 0);
        int days = ((int)(caled.getTime().getTime() / 1000L) - (int)(calst.getTime().getTime() / 1000L)) / 3600 / 24;
        return days;
    }

    public static QFilter qualitySampleLibraryFilter(QFilter schemeFilter) {
        QFilter retFilter = null;
        String selectFields = "id,checkscheme,smartcheckscheme";
        DynamicObject[] sampleLibraryArray = BusinessDataServiceHelper.load((String)ENTITY_SAMPLELIBRARY, (String)selectFields, (QFilter[])new QFilter[]{schemeFilter});
        if (sampleLibraryArray == null || sampleLibraryArray.length == 0) {
            return null;
        }
        ArrayList<Object> libIds = new ArrayList<Object>(10);
        for (int i = 0; i < sampleLibraryArray.length; ++i) {
            libIds.add(sampleLibraryArray[i].getPkValue());
        }
        retFilter = new QFilter("qualitysamplelibrary.id", "in", libIds);
        return retFilter;
    }

    public static DataSet getAllCheckPointDataSet() {
        ORM orm = ORM.create();
        String selectFields = "id,name,number";
        DataSet dsRet = orm.queryDataSet("kd.ssc.task.formplugin.rpt.RptUnpassCheckPointQueryPlugin.getAllCheckPointDataSet", ENTITY_CHECKINGPOINT, selectFields, null);
        return dsRet;
    }

    public static DataSet getAllMessageRecordDataSet() {
        ORM orm = ORM.create();
        String selectFields = "point as pointid,qualitycheck as taskid,ischeckok, reviewmethod, entryentity.messagetype as messagetype, entryentity.isnewmessage as isnewmessage";
        DataSet dsRet = orm.queryDataSet("kd.ssc.task.formplugin.rpt.RptUnpassCheckPointQueryPlugin.getAllMessageRecordDataSet", ENTITY_MESSAGERECORD, selectFields, null);
        return dsRet;
    }

    public static DataSet getLibraryDataSet() {
        ORM orm = ORM.create();
        String selectFields = "id,checkscheme,smartcheckscheme";
        DataSet dsRet = orm.queryDataSet("kd.ssc.task.formplugin.rpt.RptUnpassCheckPointQueryPlugin.getLibraryDataSet", ENTITY_SAMPLELIBRARY, selectFields, null);
        return dsRet;
    }

    public static DataSet getSchemeDataSet(boolean isSmartSchemeType) {
        ORM orm = ORM.create();
        String selectFields = "id,cpentry.cpnumber as cpnumber, cpentry.id as entryid";
        DataSet dsRet = orm.queryDataSet("kd.ssc.task.formplugin.rpt.RptUnpassCheckPointQueryPlugin.getSchemeDataSet", isSmartSchemeType ? ENTITY_SMARTCHECKSCHEME : ENTITY_QUALITYCHECKSCHEME, selectFields, null);
        return dsRet;
    }

    public static List<AbstractReportColumn> createDimensionColumns(List<AbstractReportColumn> columnList, ReportQueryParam queryParam, List<AbstractReportColumn> columns) throws Throwable {
        LocaleString width;
        FilterInfo filterinfo = queryParam.getFilter();
        FilterItemInfo itemInfo = filterinfo.getFilterItem("dimension");
        RptDimensionParam dimensionParam = new RptDimensionParam(itemInfo);
        dimensionParam.setDimension();
        if (dimensionParam.getIshandlepersondim().booleanValue()) {
            ReportColumnGroup cg = new ReportColumnGroup();
            cg.setCaption(RptConstant.getQualitycheckperson());
            ReportColumn columnHeader = new ReportColumn();
            columnHeader.setCaption(new LocaleString(""));
            columnHeader.setFieldType("text");
            columnHeader.setPicture(true);
            columnHeader.setWidth(new LocaleString("40px"));
            columnHeader.setFieldKey("personpic");
            ColumnStyle sty = new ColumnStyle();
            sty.setRadius("43px");
            sty.setTextAlign("left");
            columnHeader.setStyle(sty);
            cg.getChildren().add(columnHeader);
            ReportColumn column = new ReportColumn();
            column.setCaption(RptConstant.getQualitycheckperson());
            column.setFieldType("basedata");
            column.setEntityId(ENTITY_BOSUSER);
            column.setFieldKey("personid");
            column.setWidth(new LocaleString("86px"));
            cg.getChildren().add(column);
            cg.setMerge(true);
            cg.setFieldKey("personidpic");
            columnList.add(0, (AbstractReportColumn)cg);
        }
        if (dimensionParam.getIsbussinessbilldim().booleanValue()) {
            ReportColumn personCol = RptQualityCheckCommon.createAmountReportColumn(RptConstant.getBillName(), "billtypename");
            width = new LocaleString("134px");
            personCol.setWidth(width);
            columnList.add(0, (AbstractReportColumn)personCol);
        }
        if (dimensionParam.getIstasktypedim().booleanValue()) {
            ReportColumn taskTypeCol = RptQualityCheckCommon.createAmountReportColumn(RptConstant.getTasktypeName(), "tasktypename");
            width = new LocaleString("134px");
            taskTypeCol.setWidth(width);
            columnList.add(0, (AbstractReportColumn)taskTypeCol);
        }
        if (dimensionParam.getIsorgdim().booleanValue()) {
            ReportColumn orgCol = RptQualityCheckCommon.createAmountReportColumn(RptConstant.getOrgName(), "orgname");
            width = new LocaleString("220px");
            orgCol.setWidth(width);
            columnList.add(0, (AbstractReportColumn)orgCol);
        }
        return columnList;
    }

    public static ReportColumn createAmountReportColumn(LocaleString caption, String fieldKey) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldType("text");
        column.setFieldKey(fieldKey);
        return column;
    }

    public static List<QFilter> handleJsonQFilter(List<JSONObject> filterlist) {
        ArrayList<QFilter> ret = new ArrayList<QFilter>(10);
        if (filterlist == null || filterlist.size() == 0) {
            return ret;
        }
        QFilter filter = null;
        for (int i = 0; i < filterlist.size(); ++i) {
            JSONObject item = filterlist.get(i);
            filter = new QFilter(item.getString("property"), item.getString("cp"), item.get((Object)"value"));
            ret.add(filter);
        }
        return ret;
    }

    public static DataSet getTaskHistoryDataSet(ReportQueryParam rqParam) {
        ORM orm = ORM.create();
        List<QFilter> filters = RptQualityCheckCommon.getFilters(rqParam);
        QFilter[] filterArr = new QFilter[filters.size()];
        DataSet dsRet = orm.queryDataSet("kd.ssc.task.formplugin.rpt.RptUnpassCheckPointQueryPlugin.getTaskDataSet", ENTITY_TASKHISTORY, FIELDS_TASKANDTASKHISTORY, filters.toArray(filterArr));
        return dsRet;
    }

    public static DataSet getTaskDataSet(ReportQueryParam rqParam) {
        ORM orm = ORM.create();
        List<QFilter> filters = RptQualityCheckCommon.getFilters(rqParam);
        filters.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
        QFilter[] filterArr = new QFilter[filters.size()];
        DataSet dsRet = orm.queryDataSet("kd.ssc.task.formplugin.rpt.RptUnpassCheckPointQueryPlugin.getTaskDataSet", ENTITY_TASK, FIELDS_TASKANDTASKHISTORY, filters.toArray(filterArr));
        return dsRet;
    }

    public static void hideColumnFilter(List<FilterColumn> listFilter, List<String> needRemoveColumnNameList) {
        if (needRemoveColumnNameList == null || needRemoveColumnNameList.size() == 0) {
            return;
        }
        for (int i = 0; i < listFilter.size(); ++i) {
            Iterator<FilterColumn> it = listFilter.iterator();
            while (it.hasNext()) {
                FilterColumn c = it.next();
                String name = c.getFieldName();
                if (!needRemoveColumnNameList.contains(name)) continue;
                it.remove();
            }
        }
    }

    public static List<Long> getOrgIdFromName(String compareType, Object value) {
        ArrayList<Long> ret = new ArrayList<Long>();
        if (value == null) {
            return ret;
        }
        QFilter[] filterName = new QFilter[]{new QFilter("name", compareType, value)};
        try (DataSet dsPerson = ORM.create().queryDataSet("kd.ssc.task.formplugin.rpt.RptQualityCheckCommon.getOrgIdFromName", ENTITY_BOORG, "id", filterName);){
            Iterator iter = dsPerson.iterator();
            Row data = null;
            while (iter != null && iter.hasNext()) {
                data = (Row)iter.next();
                ret.add(data.getLong("id"));
            }
        }
        return ret;
    }

    public static List<Long> getSchemeIdFromName(String compareType, Object value) {
        ArrayList<Long> ret = new ArrayList<Long>();
        if (value == null) {
            return ret;
        }
        QFilter[] filterName = new QFilter[]{new QFilter("name", compareType, value)};
        try (DataSet dsPerson = ORM.create().queryDataSet("kd.ssc.task.formplugin.rpt.RptQualityCheckCommon.getSchemeIdFromName", ENTITY_QUALITYCHECKSCHEME, "id,name", filterName);){
            Iterator iter = dsPerson.iterator();
            Row data = null;
            while (iter != null && iter.hasNext()) {
                data = (Row)iter.next();
                ret.add(data.getLong("id"));
            }
        }
        return ret;
    }

    public static List<Long> getUserIdFromName(String compareType, Object value) {
        ArrayList<Long> ret = new ArrayList<Long>();
        if (value == null) {
            return ret;
        }
        QFilter[] filterName = new QFilter[]{new QFilter("name", compareType, value)};
        try (DataSet dsPerson = ORM.create().queryDataSet("kd.ssc.task.formplugin.rpt.RptQualityCheckCommon.getUserIdFromName", ENTITY_BOSUSER, "id", filterName);){
            Iterator iter = dsPerson.iterator();
            Row data = null;
            while (iter != null && iter.hasNext()) {
                data = (Row)iter.next();
                ret.add(data.getLong("id"));
            }
        }
        return ret;
    }

    public static List<Long> getBillTypeFromName(String compareType, Object value) {
        ArrayList<Long> ret = new ArrayList<Long>();
        if (value == null) {
            return ret;
        }
        QFilter[] filterName = new QFilter[]{new QFilter("name", compareType, value)};
        try (DataSet dsPerson = ORM.create().queryDataSet("kd.ssc.task.formplugin.rpt.RptQualityCheckCommon.getBillTypeFromName", ENTITY_BILLTYPE, "id", filterName);){
            Iterator iter = dsPerson.iterator();
            Row data = null;
            while (iter != null && iter.hasNext()) {
                data = (Row)iter.next();
                ret.add(data.getLong("id"));
            }
        }
        return ret;
    }
}

