/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.formplugin.rpt.RptQualityCheckCommon;

public class RptReductionAccountQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(RptReductionAccountQueryPlugin.class);
    private static final String ENTITY_TEMPORARYAMOUNT = "task_temporaryamount";
    private static final String FIELD_TEMPORARYAMOUNT = "id,taskid,billid,billno,formnumber,org as orgname,ssccenter,billtype,requestperson,auditperson,loccur,completetime,entryentity.amountcount as amountcount, entryentity.approvedcount as approvedcount,entryentity.reductionamount as reductionamount ";
    private static String[] selectFields = new String[]{"id", "taskid", "billid", "billno", "formnumber", "orgname", "ssccenter", "billtype", "requestperson", "auditperson", "loccur"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        DataSet dsRet = null;
        try (DataSet dsTemp = null;){
            ORM orm = ORM.create();
            QFilter[] filters = this.getFilters(param);
            dsTemp = orm.queryDataSet("kd.ssc.task.formplugin.rpt.RptReductionAccountQueryPlugin.query", ENTITY_TEMPORARYAMOUNT, FIELD_TEMPORARYAMOUNT, filters, "completetime desc");
            dsTemp.groupBy(selectFields).sum("amountcount", "amountcount").sum("approvedcount", "approvedcount").sum("reductionamount", "reductionamount").finish();
            dsRet = dsTemp.select(new String[]{"id", "taskid", "billid", "billno", "formnumber", "orgname", "ssccenter", "billtype", "requestperson", "auditperson", "loccur", "amountcount", "approvedcount", "reductionamount"});
        }
        return dsRet;
    }

    private QFilter[] getFilters(ReportQueryParam param) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter qFilter = null;
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        for (FilterItemInfo itemInfo : filterItems) {
            List<Long> ids;
            String propName = itemInfo.getPropName();
            if ("sharecenter.id".equals(propName)) {
                qFilter = new QFilter("ssccenter.id", itemInfo.getCompareType(), itemInfo.getValue());
            } else if ("completetime".equals(propName)) {
                qFilter = new QFilter("completetime", itemInfo.getCompareType(), itemInfo.getValue());
            } else if ("billtypename.id".equals(propName)) {
                qFilter = new QFilter("billtype.id", itemInfo.getCompareType(), itemInfo.getValue());
            } else if ("org.name".equalsIgnoreCase(propName)) {
                ids = RptQualityCheckCommon.getOrgIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("org.id", "in", ids);
            } else if ("org.id".equalsIgnoreCase(propName)) {
                qFilter = new QFilter("org.id", itemInfo.getCompareType(), itemInfo.getValue());
            } else if ("billnumber".equalsIgnoreCase(propName)) {
                qFilter = new QFilter("billno", itemInfo.getCompareType(), itemInfo.getValue());
            } else if ("requestpersonid.name".equalsIgnoreCase(propName)) {
                ids = RptQualityCheckCommon.getUserIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("requestperson.id", "in", ids);
            } else if ("auditpersonid.name".equalsIgnoreCase(propName)) {
                ids = RptQualityCheckCommon.getUserIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("auditperson.id", "in", ids);
            } else if ("sharecenter.name".equalsIgnoreCase(propName)) {
                ids = RptQualityCheckCommon.getOrgIdFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("ssccenter.id", "in", ids);
            } else if ("billtypename.name".equalsIgnoreCase(propName)) {
                ids = RptQualityCheckCommon.getBillTypeFromName(itemInfo.getCompareType(), itemInfo.getValue());
                qFilter = new QFilter("billtype.id", "in", ids);
            }
            if (qFilter == null) continue;
            qfList.add(qFilter);
        }
        return qfList.toArray(new QFilter[qfList.size()]);
    }
}

