/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.common.DateRangeEnum;
import kd.ssc.task.common.DateRangeUtil;
import kd.ssc.task.common.TaskFilterEnum;

public class RptTaskPersonalRankPlugin
extends AbstractReportListDataPlugin {
    private Set<Long> userSet = new HashSet<Long>();
    private String[] orderys = new String[]{"rankcoefficient desc", "taskcount desc", "processingrankcoefficient desc"};

    private void init(ReportQueryParam param) {
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter robotsFilter = new QFilter("isrobots", "=", (Object)"0");
        DynamicObjectCollection dync = QueryServiceHelper.query((String)(((Object)((Object)this)).getClass().getName() + ".users"), (String)"task_usergroup", (String)"id,entryentity.userfield userid", (QFilter[])new QFilter[]{enable, status, robotsFilter}, null);
        for (DynamicObject dyn : dync) {
            this.userSet.add(dyn.getLong("userid"));
        }
    }

    public DataSet query(ReportQueryParam param, Object object) {
        DataSet unionData;
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        Date startDate = null;
        Date endDate = null;
        for (FilterItemInfo itemInfo : filterItems) {
            String propName = itemInfo.getPropName();
            if (!"receivetime".equalsIgnoreCase(propName)) continue;
            if (">=".equalsIgnoreCase(itemInfo.getCompareType())) {
                startDate = itemInfo.getDate();
                continue;
            }
            endDate = itemInfo.getDate();
        }
        if (startDate == null || endDate == null) {
            unionData = this.query2(param, object);
        } else {
            DateRangeEnum dateRangeEnum = DateRangeUtil.getDateRangeEnum(startDate, endDate);
            unionData = dateRangeEnum != null ? this.fastQuery(param, dateRangeEnum) : this.query2(param, object);
            if (dateRangeEnum != null && unionData.isEmpty()) {
                unionData = this.query2(param, object);
            }
        }
        FilterInfo filterinfo = param.getFilter();
        FilterItemInfo ranktopInfo = filterinfo.getFilterItem("ranksel");
        if ("tail5".equals(ranktopInfo.getValue()) || "tail10".equals(ranktopInfo.getValue())) {
            this.orderys = new String[]{"rankcoefficient asc", "taskcount asc", "processingrankcoefficient asc"};
        }
        DataSet aftSTUnionData = unionData.orderBy(this.orderys);
        int i = -1;
        switch (ranktopInfo.getValue() == null ? "" : ranktopInfo.getValue().toString()) {
            case "top5": {
                i = 5;
                break;
            }
            case "top10": {
                i = 10;
                break;
            }
            case "topAll": {
                i = -1;
                break;
            }
            case "tail5": {
                i = 5;
                break;
            }
            case "tail10": {
                i = 10;
                break;
            }
            default: {
                i = 10;
            }
        }
        int count = aftSTUnionData.copy().count("personid", false);
        DataSet aftTpUnionData = i == -1 ? aftSTUnionData : aftSTUnionData.top(i);
        this.cacheData(param, aftTpUnionData.copy(), count);
        return aftTpUnionData;
    }

    private void cacheData(ReportQueryParam param, DataSet aftSTUnionData, int count) {
        String pageID;
        FilterInfo filterinfo = param.getFilter();
        FilterItemInfo pageIDInfo = filterinfo.getFilterItem("pageID");
        ArrayList queryResult = new ArrayList();
        HashMap<String, String> countMap = new HashMap<String, String>();
        countMap.put("count", count + "");
        queryResult.add(countMap);
        try (DataSet ds = aftSTUnionData;){
            for (Row row : ds) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("personid", row.getString("personid"));
                map.put("name", row.getString("name"));
                map.put("processing", row.getString("processing"));
                map.put("allocated", row.getString("allocated"));
                map.put("taskcount", row.getString("taskcount"));
                map.put("rankcoefficient", row.getString("rankcoefficient"));
                map.put("processingrankcoefficient", row.getString("processingrankcoefficient"));
                queryResult.add(map);
            }
        }
        String string = pageID = pageIDInfo.getValue() == null ? "" : pageIDInfo.getValue().toString();
        if (!StringUtils.isEmpty((Object)pageID)) {
            SscDistributeCache.remove((String)pageID);
            SscDistributeCache.put((String)pageID, (Object)SerializationUtils.toJsonString(queryResult));
        }
    }

    private List<Map<String, String>> getCacheData(String pageID) {
        if (!StringUtils.isEmpty((Object)pageID)) {
            String queryResultStr = SscDistributeCache.get((String)pageID);
            List queryResultList = SerializationUtils.fromJsonStringToList((String)queryResultStr, Map.class);
            if (queryResultList != null && !queryResultList.isEmpty()) {
                return queryResultList;
            }
            return new ArrayList<Map<String, String>>();
        }
        return new ArrayList<Map<String, String>>();
    }

    public Map<Long, Double> getRankID(String pageID) {
        LinkedHashMap<Long, Double> rankList = new LinkedHashMap<Long, Double>(16);
        List<Map<String, String>> queryResultList = this.getCacheData(pageID);
        Map<String, String> countMap = queryResultList.get(0);
        int count = Integer.parseInt(countMap.get("count"));
        queryResultList.remove(0);
        int size = count > 5 ? count : 5;
        rankList.put(-1L, Double.valueOf(size));
        int personTaskCountSize = queryResultList.size();
        for (int i = 0; i < personTaskCountSize; ++i) {
            Map<String, String> map = queryResultList.get(i);
            rankList.put(Long.valueOf(map.get("personid")), Double.valueOf(map.get("rankcoefficient")));
        }
        return rankList;
    }

    Map<String, Double> getData(String pageID, String col) {
        LinkedHashMap<String, Double> map1 = new LinkedHashMap<String, Double>();
        try {
            List<Map<String, String>> queryResultList = this.getCacheData(pageID);
            queryResultList.remove(0);
            for (Map<String, String> map : queryResultList) {
                String dataStr = map.get(col);
                Double data = "0".equals(dataStr) || StringUtils.isEmpty((Object)dataStr) ? Double.valueOf(0.0) : Double.valueOf(dataStr);
                map1.put(map.get("name"), data);
            }
            return map1;
        }
        catch (Throwable e) {
            return new HashMap<String, Double>();
        }
    }

    private DataSet fastQuery(ReportQueryParam param, DateRangeEnum dateRangeEnum) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        for (FilterItemInfo itemInfo : filterItems) {
            QFilter qFilter;
            String propName = itemInfo.getPropName();
            if ("sharecenter.id".equalsIgnoreCase(propName)) {
                qFilter = new QFilter("sscid", itemInfo.getCompareType(), itemInfo.getValue());
                qFilters.add(qFilter);
                continue;
            }
            if (!"tasktype.id".equalsIgnoreCase(propName)) continue;
            qFilter = new QFilter("tasktypeid", itemInfo.getCompareType(), itemInfo.getValue());
            qFilters.add(qFilter);
        }
        qFilters.add(new QFilter("daterange", "=", (Object)dateRangeEnum.getValue()));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"task_task_personalrankhis", (String)"task_counttask", (String)"personid, personid.name as name, rankcoefficient, processingrankcoefficient, taskcount, processing, allocated", (QFilter[])qFilters.toArray(new QFilter[0]), null);
        dataSet = dataSet.groupBy(new String[]{"personid", "name"}).sum("rankcoefficient").sum("processingrankcoefficient").sum("taskcount").sum("processing").sum("allocated").finish();
        return dataSet;
    }

    private DataSet query2(ReportQueryParam param, Object object) {
        this.init(param);
        DataSet processingData = null;
        DataSet finishedData = null;
        DataSet unionData = null;
        String caseFilter = this.getRecvTimeCaseFilter(param);
        processingData = this.getProcessingData(param, object);
        finishedData = this.getFinishedData(param, object);
        unionData = processingData.union(finishedData);
        String[] groupBy = this.getGroupBy(param);
        GroupbyDataSet gbs = unionData.groupBy(groupBy).sum("cast(case when pooltype = '1' then 1 else 0 end as integer)", "processing");
        if (StringUtils.isEmpty((Object)caseFilter)) {
            gbs.sum("1", "allocated");
        } else {
            gbs = gbs.sum("cast(case when " + caseFilter + " then 1 else 0 end as integer)", "allocated");
        }
        gbs = gbs.sum("cast(case when pooltype = '2' then 1 else 0 end as integer)", "taskcount").sum("cast(case when pooltype = '2' then coefficient else 0 end as double)", "rankcoefficient").sum("cast(case when pooltype = '1' then coefficient else 0 end as double)", "processingrankcoefficient");
        unionData = gbs.finish();
        return unionData;
    }

    private String getRecvTimeCaseFilter(ReportQueryParam param) {
        List<String> recvTimeList = this.getReceiveTimeFilter(param);
        StringBuilder buf = new StringBuilder();
        int size = recvTimeList.size();
        for (int j = 0; j < size; ++j) {
            buf.append(recvTimeList.get(j));
            if (j >= size - 1) continue;
            buf.append(" and ");
        }
        String caseFilter = buf.toString();
        return caseFilter;
    }

    private List<String> getReceiveTimeFilter(ReportQueryParam param) {
        ArrayList<String> recvTimeList = new ArrayList<String>();
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        for (FilterItemInfo itemInfo : filterItems) {
            String propName = itemInfo.getPropName();
            if (!"receivetime".equals(propName)) continue;
            Date recTimeFiltDate = (Date)itemInfo.getValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(recTimeFiltDate);
            int recTimeFiltInt = calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
            String recvTimeFiltContStr = "cast(year(receivetime) as integer)*10000+cast( month(receivetime) as integer)*100+cast(day(receivetime) as integer)" + itemInfo.getCompareType() + recTimeFiltInt;
            recvTimeList.add(recvTimeFiltContStr);
        }
        return recvTimeList;
    }

    private DataSet getFinishedData(ReportQueryParam param, Object object) {
        ORM orm = ORM.create();
        DataSet ds = null;
        String fields = this.getFields(param);
        QFilter[] finishFilters = this.getFilters(param, "finish");
        ds = orm.queryDataSet("task_task_personalrankhis", "task_taskhistory", fields, finishFilters);
        return ds;
    }

    private DataSet getProcessingData(ReportQueryParam param, Object object) {
        ORM orm = ORM.create();
        DataSet ds = null;
        String fields = this.getFields(param);
        QFilter[] processingFilters = this.getFilters(param, "processing");
        ds = orm.queryDataSet("ssc.task.RptTaskPersonalRankPlugin.getProcessingData", "task_task", fields, processingFilters);
        return ds;
    }

    private String[] getGroupBy(ReportQueryParam param) {
        String[] groupBy = null;
        groupBy = new String[]{"personid", "name"};
        return groupBy;
    }

    private String getFields(ReportQueryParam param) {
        String selectField = "personid,personid.name as name, pooltype, coefficient, receivetime";
        return selectField;
    }

    private QFilter[] getFilters(ReportQueryParam param, String flag) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter qFilter = null;
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        QFilter notAutoProcess = new QFilter("autoprocess", "=", (Object)"0");
        qfList.add(notQuaCheckTask);
        qfList.add(notAutoProcess);
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        for (FilterItemInfo itemInfo : filterItems) {
            String propName = itemInfo.getPropName();
            if ("receivetime".equals(propName)) {
                if ("allocatedDoing".equals(flag) || "allocatedDone".equals(flag)) {
                    qFilter = new QFilter("receivetime", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                }
                if (!"finish".equals(flag)) continue;
                qFilter = new QFilter("completetime", itemInfo.getCompareType(), itemInfo.getValue());
                qfList.add(qFilter);
                continue;
            }
            if ("sharecenter.id".equals(propName)) {
                qFilter = new QFilter("sscid", itemInfo.getCompareType(), itemInfo.getValue());
                qfList.add(qFilter);
                continue;
            }
            if ("tasktype.id".equals(propName)) {
                qFilter = new QFilter("tasktypeid", itemInfo.getCompareType(), itemInfo.getValue());
                qfList.add(qFilter);
                continue;
            }
            if ("usergroup".equals(propName)) {
                qFilter = new QFilter("personid", "in", this.getUsersByUserGroupId((Long)itemInfo.getValue()));
                qfList.add(qFilter);
                continue;
            }
            if ("org".equals(propName)) {
                qFilter = new QFilter("orgid", itemInfo.getCompareType(), itemInfo.getValue());
                qfList.add(qFilter);
                continue;
            }
            if (!"billtypename".equals(propName)) continue;
            qFilter = new QFilter("billtype", itemInfo.getCompareType(), itemInfo.getValue());
            qfList.add(qFilter);
        }
        if ("processing".equals(flag) || "allocatedDoing".equals(flag)) {
            qFilter = new QFilter("pooltype", "=", (Object)"1");
            qfList.add(qFilter);
        } else if ("finish".equals(flag) || "allocatedDone".equals(flag)) {
            qFilter = new QFilter("pooltype", "=", (Object)"2");
            QFilter ishandledFilter = new QFilter("ishandled", "=", (Object)"0");
            qfList.add(qFilter);
            qfList.add(ishandledFilter);
        }
        qFilter = new QFilter("personid", "in", this.userSet);
        qfList.add(qFilter);
        return qfList.toArray(new QFilter[qfList.size()]);
    }

    private Set<Long> getUsersByUserGroupId(Long usergroupid) {
        HashSet<Long> users = new HashSet<Long>();
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter groupid = new QFilter("id", "=", (Object)usergroupid);
        DynamicObjectCollection dync = QueryServiceHelper.query((String)(((Object)((Object)this)).getClass().getName() + ".users"), (String)"task_usergroup", (String)"id,entryentity.userfield userid", (QFilter[])new QFilter[]{enable, status, groupid}, null);
        for (DynamicObject dyn : dync) {
            users.add(dyn.getLong("userid"));
        }
        return users;
    }
}

