/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.satisfiedmanage;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.formplugin.satisfiedmanage.SatisfiedAesUtil;
import kd.ssc.task.formplugin.satisfiedmanage.SatisfiedRequestUtil;
import kd.ssc.task.formplugin.satisfiedmanage.TenantInfoDTO;
import kd.ssc.task.https.HttpsClientUtil;
import kd.ssc.task.util.SSCBosUtil;

public class TenantCreatePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(TenantCreatePlugin.class);
    private static final String systemType = "ssc-task-formplugin";
    private static final String DAY_FORMAT = "yyyy/MM/dd";

    public void initialize() {
        super.initialize();
    }

    public List<ComboItem> setShareCenter(String entityName) {
        QFilter qFilter;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"12", (String)"ssc", (String)entityName, (String)"47150e89000000ac");
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            qFilter = new QFilter("fisscc", "=", (Object)"1");
        } else {
            List orgIDs = hasPermOrgs.getHasPermOrgs();
            qFilter = new QFilter("id", "in", (Object)orgIDs);
        }
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        return this.getComboItems(orgs);
    }

    private List<ComboItem> getComboItems(DynamicObject[] items) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        for (DynamicObject item : items) {
            ComboItem citem = new ComboItem();
            citem.setCaption(new LocaleString(item.get("name") + ""));
            citem.setValue(item.get("id") + "");
            list.add(citem);
        }
        return list;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] data = e.getChangeSet();
        Object newValue = data[0].getNewValue();
        if (newValue != null && StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"sscid") && QueryServiceHelper.exists((String)"task_satisfiedtenant", (QFilter[])new QFilter[]{new QFilter("sscid", "=", (Object)Long.valueOf(newValue.toString()))})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u5df2\u5b58\u5728\u6570\u636e\uff0c\u65e0\u6cd5\u91cd\u590d\u521b\u5efa\u3002", (String)"TenantCreatePlugin_4", (String)systemType, (Object[])new Object[0]));
            this.getModel().setValue("sscid", null);
            return;
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object formType = this.getView().getFormShowParameter().getCustomParam("formType");
        if ("create".equals(formType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"manageurl", "useraccount", "passwd"});
            List<ComboItem> comboItems = this.setShareCenter("task_satisfiedtenant");
            ComboEdit combo = (ComboEdit)this.getControl("sscid");
            combo.setComboItems(comboItems);
            String ssc = (String)this.getView().getFormShowParameter().getCustomParam("ssc");
            this.getModel().setValue("sscid", (Object)ssc);
            if (StringUtils.isNotBlank((CharSequence)ssc)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"sscid"});
            }
        } else if ("edit".equals(formType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"manageurl", "useraccount", "passwd"});
            List<ComboItem> comboItems = this.setShareCenter("task_satisfiedtenant");
            ComboEdit combo = (ComboEdit)this.getControl("sscid");
            combo.setComboItems(comboItems);
            Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"task_satisfiedtenant", (String)"mobile,email,sscid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            this.getModel().setValue("mobile", (Object)dynamicObject.getString("mobile"));
            this.getModel().setValue("email", (Object)dynamicObject.getString("email"));
            this.getModel().setValue("sscid", (Object)dynamicObject.getString("sscid.id"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"sscid"});
        } else if ("manual".equals(formType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mobile", "email"});
            List<ComboItem> comboItems = this.setShareCenter("task_satisfiedtenant");
            ComboEdit combo = (ComboEdit)this.getControl("sscid");
            combo.setComboItems(comboItems);
            Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"task_satisfiedtenant", (String)"mobile,email,sscid,superadmin,passwd", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            this.getModel().setValue("sscid", (Object)dynamicObject.getString("sscid.id"));
            this.getModel().setValue("mobile", (Object)dynamicObject.getString("mobile"));
            this.getModel().setValue("email", (Object)dynamicObject.getString("email"));
            this.getModel().setValue("useraccount", (Object)dynamicObject.getString("superadmin"));
            this.getModel().setValue("passwd", (Object)dynamicObject.getString("passwd"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"sscid", "useraccount"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object formType = this.getView().getFormShowParameter().getCustomParam("formType");
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("donothing_create".equals(args.getOperateKey()) && "create".equals(formType)) {
                String mobile = this.getModel().getValue("mobile").toString();
                String email = this.getModel().getValue("email").toString();
                String sscid = this.getModel().getValue("sscid").toString();
                if (!this.mobileVerify(mobile)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u624b\u673a\u53f7\u201d\u8bf7\u8f93\u516511\u4f4d\u6570\u5b57\u3002", (String)"TenantCreatePlugin_2", (String)systemType, (Object[])new Object[0]));
                    return;
                }
                if (email.length() > 50) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u90ae\u7bb1\u201d\u957f\u5ea6\u8d85\u8fc750\u4f4d\u3002", (String)"TenantCreatePlugin_3", (String)systemType, (Object[])new Object[0]));
                    return;
                }
                this.createTenantRequest(sscid, mobile, email);
            } else if ("donothing_create".equals(args.getOperateKey()) && "edit".equals(formType)) {
                String mobile = this.getModel().getValue("mobile").toString();
                String email = this.getModel().getValue("email").toString();
                if (!this.mobileVerify(mobile)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u624b\u673a\u53f7\u201d\u8bf7\u8f93\u516511\u4f4d\u6570\u5b57\u3002", (String)"TenantCreatePlugin_2", (String)systemType, (Object[])new Object[0]));
                    return;
                }
                if (email.length() > 50) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u90ae\u7bb1\u201d\u957f\u5ea6\u8d85\u8fc750\u4f4d\u3002", (String)"TenantCreatePlugin_3", (String)systemType, (Object[])new Object[0]));
                    return;
                }
                this.updateTenantRequest(mobile, email);
            } else if ("donothing_create".equals(args.getOperateKey()) && "manual".equals(formType)) {
                String passwd = this.getModel().getValue("passwd").toString();
                this.updateManual(passwd);
            }
        }
    }

    private boolean mobileVerify(String mobile) {
        if (mobile.length() != 11) {
            return false;
        }
        for (int i = 0; i < mobile.length(); ++i) {
            char c = mobile.charAt(i);
            if (c - 48 >= 0 && c - 57 <= 0) continue;
            return false;
        }
        return true;
    }

    private void updateManual(String passwd) {
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"task_satisfiedtenant", (String)"id,passwd", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        dynamicObject.set("passwd", (Object)passwd);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        this.getView().getParentView().setReturnData((Object)"YES");
        this.getView().close();
    }

    private void updateTenantRequest(String mobile, String email) {
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject updateDyn = QueryServiceHelper.queryOne((String)"task_satisfiedtenant", (String)"id,thirdorgid,instanceid,aeskey", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        String thirdOrgId = updateDyn.getString("thirdorgid");
        String tenantId = updateDyn.getString("instanceid");
        String aesKey = SSCBosUtil.getSscSettingInfo((String)"satisfiedasekey");
        String platformCode = SSCBosUtil.getSscSettingInfo((String)"satisfiedplatformcode");
        String manageUrl = SSCBosUtil.getSscSettingInfo((String)"satisfiedmanageurl");
        if (StringUtils.isBlank((CharSequence)platformCode) || StringUtils.isBlank((CharSequence)manageUrl) || StringUtils.isBlank((CharSequence)aesKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u95ee\u5377\u7cfb\u7edf\u53c2\u6570\uff0c\u7136\u540e\u91cd\u8bd5\u3002", (String)"TenantManageListPlugin_8", (String)systemType, (Object[])new Object[0]));
            return;
        }
        JSONObject dataObject = new JSONObject();
        dataObject.put("org_id", (Object)thirdOrgId);
        dataObject.put("email", (Object)email);
        dataObject.put("mobile", (Object)mobile);
        dataObject.put("instance_id", (Object)tenantId);
        String encryptByAes = null;
        try {
            encryptByAes = SatisfiedAesUtil.encryptByAes(dataObject.toJSONString(), aesKey);
        }
        catch (Exception e) {
            log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406\uff1a\u8bf7\u6c42\u6570\u636e\u52a0\u5bc6\u5f02\u5e38" + e);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", (String)"TenantCreatePlugin_0", (String)systemType, (Object[])new Object[0]), e), MessageBoxOptions.OK);
            return;
        }
        JSONObject paramObject = new JSONObject();
        paramObject.put("encrypt", (Object)encryptByAes);
        String url = manageUrl + "/api/open/v1/organization/" + platformCode;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("platformcode", platformCode);
        try {
            SatisfiedRequestUtil.prinfLog("TenantCreatePlugin-updateTenantRequest() request param: " + paramObject.toJSONString());
            String ret = HttpsClientUtil.executePut((String)url, (String)paramObject.toJSONString(), headerMap);
            SatisfiedRequestUtil.prinfLog("TenantCreatePlugin-updateTenantRequest() request result: " + ret);
            if (StringUtils.isBlank((CharSequence)ret)) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", (String)"TenantCreatePlugin_0", (String)systemType, (Object[])new Object[0]), "no result"), MessageBoxOptions.OK);
                log.info("\u6ee1\u610f\u5ea6\u7ba1\u7406\uff1a\u8bf7\u6c42\u66f4\u65b0\u79df\u6237\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                return;
            }
            JSONObject resultJson = JSONObject.parseObject((String)ret);
            JSONObject msgJ = new JSONObject();
            msgJ.put("code", resultJson.get((Object)"code"));
            msgJ.put("msg", resultJson.get((Object)"msg"));
            String msg = msgJ.toJSONString();
            if ("0".equals(resultJson.getString("code"))) {
                String encrypt = resultJson.getString("encrypt");
                String data = SatisfiedAesUtil.decryptByAes(encrypt, aesKey);
                resultJson = JSONObject.parseObject((String)data);
                String managentUrl = resultJson.getJSONObject("data").getString("url");
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"task_satisfiedtenant");
                dynamicObject.set("id", (Object)id);
                dynamicObject.set("mobile", (Object)mobile);
                dynamicObject.set("email", (Object)email);
                dynamicObject.set("url", (Object)managentUrl);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
                this.getView().getParentView().setReturnData((Object)"YES");
                this.getView().close();
            } else {
                log.info("\u6ee1\u610f\u5ea6\u7ba1\u7406\uff1a\u8bf7\u6c42\u79df\u6237\u66f4\u65b0\u5931\u8d25,\u8fd4\u56de\u9519\u8bef\uff1a" + msg);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", (String)"TenantCreatePlugin_0", (String)systemType, (Object[])new Object[0]), msg), MessageBoxOptions.OK);
            }
        }
        catch (Exception e) {
            log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406\uff1a\u8bf7\u6c42\u521b\u5efa\u79df\u6237\u63a5\u53e3\u5f02\u5e38" + e);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", (String)"TenantCreatePlugin_0", (String)systemType, (Object[])new Object[0]), e), MessageBoxOptions.OK);
        }
    }

    private void createTenantRequest(String sscid, String mobile, String email) {
        String aseKey = SSCBosUtil.getSscSettingInfo((String)"satisfiedasekey");
        String platformCode = SSCBosUtil.getSscSettingInfo((String)"satisfiedplatformcode");
        String manageUrl = SSCBosUtil.getSscSettingInfo((String)"satisfiedmanageurl");
        if (StringUtils.isBlank((CharSequence)platformCode) || StringUtils.isBlank((CharSequence)manageUrl) || StringUtils.isBlank((CharSequence)aseKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u95ee\u5377\u7cfb\u7edf\u53c2\u6570\uff0c\u7136\u540e\u91cd\u8bd5\u3002", (String)"TenantManageListPlugin_8", (String)systemType, (Object[])new Object[0]));
            return;
        }
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        tenantId = tenantId + accountId + sscid;
        JSONObject dataObject = new JSONObject();
        String emailDesensitization = email.replaceAll("(^\\w)[^@]*(@.*$)", "$1****$2");
        String mobileDesensitization = mobile.replaceAll("(\\d{3})\\d*(\\d{2})", "$1****$2");
        dataObject.put("email", (Object)emailDesensitization);
        dataObject.put("mobile", (Object)mobileDesensitization);
        dataObject.put("instance_id", (Object)tenantId);
        SatisfiedRequestUtil.prinfLog("TenantCreatePlugin-createTenantRequest() request param: " + dataObject.toJSONString());
        String encryptByAes = null;
        try {
            dataObject.put("email", (Object)email);
            dataObject.put("mobile", (Object)mobile);
            encryptByAes = SatisfiedAesUtil.encryptByAes(dataObject.toJSONString(), aseKey);
        }
        catch (Exception e) {
            log.error("TenantCreatePlugin-createTenantRequest() request param encrypt exception" + e);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u79df\u6237\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", (String)"TenantCreatePlugin_1", (String)systemType, (Object[])new Object[0]), e), MessageBoxOptions.OK);
            return;
        }
        JSONObject paramObject = new JSONObject();
        paramObject.put("encrypt", (Object)encryptByAes);
        String url = manageUrl + "/api/open/v1/organization/" + platformCode;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("platformcode", platformCode);
        try {
            SatisfiedRequestUtil.prinfLog("TenantCreatePlugin-createTenantRequest() request param: " + paramObject.toJSONString());
            String ret = HttpsClientUtil.executePost((String)url, (String)paramObject.toJSONString(), headerMap);
            SatisfiedRequestUtil.prinfLog("TenantCreatePlugin-createTenantRequest() request result: " + ret);
            if (StringUtils.isBlank((CharSequence)ret)) {
                log.info("\u6ee1\u610f\u5ea6\u7ba1\u7406\uff1a\u8bf7\u6c42\u521b\u5efa\u79df\u6237\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u79df\u6237\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", (String)"TenantCreatePlugin_1", (String)systemType, (Object[])new Object[0]), "no result"), MessageBoxOptions.OK);
                return;
            }
            JSONObject resultJson = JSONObject.parseObject((String)ret);
            JSONObject msgJ = new JSONObject();
            msgJ.put("code", resultJson.get((Object)"code"));
            msgJ.put("msg", resultJson.get((Object)"msg"));
            String msg = msgJ.toJSONString();
            if ("0".equals(resultJson.getString("code"))) {
                String encrypt = resultJson.getString("encrypt");
                String data = SatisfiedAesUtil.decryptByAes(encrypt, aseKey);
                resultJson = JSONObject.parseObject((String)data);
                this.SaveTenantInfo(sscid, resultJson);
            } else if ("204".equals(resultJson.getString("code"))) {
                ret = HttpsClientUtil.executeGet((String)(url = url + "?instance_id=" + tenantId), headerMap);
                resultJson = JSONObject.parseObject((String)ret);
                if ("0".equals(resultJson.getString("code"))) {
                    String encrypt = resultJson.getString("encrypt");
                    String data = SatisfiedAesUtil.decryptByAes(encrypt, aseKey);
                    resultJson = JSONObject.parseObject((String)data);
                    this.SaveTenantInfo(sscid, resultJson);
                } else {
                    log.info("\u6ee1\u610f\u5ea6\u7ba1\u7406\uff1a\u8bf7\u6c42\u67e5\u8be2\u79df\u6237\u63a5\u53e3\u5931\u8d25,\u8fd4\u56de\u9519\u8bef\uff1a" + msg);
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u79df\u6237\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", (String)"TenantCreatePlugin_1", (String)systemType, (Object[])new Object[0]), msg), MessageBoxOptions.OK);
                }
            } else {
                log.info("\u6ee1\u610f\u5ea6\u7ba1\u7406\uff1a\u8bf7\u6c42\u521b\u5efa\u79df\u6237\u63a5\u53e3\u5931\u8d25,\u8fd4\u56de\u9519\u8bef\uff1a" + msg);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u79df\u6237\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", (String)"TenantCreatePlugin_1", (String)systemType, (Object[])new Object[0]), msg), MessageBoxOptions.OK);
            }
        }
        catch (Exception e) {
            log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406\uff1a\u8bf7\u6c42\u521b\u5efa\u79df\u6237\u63a5\u53e3\u5f02\u5e38" + e);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u79df\u6237\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a%s", (String)"TenantCreatePlugin_1", (String)systemType, (Object[])new Object[0]), e), MessageBoxOptions.OK);
        }
    }

    private void SaveTenantInfo(String sscid, JSONObject resultJson) {
        TenantInfoDTO info = (TenantInfoDTO)SerializationUtils.fromJsonString((String)resultJson.getString("data"), TenantInfoDTO.class);
        StringBuilder infoStr = new StringBuilder(info.toString());
        SimpleDateFormat sdf = new SimpleDateFormat(DAY_FORMAT);
        SatisfiedRequestUtil.prinfLog("TenantCreatePlugin-SaveTenantInfo() typeCase Result " + infoStr);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"task_satisfiedtenant");
        dynamicObject.set("mobile", (Object)info.getMobile());
        dynamicObject.set("email", (Object)info.getEmail());
        dynamicObject.set("thirdorgid", (Object)info.getOrg_id());
        dynamicObject.set("superadmin", (Object)info.getUsername());
        dynamicObject.set("expiredatatime", (Object)info.getExpire_dt());
        try {
            String expiredate = info.getExpire_dt();
            if (StringUtils.isBlank((CharSequence)expiredate)) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(1, 1);
                dynamicObject.set("expiredate", (Object)calendar.getTime());
            } else {
                dynamicObject.set("expiredate", (Object)sdf.parse(expiredate));
            }
        }
        catch (ParseException e) {
            log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406\uff1a\u65e5\u671f\u8f6c\u6362\u51fa\u9519", (Throwable)e);
        }
        dynamicObject.set("instanceid", (Object)info.getInstance_id());
        dynamicObject.set("userstatus", (Object)info.getStatus());
        dynamicObject.set("secretkey", (Object)info.getSecret_key());
        dynamicObject.set("aeskey", (Object)info.getAes_key());
        dynamicObject.set("url", (Object)info.getUrl());
        dynamicObject.set("sscid", (Object)sscid);
        dynamicObject.set("enable", (Object)1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        this.getView().getParentView().setReturnData((Object)"YES");
        this.getView().close();
    }
}

