/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.sla.init;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.util.SscLicenseUtil;

public class SlaInitListPlugin
extends AbstractListPlugin {
    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String version = LicenseServiceHelper.getProductVersion();
        if ("5.0".equals(version)) {
            SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)"sla_init_new");
        }
        super.preOpenForm(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List comFilters = args.getCommonFilterColumns();
        for (FilterColumn column : comFilters) {
            String sscId;
            CommonFilterColumn comFilter = (CommonFilterColumn)column;
            if (!comFilter.getFieldName().equals("org.name")) continue;
            comFilter.setMulti(false);
            List comboItems = comFilter.getComboItems();
            List defaultValue = comFilter.getDefaultValues();
            if ((defaultValue == null || defaultValue.isEmpty()) && comboItems != null && !comboItems.isEmpty()) {
                comFilter.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
            }
            if (StringUtils.isEmpty((String)(sscId = this.getPageCache().get("ssc")))) {
                sscId = comFilter.getDefaultValues().get(0) + "";
                this.getPageCache().put("ssc", sscId);
                continue;
            }
            comFilter.setDefaultValue(sscId);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            String curFieldName = "";
            String curValue = "";
            if (currentCommonFilter.containsKey("FieldName") && ((List)currentCommonFilter.get("FieldName")).size() > 0) {
                curFieldName = (String)((List)currentCommonFilter.get("FieldName")).get(0);
            }
            if (currentCommonFilter.containsKey("Value") && ((List)currentCommonFilter.get("Value")).size() > 0) {
                curValue = (String)((List)currentCommonFilter.get("Value")).get(0) + "";
            }
            String oldSSC = this.getPageCache().get("ssc");
            if ("org.id".equals(curFieldName) && !curValue.equals(oldSSC)) {
                this.getPageCache().put("ssc", curValue);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if ("initsetting".equals(operate.getOperateKey()) && !selectedRows.isEmpty() && selectedRows.size() > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"SlaContractDetailsListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        if ("modify".equals(operate.getOperateKey())) {
            // empty if block
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("initsetting".equals(operateKey) && args.getOperationResult().isSuccess()) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            this.initSetting(selectedRows);
        } else if ("finishinit".equals(operateKey) || "resetinit".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("setting".equals(e.getActionId())) {
            if ("save".equals(e.getReturnData())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SlaInitListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void initSetting(ListSelectedRowCollection selectedRows) {
        String ssc = this.getPageCache().get("ssc");
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            if (StringUtils.isEmpty((String)ssc)) {
                this.openSettingForm("", null);
            } else {
                QFilter qFilters = new QFilter("org", "=", (Object)Long.parseLong(ssc));
                DynamicObject initDyo = QueryServiceHelper.queryOne((String)"sla_init_new", (String)"id", (QFilter[])qFilters.toArray());
                if (initDyo != null) {
                    Object initId = initDyo.get("id");
                    this.verifyInitVariable(initId);
                } else {
                    this.openSettingForm(ssc, null);
                }
            }
        } else {
            Object initId = selectedRows.get(0).getPrimaryKeyValue();
            this.verifyInitVariable(initId);
        }
    }

    private void verifyInitVariable(Object initId) {
        DynamicObject slaInit = BusinessDataServiceHelper.loadSingle((Object)initId, (String)"sla_init_new", (String)"id,isfinishinit,org");
        if (slaInit.getBoolean("isfinishinit")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SlaInitListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String org = slaInit.getString("org.id");
        QFilter qFilters = new QFilter("org", "=", (Object)Long.parseLong(org));
        qFilters.and("isperiod", "=", (Object)"1");
        boolean existsBill = QueryServiceHelper.exists((String)"sla_servicebill", (QFilter[])qFilters.toArray());
        boolean existsContract = QueryServiceHelper.exists((String)"sla_servicecontract", (QFilter[])qFilters.toArray());
        if (existsBill || existsContract) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5b58\u5728\u671f\u521d\u5355\u636e\uff0c\u4e0d\u80fd\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SlaInitListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openSettingForm(org, initId);
    }

    private void openSettingForm(String ssc, Object slaInitId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("ssc", (Object)ssc);
        if (slaInitId != null) {
            parameter.setCustomParam("slainit", slaInitId);
        }
        parameter.setFormId("sla_initsetting");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setting");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }
}

