/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartApproval;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.ssc.credit.SubScoreRuleHelper;
import kd.ssc.enums.ApprovalOperationEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.smartApproval.enums.IsPassEnum;
import kd.ssc.smartApproval.enums.IsSuccessEnum;
import kd.ssc.smartApproval.pojo.SmartApprovalPredictedResult;
import kd.ssc.task.formplugin.pojo.FactorInfo;
import kd.ssc.task.formplugin.smartApproval.AffectFactorParser;
import kd.ssc.task.formplugin.util.WithdrawalSelectorUtil;
import kd.ssc.task.partask.util.PartaskUniversalUtil;

public class PredictedDataHelper {
    private static final Log log = LogFactory.getLog(PredictedDataHelper.class);

    public static SmartApprovalPredictedResult getPredictedDataByTask(Long taskId) {
        SmartApprovalPredictedResult predictedData = new SmartApprovalPredictedResult();
        String selectField = "taskid,predictsuccess,predictpass,predictpassratio,affect,withdrawal,operation,breakrule,similartask";
        QFilter filter = new QFilter("taskid", "=", (Object)taskId);
        DynamicObject originalPredictedData = QueryServiceHelper.queryOne((String)"task_approval_result", (String)selectField, (QFilter[])new QFilter[]{filter});
        if (originalPredictedData == null) {
            log.info("No prediction result. taskId = " + taskId);
            predictedData.setIsSuccess(IsSuccessEnum.failure);
            return predictedData;
        }
        String isSuccess = originalPredictedData.getString("predictsuccess");
        IsSuccessEnum isSuccessEnum = IsSuccessEnum.getEnumByCode((String)isSuccess);
        predictedData.setIsSuccess(isSuccessEnum);
        if (isSuccessEnum == IsSuccessEnum.success) {
            String isPass = originalPredictedData.getString("predictpass");
            IsPassEnum isPassEnum = IsPassEnum.getEnumByCode((String)isPass);
            predictedData.setIsPass(isPassEnum);
            BigDecimal passFailProbability = originalPredictedData.getBigDecimal("predictpassratio");
            predictedData.setPassFailProbability(passFailProbability);
            String suggestDetail = PredictedDataHelper.getSuggestDetail(originalPredictedData);
            predictedData.setSuggestDetail(suggestDetail);
            String orOperation = originalPredictedData.getString("operation");
            List<String> operations = PredictedDataHelper.getFactorList(orOperation);
            operations = PredictedDataHelper.legalOperations(operations, taskId);
            predictedData.setOperation(operations);
            String orWithdrawal = originalPredictedData.getString("withdrawal");
            List<String> withdrawals = PredictedDataHelper.getFactorList(orWithdrawal);
            withdrawals = PredictedDataHelper.legalWithdrawals(withdrawals, taskId);
            predictedData.setWithdrawal(withdrawals);
            String orBreakrule = originalPredictedData.getString("breakrule");
            List<String> breakrules = PredictedDataHelper.getFactorList(orBreakrule);
            breakrules = PredictedDataHelper.legalBreakRules(breakrules, isPassEnum, taskId);
            predictedData.setBreakrule(breakrules);
            String orSimilartask = originalPredictedData.getString("similartask");
            List<String> similartasks = PredictedDataHelper.getFactorList(orSimilartask);
            similartasks = PredictedDataHelper.legalSimilarTasks(similartasks);
            predictedData.setSimilartask(similartasks);
        }
        return predictedData;
    }

    private static List<String> legalOperations(List<String> operations, Long taskId) {
        if (operations == null || operations.size() == 0) {
            return Collections.emptyList();
        }
        if (!QueryServiceHelper.exists((String)"task_task", (Object)taskId)) {
            return Collections.emptyList();
        }
        HashSet<String> retainOperations = new HashSet<String>(operations);
        retainOperations.retainAll(ApprovalOperationEnum.actualValues());
        boolean isStart = false;
        try {
            isStart = PartaskUniversalUtil.isStartInProcessing((long)taskId);
        }
        catch (Exception e) {
            log.error("\u521d\u5ba1\u4efb\u52a1\u5224\u65ad\u5f02\u5e38", (Throwable)e);
            return Collections.emptyList();
        }
        if (isStart) {
            retainOperations.remove(ApprovalOperationEnum.REPLUSE2SSC.getValue());
        }
        operations.retainAll(retainOperations);
        return operations;
    }

    private static List<String> legalWithdrawals(List<String> withdrawals, Long taskId) {
        if (withdrawals == null || withdrawals.size() == 0) {
            return Collections.emptyList();
        }
        if (!QueryServiceHelper.exists((String)"task_task", (Object)taskId)) {
            return Collections.emptyList();
        }
        List recommands = withdrawals.stream().map(Long::valueOf).collect(Collectors.toList());
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_task", (String)"sscid,billtype,tasktypeid", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
        long sscid = task.getLong("sscid");
        long billtypeId = task.getLong("billtype");
        long tasktypeId = task.getLong("tasktypeid");
        QFilter existFilter = new QFilter("id", "in", recommands);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_withdrawal", (Long)sscid);
        List enables = QueryServiceHelper.query((String)"task_withdrawal", (String)"id", (QFilter[])new QFilter[]{existFilter, enableFilter, baseDataFilter}).stream().map(d -> d.get("id") + "").collect(Collectors.toList());
        WithdrawalSelectorUtil withdrawalSelector = new WithdrawalSelectorUtil();
        List isAssign = withdrawalSelector.getWithdrawalIdBybilltypeAndTasktype(billtypeId, tasktypeId).stream().map(v -> v + "").collect(Collectors.toList());
        withdrawals.retainAll(enables);
        withdrawals.retainAll(isAssign);
        return withdrawals;
    }

    private static List<String> legalBreakRules(List<String> breakrules, IsPassEnum isPassEnum, Long taskId) {
        if (breakrules == null || breakrules.size() == 0) {
            return Collections.emptyList();
        }
        if (!QueryServiceHelper.exists((String)"task_task", (Object)taskId)) {
            return Collections.emptyList();
        }
        if (isPassEnum == IsPassEnum.pass) {
            List recommands = breakrules.stream().map(Long::valueOf).collect(Collectors.toList());
            QFilter existFilter = new QFilter("id", "in", recommands);
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter typeFilter = new QFilter("type", "=", (Object)"1");
            List enables = QueryServiceHelper.query((String)"fircm_subscorerule", (String)"id", (QFilter[])new QFilter[]{existFilter, enableFilter, typeFilter}).stream().map(d -> d.get("id") + "").collect(Collectors.toList());
            breakrules.retainAll(enables);
            List allocates = SubScoreRuleHelper.getBillRelationSubScoreRuleByTask((Long)taskId, (String)TaskPoolTypeEnum.PROCESSING.getValue()).stream().map(l -> l + "").collect(Collectors.toList());
            breakrules.retainAll(allocates);
        }
        return breakrules;
    }

    private static List<String> legalSimilarTasks(List<String> similartasks) {
        List hisTaskIds = similartasks.stream().map(Long::valueOf).collect(Collectors.toList());
        DynamicObjectCollection similarHisTask = QueryServiceHelper.query((String)"task_taskhistory", (String)"id", (QFilter[])new QFilter("id", "in", hisTaskIds).toArray());
        return similarHisTask.stream().map(d -> d.get("id") + "").collect(Collectors.toList());
    }

    private static String getSuggestDetail(DynamicObject original) {
        String text;
        HashMap<String, FactorInfo> factorMap = AffectFactorParser.parseAffectFactorInfo(original);
        List factorInfoList = factorMap.values().stream().sorted((e1, e2) -> e2.getValue().compareTo(e1.getValue())).limit(5L).collect(Collectors.toList());
        List<String> factorFields = factorInfoList.stream().map(FactorInfo::getField).collect(Collectors.toList());
        if (!factorFields.isEmpty()) {
            StringJoiner joiner = new StringJoiner("\u3001");
            factorFields.forEach(joiner::add);
            text = joiner.toString();
        } else {
            text = ResManager.loadKDString((String)"\u4fe1\u7528\u5206\u6570\u3001\u5904\u7406\u4eba\u3001\u4efb\u52a1\u72b6\u6001", (String)"PredictedDataHelper_2", (String)"ssc-task-common", (Object[])new Object[0]);
        }
        String description = ResManager.loadKDString((String)"\u7531\u4e8e%1$s\u7b49\u56e0\u7d20\u7684\u5f71\u54cd%2$s", (String)"PredictedDataHelper_0", (String)"ssc-task-common", (Object[])new Object[0]);
        return String.format(description, text, "\uff0c");
    }

    private static List<String> getFactorList(String jsonString) {
        Object[] paramValues;
        ArrayList<String> result = new ArrayList<String>(5);
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return result;
        }
        JSONArray paramValueJson = JSONObject.parseArray((String)jsonString);
        for (Object va : paramValues = paramValueJson.toArray()) {
            result.add(va.toString());
        }
        return result;
    }
}

