/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartcs;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SmartcsStaffEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener,
BeforeQuickAddNewListener {
    private static final Log logger = LogFactory.getLog(SmartcsStaffEditPlugin.class);
    private final Supplier<Long> sscIdSup = () -> Optional.ofNullable(this.getView().getFormShowParameter().getCustomParams().get("createorg")).map(ssc -> Long.valueOf(ssc.toString())).orElse(null);
    private boolean initialized = false;

    public void preOpenForm(PreOpenFormEventArgs e) {
        Object sscId = e.getFormShowParameter().getCustomParams().get("createorg");
        if (sscId == null) {
            logger.error(ResManager.loadKDString((String)"\u9875\u9762\u672a\u643a\u5e26\u5171\u4eab\u4e2d\u5fc3\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SmartcsKDString_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            e.setCancelMessage(ResManager.loadKDString((String)"\u9875\u9762\u672a\u643a\u5e26\u5171\u4eab\u4e2d\u5fc3\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SmartcsKDString_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            super.preOpenForm(e);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("createorg", (Object)this.sscIdSup.get());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadShowEntity(this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW);
    }

    public void registerListener(EventObject e) {
        BasedataEdit groupId;
        BasedataEdit userid = (BasedataEdit)this.getControl("userid");
        if (userid != null) {
            userid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            userid.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((groupId = (BasedataEdit)this.getControl("s_groupid")) != null) {
            groupId.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            groupId.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            args.setCancel(true);
            if (this.validateEntry()) {
                this.saveBill();
            }
        }
        if (args.getSource() instanceof SaveAndNew) {
            this.getView().invokeOperation("new");
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Long sscId = this.sscIdSup.get();
        String eventName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.setF7Style(3);
        List f7Filters = listShowParameter.getListFilterParameter().getQFilters();
        switch (eventName) {
            case "s_groupid": {
                ArrayList<Long> groupIds = new ArrayList<Long>();
                this.getGroupsInModel(this.getModel().getEntryEntity("s_entryentity"), "s_groupid", groupIds);
                QFilter groupsNotShow = new QFilter("createorg", "=", (Object)sscId);
                if (!groupIds.isEmpty()) {
                    groupsNotShow.and(new QFilter("id", "not in", groupIds));
                }
                f7Filters.add(groupsNotShow);
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        if (afterF7SelectEvent.getSource() instanceof UserEdit) {
            Long userId = null;
            DynamicObject user = (DynamicObject)this.getModel().getValue("userid");
            if (user != null) {
                userId = user.getLong("id");
                QFilter userWithSSC = new QFilter("userid", "=", (Object)userId).and("createorg", "=", (Object)this.sscIdSup.get());
                try (TXHandle txHandle = TX.requiresNew();){
                    DynamicObject staffPKValue = QueryServiceHelper.queryOne((String)"som_smartcs_staff", (String)"id", (QFilter[])new QFilter[]{userWithSSC});
                    this.changeUser(userId, staffPKValue);
                }
            } else {
                this.changeUser(userId, null);
            }
        }
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent event) {
        BasedataEdit baseData = (BasedataEdit)event.getSource();
        String key = baseData.getKey();
        FormShowParameter showParameter = event.getShowParameter();
        this.getPageCache().put("createorg", this.sscIdSup.get().toString());
        if ("s_groupid".equals(key)) {
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
    }

    private void getGroupsInModel(DynamicObjectCollection groups, String identifier, List<Long> groupIds) {
        for (DynamicObject dyo : groups) {
            Optional.ofNullable(dyo.getDynamicObject(identifier)).map(g -> g.getLong("id")).ifPresent(groupIds::add);
        }
    }

    private void changeUser(Long userId, Object pkValue) {
        IDataModel model = this.getModel();
        DynamicObjectCollection show = model.getEntryEntity("s_entryentity");
        model.beginInit();
        if (pkValue != null) {
            Object id = ((DynamicObject)pkValue).get("id");
            IBillModel billModel = (IBillModel)model;
            billModel.setPKValue(id);
            billModel.load(id);
        } else {
            DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)"som_smartcs_staff");
            model.createNewData((Object)newData);
            model.setValue("status", (Object)"C");
            model.setValue("creator", (Object)RequestContext.get().getCurrUserId());
            if (userId != null) {
                model.setValue("userid", (Object)userId);
            }
        }
        model.updateCache();
        model.endInit();
        model.setDataChanged(false);
        model.deleteEntryData("s_entryentity");
        for (DynamicObject dyo : show) {
            int newEntryRow = model.createNewEntryRow("s_entryentity");
            model.setValue("s_groupid", dyo.get("s_groupid"), newEntryRow);
        }
        this.getView().updateView("s_entryentity");
    }

    private void loadShowEntity(boolean addNew) {
        IDataModel model = this.getModel();
        model.setValue("createorg", (Object)this.sscIdSup.get());
        Object groupId = this.getView().getFormShowParameter().getCustomParam("s_groupid");
        DynamicObjectCollection show = model.getEntryEntity("s_entryentity");
        if (addNew) {
            if (!show.isEmpty() && groupId != null) {
                model.setValue("s_groupid", groupId, 0);
            }
        } else if (show.isEmpty()) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            for (DynamicObject entry : entryEntity) {
                DynamicObject row = show.addNew();
                DynamicObject modelRow = entry.getDynamicObject("groupid");
                row.set("s_groupid", (Object)modelRow);
                if (this.initialized) continue;
                row.getDataEntityState().setFromDatabase(true);
            }
            this.initialized = true;
            model.updateEntryCache(show);
        }
        this.getView().updateView("s_entryentity");
    }

    private boolean validateEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("s_entryentity");
        if (entryEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u7ec4\u4fe1\u606f\u201d\u3002", (String)"SmartcsStaffSavePlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean isAllEmpty = true;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)entryEntity.get(i);
            if (object.get("s_groupid") == null) continue;
            isAllEmpty = false;
            break;
        }
        if (isAllEmpty) {
            if (entryEntity.size() == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5206\u7ec4\u4fe1\u606f\u201d\u7b2c1\u884c:\u201c\u7ec4\u540d\u201d\u3002", (String)"SmartcsStaffSavePlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return false;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ec4\u540d\u201d\u3002", (String)"SmartcsStaffSavePlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            if (((DynamicObject)iterator.next()).get("s_groupid") != null) continue;
            iterator.remove();
        }
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("s_entryentity");
        return true;
    }

    private void saveBill() {
        DynamicObject showEntry;
        DynamicObject billData;
        DynamicObjectCollection entryEntity;
        IDataModel model = this.getModel();
        DynamicObject[] dbData = BusinessDataServiceHelper.load((Object[])new Object[]{model.getValue("id")}, (DynamicObjectType)model.getDataEntityType());
        if (dbData == null || dbData.length == 0) {
            entryEntity = model.getEntryEntity("entryentity");
            entryEntity.clear();
            billData = model.getDataEntity();
        } else {
            billData = dbData[0];
            entryEntity = billData.getDynamicObjectCollection("entryentity");
        }
        DynamicObjectCollection showEntryEntity = model.getEntryEntity("s_entryentity");
        ArrayList<Integer> newGroups = new ArrayList<Integer>(showEntryEntity.size());
        for (int i = 0; i < showEntryEntity.size(); ++i) {
            boolean isNew = true;
            showEntry = (DynamicObject)showEntryEntity.get(i);
            long newGroupId = showEntry.getDynamicObject("s_groupid").getLong("id");
            for (DynamicObject entry : entryEntity) {
                if (newGroupId != entry.getDynamicObject("groupid").getLong("id")) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            newGroups.add(i);
        }
        Iterator iterator = newGroups.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            showEntry = (DynamicObject)showEntryEntity.get(i);
            DynamicObject dbEntry = entryEntity.addNew();
            dbEntry.set("groupid", (Object)showEntry.getDynamicObject("s_groupid"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billData});
        model.setDataChanged(false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SmartcsStaffSavePlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }
}

