/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.achieve.AchieveDateUtil;
import kd.ssc.achieve.BitSetUtil;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.enums.workcalendar.SscDateType;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.task.common.workcalendar.SscWorkCalendarApi;
import kd.ssc.task.formplugin.achieve.AchieveSchemeFormPlugin;
import kd.ssc.task.formplugin.pojo.achieve.AchieveExpEnum;
import kd.ssc.task.formplugin.pojo.achieve.AchieveExpInfo;
import kd.ssc.task.formplugin.pojo.achieve.PersonalInfo;
import kd.ssc.task.formplugin.pojo.achieve.UserOnDutyTime;
import kd.ssc.task.formplugin.util.DateUtil;

public class AchieveUtil {
    private static final Log log = LogFactory.getLog(AchieveUtil.class);

    public static List<Long> getSscCenters() {
        List<Long> ids = new ArrayList<Long>(16);
        String selectFields = "id";
        QFilter filter = new QFilter("fisscc", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (orgs != null && !orgs.isEmpty()) {
            ids = orgs.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        }
        return ids;
    }

    public static List<Long> getGroups(Long sscId) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        QFilter gfilter = new QFilter("createorg", "=", (Object)sscId);
        String selectFields = "id,createorg";
        DynamicObjectCollection groups = QueryServiceHelper.query((String)"task_usergroup", (String)selectFields, (QFilter[])new QFilter[]{gfilter});
        Set<Object> groupIds = new HashSet(16);
        if (groups != null && !groups.isEmpty()) {
            groupIds = groups.stream().map(g -> g.getLong("id")).collect(Collectors.toSet());
        }
        ids.addAll(groupIds);
        return ids;
    }

    public static List<Long> getUsers(Long sscId, Long groupId) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        Set<Object> uIds = new HashSet(16);
        QFilter gfilter = new QFilter("createorg", "=", (Object)sscId);
        gfilter.and("id", "=", (Object)groupId);
        String selectFields = "id,createorg,entryentity.userfield";
        DynamicObjectCollection userIds = QueryServiceHelper.query((String)"task_usergroup", (String)selectFields, (QFilter[])new QFilter[]{gfilter});
        if (userIds != null && !userIds.isEmpty()) {
            uIds = userIds.stream().map(g -> g.getLong("entryentity.userfield")).collect(Collectors.toSet());
        }
        ids.addAll(uIds);
        return ids;
    }

    public static List<Long> getExistWorkCalendarSsc(List<Long> orgIds, Date nowDate) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        QFilter filters = new QFilter("ssccenter", "in", orgIds);
        filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()));
        filters.and(new QFilter("dateentry.date", "=", (Object)nowDate));
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"id,ssccenter", (QFilter[])new QFilter[]{filters});
        if (orgs != null && !orgs.isEmpty()) {
            Set idSets = orgs.stream().map(o -> o.getLong("ssccenter")).collect(Collectors.toSet());
            ids.addAll(idSets);
        }
        return ids;
    }

    public static DynamicObjectCollection getDatas(List<Long> orgIds, List<Long> groupIds, Date nowDate, List<Long> userIdList) {
        QFilter filters = new QFilter("ssccenter", "in", orgIds);
        if (groupIds != null && (userIdList == null || userIdList.size() == 0)) {
            filters.and(new QFilter("dateentry.usergroup", "in", groupIds));
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.GROUP.getValue()));
        } else if (groupIds != null) {
            filters.and(new QFilter("dateentry.user", "in", userIdList));
            filters.and(new QFilter("dateentry.usergroup", "in", groupIds));
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.EMPLOYEE.getValue()));
        } else {
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()));
        }
        filters.and(new QFilter("dateentry.date", "=", (Object)nowDate));
        return QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"id,dateentry.id,dateentry.level,dateentry.ssc,dateentry.usergroup,dateentry.datetype,dateentry.user,dateentry.timeentry.*", (QFilter[])new QFilter[]{filters});
    }

    /*
     * WARNING - void declaration
     */
    public static String saveUserTime(Date beforeDay, List<Long> sscIds) {
        String result = "";
        HashMap<Long, List<Long>> ssc_groupMap = new HashMap<Long, List<Long>>(16);
        List<Long> existSscId = null;
        try {
            existSscId = sscIds == null || sscIds.isEmpty() ? AchieveUtil.getExistWorkCalendarSsc(AchieveUtil.getSscCenters(), beforeDay) : AchieveUtil.getExistWorkCalendarSsc(sscIds, beforeDay);
            log.info("\u9700\u8981\u91cd\u7b97\u7684\u5171\u4eab\u4e2d\u5fc3\uff1a" + existSscId.toString());
            for (Long l : existSscId) {
                List<Long> list = AchieveUtil.getGroups(l);
                if (list.isEmpty()) continue;
                ssc_groupMap.put(l, list);
            }
            ArrayList<PersonalInfo> personalInfos = new ArrayList<PersonalInfo>(16);
            for (Map.Entry entry : ssc_groupMap.entrySet()) {
                Long sscid = (Long)entry.getKey();
                List groupIds = (List)entry.getValue();
                List<Object> users = new ArrayList(16);
                log.info("\u5171\u4eab\u4e2d\u5fc3\uff1a" + sscid + "\uff0c\u5305\u542b\u7528\u6237\u7ec4\uff1a" + groupIds.toString());
                for (Long gid : groupIds) {
                    users = AchieveUtil.getUsers(sscid, gid);
                    if (users.isEmpty()) continue;
                    PersonalInfo personalInfo = new PersonalInfo();
                    personalInfo.setSscId(sscid);
                    personalInfo.setGroupId(gid);
                    personalInfo.setUserIds(users);
                    personalInfos.add(personalInfo);
                }
            }
            ArrayList<UserOnDutyTime> arrayList = new ArrayList<UserOnDutyTime>(16);
            for (PersonalInfo p : personalInfos) {
                Long sscId = p.getSscId();
                Long groupId = p.getGroupId();
                List<Long> userIds = p.getUserIds();
                for (Long uid : userIds) {
                    void var7_16;
                    float u_dutytime = 0.0f;
                    float u_overtime = 0.0f;
                    float u_leavetime = 0.0f;
                    DynamicObjectCollection udatas = AchieveUtil.getDatas(Collections.singletonList(sscId), Arrays.asList(groupId), beforeDay, Arrays.asList(uid));
                    DynamicObjectCollection gdatas = AchieveUtil.getDatas(Collections.singletonList(sscId), Arrays.asList(groupId), beforeDay, null);
                    DynamicObjectCollection sdatas = AchieveUtil.getDatas(Collections.singletonList(sscId), null, beforeDay, null);
                    log.info(String.format("udatas:" + udatas.size(), ";getDatas:" + gdatas.size(), ";sdatas:" + sdatas.size()));
                    HashSet<String> workSet = new HashSet(8);
                    if (!gdatas.isEmpty()) {
                        String string = AchieveUtil.getWorkDayStatus(((DynamicObject)gdatas.get(0)).getString("dateentry.datetype"));
                        workSet = AchieveUtil.getWorkSet(gdatas);
                    } else {
                        String string = AchieveUtil.getWorkDayStatus(((DynamicObject)sdatas.get(0)).getString("dateentry.datetype"));
                        workSet = AchieveUtil.getWorkSet(sdatas);
                    }
                    if (!udatas.isEmpty()) {
                        Map<String, Float> times = AchieveUtil.getUserWorkTime(udatas, workSet);
                        u_dutytime = times.get("onDuTime").floatValue();
                        u_leavetime = times.get("leaveTime").floatValue();
                        u_overtime = times.get("overWorkTime").floatValue();
                        UserOnDutyTime u_info = AchieveUtil.buildPojo(sscId, groupId, uid, beforeDay, (String)var7_16, u_dutytime, u_overtime, u_leavetime, BitSetUtil.hashSetToBitSetStr(workSet));
                        arrayList.add(u_info);
                        continue;
                    }
                    UserOnDutyTime u_info = AchieveUtil.buildPojo(sscId, groupId, uid, beforeDay, (String)var7_16, AchieveDateUtil.getHours((int)workSet.size()).floatValue(), u_overtime, u_leavetime, BitSetUtil.hashSetToBitSetStr(workSet));
                    arrayList.add(u_info);
                }
            }
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
            int tag = 0;
            for (UserOnDutyTime info : arrayList) {
                if (info.getUserId() == null) continue;
                list.add(AchieveUtil.buildDny(info));
                if (++tag != 500) continue;
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[500]));
                tag = 0;
                list.clear();
            }
            if (!list.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
            }
        }
        catch (Exception e) {
            result = e.getMessage();
            log.error("\u5728\u5c97\u65f6\u957f\u91cd\u7b97\u5931\u8d25\uff1a", (Throwable)e);
        }
        return result;
    }

    public static void saveAchieveException(List<Long> existSscId, String type, Date beforeDay, String logStr, String status, Long excepId) {
        ArrayList<AchieveExpInfo> infos = new ArrayList<AchieveExpInfo>(16);
        HashSet<DynamicObject> set = new HashSet<DynamicObject>(16);
        if (excepId != null) {
            DynamicObject[] querySscid;
            QFilter filter = new QFilter("id", "=", (Object)excepId);
            for (DynamicObject obj : querySscid = BusinessDataServiceHelper.load((String)"ssc_achieveexception", (String)"id,sscid,achievebasedata,recalstatus,recalculation,logdetail_tag,createdate,modifydate", (QFilter[])new QFilter[]{filter})) {
                int count = obj.getInt("recalculation") + 1;
                String detail = logStr == null ? obj.getString("logdetail_tag") : logStr;
                obj.set("modifydate", (Object)new Date());
                obj.set("recalstatus", (Object)status);
                obj.set("recalculation", (Object)count);
                obj.set("logdetail_tag", (Object)detail);
                set.add(obj);
            }
            SaveServiceHelper.save((DynamicObject[])set.toArray(new DynamicObject[0]));
        } else {
            for (Long sid : existSscId) {
                AchieveExpInfo achieveExpInfo = AchieveUtil.buildAchieveExp(sid, AchieveExpEnum.SSC_USERONDUTYTIME.getValue(), status, 0, logStr, beforeDay, beforeDay);
                infos.add(achieveExpInfo);
            }
            AchieveUtil.saveAchieveExp(infos);
        }
    }

    public static UserOnDutyTime buildPojo(Long sscId, Long groupId, Long userId, Date date, String workDay, float dutytime, float overtime, float leavetime, String dutytimeBitSet) {
        UserOnDutyTime userOnDutyTime = new UserOnDutyTime();
        userOnDutyTime.setSscId(sscId);
        userOnDutyTime.setGroupId(groupId);
        userOnDutyTime.setUserId(userId);
        userOnDutyTime.setDate(date);
        userOnDutyTime.setWorkDay(workDay);
        userOnDutyTime.setDutytime(dutytime);
        userOnDutyTime.setOvertime(overtime);
        userOnDutyTime.setLeavetime(leavetime);
        userOnDutyTime.setDutytimeBitSet(dutytimeBitSet);
        return userOnDutyTime;
    }

    public static DynamicObject buildDny(UserOnDutyTime userCalendar) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ssc_userondutytime");
        dynamicObject.set("sscid", (Object)userCalendar.getSscId());
        dynamicObject.set("groupid", (Object)userCalendar.getGroupId());
        dynamicObject.set("userid", (Object)userCalendar.getUserId());
        dynamicObject.set("daten", (Object)userCalendar.getDate());
        dynamicObject.set("iswork", (Object)userCalendar.getWorkDay());
        dynamicObject.set("ondutytime", (Object)Float.valueOf(userCalendar.getDutytime()));
        dynamicObject.set("overtime", (Object)Float.valueOf(userCalendar.getOvertime()));
        dynamicObject.set("leavetime", (Object)Float.valueOf(userCalendar.getLeavetime()));
        dynamicObject.set("dutytimebitset", (Object)userCalendar.getDutytimeBitSet());
        return dynamicObject;
    }

    public static String getWorkDayStatus(String dateType) {
        String type = "1";
        if ("3".equals(dateType) || "4".equals(dateType)) {
            type = "2";
        }
        return type;
    }

    public static void deleteDate(List<Date> dates, List<Long> sscIds) {
        QFilter filter = new QFilter("daten", "in", dates);
        if (sscIds != null && !sscIds.isEmpty()) {
            filter.and("sscid", "in", sscIds);
        }
        DeleteServiceHelper.delete((String)"ssc_userondutytime", (QFilter[])new QFilter[]{filter});
    }

    public static List<ComboItem> getAllPermSSC(Long userId, String entityName) {
        ArrayList<ComboItem> sscList = new ArrayList<ComboItem>(16);
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"12", (String)"som", (String)entityName, (String)"47150e89000000ac", (boolean)true);
        List hasPermOrgs = allPermOrgs.getHasPermOrgs();
        String algoKey = AchieveUtil.class + ".getAllPermSSC()";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)hasPermOrgs)};
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_org", (String)"id,name", (QFilter[])filters, null);){
            for (Row row : orgDataSet) {
                ComboItem combobox = new ComboItem();
                combobox.setValue(row.getString(0));
                combobox.setCaption(new LocaleString(row.getString(1)));
                sscList.add(combobox);
            }
        }
        log.info(algoKey + sscList.size());
        return sscList;
    }

    public static List<Long> getMonthOfYear(Object startDate, Object enDate) {
        ArrayList<Long> monthOfYears = new ArrayList<Long>();
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime((Date)startDate);
        start.set(start.get(1), start.get(2), 1);
        end.setTime((Date)enDate);
        end.set(end.get(1), end.get(2), 2);
        Calendar curr = start;
        while (curr.before(end)) {
            monthOfYears.add(Long.parseLong(DateUtil.format(curr.getTime(), "yyyyMM")));
            curr.add(2, 1);
        }
        return monthOfYears;
    }

    public static boolean codeRule(String entityName) {
        QFilter filter = new QFilter("bizobjectid", "=", (Object)entityName);
        filter.and("enable", "=", (Object)EnableStatusEnum.Enable.getValue());
        DynamicObject codeRule = QueryServiceHelper.queryOne((String)"bos_coderule", (String)"id,enable", (QFilter[])new QFilter[]{filter});
        return codeRule != null;
    }

    public static List<Long> getSelectedRowIds(IListView view) {
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        ArrayList<Long> selectedRowIds = new ArrayList<Long>();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long selectedRowId = Long.valueOf(listSelectedRow.getPrimaryKeyValue() + "");
            selectedRowIds.add(selectedRowId);
        }
        return selectedRowIds;
    }

    public static Map<String, Float> getUserWorkTime(DynamicObjectCollection udatas, Set<String> workTimeSet) {
        HashMap<String, Float> result = new HashMap<String, Float>(3);
        String timeType = null;
        String begintimeam = null;
        String endtimeam = null;
        String begintimepm = null;
        String endtimepm = null;
        HashSet<String> overWorkTimeSet = new HashSet<String>(60);
        HashSet<String> leaveTimeSet = new HashSet<String>(60);
        for (Object u : udatas) {
            timeType = u.getString("dateentry.timeentry.timetype");
            begintimeam = u.getString("dateentry.timeentry.begintimeam");
            endtimeam = u.getString("dateentry.timeentry.endtimeam");
            begintimepm = u.getString("dateentry.timeentry.begintimepm");
            endtimepm = u.getString("dateentry.timeentry.endtimepm");
            switch (timeType) {
                case "2": {
                    AchieveUtil.setTimeHashSetValue(begintimeam, endtimeam, leaveTimeSet);
                    AchieveUtil.setTimeHashSetValue(begintimepm, endtimepm, leaveTimeSet);
                    break;
                }
                case "3": {
                    AchieveUtil.setTimeHashSetValue(begintimeam, endtimeam, overWorkTimeSet);
                    AchieveUtil.setTimeHashSetValue(begintimepm, endtimepm, overWorkTimeSet);
                    break;
                }
            }
        }
        HashSet<String> overWorkAndLeave = new HashSet<String>(8);
        overWorkAndLeave.addAll(overWorkTimeSet);
        overWorkAndLeave.retainAll(leaveTimeSet);
        for (String time : overWorkAndLeave) {
            boolean isBelong = AchieveUtil.isBelongOverWork(udatas, AchieveDateUtil.timeStringToDate((String)time));
            if (isBelong) {
                leaveTimeSet.remove(time);
                continue;
            }
            overWorkTimeSet.remove(time);
        }
        overWorkTimeSet.removeAll(workTimeSet);
        int overWorkMin = overWorkTimeSet.size();
        result.put("overWorkTime", AchieveDateUtil.getHours((int)overWorkMin));
        leaveTimeSet.retainAll(workTimeSet);
        int leaveMin = leaveTimeSet.size();
        result.put("leaveTime", AchieveDateUtil.getHours((int)leaveMin));
        int onDuTimeMin = workTimeSet.size() + overWorkMin - leaveMin;
        result.put("onDuTime", AchieveDateUtil.getHours((int)onDuTimeMin));
        workTimeSet.addAll(overWorkTimeSet);
        workTimeSet.removeAll(leaveTimeSet);
        return result;
    }

    public static void setTimeHashSetValue(String beginTime, String endTime, Set<String> timeHashSet) {
        if (!StringUtils.isEmpty((String)beginTime) && !StringUtils.isEmpty((String)endTime)) {
            Calendar beginCalendar = AchieveDateUtil.getCalendarByTimeStr((String)beginTime);
            Calendar endCalendar = AchieveDateUtil.getCalendarByTimeStr((String)endTime);
            while (!AchieveDateUtil.getTimeStrByCalendar((Calendar)beginCalendar).equals(AchieveDateUtil.getTimeStrByCalendar((Calendar)endCalendar))) {
                timeHashSet.add(AchieveDateUtil.getTimeStrByCalendar((Calendar)beginCalendar));
                beginCalendar.add(12, 1);
            }
        }
    }

    public static int getIntersectionSetSize(Set<String> ... sets) {
        HashSet<String> intersectionSet = new HashSet<String>(8);
        for (Set<String> set : sets) {
            intersectionSet.addAll(set);
        }
        return intersectionSet.size();
    }

    public static Set<String> getWorkSet(DynamicObjectCollection datas) {
        HashSet<String> workTimeSet = new HashSet<String>(60);
        String timeType = null;
        String dateType = null;
        String begintimeam = null;
        String endtimeam = null;
        String begintimepm = null;
        String endtimepm = null;
        for (DynamicObject g : datas) {
            SscDateType dateTypeEn;
            timeType = g.getString("dateentry.timeentry.timetype");
            dateType = g.getString("dateentry.datetype");
            begintimeam = g.getString("dateentry.timeentry.begintimeam");
            endtimeam = g.getString("dateentry.timeentry.endtimeam");
            begintimepm = g.getString("dateentry.timeentry.begintimepm");
            endtimepm = g.getString("dateentry.timeentry.endtimepm");
            if (!timeType.equals("1") || (dateTypeEn = SscDateType.getSscDateType((String)dateType)) == null) continue;
            switch (dateTypeEn) {
                case WORKDATE: {
                    AchieveUtil.setTimeHashSetValue(begintimeam, endtimeam, workTimeSet);
                    AchieveUtil.setTimeHashSetValue(begintimepm, endtimepm, workTimeSet);
                    break;
                }
                case HALFWORKDATEAM: {
                    AchieveUtil.setTimeHashSetValue(begintimeam, endtimeam, workTimeSet);
                    break;
                }
                case HALFWORKDATEPM: {
                    AchieveUtil.setTimeHashSetValue(begintimepm, endtimepm, workTimeSet);
                    break;
                }
            }
            break;
        }
        return workTimeSet;
    }

    public static boolean isBelongOverWork(DynamicObjectCollection udatas, Date time) {
        boolean findTime = false;
        boolean isOverWork = false;
        udatas.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return Long.compare(o1.getLong("dateentry.timeentry.id"), o2.getLong("dateentry.timeentry.id")) == 1 ? -1 : 0;
            }
        });
        String timeType = null;
        Date begintimeam = null;
        Date endtimeam = null;
        for (DynamicObject data : udatas) {
            if (findTime) break;
            timeType = data.getString("dateentry.timeentry.timetype");
            begintimeam = AchieveDateUtil.timeStringToDate((String)data.getString("dateentry.timeentry.begintimeam"));
            endtimeam = AchieveDateUtil.timeStringToDate((String)data.getString("dateentry.timeentry.endtimeam"));
            switch (timeType) {
                case "2": {
                    findTime = SscWorkCalendarApi.belongTime(begintimeam, endtimeam, time);
                    break;
                }
                case "3": {
                    findTime = SscWorkCalendarApi.belongTime(begintimeam, endtimeam, time);
                    if (!findTime) break;
                    isOverWork = true;
                    break;
                }
            }
        }
        return isOverWork;
    }

    public static void saveAchieveExp(List<AchieveExpInfo> infos) {
        HashSet<DynamicObject> sets = new HashSet<DynamicObject>(16);
        if (infos != null && !infos.isEmpty()) {
            for (AchieveExpInfo info : infos) {
                DynamicObject exp = BusinessDataServiceHelper.newDynamicObject((String)"ssc_achieveexception");
                exp.set("sscid", (Object)info.getSscId());
                exp.set("achievebasedata", (Object)info.getBasedataType());
                exp.set("recalstatus", (Object)info.getStatus());
                exp.set("recalculation", (Object)info.getCount());
                exp.set("logdetail", (Object)info.getLogDetail());
                exp.set("createdate", (Object)info.getCreateDate());
                exp.set("modifydate", (Object)info.getModifyDate());
                sets.add(exp);
            }
        }
        SaveServiceHelper.save((DynamicObject[])sets.toArray(new DynamicObject[0]));
    }

    public static AchieveExpInfo buildAchieveExp(Long sscId, String type, String status, int count, String log, Date createDate, Date modifyDate) {
        AchieveExpInfo info = new AchieveExpInfo();
        info.setSscId(sscId);
        info.setBasedataType(type);
        info.setStatus(status);
        info.setCount(count);
        info.setLogDetail(log);
        info.setCreateDate(createDate);
        info.setModifyDate(modifyDate);
        return info;
    }

    public static Long getTargetIdByMasterId(Long sscId, Long targetMasterId) {
        QFilter filter = new QFilter("createorg", "=", (Object)sscId);
        filter.and(new QFilter("masterid", "=", (Object)targetMasterId));
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"ssc_achievetarget", (String)"id", (QFilter[])filter.toArray());
        if (dyo != null) {
            return dyo.getLong("id");
        }
        return targetMasterId;
    }

    public static boolean isExistChildTarget(Long sscId, Long targetId) {
        String sql = "select 1 from t_tk_achievetarget where fid in( select fdataid from t_tk_achievetarget_U where fuseorgid = " + sscId + " ) and fparentid=" + targetId;
        String algoKey = AchieveSchemeFormPlugin.class + "isExistChildTarget()";
        DataSet re = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"ssc"), (String)sql);
        boolean isExist = re.isEmpty();
        re.close();
        return !isExist;
    }
}

