/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class TaskApproveUtil {
    private static String COMMON_URL = "/images/pc/emotion/default_person_82_82.png";

    public static FormShowParameter setAuditRecord(Long taskid, Long billTypeId, boolean isHist) {
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setCustomParam("taskid", (Object)taskid.toString());
        parameEdit.setCustomParam("billtypeid", (Object)billTypeId.toString());
        parameEdit.setCustomParam("isHist", (Object)isHist);
        parameEdit.setFormId("task_approvalhistory");
        parameEdit.getOpenStyle().setTargetKey("approvalrecordtabpage");
        parameEdit.getOpenStyle().setShowType(ShowType.InContainer);
        return parameEdit;
    }

    public static List<Map<String, Object>> setPauseRecord(Long taskid, boolean isHist) {
        QFilter jobItem = new QFilter("jobid", "=", (Object)taskid);
        QFilter opItem = QFilter.of((String)"operation = ? or operation = ?", (Object[])new Object[]{"3", "4"});
        QFilter[] filterItems = new QFilter[]{jobItem, opItem};
        String entityName = isHist ? "task_statechangehis" : "task_statechange";
        DataSet pauseRecordDataSet = ORM.create().queryDataSet("ssc.taskAppreval.pauseRecords", entityName, "id,jobid,newjobstate,oldjobstate,changetime,message,operation,operatorid.id,operatorid.useropenid,operatorid.name,operatorid.picturefield", filterItems, "changetime desc");
        Iterator it = pauseRecordDataSet.iterator();
        SimpleDateFormat longformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<Map<String, Object>> approvalRecordItems = new ArrayList<Map<String, Object>>();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("group", "approved");
            item.put("groupDecisionType", "approve");
            ArrayList childrenItems = new ArrayList();
            HashMap<String, Object> childrenItem = new HashMap<String, Object>();
            childrenItem.put("openId", row.get("operatorid.useropenid"));
            if (row.get("operatorid.id") != null) {
                Map userAvatarPath = UserServiceHelper.getUserAvatarPath(Collections.singletonList(Long.parseLong(row.get("operatorid.id").toString())), (boolean)true);
                if (StringUtils.isNotEmpty((String)((String)userAvatarPath.get(row.get("operatorid.id"))))) {
                    childrenItem.put("avatar", userAvatarPath.get(row.get("operatorid.id")));
                } else {
                    childrenItem.put("avatar", COMMON_URL);
                }
            }
            childrenItem.put("userName", row.get("operatorid.name"));
            childrenItem.put("decisionType", "approve");
            String operation = "";
            if ("3".equals(row.get("operation"))) {
                operation = String.format(ResManager.loadKDString((String)"%s\uff1a\u6682\u6302", (String)"TaskApprevalPlugin_29", (String)"ssc-task-formplugin", (Object[])new Object[0]), "");
            } else if ("4".equals(row.get("operation"))) {
                operation = String.format(ResManager.loadKDString((String)"%s\uff1a\u53d6\u6d88\u6682\u6302", (String)"TaskApprevalPlugin_30", (String)"ssc-task-formplugin", (Object[])new Object[0]), "");
            }
            childrenItem.put("resultName", operation);
            childrenItem.put("time", longformat.format(row.get("changetime")));
            childrenItem.put("message", row.get("message"));
            childrenItems.add(childrenItem);
            item.put("children", childrenItems);
            approvalRecordItems.add(item);
        }
        pauseRecordDataSet.close();
        return approvalRecordItems;
    }
}

