/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.common.teamleader.TeamLeaderApi;

public class UserGroupUtil {
    public static HashSet<Long> getManageGroup(String sscid, String userId) {
        DynamicObject[] userGroups;
        QFilter sscFilter = new QFilter("createorg", "=", (Object)Long.valueOf(sscid));
        HashSet<Long> manageSet = new HashSet<Long>(16);
        for (DynamicObject usergroup : userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,entryentity.teamleader,entryentity.userfield", (QFilter[])new QFilter[]{sscFilter})) {
            DynamicObjectCollection usergroupColl = usergroup.getDynamicObjectCollection("entryentity");
            Long userGroupID = usergroup.getLong("id");
            for (DynamicObject user : usergroupColl) {
                String userID = user.getString("userfield.id");
                boolean isLeader = user.getBoolean("teamleader");
                if (!isLeader || !userId.equals(userID)) continue;
                manageSet.add(userGroupID);
            }
        }
        return manageSet;
    }

    public static HashSet<String> getManageSsc(Long userId) {
        DynamicObject[] userGroups;
        HashSet<String> manageSscSet = new HashSet<String>(16);
        QFilter filter1 = new QFilter("entryentity.teamleader", "=", (Object)"1");
        QFilter filter2 = new QFilter("entryentity.userfield.id", "=", (Object)userId);
        for (DynamicObject usergroup : userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,entryentity.teamleader,entryentity.userfield,createorg.id", (QFilter[])new QFilter[]{filter1, filter2})) {
            manageSscSet.add(usergroup.getString("createorg.id"));
        }
        return manageSscSet;
    }

    public static boolean isGroupLeader(String userId, String sscId) {
        HashSet<Long> manageGroup = UserGroupUtil.getManageGroup(sscId, userId);
        return !manageGroup.isEmpty();
    }

    public static boolean verifyIdentity(String sscId, String userId, String adminRoleId, String businessAdminRole, IPageCache pageCache) {
        boolean adminRole = TeamLeaderApi.isAdminRole(sscId, Long.valueOf(userId), "HXLFBW8ZGNH", "HXLT47Z1L8S");
        if (!adminRole && "/JFEAD2U2A1R".equals(adminRoleId)) {
            adminRole = TeamLeaderApi.isAdminRole(sscId, Long.valueOf(userId), "/JFEAD2U2A1R");
        }
        if (adminRole) {
            pageCache.put("identity", "sysadmin");
            return true;
        }
        if (UserGroupUtil.isGroupLeader(userId, sscId)) {
            pageCache.put("identity", "groupleader");
            return true;
        }
        return false;
    }

    public static boolean allMyManageGroup(List<String> sscList, Set<Long> userGroupSet, IFormView formView) {
        String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
        HashSet<Long> manageGroup = UserGroupUtil.getManageGroup(sscList.get(0), currUserId);
        for (Long selectGroup : userGroupSet) {
            if (manageGroup.contains(selectGroup)) continue;
            formView.showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u7ec4\u957f\u53d8\u66f4\uff0c\u65e0\u6743\u9650\u4e3a\u4efb\u52a1\u5206\u914d\u4eba\u5458\u3002\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"UserGroupUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean isRobotGroup(Long userGroupId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)userGroupId, (String)"task_usergroup", (String)"isrobots");
        return dynamicObject.getBoolean("isrobots");
    }
}

