/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.voucher;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.task.common.VoucherBtnEnum;
import kd.ssc.task.formplugin.voucher.TaskbillVoucherPlugin;

public class TaskHandleShowPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(TaskbillVoucherPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (customParams != null) {
            String chooseoperations;
            String voucheroperation = (String)customParams.get("voucheroperation");
            if ("1".equals(voucheroperation)) {
                view.setVisible(Boolean.FALSE, new String[]{"savevoucher", "deletevoucher"});
            }
            if ((chooseoperations = (String)customParams.get("chooseoperations")) != null) {
                String[] operationArray = chooseoperations.split(",");
                List<String> chooseoperationList = Arrays.asList(operationArray);
                for (String type : chooseoperationList) {
                    if (VoucherBtnEnum.PREVIEW_VOUCHER.getCode().equals(type)) {
                        model.setValue("previewvoucher", (Object)true);
                        continue;
                    }
                    if (VoucherBtnEnum.CHECK_VOUCHER.getCode().equals(type)) {
                        model.setValue("checkvoucher", (Object)true);
                        continue;
                    }
                    if (VoucherBtnEnum.SAVE_VOUCHER.getCode().equals(type)) {
                        model.setValue("savevoucher", (Object)true);
                        continue;
                    }
                    if (!VoucherBtnEnum.DELETE_VOUCHER.getCode().equals(type)) continue;
                    model.setValue("deletevoucher", (Object)true);
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("btnok".equals(key)) {
            Boolean previewvoucher = (Boolean)model.getValue("previewvoucher");
            Boolean checkvoucher = (Boolean)model.getValue("checkvoucher");
            Boolean savevoucher = (Boolean)model.getValue("savevoucher");
            Boolean deletevoucher = (Boolean)model.getValue("deletevoucher");
            StringBuilder textvalue = new StringBuilder();
            StringBuilder code = new StringBuilder();
            textvalue.append(previewvoucher != false ? model.getProperty("previewvoucher").getDisplayName().getLocaleValue() + "," : "");
            code.append(previewvoucher != false ? VoucherBtnEnum.PREVIEW_VOUCHER.getCode() + "," : "");
            textvalue.append(checkvoucher != false ? model.getProperty("checkvoucher").getDisplayName().getLocaleValue() + "," : "");
            code.append(checkvoucher != false ? VoucherBtnEnum.CHECK_VOUCHER.getCode() + "," : "");
            textvalue.append(savevoucher != false ? model.getProperty("savevoucher").getDisplayName().getLocaleValue() + "," : "");
            code.append(savevoucher != false ? VoucherBtnEnum.SAVE_VOUCHER.getCode() + "," : "");
            textvalue.append(deletevoucher != false ? model.getProperty("deletevoucher").getDisplayName().getLocaleValue() + "," : "");
            code.append(deletevoucher != false ? VoucherBtnEnum.DELETE_VOUCHER.getCode() : "");
            HashMap<String, String> map = new HashMap<String, String>();
            if (textvalue.length() > 0) {
                textvalue.deleteCharAt(textvalue.lastIndexOf(","));
            }
            map.put("textvalue", textvalue.toString());
            map.put("code", code.toString());
            log.info("TaskHandleShowPlugin \u56de\u4f20\u7ed9\u4e1a\u52a1\u5355\u636emap:" + map);
            this.getView().returnDataToParent(map);
            view.close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        Boolean newValue = (Boolean)changeData.getNewValue();
        if ("checkvoucher".equals(propName) || "savevoucher".equals(propName) || "deletevoucher".equals(propName)) {
            if (newValue.booleanValue()) {
                model.setValue("previewvoucher", (Object)Boolean.TRUE);
            }
        } else if ("previewvoucher".equals(propName) && !newValue.booleanValue()) {
            Boolean checkvoucher = (Boolean)model.getValue("checkvoucher");
            Boolean savevoucher = (Boolean)model.getValue("savevoucher");
            Boolean deletevoucher = (Boolean)model.getValue("deletevoucher");
            if (checkvoucher.booleanValue() || savevoucher.booleanValue() || deletevoucher.booleanValue()) {
                model.setValue("checkvoucher", (Object)Boolean.FALSE);
                model.setValue("savevoucher", (Object)Boolean.FALSE);
                model.setValue("deletevoucher", (Object)Boolean.FALSE);
            }
        }
    }
}

