/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.voucher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.VoucherBtnEnum;
import kd.ssc.task.formplugin.util.VoucherUtil;

public class TaskVoucherApproveFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(TaskVoucherApproveFormPlugin.class);
    private static final String VIEWVOUCHERBTN = "viewvoucherbtn";
    private static final String CHECKVOUCHERBTN = "checkvoucherbtn";
    private static final String SAVEVOUCHERBTN = "savevoucherbtn";
    private static final String DELETEVOUCHERBTN = "deletevoucherbtn";
    private static Map<String, String> permissionMap = new HashMap<String, String>(7);
    private static final List<String> voucherOps = Arrays.asList("viewvoucherop", "checkvoucherop", "savevoucherop", "deletevoucherop");

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", VIEWVOUCHERBTN});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String sscId = this.getView().getFormShowParameter().getCustomParam("sscid") + "";
        if (kd.bos.util.StringUtils.isNotEmpty((String)sscId)) {
            String key;
            switch (key = evt.getItemKey()) {
                case "viewvoucherbtn": {
                    if (this.permission(key, Long.parseLong(sscId))) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6211\u7684\u4efb\u52a1\u201d\u7684\u201c\u9884\u89c8\u51ed\u8bc1\u201d\u7684\u6743\u9650\u3002", (String)"TaskVoucherApproveFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                case "checkvoucherbtn": {
                    String from = (String)this.getView().getFormShowParameter().getCustomParam("from");
                    if ("admin".equals(from) && !this.permission4TaskAdmin(Long.parseLong(sscId))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u67e5\u770b\u51ed\u8bc1\u201d\u7684\u6743\u9650\u3002", (String)"TaskAdministrateListPlugin_95", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                        break;
                    }
                    if ("admin".equals(from) || this.permission(key, Long.parseLong(sscId))) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6211\u7684\u4efb\u52a1\u201d\u7684\u201c\u67e5\u770b\u51ed\u8bc1\u201d\u7684\u6743\u9650\u3002", (String)"TaskVoucherApproveFormPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                case "savevoucherbtn": {
                    if (this.permission(key, Long.parseLong(sscId))) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6211\u7684\u4efb\u52a1\u201d\u7684\u201c\u751f\u6210\u51ed\u8bc1\u201d\u7684\u6743\u9650\u3002", (String)"TaskVoucherApproveFormPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    break;
                }
                case "deletevoucherbtn": {
                    if (this.permission(key, Long.parseLong(sscId))) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6211\u7684\u4efb\u52a1\u201d\u7684\u201c\u5220\u9664\u51ed\u8bc1\u201d\u7684\u6743\u9650\u3002", (String)"TaskVoucherApproveFormPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        List<String> allShow = Arrays.asList(VoucherBtnEnum.PREVIEW_VOUCHER.getValue(), VoucherBtnEnum.CHECK_VOUCHER.getValue(), VoucherBtnEnum.SAVE_VOUCHER.getValue(), VoucherBtnEnum.DELETE_VOUCHER.getValue());
        List<String> supportVoucherStates = Arrays.asList(TaskStateEnum.TO_BE_AUDIT.getValue(), TaskStateEnum.AUDIT_PASSED.getValue(), TaskStateEnum.REUPLOAD_IMAGE.getValue());
        if (formShowParameter != null) {
            DynamicObjectCollection entryentity;
            boolean isneedvoucher;
            String state = (String)formShowParameter.getCustomParam("state");
            String from = (String)formShowParameter.getCustomParam("from");
            if (!supportVoucherStates.contains(state)) {
                view.setEnable(Boolean.FALSE, allShow.toArray(new String[0]));
            } else if ("admin".equals(from)) {
                view.setEnable(Boolean.FALSE, new String[]{VoucherBtnEnum.PREVIEW_VOUCHER.getValue(), VoucherBtnEnum.SAVE_VOUCHER.getValue(), VoucherBtnEnum.DELETE_VOUCHER.getValue()});
            }
            Long billtypeid = (Long)formShowParameter.getCustomParam("billtypeid");
            Long tasktypeid = (Long)formShowParameter.getCustomParam("tasktypeid");
            String billnumber = (String)formShowParameter.getCustomParam("billnumber");
            QFilter bfilter = new QFilter("id", "=", (Object)billtypeid);
            DynamicObject task_taskbill = BusinessDataServiceHelper.loadSingle((String)"task_taskbill", (String)"id,isneedvoucher,entryentity,entryentity.tasktype,entryentity.childpkid", (QFilter[])new QFilter[]{bfilter});
            view.setVisible(Boolean.FALSE, allShow.toArray(new String[0]));
            if (task_taskbill != null && (isneedvoucher = task_taskbill.getBoolean("isneedvoucher")) && (entryentity = task_taskbill.getDynamicObjectCollection("entryentity")) != null && entryentity.size() > 0) {
                for (DynamicObject obj : entryentity) {
                    DynamicObjectCollection entryentityvoucher;
                    DynamicObject taskbillchild;
                    DynamicObject tasktype = obj.getDynamicObject("tasktype");
                    if (tasktype == null || tasktype.getLong("id") != tasktypeid.longValue() || (taskbillchild = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("childpkid"), (String)"task_taskbill_child")) == null || (entryentityvoucher = taskbillchild.getDynamicObjectCollection("entryentityvoucher")) == null || entryentityvoucher.size() <= 0) continue;
                    String[] taskhandleshowSplit = null;
                    for (DynamicObject voucherObj : entryentityvoucher) {
                        String billconditionjson = voucherObj.getString("billconditionjson_tag");
                        if (StringUtils.isEmpty((CharSequence)billconditionjson)) {
                            String taskhandleshowStr = (String)voucherObj.get("taskhandleshow");
                            taskhandleshowSplit = taskhandleshowStr.split(",");
                            break;
                        }
                        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)billconditionjson, FilterCondition.class);
                        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billnumber);
                        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, condition);
                        filterBuilder.buildFilter();
                        filterBuilder.getQFilters();
                        QFilter filter = filterBuilder.getQFilter();
                        Long billId = Long.valueOf((String)formShowParameter.getCustomParam("billid"));
                        QFilter billIdFilter = new QFilter("id", "=", (Object)billId);
                        DynamicObject taskbill = BusinessDataServiceHelper.loadSingle((String)billnumber, (String)"id", (QFilter[])new QFilter[]{filter, billIdFilter});
                        if (taskbill == null) continue;
                        String taskhandleshowStr = (String)voucherObj.get("taskhandleshow");
                        taskhandleshowSplit = taskhandleshowStr.split(",");
                        break;
                    }
                    ArrayList<String> btnShow = new ArrayList<String>(4);
                    if (taskhandleshowSplit == null || taskhandleshowSplit.length <= 0) continue;
                    for (String type : taskhandleshowSplit) {
                        if (VoucherBtnEnum.PREVIEW_VOUCHER.getCode().equals(type)) {
                            btnShow.add(VoucherBtnEnum.PREVIEW_VOUCHER.getValue());
                        } else if (VoucherBtnEnum.CHECK_VOUCHER.getCode().equals(type)) {
                            btnShow.add(VoucherBtnEnum.CHECK_VOUCHER.getValue());
                        } else if (VoucherBtnEnum.SAVE_VOUCHER.getCode().equals(type)) {
                            btnShow.add(VoucherBtnEnum.SAVE_VOUCHER.getValue());
                        }
                        if (!VoucherBtnEnum.DELETE_VOUCHER.getCode().equals(type)) continue;
                        btnShow.add(VoucherBtnEnum.DELETE_VOUCHER.getValue());
                    }
                    view.setVisible(Boolean.TRUE, btnShow.toArray(new String[0]));
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate formOp = (FormOperate)args.getSource();
            String operateKey = formOp.getOperateKey();
            IFormView view = this.getView();
            Map customParams = view.getFormShowParameter().getCustomParams();
            String billnumber = (String)customParams.get("billnumber");
            String billid = (String)customParams.get("billid");
            OperationResult operationResult = null;
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignoreValidation", "true");
            Map voucherOperate = null;
            if (!voucherOps.contains(operateKey)) {
                return;
            }
            List<Long> vouncherids = VoucherUtil.getVouncheridByBillid(Long.parseLong(billid));
            switch (operateKey) {
                case "viewvoucherop": 
                case "savevoucherop": {
                    this.whetherMoreVoucher(billnumber, billid, operateKey);
                    break;
                }
                case "checkvoucherop": {
                    VoucherUtil.viewVoucher(billid, this.getView(), true);
                    break;
                }
                case "deletevoucherop": {
                    try {
                        voucherOperate = EntityMetadataCache.getDataEntityOperate((String)billnumber, (String)"deletevoucher");
                        if (vouncherids.isEmpty()) {
                            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u5173\u8054\u51ed\u8bc1\u3002", (String)"VoucherUtil_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                            break;
                        }
                        operationResult = OperationServiceHelper.executeOperate((String)((String)voucherOperate.get("key")), (String)billnumber, (Object[])new Object[]{billid}, (OperateOption)option);
                        if (!operationResult.isSuccess()) {
                            List allErrorInfo = operationResult.getAllErrorOrValidateInfo();
                            StringBuilder sb = new StringBuilder();
                            allErrorInfo.forEach(error -> sb.append(error.getMessage()));
                            view.showTipNotification(sb.toString());
                            log.info("\u5220\u9664\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + billid + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + sb);
                            break;
                        }
                        if (billnumber.contains("fr_manualtallybill")) {
                            List successPkIds = operationResult.getSuccessPkIds();
                            this.isGenVoucher(successPkIds, "0");
                        }
                        view.showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664\u51ed\u8bc1\u3002", (String)"TaskVoucherApproveFormPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    }
                    catch (Exception e4) {
                        view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1\u5931\u8d25: %s", (String)"TaskVoucherApproveFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), e4.getMessage()));
                        log.info("\u5220\u9664\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + billid + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e4.getMessage());
                    }
                    break;
                }
            }
        }
    }

    private void whetherMoreVoucher(String billnumber, String billid, String viewvoucherop) {
        if ("viewvoucherop".equalsIgnoreCase(viewvoucherop) && billnumber.contains("fr_manualtallybill")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u7528\u8f6c\u8d26\u7533\u8bf7\u5355\u4e0d\u901a\u8fc7DAP\u914d\u7f6e\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u652f\u6301\u9884\u89c8\u51ed\u8bc1\u3002", (String)"TaskVoucherApproveFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            Map temp;
            Long billId;
            Object tempIds;
            QFilter filter = new QFilter("billentity", "=", (Object)billnumber);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"ai_dapconfig", (String)"isselecttemp,notshowvoucher", (QFilter[])filter.toArray());
            if (dynamicObject.getBoolean("isselecttemp") && !Objects.isNull(tempIds = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"SelectTemplteService", (String)"getNewSelectVchtemplate", (Object[])new Object[]{billnumber, Collections.singletonList(billId = Long.valueOf(Long.parseLong(billid))), true})) && !CollectionUtils.isEmpty((Map)(temp = (Map)tempIds))) {
                List allTempIDS = (List)temp.get("useTemp");
                if (CollectionUtils.isEmpty((Collection)allTempIDS)) {
                    allTempIDS = (List)temp.get("AllTempIDS");
                }
                if (!CollectionUtils.isEmpty((Collection)allTempIDS) && allTempIDS.size() > 1) {
                    QFilter filter1 = new QFilter("id", "in", (Object)allTempIDS);
                    DynamicObjectCollection ai_vchtemplates = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"id, number,name, booktype.FBasedataId.name", (QFilter[])filter1.toArray());
                    ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(ai_vchtemplates.size());
                    for (DynamicObject dy : ai_vchtemplates) {
                        HashMap<String, Object> param = new HashMap<String, Object>(8);
                        param.put("tempid", dy.getLong("id"));
                        param.put("number", dy.getString("number"));
                        param.put("name", dy.getString("name"));
                        param.put("booktype", dy.getString("booktype.FBasedataId.name"));
                        params.add(param);
                    }
                    this.showSelectTemp(params, billnumber, billid, viewvoucherop);
                    return;
                }
            }
        }
        catch (Exception e) {
            log.error("getNewSelectVchtemplate error", (Throwable)e);
        }
        if ("viewvoucherop".equalsIgnoreCase(viewvoucherop)) {
            this.viewvoucherop(billnumber, billid, 0L);
        } else {
            this.savevoucherop(billnumber, billid, 0L);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (e.getReturnData() != null) {
            Map ret = (Map)e.getReturnData();
            String billnumber = (String)ret.get("billnumber");
            String billid = (String)ret.get("billid");
            Long tempid = (Long)ret.get("tempid");
            if ("ssc_selecttmp".equals(actionId)) {
                this.savevoucherop(billnumber, billid, tempid);
            } else if ("ssc_selecttmp_viewvoucherop".equals(actionId)) {
                this.viewvoucherop(billnumber, billid, tempid);
            }
        }
    }

    private void showSelectTemp(List<Map<String, Object>> param, String billnumber, String billid, String viewvoucherop) {
        FormShowParameter formShow = new FormShowParameter();
        formShow.setFormId("ssc_selecttemplate");
        formShow.setCustomParam("tempParam", (Object)SerializationUtils.toJsonString(param));
        formShow.setCustomParam("pageId", (Object)this.getView().getPageId());
        formShow.setCustomParam("billnumber", (Object)billnumber);
        formShow.setCustomParam("billid", (Object)billid);
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        if ("viewvoucherop".equals(viewvoucherop)) {
            formShow.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "ssc_selecttmp_viewvoucherop"));
        } else {
            formShow.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "ssc_selecttmp"));
        }
        this.getView().showForm(formShow);
    }

    private void viewvoucherop(String billnumber, String billid, Long tempId) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", "true");
        Map voucherOperate = null;
        OperationResult operationResult = null;
        IFormView view = this.getView();
        try {
            voucherOperate = EntityMetadataCache.getDataEntityOperate((String)billnumber, (String)"previewvoucher");
            option.setVariableValue("previewpageid", view.getPageId());
            if (null != tempId && tempId > 0L) {
                HashMap<String, List<Long>> tempids = new HashMap<String, List<Long>>(1);
                tempids.put("useTemp", Collections.singletonList(tempId));
                option.setVariableValue("tempId", SerializationUtils.toJsonString(tempids));
            }
            if ((operationResult = OperationServiceHelper.executeOperate((String)((String)voucherOperate.get("key")), (String)billnumber, (Object[])new Object[]{billid}, (OperateOption)option)).isSuccess()) {
                this.showPreVoucher(view);
            } else {
                List allErrorInfo = operationResult.getAllErrorOrValidateInfo();
                StringBuilder sb = new StringBuilder();
                allErrorInfo.forEach(error -> sb.append(error.getMessage()));
                view.showTipNotification(sb.toString());
                log.info("\u9884\u89c8\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + billid + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + sb);
            }
        }
        catch (Exception e1) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u9884\u89c8\u51ed\u8bc1\u5931\u8d25: %s", (String)"TaskVoucherApproveFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), e1.getMessage()));
            log.info("\u9884\u89c8\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + billid + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e1.getMessage());
        }
    }

    private void savevoucherop(String billnumber, String billid, Long tempId) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", "true");
        Map voucherOperate = null;
        OperationResult operationResult = null;
        try {
            if (billnumber.contains("fr_manualtallybill")) {
                voucherOperate = EntityMetadataCache.getDataEntityOperate((String)billnumber, (String)"genvoucher");
                option.setVariableValue("ismanualtallybill", "true");
            } else {
                voucherOperate = EntityMetadataCache.getDataEntityOperate((String)billnumber, (String)"generatevoucher");
                option.setVariableValue("ignorebillstatus", "true");
                log.info("kd.ssc.task.formplugin.voucher.TaskVoucherApproveFormPlugin.afterDoOperation\u6ce8\u5165ignorebillstatus\u53c2\u6570\uff1a" + option.getVariableValue("ignorebillstatus"));
            }
            if (null != tempId && tempId > 0L) {
                HashMap<String, List<Long>> tempids = new HashMap<String, List<Long>>(1);
                tempids.put("useTemp", Collections.singletonList(tempId));
                option.setVariableValue("tempId", SerializationUtils.toJsonString(tempids));
            }
            if (!(operationResult = OperationServiceHelper.executeOperate((String)((String)voucherOperate.get("key")), (String)billnumber, (Object[])new Object[]{billid}, (OperateOption)option)).isSuccess()) {
                List allErrorInfo = operationResult.getAllErrorOrValidateInfo();
                StringBuilder sb = new StringBuilder();
                allErrorInfo.forEach(error -> sb.append(error.getMessage()));
                this.getView().showTipNotification(sb.toString());
                log.info("\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + billid + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + sb);
            } else {
                VoucherUtil.viewVoucher(billid, this.getView(), true);
            }
        }
        catch (Exception e3) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25: %s", (String)"TaskVoucherApproveFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), e3.getMessage()));
            log.info("\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + billid + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e3.getMessage());
        }
    }

    private void showPreVoucher(IFormView view) {
        IAppCache cache = AppCache.get((String)"gl");
        String string = (String)cache.get("accSys_" + view.getPageId() + "_perviewvoucher", String.class);
        String entityName = (String)cache.get("accSys_" + view.getPageId() + "_entityname", String.class);
        String billId = (String)cache.get("accSys_" + view.getPageId() + "_billid", String.class);
        String isevent = (String)cache.get("accSys_" + view.getPageId() + "_isevent", String.class);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            String tempId = (String)cache.get("accSys_" + view.getPageId() + "_vchtemplateid", String.class);
            FormShowParameter form = new FormShowParameter();
            form.setFormId("ai_previewvoucher");
            form.setCustomParam("voucher", (Object)string);
            form.setCustomParam("entityname", (Object)entityName);
            form.setCustomParam("isevent", (Object)isevent);
            form.setCustomParam("billId", (Object)billId);
            form.setCustomParam("tempId", (Object)tempId);
            form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            form.setStatus(OperationStatus.VIEW);
            view.showForm(form);
        }
        cache.remove("accSys_" + view.getPageId() + "_perviewvoucher");
    }

    private boolean permission4TaskAdmin(Long sscId) {
        String permissionId;
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "ssc";
        }
        appId = AppMetadataCache.getAppInfo((String)appId).getId();
        String entityName = "task_administrate";
        Long userId = RequestContext.get().getCurrUserId();
        int result = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)appId, (String)entityName, (String)(permissionId = "2DOB9V58MPL="));
        return result == 1;
    }

    private boolean permission(String operationKey, Long sscId) {
        String permissionId;
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "ssc";
        }
        appId = AppMetadataCache.getAppInfo((String)appId).getId();
        String entityName = "task_task";
        Long userId = RequestContext.get().getCurrUserId();
        int result = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)appId, (String)entityName, (String)(permissionId = permissionMap.get(operationKey)));
        return result == 1;
    }

    private void isGenVoucher(List<Object> pkIds, String value) {
        DynamicObject[] bills;
        if (CollectionUtils.isEmpty(pkIds)) {
            return;
        }
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"fr_manualtallybill", (String)"isgenvoucher", (QFilter[])new QFilter("id", "in", pkIds).toArray())) {
            bill.set("isgenvoucher", (Object)value);
        }
        SaveServiceHelper.save((DynamicObject[])bills);
    }

    static {
        permissionMap.put(VIEWVOUCHERBTN, "2IRART47A/E6");
        permissionMap.put(CHECKVOUCHERBTN, "2DOB9V58MPL=");
        permissionMap.put(SAVEVOUCHERBTN, "/LRTO/JV2TYZ");
        permissionMap.put(DELETEVOUCHERBTN, "/LSMQBAL/70Y");
    }
}

