/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workbill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class WorkBillTemplateFormPlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener {
    private static final String VIEW_SOURCE = "viewsource";
    private static final String IS_PREVIEW = "isPreview";
    private static final Log log = LogFactory.getLog(WorkBillTemplateFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Object isPreview = showParam.getCustomParam(IS_PREVIEW);
        if (isPreview != null && ((Boolean)isPreview).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbmain"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tbmain1"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbmain1"});
        }
        this.setBillStatus();
    }

    private void setBillStatus() {
        String status = (String)this.getModel().getValue("billstatus");
        if ("D".equals(status) || "F".equals(status)) {
            BillView billView = (BillView)this.getView();
            billView.setBillStatus(BillOperationStatus.AUDIT);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (VIEW_SOURCE.equals(evt.getItemKey())) {
            this.viewSource();
        }
    }

    private void viewSource() {
        String linkconfig = this.getLinkConfig();
        List<Object> params = this.buildParams();
        Object url = this.getUrl(linkconfig, params);
        this.openUrl(url);
    }

    private String getLinkConfig() {
        String linkconfig = (String)this.getModel().getValue("linkconfig");
        if (StringUtils.isEmpty((CharSequence)linkconfig)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u670d\u52a1\u6d41\u7a0b\u3002", (String)"WorkBillTemplateFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return linkconfig;
    }

    private Object getUrl(String linkconfig, List<Object> params) {
        Map result;
        try {
            result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"execute", (Object[])new Object[]{linkconfig, params});
        }
        catch (Exception e) {
            log.error("dispatch isc error:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u8c03\u7528\u5f02\u5e38\uff1a%s\u3002", (String)"WorkBillTemplateFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), e));
        }
        return ((Map)result.get("output")).get("url");
    }

    private void openUrl(Object url) {
        if (url == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u8fd4\u56de\u7684url\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkBillTemplateFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if (url instanceof String) {
            this.getView().openUrl((String)url);
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u8fd4\u56de\u7684URL\u201c%s\u201d\u4e0d\u662f\u5b57\u7b26\u4e32\u7c7b\u578b\u3002", (String)"WorkBillTemplateFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), url));
        }
    }

    private List<Object> buildParams() {
        String billNo = (String)this.getModel().getValue("billno");
        String sourcebillid = (String)this.getModel().getValue("sourcebillid");
        String extparam = (String)this.getModel().getValue("extparam_tag");
        String sourcebilltype = (String)this.getModel().getValue("sourcebilltype");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(billNo);
        paramList.add(sourcebillid);
        paramList.add(sourcebilltype);
        paramList.add(extparam);
        return paramList;
    }
}

