/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workcalendar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.ssc.task.formplugin.util.SscUtil;
import kd.ssc.task.formplugin.workcalendar.SscWorkCalendarBasePlugin;

public class SscWorkCalendarGroupEditPlugin
extends SscWorkCalendarBasePlugin
implements IConfirmCallBack {
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_batchset": {
                String org = this.getCurrentOrgId().trim();
                String group = this.getCurrentGroup().trim();
                if (StringUtils.isEmpty((CharSequence)org)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u6570\u636e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u3002", (String)"SscWorkCalendarGroupEditPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)group)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6743\u9650\u3002", (String)"SscWorkCalendarGroupEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bar_batchset");
                this.showForm("group_workcalendarsetting", null, closeCallBack, ShowType.Modal);
                break;
            }
            case "donothing_save": {
                this.savePersonalizedData();
                this.loadBaseWorkCalendar(this.getCurrentYear());
                break;
            }
            case "multiplex": {
                CloseCallBack multiplexCallBack = new CloseCallBack((IFormPlugin)this, "bar_batchset");
                this.showForm("ssc_calendar_multiplex", null, multiplexCallBack, ShowType.Modal);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData;
        super.closedCallBack(closedCallBackEvent);
        if ("bar_batchset".equals(closedCallBackEvent.getActionId()) && (returnData = this.getView().getReturnData() + "").trim().equals("refreshData")) {
            String year = this.getModel().getValue("year") + "";
            String selecteddate = this.getModel().getValue("selecteddate") + "";
            if (StringUtils.isEmpty((CharSequence)selecteddate.trim()) || StringUtils.isEmpty((CharSequence)year.trim())) {
                return;
            }
            this.loadBaseWorkCalendar(Integer.parseInt(year));
            this.markWorkCalendar(selecteddate);
            this.getView().updateView("singledayset");
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", formId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(map);
        map.put("creatorid", Long.parseLong(RequestContext.get().getUserId()));
        map.put("ssccenterid", this.getCurrentOrgId());
        String groupId = this.getCurrentGroup();
        if (groupId != null) {
            map.put("groupId", groupId);
        }
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(showParameter);
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "ssc_workcalendar_group", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"SscWorkCalendarGroupEditPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

