/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.dto.SynBailedOrgDTO;
import kd.ssc.task.util.OrganizationSynchronizeUtil;

public class AutoSynOrgSchedule
extends AbstractTask {
    private static final Log log = LogFactory.getLog(AutoSynOrgSchedule.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            this.autoSynOrg();
        }
        catch (Exception e) {
            log.error("\u9002\u7528\u7ec4\u7ec7\u540c\u6b65\u9519\u8bef", (Throwable)e);
            String msg = e.getMessage();
            if (msg.length() > 251) {
                msg = msg.substring(0, 251);
            }
            String stackInfo = Arrays.toString(e.getStackTrace());
            this.saveException2SynLog(msg, stackInfo);
        }
    }

    private void autoSynOrg() {
        this.deleteHisRecord();
        DynamicObjectCollection bizBills = this.getSynBill();
        List<SynBailedOrgDTO> dtos = this.transformDto(bizBills);
        new OrganizationSynchronizeUtil(dtos).synBailedOrganizationForList();
    }

    private void deleteHisRecord() {
        Date startDate = this.getStartDate(new Date());
        QFilter[] qFilters = new QFilter[]{new QFilter("syntime", "<", (Object)startDate)};
        DeleteServiceHelper.delete((String)"task_synorglog", (QFilter[])qFilters);
    }

    private Date getStartDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -90);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    private DynamicObjectCollection getSynBill() {
        String selectField = this.getSelectField();
        List<QFilter> filters = this.getQfilters();
        String orderBy = this.getOrderBy();
        return QueryServiceHelper.query((String)"task_taskbill", (String)selectField, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBy);
    }

    private String getSelectField() {
        return "id,ssccenter,bindbill,applycond";
    }

    private List<QFilter> getQfilters() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("effective", "=", (Object)"1"));
        filters.add(new QFilter("autosynorg", "=", (Object)"1"));
        return filters;
    }

    private String getOrderBy() {
        return "ssccenter,id";
    }

    private List<SynBailedOrgDTO> transformDto(DynamicObjectCollection bizBills) {
        if (bizBills == null) {
            return new ArrayList<SynBailedOrgDTO>(0);
        }
        int size = bizBills.size();
        ArrayList<SynBailedOrgDTO> dtos = new ArrayList<SynBailedOrgDTO>(size);
        for (DynamicObject dyo : bizBills) {
            SynBailedOrgDTO dto = new SynBailedOrgDTO(Long.valueOf(dyo.getLong("id")), Long.valueOf(dyo.getLong("ssccenter")), dyo.getString("bindbill"), Long.valueOf(dyo.getLong("applycond")));
            dtos.add(dto);
        }
        return dtos;
    }

    private void saveException2SynLog(String msg, String stackInfo) {
        DynamicObject saveDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_synorglog");
        saveDyo.set("syntime", (Object)new Date());
        saveDyo.set("synstatus", (Object)"2");
        saveDyo.set("stackinfo", (Object)msg);
        saveDyo.set("stackinfo_tag", (Object)stackInfo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
    }
}

