/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.ssc.task.util.BizBillValidateUtil;

public class BizBillOrgValidator
extends AbstractValidator {
    private static final String SAVEOP = "save";

    public void validate() {
        boolean isSaveOp = SAVEOP.equals(this.getOperateKey());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Map.Entry validateResult;
            DynamicObject dyo = dataEntity.getDataEntity();
            long bizBillId = dyo.getLong("id");
            String bindBill = dyo.getString("bindbill.id");
            long applyCondId = dyo.getLong("applycond.id");
            List<Long> bailedOrg = this.getBailedOrg(dyo);
            String effectiveStatus = dyo.getString("effective");
            if (isSaveOp) {
                String effective = dyo.getString("effective");
                if ("0".equals(effective)) continue;
                if ("2".equals(effective)) {
                    validateResult = BizBillValidateUtil.validateOnWayBizBillOrgUsed(bailedOrg, (long)bizBillId, (String)bindBill, (long)applyCondId);
                    Map.Entry useOrgCheckRe = BizBillValidateUtil.checkUseOrgOfOnWayBizBIll((String)bindBill, bailedOrg);
                    if (!((Boolean)useOrgCheckRe.getKey()).booleanValue()) {
                        this.addErrorMessage(dataEntity, (String)useOrgCheckRe.getValue());
                    }
                } else {
                    if (!"1".equals(effectiveStatus)) continue;
                    validateResult = BizBillValidateUtil.validateOrgUsed(bailedOrg, (long)bizBillId, (String)bindBill, (long)applyCondId);
                }
            } else {
                validateResult = BizBillValidateUtil.validateOrgUsed(bailedOrg, (long)bizBillId, (String)bindBill, (long)applyCondId);
            }
            if (((Boolean)validateResult.getKey()).booleanValue()) continue;
            this.addErrorMessage(dataEntity, (String)validateResult.getValue());
        }
    }

    private List<Long> getBailedOrg(DynamicObject dyo) {
        return dyo.getDynamicObjectCollection("sscbillorgpar").stream().map(d -> d.getLong("fbasedataid_id")).collect(Collectors.toList());
    }
}

