/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.ssc.task.util.CommonValidateUtil;

public class CreditfilesSaveValidatorPlugin
extends AbstractValidator {
    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setEntityKey("task_creditfiles");
    }

    public void validate() {
        StringBuilder errorMsg = new StringBuilder();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dy = (DynamicObject)dataEntity.getValue("creditlevel");
            BigDecimal creditvalue = (BigDecimal)dataEntity.getValue("creditvalue");
            if (dy == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4fe1\u7528\u7b49\u7ea7\uff1b", (String)"CreditfilesSaveValidatorPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0])).append("\n\r");
            }
            if (creditvalue == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4fe1\u7528\u5206\u6570\uff1b", (String)"CreditfilesSaveValidatorPlugin_1", (String)"ssc-task-opplugin", (Object[])new Object[0])).append("\n\r");
            }
            if (creditvalue != null && dy != null) {
                BigDecimal minvalue = dy.getBigDecimal("minvalue");
                BigDecimal maxvalue = dy.getBigDecimal("maxvalue");
                if (creditvalue.compareTo(minvalue) < 0 || creditvalue.compareTo(maxvalue.add(new BigDecimal("1"))) >= 0) {
                    errorMsg.append(ResManager.loadKDString((String)"\u5206\u6570\u672a\u5728\u9009\u62e9\u7684\u4fe1\u7528\u7b49\u7ea7\u8303\u56f4\u5185\uff1b", (String)"CreditfilesSaveValidatorPlugin_2", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                }
            }
            if (errorMsg.length() <= 0) continue;
            this.addMessage(dataEntity, CommonValidateUtil.replaceEnding((String)errorMsg.toString()), ErrorLevel.Error);
        }
    }
}

