/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.indicators;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.validate.AbstractValidator;
import kd.ssc.enums.indicators.DateRangeEnum;
import kd.ssc.enums.indicators.IndicatorsTypeEnum;

public class IndicatorsSaveValidator
extends AbstractValidator {
    private static final String COMPOSITE_INDICATORS_TYPE_ID = "1570359605291622400";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject indicators = dataEntity.getDataEntity();
            String number = indicators.getString("number");
            if (!IndicatorsSaveValidator.checkEngLetter(number)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u7b26\u5408\u89c4\u5219\uff0c\u8bf7\u91c7\u7528\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u547d\u540d\u3002", (String)"IndicatorsSaveValidator_6", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                continue;
            }
            String indicatorsType = indicators.getString("indicatorstype");
            if (IndicatorsTypeEnum.BASE.getType().equalsIgnoreCase(indicatorsType)) {
                String dimensionStatistical;
                Object unit = indicators.get("unit");
                if (unit == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorsSaveValidator_7", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject bizObject = indicators.getDynamicObject("bizobject");
                if (bizObject == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorsSaveValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String dateMapping = indicators.getString("datemapping");
                if (StringUtils.isEmpty((CharSequence)dateMapping)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65f6\u95f4\u5b57\u6bb5\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorsSaveValidator_1", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String dateType = indicators.getString("datetype");
                if (StringUtils.isEmpty((CharSequence)dateType)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorsSaveValidator_2", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (DateRangeEnum.CUSTOM.getType().equals(dateType)) {
                    Date beginDate = indicators.getDate("datebegin");
                    Date endDate = indicators.getDate("dateend");
                    if (beginDate == null || endDate == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorsSaveValidator_8", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)(dimensionStatistical = indicators.getString("dimensionstatistical")))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7edf\u8ba1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorsSaveValidator_3", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String dimensionMapping = indicators.getString("dimensionmapping");
                if (StringUtils.isEmpty((CharSequence)dimensionMapping)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u5b57\u6bb5\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorsSaveValidator_4", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String calFormulaJson = indicators.getString("calformulajson");
                String calFormula = indicators.getString("calformula");
                if (StringUtils.isEmpty((CharSequence)calFormula) || StringUtils.isEmpty((CharSequence)calFormulaJson)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorsSaveValidator_5", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)calFormulaJson, CRFormula.class);
                String expression = crFormula.getExpression();
                if (!StringUtils.isEmpty((CharSequence)expression)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorsSaveValidator_5", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!IndicatorsTypeEnum.COMPOSITE.getType().equals(indicatorsType)) continue;
            String calFormulaJson = indicators.getString("calformulajson");
            String calFormula = indicators.getString("calformula");
            if (!StringUtils.isEmpty((CharSequence)calFormula) && !StringUtils.isEmpty((CharSequence)calFormulaJson)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorsSaveValidator_5", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private static boolean checkEngLetter(String passengerName) {
        if (passengerName == null || passengerName.isEmpty()) {
            return true;
        }
        String eng = "^[a-zA-Z][a-zA-Z0-9_]*$";
        Pattern pattern = Pattern.compile(eng);
        Matcher matcher = pattern.matcher(passengerName);
        return matcher.matches();
    }
}

