/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.sla;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.constant.EntityField;
import kd.ssc.task.opplugin.sla.SlaServiceContractSynNorAmtValidator;

public class SlaServiceContractSynNorAmtPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(SlaServiceContractSynNorAmtPlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SlaServiceContractSynNorAmtValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("sourceentryid");
        fields.add("norprice");
        fields.add("norfixedamount");
        fields.add("contractdetails");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        OperationResult operationResult = this.getOperationResult();
        ValidateResultCollection collection = operationResult.getValidateResult();
        List validateResults = collection.getValidateErrors();
        List successPkIds = operationResult.getSuccessPkIds();
        Map<String, Object> resultMap = this.synNorAmount(args.getDataEntities());
        List failIds = (List)resultMap.get("failIds");
        successPkIds.remove(failIds);
        String opsMsg = (String)resultMap.get("opMsg");
        if (StringUtils.isNotEmpty((String)opsMsg)) {
            ValidationErrorInfo info = new ValidationErrorInfo("", null, 0, 0, "errorcode_001", "", opsMsg, ErrorLevel.Error);
            ValidateResult validateResult = new ValidateResult();
            validateResult.addErrorInfo((OperateErrorInfo)info);
            validateResults.add(validateResult);
        }
    }

    private Map<String, Object> synNorAmount(DynamicObject[] bills) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder opMsg = new StringBuilder();
        ArrayList<Object> failIds = new ArrayList<Object>(8);
        StringBuilder billNoStr = new StringBuilder();
        for (DynamicObject bill : bills) {
            try {
                DynamicObject contractDetail = bill.getDynamicObject("contractdetails");
                if (contractDetail == null) continue;
                Long cdpk = contractDetail.getLong("id");
                DynamicObject cdBasedata = BusinessDataServiceHelper.loadSingleFromCache((Object)cdpk, (String)"sla_contractdetails", (String)EntityField.buildSelectField((String[])new String[]{"id", "norprice", "norfixedamount"}));
                DynamicObjectCollection detailsEntry = cdBasedata.getDynamicObjectCollection("detailsentry");
                DynamicObjectCollection conDetailsEntry = bill.getDynamicObjectCollection("condetails");
                for (DynamicObject rowSC : conDetailsEntry) {
                    Long sourceEntryId = rowSC.getLong("sourceentryid");
                    for (DynamicObject rowCD : detailsEntry) {
                        Long entryId = rowCD.getLong("id");
                        if (!entryId.equals(sourceEntryId)) continue;
                        rowSC.set("norprice", (Object)rowCD.getBigDecimal("norprice"));
                        rowSC.set("norfixedamount", (Object)rowCD.getBigDecimal("norfixedamount"));
                    }
                }
            }
            catch (Exception ex) {
                String billNo = bill.getString("billno");
                billNoStr.append(billNo).append(",");
                failIds.add(bill.getPkValue());
                log.error("\u5171\u4eab\u670d\u52a1\u5408\u540c" + billNo + "\uff0c\u540c\u6b65\u7ed3\u7b97\u4ef7\u683c\u5f02\u5e38 ", (Throwable)ex);
            }
        }
        if (StringUtils.isBlank((String)billNoStr.toString())) {
            resultMap.put("opMsg", opMsg.toString());
        } else {
            opMsg.append("[");
            opMsg.append(billNoStr.substring(0, billNoStr.length() - 1));
            opMsg.append("]");
            opMsg.append((CharSequence)billNoStr).append(ResManager.loadKDString((String)"\u540c\u6b65\u7ed3\u7b97\u4ef7\u683c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"SlaServiceContractSynNorAmtPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            resultMap.put("opMsg", opMsg.toString());
        }
        resultMap.put("failIds", failIds);
        SaveServiceHelper.update((DynamicObject[])bills);
        return resultMap;
    }
}

